#ifndef __DBOOTSTRAP_UTIL_H
#define __DBOOTSTRAP_UTIL_H

#define TARGET_PREFIX    "/target"
#define TARGET_NOPREFIX  "/tmp/notarget"
#define TARGET_TESTDIR   "/tmp/target"

#define MAXLINE 1024

/*
 * int execlog_to_string(const char *cmd, int *exitcode,
 *                       char *result, int len, int flag);
 *
 * Like execlog, but return the command's stdout in result buffer,
 * with a maximum limit of len bytes, result is null terminated.  The
 * command's exit code is stored in exitcode.  The flag variable says
 * what to do with stderr:
 *   0: ignore stderr
 *   1: redirect stderr to syslog
 *   2: merge stderr and stdin
 * Any other value of flag produces undefined behavior.
 * 
 * This function returns a negative value on failure.
 *
 * Author: Colin Walters <walters@cis.ohio-state.edu> */
extern int execlog_to_string(const char *cmd, int *exitcode,
			     char *result, int len, int flag);

/*
 *  int execlog(const char * command, int priority) 
 *  
 * Execute command (via "/bin/sh -c") and log output (with stdout and
 * stderr merged) at given priority.  See syslog(3) for priority
 * options. N.B. Any shell redirection in the command may break, as 
 * inside the function " 2>&1" is appended to the command before 
 * execution. 
 * 
 * Mike Welles, <mike@onshore.com> 
 */ 
extern int execlog(const char *, int); 

/*
  variable argument version of execlog 
 */
extern int vexeclog(int,  const char *fmt, ...); 

/*
 * int fullscreen_execlog(const char *cmd)
 *
 * full-screen version of execlog, does busybox suspend; does not log
 * output of command.  Will log if return value != 0 and if debugging,
 * will log command name
 */
int fullscreen_execlog(const char *);

/*
 * int check_target_path(void)
 *
 * Check that the target path exists, or create it if it does not.
 */
extern int check_target_path(void);

/*
 * const char* target_path(const char* dir)
 *
 * Return the path to target directory: either real /target if already
 * mounted or a temporary /tmp/notarget directory.
 */
extern const char* target_path(const char*);

/*
 * int check_dir(const char* dirname)
 *
 * Stats DIRNAME and checks whether it exists and whether it's a 
 * directory.
 */
extern int check_dir (const char*);

/* 
 *  int write_userconfig(const char *key, const char *value) 
 *  
 * write a configuration setting atomically to USER_SETTINGS_FILE, of the
 * form "<KEY>='<VALUE>'\n".  Returns 0 for success, !0 otherwise.
 * if value == NULL then write "<KEY>=''\n"
 */
extern int write_userconfig (const char *, const char *);

/* 
 *  int write_userconfig_va(const char *key, const char *fmt, ...) 
 *
 * Just the same as write_userconfig, but the value is a format which
 * can take fprintf style arguments.
 */
extern int write_userconfig_va (const char *, const char *, ...);

/*
 * char *normalize_dir (const char *what, char *buf, size_t bufsize)
 *
 *  Normalizes the directory name given by WHAT.  the result is placed into
 *  BUF, which is BUFSIZE characters.
 *  If everything is fine, returns the pointer to BUF, otherwise -- NULL
 */
extern char *normalize_dir (const char *, char *, size_t);

/* int is_network_configured(void)
 * 
 * Checks if the network is configured. This is done by looking for a file
 * that the netconfig.c code creates, as well as for ifconfig (either on
 * the working root, or the target root).
 */
extern int is_network_configured(void);

/* int is_filesystem_supported(const char *fstype)
 * 
 * Returns true if and only if the filesystem type named by fstype
 * (such as ext2, or xfs) is available in the kernel.
 */
extern int
is_filesystem_supported(const char *fstype);

/* int is_fstype(const char *mount, const char *fs)
 *
 * Returns 1 when mounted filesystem type matches queried type. 
 */

extern int
is_fstype(const char *mount, const char *fs);

/* int initchroot_cap(void)
 *
 * Checks to see if the kernel is capable of supporting init-chroot
 * (Debian hack), returns 1 for true, 0 for false.
 */
extern int initchroot_cap(void);

/* int check_pending_config(void)
 *
 * Handles the even of when Root is mounted (on /target).  This means
 * that pre-Root settings written to other locations are copied to
 * their place under /target, and some generally useful values are
 * populated to USER_SETTINGS_FILE
 */
extern int check_pending_config(void);

/*
 * Displays `message' in a `pleaseWaitBox()', then calls `thunk
 * (result)' in a context where terminal and signal settings that
 * allow Ctrl-C to interrrupt the operation have been made.  Pops down
 * the dialog after `thunk' returns, and restores the terminal and
 * signal settings, then returns 0 unless the `thunk' was interrupted
 * by the user, in which case it returns 1.
 *
 * The `message' will have _(" Press Ctrl-C to interrupt.")  appended
 * automaticly in the `pleaseWaitBox()' display.  The dialog will look
 * best if there are no newlines in the message string.
 */
int
do_interruptable (const char *message,
		  void (*thunk) (void *result),
		  void *result);

/* int is_live_cd(void)
 *
 * Check whetever our installation system looks like a Debian live cd,
 * including the archive directory.
 *
 * Return vals:
 *
 *  0 : Normal, not a CDROM
 *  2 : We booted from a CDROM and it is the live root fs, assume
 *      we are installing from an already mounted directory (/debian)
 */
extern int is_live_cd(void);

/* Looks in the procfs whetever a cdrom drive does exist (1) or not (0) */
extern int have_cdrom(void);

/* Is the partition on an NFS mountpoint? */
int is_nfs_partition(const char *);

/* Is the root filesystem on a floppy drive? */
int is_root_a_floppy (void);

/* flush buffers for a file */
inline int fdflush(const char *);

/* safely add item to a list */
int addtolist(char **list, const char *element);

/* Checks to see if any network interfaces are active (excepting the
 * loopback interface "lo" - Returns the number of active interfaces. If
 * all is non-zero, all interfaces are counted, even if not up */
int is_network_up(int all);

/* Checks to see if the named interface, "inter", is up - Returns 1 if it
 * is, 0 if it is down. -1 is returned if the interface does not exist. */
int is_interface_up(char *inter);

/* Takes the buffer "p" and reads the interface name from it. "p" must be
 * a full line read in from /proc/net/dev. The interface name is places
 * into the "name" buffer (which must already be allocated) */
void get_name(char *name, char *p);

/* Get listing of interfaces on the system. getif_start() must be called
 * first in order to initialize the setup. After which, each successive
 * call get getif() will return a pointer to the next interface, ending
 * with NULL, when no more interfaces are available. If you call getif and
 * all is non-zero, it will return all interfaces, even ones that are not
 * active. Finally when done, call getif_end().
 */
void getif_start(void);
char *getif(int all);
void getif_end(void);

#ifdef USE_LANGUAGE_CHOOSER
    extern char *mirror_country_map[];
    void find_opt_server (char *);
    size_t strwidth (const char *);
    void wpadit (char *, const char *, size_t);
#else
#define strwidth(x) strlen(x)
#endif

 /* make a symlink from /lib/modules to /target/lib/modules
  * so that 'depmod' will function properly */
void frob_lib_modules(void);

extern int max(int, int);

/* get_fs_type
 *
 * given a partition name (/dev/hda1) it will return the type of partition
 * is.
 * 	ext2 ext3 reiserfs xfs
 */
const char *get_fs_type(const char *);

/* concatenates two strings, allocating memore for the new one */
extern char * concat_paths (const char *path1, const char *path2);

#endif /* __DBOOTSTRAP_UTIL_H */
