#include "config.h"
#if HAVE_IBM_PARTITION  

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <linux/fs.h>
#include <linux/types.h>
#include <linux/hdreg.h>
#include <linux/version.h>
#include <asm/dasd.h>   
#include <asm/vtoc.h>   

#include "fdisk.h"

#define USABLE_PARTITIONS ((1 << DASD_PARTN_BITS) - 1)

unsigned char ASCtoEBC[256] =
{
  /*00  NL    SH    SX    EX    ET    NQ    AK    BL */
  0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F,
  /*08  BS    HT    LF    VT    FF    CR    SO    SI */
  0x16, 0x05, 0x15, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
  /*10  DL    D1    D2    D3    D4    NK    SN    EB */
  0x10, 0x11, 0x12, 0x13, 0x3C, 0x15, 0x32, 0x26,
  /*18  CN    EM    SB    EC    FS    GS    RS    US */
  0x18, 0x19, 0x3F, 0x27, 0x1C, 0x1D, 0x1E, 0x1F,
  /*20  SP     !     "     #     $     %     &     ' */
  0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,
  /*28   (     )     *     +     ,     -    .      / */
  0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,
  /*30   0     1     2     3     4     5     6     7 */
  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
  /*38   8     9     :     ;     <     =     >     ? */
  0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,
  /*40   @     A     B     C     D     E     F     G */
  0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
  /*48   H     I     J     K     L     M     N     O */
  0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
  /*50   P     Q     R     S     T     U     V     W */
  0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
  /*58   X     Y     Z     [     \     ]     ^     _ */
  0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,
  /*60   `     a     b     c     d     e     f     g */
  0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
  /*68   h     i     j     k     l     m     n     o */
  0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
  /*70   p     q     r     s     t     u     v     w */
  0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
  /*78   x     y     z     {     |     }     ~    DL */
  0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFF
};


unsigned char EBCtoASC[256] =
{
 /* 0x00   NUL   SOH   STX   ETX  *SEL    HT  *RNL   DEL */
          0x00, 0x01, 0x02, 0x03, 0x07, 0x09, 0x07, 0x7F,
 /* 0x08   -GE  -SPS  -RPT    VT    FF    CR    SO    SI */
          0x07, 0x07, 0x07, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
 /* 0x10   DLE   DC1   DC2   DC3  -RES   -NL    BS  -POC
                                  -ENP  ->LF             */
          0x10, 0x11, 0x12, 0x13, 0x07, 0x0A, 0x08, 0x07,
 /* 0x18   CAN    EM  -UBS  -CU1  -IFS  -IGS  -IRS  -ITB
                                                    -IUS */
          0x18, 0x19, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
 /* 0x20   -DS  -SOS    FS  -WUS  -BYP    LF   ETB   ESC
                                  -INP                   */
          0x07, 0x07, 0x1C, 0x07, 0x07, 0x0A, 0x17, 0x1B,
 /* 0x28   -SA  -SFE   -SM  -CSP  -MFA   ENQ   ACK   BEL
                       -SW                               */ 
          0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x06, 0x07,
 /* 0x30  ----  ----   SYN   -IR   -PP  -TRN  -NBS   EOT */
          0x07, 0x07, 0x16, 0x07, 0x07, 0x07, 0x07, 0x04,
 /* 0x38  -SBS   -IT  -RFF  -CU3   DC4   NAK  ----   SUB */
          0x07, 0x07, 0x07, 0x07, 0x14, 0x15, 0x07, 0x1A,
 /* 0x40    SP   RSP                         ----       */
          0x20, 0xFF, 0x83, 0x84, 0x85, 0xA0, 0x07, 0x86,
 /* 0x48                       .     <     (     +     | */
          0x87, 0xA4, 0x9B, 0x2E, 0x3C, 0x28, 0x2B, 0x7C,
 /* 0x50     &                                      ---- */
          0x26, 0x82, 0x88, 0x89, 0x8A, 0xA1, 0x8C, 0x07,
 /* 0x58                !     $     *     )     ;       */
          0x8D, 0xE1, 0x21, 0x24, 0x2A, 0x29, 0x3B, 0xAA,
 /* 0x60     -     /  ----       ----  ----  ----       */
          0x2D, 0x2F, 0x07, 0x8E, 0x07, 0x07, 0x07, 0x8F,
 /* 0x68              ----     ,     %     _     >     ? */ 
          0x80, 0xA5, 0x07, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,
 /* 0x70  ----        ----  ----  ----  ----  ----  ---- */
          0x07, 0x90, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
 /* 0x78     *     `     :     #     @     '     =     " */
          0x70, 0x60, 0x3A, 0x23, 0x40, 0x27, 0x3D, 0x22,
 /* 0x80     *     a     b     c     d     e     f     g */
          0x07, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
 /* 0x88     h     i              ----  ----  ----       */
          0x68, 0x69, 0xAE, 0xAF, 0x07, 0x07, 0x07, 0xF1,
 /* 0x90          j     k     l     m     n     o     p */
          0xF8, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,
 /* 0x98     q     r                    ----        ---- */
          0x71, 0x72, 0xA6, 0xA7, 0x91, 0x07, 0x92, 0x07,
 /* 0xA0           ~     s     t     u     v     w     x */
          0xE6, 0x7E, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
 /* 0xA8     y     z              ----  ----  ----  ---- */
          0x79, 0x7A, 0xAD, 0xAB, 0x07, 0x07, 0x07, 0x07,
 /* 0xB0     ^                    ----       ----       */
          0x5E, 0x9C, 0x9D, 0xFA, 0x07, 0x07, 0x07, 0xAC,
 /* 0xB8        ----     [     ]  ----  ----  ----  ---- */
          0xAB, 0x07, 0x5B, 0x5D, 0x07, 0x07, 0x07, 0x07,
 /* 0xC0     {     A     B     C     D     E     F     G */
          0x7B, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
 /* 0xC8     H     I  ----                         ---- */
          0x48, 0x49, 0x07, 0x93, 0x94, 0x95, 0xA2, 0x07,
 /* 0xD0     }     J     K     L     M     N     O     P */
          0x7D, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
 /* 0xD8     Q     R  ----                              */
          0x51, 0x52, 0x07, 0x96, 0x81, 0x97, 0xA3, 0x98,
 /* 0xE0     \           S     T     U     V     W     X */
          0x5C, 0xF6, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
 /* 0xE8     Y     Z        ----       ----  ----  ---- */
          0x59, 0x5A, 0xFD, 0x07, 0x99, 0x07, 0x07, 0x07,
 /* 0xF0     0     1     2     3     4     5     6     7 */
          0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
 /* 0xF8     8     9  ----  ----       ----  ----  ---- */
          0x38, 0x39, 0x07, 0x07, 0x9A, 0x07, 0x07, 0x07
};


char *
vtoc_ebcdic_enc (unsigned char source[LINE_LENGTH],
		unsigned char target[LINE_LENGTH],
		int l)
{
	int i;
	for (i = 0; i < l; i++)
		target[i]=ASCtoEBC[(unsigned char)(source[i])];
 
	return target;
}  

char *
vtoc_ebcdic_dec (unsigned char source[LINE_LENGTH],
		unsigned char target[LINE_LENGTH],
		int l)
{
	int i;
	for (i = 0; i < l; i++)
		target[i]=EBCtoASC[(unsigned char)(source[i])];
 
	return target;
}  

int parse_ibm_partition(char *device, int fd)
{  
	struct hd_geometry geo;
        int blksize = 0;
	dasd_information_t dasd_info;
	char str[LINE_LENGTH];
	unsigned long b = -1;
	int i;
	volume_label_t   v;
	format4_label_t f4;
	int offset = 0;
	int size = 0;
	int psize = 0;
	char part_name[PATH_MAX];
	char buffer[PATH_MAX];
	int rc;

	if (ioctl(fd, HDIO_GETGEO, &geo) != 0) return 0;

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,3,98))
	if (ioctl(fd, BLKSSZGET, &blksize) != 0)
#else
	if (ioctl(fd, BLKGETBSZ, &blksize) != 0)
#endif /* KERNEL_VERSION */
		return 0;

	/* get disk type */
	if (ioctl(fd, BIODASDINFO, &dasd_info) != 0) return 0;

	if (memcmp(dasd_info.type, "ECKD", 4) && 
	    memcmp(dasd_info.type, "FBA", 3) &&
	    memcmp(dasd_info.type, "DIAG", 4)) 
		return 0;
		

/*
        if (ioctl(fd, DASDAPIVER, &i) != 0) return 0;
 
	if (DASD_API_VERSION != i) return -1;
		sprintf(s, "The current API version '%d' doesn't " \
			"match dasd driver API version " \
			"'%d'!", i, j);
		fdasd_error(anc, api_version_mismatch, s);
*/

	/* old disk layout */
#if 0
	if (dasd_info.FBA_layout) {
		memcpy(part_name, device, strlen(device)-4);
		part_name[strlen(device)-4] = '\0';
		strcat(part_name, "part1");
		/* check if swap partition */
		sprintf(buffer, "swapon %s 1>/dev/null 2>&1", part_name);
                rc = system(buffer);
		if(!rc) {
		  sprintf(buffer, "swapoff %s 1>/dev/null 2>&1", part_name);
		  system(buffer);
		}
		offset = dasd_info.label_block + 1;
		size = geo.heads*geo.sectors*geo.cylinders;
		fdisk_add_partition(device, 1,
			rc ? PTYPE_IBM_L_NATIVE: PTYPE_IBM_L_SWAP,
			((size-offset)*(blksize/512))/2);
		return 1;
	}
#endif


	if (lseek(fd, dasd_info.label_block * blksize, SEEK_SET) == -1) return 0;

	if (read(fd, &v, sizeof(volume_label_t)) != sizeof(volume_label_t)) return 0;

	if (!memcmp(v.vollbl, vtoc_ebcdic_enc("CMS1",str,4),4)) {
		if (* (((long *)&v) + 13) != 0) {
			long * label = (long *) &v; 
			blksize = label[3];
			offset = label[13];
			size = (label[7]-1)*(blksize>>10); 
		}else {
			offset = dasd_info.label_block + 1; 
			size =  geo.heads*geo.sectors*geo.cylinders;
		}
		fdisk_add_partition(device, 1,
			PTYPE_IBM_LINUX,
			((size-offset)*(blksize/512))/2);
		return 1;
	}
	else if (!memcmp(v.vollbl, vtoc_ebcdic_enc("VOL1",str,4),4)) {
		int current_minor = 1;

		b = ((v.vtoc.cc * geo.heads * geo.sectors +
                                v.vtoc.hh * geo.sectors +
                                v.vtoc.b) - 1) * blksize ;
		if (b <= 0) return 0;

		if (lseek(fd, b, SEEK_SET) == -1) return 0;

		if (read(fd, &f4, sizeof(format4_label_t)) != sizeof(format4_label_t)) return 0;

		if (f4.DS4IDFMT != 0xf4) return 0;

		/* format4 DSCB is valid, reading VTOC labels now  */
		b += blksize;

		for (i=1; i<=geo.sectors; i++) 
		{
			format1_label_t f1;
			char dsn[45];
			char * rc;

			if (lseek(fd, b, SEEK_SET) == -1) return 0;

			if (read(fd, &f1, sizeof(format1_label_t)) != sizeof(format1_label_t)) return 0;

			switch (f1.DS1FMTID) 
			{
			case 0xf1:
				offset = (f1.DS1EXT1.llimit.cc *geo.heads + f1.DS1EXT1.llimit.hh) * geo.sectors;
				psize = (f1.DS1EXT1.ulimit.cc *geo.heads + f1.DS1EXT1.ulimit.hh) * geo.sectors - offset + geo.sectors;

				vtoc_ebcdic_dec(f1.DS1DSNAM, dsn, 44);
				dsn[44] = '\0';
				rc = strstr(dsn, "PART");
				fdisk_add_partition(device, current_minor,
					 rc ? (memcmp(rc+9, "SWAP", 4)? PTYPE_IBM_L_NATIVE: PTYPE_IBM_L_SWAP): PTYPE_IBM_LINUX,
					(psize*(blksize/512))/2);
				current_minor++;
	
				break;
			default: 
			}
			b += blksize;
		}
		return 1;
	}
	else {
		memcpy(part_name, device, strlen(device)-4);
		part_name[strlen(device)-4] = '\0';
		strcat(part_name, "part1");
		/* check if swap partition */
		sprintf(buffer, "swapon %s 1>/dev/null 2>&1", part_name);
                rc = system(buffer);
		if(!rc) {
		  sprintf(buffer, "swapoff %s 1>/dev/null 2>&1", part_name);
		  system(buffer);
		}
		offset = dasd_info.label_block + 1;
		size = geo.heads*geo.sectors*geo.cylinders;
		fdisk_add_partition(device, 1,
			rc ? PTYPE_IBM_L_NATIVE: PTYPE_IBM_L_SWAP,
			((size-offset)*(blksize/512))/2);
		return 1;
	}
}

#endif /* HAVE_IBM_PARTITION */  
