#include "config.h"
#if HAVE_SGI_PARTITION

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/types.h>
#include "byteorder.h"

#include "fdisk.h"

#define	SGI_LABEL_MAGIC		0x0be5a941

struct device_parameter { /*  1 * 48 bytes */
     __u8  skew;
     __u8  gap1;
     __u8  gap2;
     __u8  sparecyl;
     __u16 pcylcount;
     __u16 head_vol0;
     __u16 ntrks;	/* tracks in cyl 0 or vol 0 */
     __u8  cmd_tag_queue_depth;
     __u8  unused0;
     __u16 unused1;
     __u16 nsect;	/* sectors/tracks in cyl 0 or vol 0 */
     __u16 bytes;
     __u16 ilfact;
     __u32  flags;		/* controller flags */
     __u32  datarate;
     __u32  retries_on_error;
     __u32  ms_per_word;
     __u16 xylogics_gap1;
     __u16 xylogics_syncdelay;
     __u16 xylogics_readdelay;
     __u16 xylogics_gap2;
     __u16 xylogics_readgate;
     __u16 xylogics_writecont;
}; 

struct volume_directory { 	/* 15 * 16 bytes */
     __u8 vol_file_name[8];	/* an character array */
     __u32  vol_file_start;	/* number of logical block */
     __u32  vol_file_size;	/* number of bytes */
};

struct sgi_partition {	/* 16 * 12 bytes */
	__u32 num_sectors;	/* number of blocks */
	__u32 start_sector;	/* sector must be cylinder aligned */
	__u32 id;
};

struct sgi_disklabel {
   __u32    magic;      /* expect SGI_LABEL_MAGIC */
   __u16 boot_part;     /* active boot partition */
   __u16 swap_part;     /* active swap partition */
   __u8 boot_file[16];  /* name of the bootfile */
   struct device_parameter deviceparams;
   struct volume_directory directory[15];
   struct sgi_partition partitions[16];
   __u32   csum;
   __u32   fillbytes;
};


static unsigned int sgi_label_checksum(
		struct sgi_disklabel* base )
{
     unsigned int *ui, csum, cs;
     ui = ((unsigned int *) (base + 1)) - 1;
     for(csum = 0; ui >= ((unsigned int *) base);) {
                cs = *ui--;
                csum += __be32_to_cpu(cs);
     } 
     return csum;
}

int parse_sgi_partition(char *device, int fd)
{
	 struct sgi_disklabel* label;
	 struct sgi_partition *p; 
	 unsigned i, blocks, minor = 1;

	 unsigned char data[512];

	 if (!sread( fd, 0L, data ))
	   return -1;
	 label = (struct sgi_disklabel *) data;
	 if (__be32_to_cpu(label->magic) != SGI_LABEL_MAGIC) {
	   	return 0;
	 }

	 /* Look at the checksum */
	 if( sgi_label_checksum( label )) {
	   	return 0;
	 }

	 /* SGI Disklabel can have up to 16 partitions */
	 p = label->partitions;
	 for( i = 0; i < 16; i++, p++ ) {
		 	blocks = __cpu_to_be32(p->num_sectors);
		 	if(!blocks) 
				continue;
		 	/* XXX: blocksize? */
			fdisk_add_partition(device, minor, p->id, blocks/2);
			++minor;
	 }
	 return 1;
}
#endif /*HAVE_SGI_PARTITION */ 
