//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/IO/ImportSettings.h
//! @brief     Declares import settings structs.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_DEVICE_IO_IMPORTSETTINGS_H
#define BORNAGAIN_DEVICE_IO_IMPORTSETTINGS_H

#include "Wrap/WinDllMacros.h"
#include <string>

enum QUnit { over_nm, over_angstrom };

//! This parameterization can be set interactively by GUI users.
//! Therefore, exceptionally, indices are counting from 1, not  from 0.

struct ImportSettings1D {
    std::string headerPrefix; //!< prefix of header lines (usually a single character like "#")
    std::string linesToSkip;  //!< pattern denoting line to skip (i.e. '1,10-12,42')
    std::string separator;    //!< column separator
    size_t col_Q;             //!< column number of Q (counting from 1!)
    size_t col_R;             //!< column number of R
    size_t col_sR;            //!< column number of sigma R, or 0
    size_t col_dQ;            //!< column number of delta Q, or 0
    size_t col_lambda;        //!< column number of wavelength, or 0
    QUnit qUnit{over_nm};
    // bool operator!=(const ImportSettings& other) const;
    // QByteArray serialize() const;
    // void deserialize(const QByteArray& data);
};

BA_DEVICE_API_ extern const ImportSettings1D legacy1D_2cols;
BA_DEVICE_API_ extern const ImportSettings1D legacy1D_3cols;
BA_DEVICE_API_ extern const ImportSettings1D legacy1D_4cols;
BA_DEVICE_API_ extern const ImportSettings1D legacy1D_5cols;

#endif // BORNAGAIN_DEVICE_IO_IMPORTSETTINGS_H
