//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/OffspecInstrumentEditor.cpp
//! @brief     Implements class OffspecInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Instrument/OffspecInstrumentEditor.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/View/Instrument/OffspecDetectorEditor.h"
#include "GUI/View/Instrument/PolarizationAnalysisEditor.h"
#include "GUI/View/Instrument/ScanEditor.h"

OffspecInstrumentEditor::OffspecInstrumentEditor(QWidget* parent, OffspecInstrumentItem* instrument,
                                                 MultiInstrumentNotifier* ec)

    : QWidget(parent)
    , m_ec(ec, instrument)
{
    ASSERT(instrument);
    auto* layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);

    auto* scanEditor = new ScanEditor(this, instrument->scanItem(), &m_ec);
    layout->addWidget(scanEditor);

    auto* detectorEditor = new OffspecDetectorEditor(this, instrument);
    layout->addWidget(detectorEditor);

    auto* polMatricesAnalysisEditor = new PolarizationAnalysisEditor(this, instrument);
    layout->addWidget(polMatricesAnalysisEditor);

    layout->addStretch();

    connect(scanEditor, &ScanEditor::dataChanged, this, &OffspecInstrumentEditor::dataChanged);
    connect(detectorEditor, &OffspecDetectorEditor::dataChanged, this,
            &OffspecInstrumentEditor::dataChanged);
    connect(polMatricesAnalysisEditor, &PolarizationAnalysisEditor::dataChanged, this,
            &OffspecInstrumentEditor::dataChanged);
}
