+++
title = "Windows"
weight = 50
+++

## Install on Windows

BornAgain GUI application for Windows is provided as 64-bit installer; it requires Python libraries to be installed on the system for being run.

BornAgain Python package is available in PyPI repository and can be installed with `pip`. This package is required for running scripts or importing them into the GUI application.

To install and run BornAgain for the first time proceed with the following steps:

- [Install Python environment](#install-python-environment)
- [Install BornAgain Python package](#install-bornagain-python-package)
- [Install BornAgain GUI application](#install-bornagain-gui-application)
- [Troubleshooting](#troubleshooting)

### Install Python environment

{{< alert theme="info" >}}
If Python environment is already installed and set up, this block can be skipped.
{{< /alert >}}

Python environment is needed for running both GUI application and example scripts.
The installer for appropriate version of Python can be downloaded from https://www.python.org/downloads.

BornAgain supports Python versions from 3.8 to 3.11.

Run the installer and follow the steps.

To use BornAgain GUI application, the installation directory should be added to the system `PATH`:

{{< figscg src="add_to_PATH.png" class="center" width="450px">}}

Ensure that `pip` package manager is checked for installation. Command
```
$ python -m ensurepip
```
will install `pip` if it is missing.

#### BornAgain with Anaconda

With Anaconda Python the requirements for versions 3.8 and 3.9 are more restrictive:

compatibility is confirmed for Python 3.8.x>=3.8.15 and for 3.9.x>=3.9.15

### Install BornAgain Python package

{{< alert theme="info" >}}
For using BornAgain as GUI application only, this block can be skipped.
{{< /alert >}}

BornAgain Python package in available in the public repository and can be installed with `pip`:
```
$ python -m pip install bornagain
```

### Install BornAgain GUI application

{{< alert theme="info" >}}
For using BornAgain in scripts only, this block can be skipped.
{{< /alert >}}

BornAgain installation package can be downloaded from
{{% files-versioned %}}.
The installer should be chosen accordingly to the Python version installed on the
destination machine, for example `{{% recommended-wininstaller %}}`.

After downloading the installer,
double click the `.exe` file and follow the instructions on the screen.

{{< figscg src="/img/bornagainapp_32.png" class="float-left">}}

Use the BornAgain icon located on the desktop to start the GUI.
Please refer to [Using graphical user interface]({{% relref "gui" %}})
section for a basic overview of GUI functionality.

### Troubleshooting

If you are experiencing problems while running BornAgain Python scripts please refer to the following tutorial.

+ [Python troubleshooting]({{% relref "installation/install/windows/python-troubleshooting" %}}).
