+++
title = "Python troubleshooting"
weight = 30
+++

## Python troubleshooting

The following checklist can be useful to tackle possible causes of the problem.

* [BornAgain.exe cannot start]({{% relref "#dll-not-found" %}})
* [How many Python distributions are installed on the system?]({{% relref "#how-many-python" %}})
* [Does the Python interpreter version matches the BornAgain installation?]({{% relref "#does-interpreter-match" %}})

<hr>

#### BornAgain.exe cannot start
{{% anchor "dll-not-found" %}}

{{< figscg src="dll_not_found.png" class="center" width="450px">}}

This message appears on running `BornAgain.exe` if BornAgain cannot find Python libraries.

If Python is correctly installed on the system according to [Install Python environment]({{% relref "installation/install/windows#install-python-environment" %}}), check if it discoverable by the system. Open command line or PowerShell and type
```
$ python
```
If Python interpreter has not started, then its installation directory is not in system `PATH`.
Open 

`Edit the system environment variables` -> `Environment variables` -> `System variables` -> `Path` -> `Edit` 

and add Python installation directory to the end

{{< figscg src="path.png" class="center" width="450px">}}

<hr>

#### How many Pythons are installed on the system?
{{% anchor "how-many-python" %}}

Having more than one Python interpreter installed on the system may cause subtle errors.
Managing their co-existence is possible, but may require special skills.
It may be preferable to uninstall all Python versions but one.

<hr>

#### Does the Python interpreter version matches the BornAgain installation?
{{% anchor "does-interpreter-match" %}}

BornAgain is a `64-bit` application and requires a `64-bit` Python3 installed on the system.

The Python version number, indicated in the BornAgain installer name
(e.g. `{{% recommended-wininstaller %}}`) must
match the Python installation on your system.
