+++
title = "Dodecahedron"
+++

### Dodecahedron

A regular dodecahedron.


<img src="/img/draw/ff/3d/Dodecahedron.png" width="30%">
<!--
<img src="../cut/Dodecahedron_xy.svg" width="30%">
<img src="../cut/Dodecahedron_xz.svg" width="30%">
-->

#### Constructor

```python
Dodecahedron(a)
```

Parameters:
- a, length of the edge

#### Usage

As for any other [Form factor](/py/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Dodecahedron" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.).

Form factor computation is based on the generic form factor of a polyhedron with inversion symmetry provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V= \dfrac{1}{4}(15+7\sqrt{5})a^3 \approx 7.663 \space a^3. $$

#### Related shapes

- [Icosahedron](/py/sample/particle/ff/hard/icosahedron), a regular icosahedron. 

#### Example

Scattering by uncorrelated, oriented truncated dodecahedra for horizontal incidence:

<img src="/img/auto/ff/Dodecahedron.png">

Generated by {{% ref-ex "ff/Dodecahedron.py" %}}.

#### History

Introduced in BornAgain 1.6.
