//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Axis/FrameUtil.h
//! @brief     Defines namespace FrameUtil.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_BASE_AXIS_FRAMEUTIL_H
#define BORNAGAIN_BASE_AXIS_FRAMEUTIL_H

#include <cstddef>
#include <vector>

class Frame;
class Scale;

namespace FrameUtil {

//! Transforms coordinate on axis into the bin-fraction-coordinate.
double coordinateToBinf(double coordinate, const Scale& axis);

//! Transforms bin-fraction-coordinate into axis coordinate.
double coordinateFromBinf(double value, const Scale& axis);

//! Transforms x,y coordinate from Datafield axes coordinates to bin-fraction-coordinates.
void coordinatesToBinf(double& x, double& y, const Frame& frame);

//! Transforms x,y coordinate from bin-fraction-coordinates to Datafield's axes coordinates.
void coordinatesFromBinf(double& x, double& y, const Frame& frame);

} // namespace FrameUtil

#endif // BORNAGAIN_BASE_AXIS_FRAMEUTIL_H
