#ifndef _CUTSELECTION_H_
#define _CUTSELECTION_H_

#include "operation.h"

class Element;
class Compound;
class Table;
class Reference;
class Part;

/** This operation copies the selection to an internal memory
 */
class CutSelection : public Operation
{
 private:
  Table * _oldTable;
  Table * _delete;
  Compound * _comp;

 public:
  CutSelection(Compound * comp);
  CutSelection(const CutSelection&);
  ~CutSelection();

  void undo();
  void redo();

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
