#ifndef _SONG_H_
#define _SONG_H_

#include "config.h"

#include "part.h"
#include "track.h"
#include "compound.h"
#include "position.h"
#include "operation.h"
#include "vector.h"

class PrProgress;
class Player;

#ifdef HAVE_ARTS_ENVIRONMENT
#include "arts/artsmodules.h"
#endif

enum PartApp { CLEAN, TRACKNAME, INSTRUMENT, EVENTS };
enum EditorApp { ADJUSTPARAMETERS, NOADJUST };

class Song : public Compound
{
 private:

  const char * _title;
  const char * _author;
  const char * _comment;
  int _tempo;
  int _meter0;
  int _meter1;
  Position _left; // left locator
  Position _right; // right locator
  Position _current; // current position pointer
  Part * _master;
  Vector opHistory;
  Vector opFuture;
  double _version;
  Player * _player;
  PartApp _part_appearance;
  EditorApp _editor_appearance;
  void initEnvironment();
#ifdef HAVE_ARTS_ENVIRONMENT
  mutable Arts::Environment::Container _arts_container;
  mutable Arts::Environment::MixerItem _arts_mixer;
#endif

 public:

  Song();
  Song(double);
  Song(const Song&);
  ~Song();

  void doo(Operation*);
  void undo(int i=-1);
  void redo(int i=-1);
  void oplist();
  void clearOplist();
  Operation * currentOp();
  Vector * undoList();
  Vector * redoList();
  const char * currentUndoText();
  const char * currentRedoText();
  void updateGui(int changes=-1);

  const char * title() const { return _title; }
  const char * author() const { return _author; }
  const char * comment() const { return _comment; }
  PartApp partAppearance() const { return _part_appearance; }
  EditorApp editorAppearance() const { return _editor_appearance; }
  int tempo() const { return _tempo; }
  int meter0() const { return _meter0; }
  int meter1() const { return _meter1; }
  Position left() const { return _left; }
  Position right() const { return _right; }
  Position current() const { return _current; }
  Part * master() const { return (( _master!=0 && !_master->track()->mute() )?_master:0); }

  void setTitle(const char*);
  void setAuthor(const char*);
  void setComment(const char*);
  void setPartAppearance(PartApp);
  void setEditorAppearance(EditorApp);
  void setTempo(int);
  void setMeter(int,int);
  void setMeter0(int);
  void setMeter1(int);
  void setLeft(Position);
  void setLeft(int,int,int);
  void setRight(Position);
  void setRight(int,int,int);
  void setCurrent(Position);
  void setCurrent(int,int,int);
  void setMaster(Part*);
  Player * player() const { return _player; }

  /**
   * Returns the first track of the type "type" or null.
   * The track's type determined by its ctype() method.
   **/
  Track * getTrack(const char * type);

#ifdef HAVE_ARTS_ENVIRONMENT
  Arts::Environment::Container envContainer() const { return _arts_container; }
  Arts::Environment::MixerItem envMixer() { return _arts_mixer; }
#endif

  void bbt(int & bar, int & beat, int & tick, Position pos);
  void play(PrProgress * progress = 0, Part * part = 0, long left = 0, long right = 0, bool cycl = false, int record_track = -1);
  double version() const { return _version; }

  bool hasScore();
  bool hasDrum();
  Track * createTrack(int type, const char * desc);

  virtual void add(Element * e);

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

  static Element * load(ifstream*,double,PrProgress*);
};

#endif
