


CREATE   FUNCTION lower_text_num(TEXT, NUMERIC(10, 0))
RETURNS  TEXT AS 'SELECT LOWER($1) || to_char($2, ''|FM9999999999'')'
LANGUAGE 'sql'
WITH     (ISCACHABLE);

CREATE   FUNCTION append_id(TEXT, NUMERIC(10,0))
RETURNS  TEXT AS '
    SELECT CASE WHEN $2 = 0 THEN
                $1
           ELSE
                $1 || '' '' || CAST($2 AS TEXT)
           END;'
LANGUAGE 'sql'
WITH     (ISCACHABLE, ISSTRICT);

CREATE AGGREGATE id_list (
    SFUNC    = append_id,
    BASETYPE = NUMERIC(10, 0),
    STYPE    = TEXT,
    INITCOND = ''
);


CREATE SEQUENCE seq_at_type START 1024;
CREATE SEQUENCE seq_element_type_member START 1024;


CREATE TABLE at_type (
    id              NUMERIC(10,0)  NOT NULL
                                   DEFAULT NEXTVAL('seq_at_type'),
    name            VARCHAR(64)	   NOT NULL,
    description     VARCHAR(256),
    top_level       NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__top_level
                                     CHECK (top_level IN (0,1)),
    paginated       NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__paginated
                                     CHECK (paginated IN (0,1)),
    fixed_url       NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__fixed_url
                                     CHECK (fixed_url IN (0,1)),
    related_story   NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__related_story
                                     CHECK (related_story IN (0,1)),
    related_media   NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__related_media
                                     CHECK (related_media IN (0,1)),
    media           NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_at_type__media
                                     CHECK (media IN (0,1)),
    biz_class__id   NUMERIC(10,0)  NOT NULL,
    active          NUMERIC(1,0)   NOT NULL
                                   DEFAULT 1
                                   CONSTRAINT ck_at_type__active
                                     CHECK (active IN (0,1)),
    CONSTRAINT pk_at_type__id PRIMARY KEY (id)
);


CREATE TABLE element_type_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_element_type_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_element_type_member__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_at_type__name ON at_type(LOWER(name));
CREATE INDEX fdx_class__at_type ON at_type(biz_class__id);
CREATE INDEX fkx_comp_type__comp_type_member ON element_type_member(object_id);
CREATE INDEX fkx_member__comp_type_member ON element_type_member(member__id);




CREATE SEQUENCE seq_media START 1024;

CREATE SEQUENCE seq_media_instance START 1024;

CREATE SEQUENCE seq_media__contributor START 1024;

CREATE SEQUENCE seq_media_member START 1024;

CREATE SEQUENCE seq_media_fields START 1024;

CREATE SEQUENCE seq_attr_media START  1024;

CREATE SEQUENCE seq_attr_media_val START 1024;

CREATE SEQUENCE seq_attr_media_meta START 1024;

CREATE SEQUENCE seq_media_uri START 1024;



CREATE TABLE media (
    id                NUMERIC(10,0)   NOT NULL
                                      DEFAULT NEXTVAL('seq_media'),
    element__id       NUMERIC(10,0)   NOT NULL,
    priority          NUMERIC(1,0)    NOT NULL
                                      DEFAULT 3
                                      CONSTRAINT ck_media__priority
                                        CHECK (priority BETWEEN 1 AND 5),
    source__id        NUMERIC(10,0)   NOT NULL,
    current_version   NUMERIC(10,0),
    published_version NUMERIC(10,0),
    usr__id           NUMERIC(10,0),
    first_publish_date TIMESTAMP,
    publish_date      TIMESTAMP,
    expire_date       TIMESTAMP,
    cover_date        TIMESTAMP,
    workflow__id      NUMERIC(10,0)   NOT NULL,
    desk__id          NUMERIC(10,0)   NOT NULL,
    publish_status    NUMERIC(1,0)    NOT NULL
                                      DEFAULT 0
                                      CONSTRAINT ck_media__publish_status 
                                        CHECK (publish_status IN (0,1)),
    active            NUMERIC(1,0)    NOT NULL
                                      DEFAULT 1
                                      CONSTRAINT ck_media__active
                                        CHECK (active IN (0,1)),
    site__id          NUMERIC(10,0)   NOT NULL,
    alias_id          NUMERIC(10,0)   CONSTRAINT ck_media_id
                                        CHECK (alias_id != id),  
    CONSTRAINT pk_media__id PRIMARY KEY (id)
);


CREATE TABLE media_instance (
    id                  NUMERIC(10,0)   NOT NULL
                                        DEFAULT NEXTVAL('seq_media_instance'),
    name                VARCHAR(256),
    description         VARCHAR(1024),
    media__id           NUMERIC(10,0)   NOT NULL,
    usr__id             NUMERIC(10,0)   NOT NULL,
    version             NUMERIC(10,0),
    category__id        NUMERIC(10,0)   NOT NULL,
    media_type__id      NUMERIC(10,0)   NOT NULL,
    primary_oc__id      NUMERIC(10,0)   NOT NULL,
    file_size           NUMERIC(10,0),
    file_name           VARCHAR(256),
    location            VARCHAR(256),
    uri                 VARCHAR(256),
    checked_out         NUMERIC(1,0)    NOT NULL
                                        DEFAULT 0
                                        CONSTRAINT ck_media_instance__checked_out 
                                        CHECK (checked_out IN(0,1)),
    CONSTRAINT pk_media_instance__id PRIMARY KEY (id)
);

CREATE TABLE media_uri (
    id        NUMERIC(10,0)   NOT NULL
                              DEFAULT NEXTVAL('seq_media_uri'),
    media__id NUMERIC(10)     NOT NULL,
    site__id  NUMERIC(10)     NOT NULL,
    uri       TEXT            NOT NULL,
    CONSTRAINT pk_media_uri__id PRIMARY KEY (id)
);


CREATE TABLE media__output_channel (
    media_instance__id  NUMERIC(10, 0)  NOT NULL,
    output_channel__id  NUMERIC(10, 0)  NOT NULL,
    CONSTRAINT pk_media_output_channel
      PRIMARY KEY (media_instance__id, output_channel__id)
);

CREATE TABLE media_fields (
    id              NUMERIC(10,0)  NOT NULL     
                                   DEFAULT NEXTVAL('seq_media_fields'),
    biz_pkg         NUMERIC(10,0)  NOT NULL,
    name            VARCHAR(32)    NOT NULL,
    function_name   VARCHAR(256)   NOT NULL,
    active          NUMERIC(1,0)   NOT NULL
                                   DEFAULT 1
                                   CONSTRAINT ck_media_fields__active
                                     CHECK (active IN(0,1)) ,
    CONSTRAINT pk_media_fields__id PRIMARY KEY (id)
);


CREATE TABLE media__contributor (
    id                  NUMERIC(10,0)   NOT NULL
                                        DEFAULT NEXTVAL('seq_media__contributor'),
    media_instance__id  NUMERIC(10,0)   NOT NULL,
    member__id          NUMERIC(10,0)   NOT NULL,
    place               NUMERIC(3,0)    NOT NULL,
    role                VARCHAR(256),
    CONSTRAINT pk_media_category_id PRIMARY KEY (id)
);



CREATE TABLE media_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_media_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_media_member__id PRIMARY KEY (id)
);



CREATE TABLE attr_media (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_media'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_media__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_media__id PRIMARY KEY (id)
);



CREATE TABLE attr_media_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_media_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_media_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_media_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_media_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_media_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_media_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_media_meta__id PRIMARY KEY (id)
);




CREATE INDEX idx_media__first_publish_date ON media(first_publish_date);
CREATE INDEX idx_media__publish_date ON media(publish_date);
CREATE INDEX idx_media__cover_date ON media(cover_date);
CREATE INDEX fkx_source__media ON media(source__id);
CREATE INDEX fkx_usr__media ON media(usr__id);
CREATE INDEX fkx_element__media ON media(element__id);
CREATE INDEX fkx_site_id__media ON media(site__id);
CREATE INDEX fdx_alias_id__media ON media(alias_id);

CREATE INDEX idx_media_instance__name ON media_instance(LOWER(name));
CREATE INDEX idx_media_instance__description ON media_instance(LOWER(description));
CREATE INDEX idx_media_instance__file_name ON media_instance(LOWER(file_name));
CREATE INDEX idx_media_instance__uri ON media_instance(LOWER(uri));
CREATE INDEX fkx_media__media_instance ON media_instance(media__id);
CREATE INDEX fkx_usr__media_instance ON media_instance(usr__id);
CREATE INDEX fkx_media_type__media_instance ON media_instance(media_type__id);
CREATE INDEX fkx_category__media_instance ON media_instance(category__id);
CREATE INDEX fdx_primary_oc__media_instance ON media_instance(primary_oc__id);

CREATE INDEX fkx_media__media_uri ON media_uri(media__id);
CREATE UNIQUE INDEX udx_media_uri__site_id__uri
ON media_uri(lower_text_num(uri, site__id));

CREATE INDEX fkx_media__oc__media ON media__output_channel(media_instance__id);
CREATE INDEX fkx_media__oc__oc ON media__output_channel(output_channel__id);

CREATE INDEX fkx_media__media_member ON media_member(object_id);
CREATE INDEX fkx_member__media_member ON media_member(member__id);

CREATE UNIQUE INDEX udx_attr_media__subsys__name ON attr_media(subsys, name);

CREATE INDEX idx_attr_media__name ON attr_media(LOWER(name));
CREATE INDEX idx_attr_media__subsys ON attr_media(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_media_val__obj_attr ON attr_media_val (object__id,attr__id);

CREATE INDEX fkx_media__attr_media_val ON attr_media_val(object__id);
CREATE INDEX fkx_attr_media__attr_media_val ON attr_media_val(attr__id);

CREATE UNIQUE INDEX udx_attr_media_meta__attr_name ON attr_media_meta (attr__id, name);

CREATE INDEX idx_attr_media_meta__name ON attr_media_meta(LOWER(name));

CREATE INDEX fkx_attr_media__attr_media_meta ON attr_media_meta(attr__id);

CREATE INDEX fdx_media__desk__id ON media(desk__id) WHERE desk__id > 0;
CREATE INDEX fdx_media__workflow__id ON media(workflow__id) WHERE workflow__id > 0;


CREATE SEQUENCE seq_story_container_tile START  1024;

CREATE SEQUENCE seq_media_container_tile START  1024;


CREATE TABLE story_container_tile (
    id                   NUMERIC(10,0)   NOT NULL
                                         DEFAULT NEXTVAL('seq_story_container_tile'),
    name                 VARCHAR(64)     NOT NULL,
    key_name             VARCHAR(64)     NOT NULL,
    description          VARCHAR(256),
    element__id          NUMERIC(10,0)   NOT NULL,
    object_instance_id   NUMERIC(10,0)   NOT NULL,
    parent_id            NUMERIC(10,0),
    place                NUMERIC(10,0)   NOT NULL,
    object_order         NUMERIC(10,0)   NOT NULL,
    related_instance__id NUMERIC(10,0),
    related_media__id    NUMERIC(10,0),
    active               NUMERIC(1,0)    NOT NULL
                                         DEFAULT 1
                                         CONSTRAINT ck_sc_tile__active
                                           CHECK (active IN (0,1)),

    CONSTRAINT pk_container_tile__id PRIMARY KEY (id)
);



CREATE TABLE media_container_tile (
    id                          NUMERIC(10,0)   NOT NULL
                                                DEFAULT NEXTVAL('seq_media_container_tile'),
    name                        VARCHAR(64)     NOT NULL,
    key_name                    VARCHAR(64)     NOT NULL,
    description                 VARCHAR(256),
    element__id      	        NUMERIC(10,0)   NOT NULL,
    object_instance_id          NUMERIC(10,0)   NOT NULL,
    parent_id                   NUMERIC(10,0),
    place                       NUMERIC(10,0)   NOT NULL,
    object_order                NUMERIC(10,0)   NOT NULL,

    -- Hack. These two columns never hold values, but keep this table in sync
    -- with story_container_tile, since they share the same code base.
    related_instance__id        NUMERIC(10,0), 
    related_media__id           NUMERIC(10,0),
    active              	NUMERIC(1,0)    NOT NULL
                                                DEFAULT 1
                                                CONSTRAINT ck_mc_tile__active
                                                  CHECK (active IN (0,1)),

    CONSTRAINT pk_media_container_tile__id PRIMARY KEY (id)
);


CREATE INDEX idx_sc_tile__key_name ON story_container_tile(LOWER(key_name));
CREATE INDEX fkx_sc_tile__sc_tile ON story_container_tile(parent_id);
CREATE INDEX fkx_story__sc_tile ON story_container_tile(object_instance_id);
CREATE INDEX fkx_sc_tile__related_story ON story_container_tile(related_instance__id);
CREATE INDEX fkx_sc_tile__related_media ON story_container_tile(related_media__id);

CREATE INDEX idx_mc_tile__key_name ON media_container_tile(LOWER(key_name));
CREATE INDEX fkx_mc_tile__mc_tile ON media_container_tile(parent_id);
CREATE INDEX fkx_media__mc_tile ON media_container_tile(object_instance_id);




CREATE SEQUENCE seq_story_data_tile START 1024;

CREATE SEQUENCE seq_media_data_tile START 1024;


CREATE TABLE story_data_tile (
    id                   NUMERIC(10,0)  NOT NULL
                                        DEFAULT NEXTVAL('seq_story_data_tile'),
    name                 VARCHAR(64)    NOT NULL,
    key_name             VARCHAR(64)    NOT NULL,
    description          VARCHAR(256),
    element_data__id     NUMERIC(10,0)  NOT NULL,
    object_instance_id   NUMERIC(10,0)  NOT NULL,
    parent_id            NUMERIC(10,0)  NOT NULL,
    hold_val             NUMERIC(1,0)   NOT NULL
                                        DEFAULT 0
                                        CONSTRAINT ck_sd_tile__hold_val
                                          CHECK (hold_val IN (0,1)),

    place                NUMERIC(10,0)  NOT NULL,
    object_order         NUMERIC(10,0)  NOT NULL,
    date_val             TIMESTAMP,
    short_val            TEXT,
    blob_val             TEXT,
    active               NUMERIC(1,0)   NOT NULL
                                        DEFAULT 1
                                        CONSTRAINT ck_sd_tile__active
                                          CHECK (active IN (0,1)),

    CONSTRAINT pk_story_data_tile__id PRIMARY KEY (id)
);



CREATE TABLE media_data_tile (
    id                   NUMERIC(10,0)  NOT NULL
                                        DEFAULT NEXTVAL('seq_media_data_tile'),
    name                 VARCHAR(64)    NOT NULL,
    key_name             VARCHAR(64)    NOT NULL,
    description          VARCHAR(256),
    element_data__id     NUMERIC(10,0)  NOT NULL,
    object_instance_id   NUMERIC(10,0)  NOT NULL,
    parent_id            NUMERIC(10,0)  NOT NULL,
    place                NUMERIC(10,0)  NOT NULL,
    hold_val             NUMERIC(1,0)   NOT NULL
                                        DEFAULT 0
                                        CONSTRAINT ck_md_tile__hold_val
                                          CHECK (hold_val IN (0,1)),

    object_order         NUMERIC(10,0)  NOT NULL,
    date_val             TIMESTAMP,
    short_val            VARCHAR(1024),
    blob_val             TEXT,
    active               NUMERIC(1,0)   NOT NULL
                                        DEFAULT 1
                                        CONSTRAINT ck_md_tile__active
                                          CHECK (active IN (0,1)),

    CONSTRAINT pk_media_data_tile__id PRIMARY KEY (id)
);

CREATE INDEX idx_story_data_tile__key_name ON story_data_tile(LOWER(key_name));
CREATE INDEX fkx_story_instance__sd_tile ON story_data_tile(object_instance_id);
CREATE INDEX fkx_element__sd_tile ON story_data_tile(element_data__id);
CREATE INDEX fkx_sc_tile__sd_tile ON story_data_tile(parent_id);

CREATE INDEX idx_media_data_tile__key_name ON media_data_tile(LOWER(key_name));
CREATE INDEX fkx_media_instance__md_tile ON media_data_tile(object_instance_id);
CREATE INDEX fkx_element__md_tile ON media_data_tile(element_data__id);
CREATE INDEX fkx_sc_tile__md_tile ON media_data_tile(parent_id);




CREATE SEQUENCE seq_story START  1024;

CREATE SEQUENCE seq_story_instance START 1024;

CREATE SEQUENCE seq_story__category START  1024;

CREATE SEQUENCE seq_story__contributor START 1024;

CREATE SEQUENCE seq_attr_story START 1024;

CREATE SEQUENCE seq_attr_story_val START 1024;

CREATE SEQUENCE seq_attr_story_meta START 1024;

CREATE SEQUENCE seq_story_uri START 1024;




CREATE TABLE story (
    id                NUMERIC(10,0)   NOT NULL
                                      DEFAULT NEXTVAL('seq_story'),
    priority          NUMERIC(1,0)    NOT NULL
                                      DEFAULT 3
                                      CONSTRAINT ck_story__priority
                                        CHECK (priority BETWEEN 1 AND 5),
    source__id        NUMERIC(10,0)   NOT NULL, 
    usr__id           NUMERIC(10,0),
    element__id       NUMERIC(10,0)   NOT NULL,
    primary_uri       VARCHAR(128),
    first_publish_date TIMESTAMP,
    publish_date      TIMESTAMP,
    expire_date       TIMESTAMP,
    cover_date        TIMESTAMP,
    current_version   NUMERIC(10, 0)  NOT NULL,
    published_version NUMERIC(10, 0),
    workflow__id      NUMERIC(10,0)   NOT NULL,
    desk__id          NUMERIC(10,0)   NOT NULL,
    publish_status    NUMERIC(1,0)    NOT NULL
                                      DEFAULT 0
                                      CONSTRAINT ck_story__publish_status
                                        CHECK (publish_status IN (0,1)),
    active            NUMERIC(1,0)    NOT NULL
                                      DEFAULT 1
                                      CONSTRAINT ck_story__active
                                        CHECK (active IN (0,1)),
    site__id          NUMERIC(10,0)   NOT NULL,
    alias_id          NUMERIC(10,0)   CONSTRAINT ck_story_id
                                        CHECK (alias_id != id),  
    CONSTRAINT pk_story__id PRIMARY KEY (id)
);



CREATE TABLE story_instance (
    id             NUMERIC(10,0)   NOT NULL
                                  DEFAULT NEXTVAL('seq_story_instance'),
    name           VARCHAR(256),
    description    VARCHAR(1024),
    story__id      NUMERIC(10,0)   NOT NULL,
    version        NUMERIC(10,0),
    usr__id        NUMERIC(10,0)   NOT NULL,
    slug           VARCHAR(64),
    primary_oc__id NUMERIC(10,0)   NOT NULL,
    checked_out    NUMERIC(1,0)    NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_story_instance__checked_out
                                     CHECK (checked_out IN (0,1)),
    CONSTRAINT pk_story_instance__id PRIMARY KEY (id)
);

CREATE TABLE story_uri (
    id        NUMERIC(10,0)   NOT NULL
                              DEFAULT NEXTVAL('seq_story_uri'),
    story__id NUMERIC(10)     NOT NULL,
    site__id NUMERIC(10)      NOT NULL,
    uri       TEXT            NOT NULL,
    CONSTRAINT pk_story_uri__id PRIMARY KEY (id)
);


CREATE TABLE story__output_channel (
    story_instance__id  NUMERIC(10, 0)  NOT NULL,
    output_channel__id  NUMERIC(10, 0)  NOT NULL,
    CONSTRAINT pk_story_output_channel
      PRIMARY KEY (story_instance__id, output_channel__id)
);



CREATE TABLE story__category (
    id                  NUMERIC(10,0)  NOT NULL
                                       DEFAULT NEXTVAL('seq_story__category'),
    story_instance__id  NUMERIC(10,0)  NOT NULL,
    category__id        NUMERIC(10,0)  NOT NULL,
    main                NUMERIC(1,0)   NOT NULL
                                       DEFAULT 0
                                       CONSTRAINT ck_story__category__main
                                         CHECK (main IN (0,1)),
    CONSTRAINT pk_story_category__id PRIMARY KEY (id)
);


CREATE TABLE story__contributor (
    id                  NUMERIC(10,0)   NOT NULL
                                        DEFAULT NEXTVAL('seq_story__contributor'),
    story_instance__id  NUMERIC(10,0)   NOT NULL,
    member__id          NUMERIC(10,0)   NOT NULL,
    place               NUMERIC(3,0)    NOT NULL,
    role                VARCHAR(256),
    CONSTRAINT pk_story_category_id PRIMARY KEY (id)
);


CREATE TABLE attr_story (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_story'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_story__active
                               CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_story__id PRIMARY KEY (id)
);


CREATE TABLE attr_story_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_story_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_story_val__active
                                   CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_story_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_story_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_story_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_story_meta__active
                                CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_story_meta__id PRIMARY KEY (id)
);



CREATE INDEX idx_story__primary_uri ON story(LOWER(primary_uri));
CREATE INDEX fdx_usr__story ON story(usr__id);
CREATE INDEX fdx_source__story ON story(source__id);
CREATE INDEX fdx_element__story ON story(element__id);
CREATE INDEX fdx_site_id__story ON story(site__id);
CREATE INDEX fdx_alias_id__story ON story(alias_id);
CREATE INDEX idx_story__first_publish_date ON story(first_publish_date);
CREATE INDEX idx_story__publish_date ON story(publish_date);
CREATE INDEX idx_story__cover_date ON story(cover_date);

CREATE INDEX idx_story_instance__name ON story_instance(LOWER(name));
CREATE INDEX idx_story_instance__description ON story_instance(LOWER(description));
CREATE INDEX idx_story_instance__slug ON story_instance(LOWER(slug));
CREATE INDEX fdx_story__story_instance ON story_instance(story__id);
CREATE INDEX fdx_usr__story_instance ON story_instance(usr__id);
CREATE INDEX fdx_primary_oc__story_instance ON story_instance(primary_oc__id);

CREATE INDEX fkx_story__story_uri ON story_uri(story__id);
CREATE UNIQUE INDEX udx_story_uri__site_id__uri
ON story_uri(lower_text_num(uri, site__id));

CREATE UNIQUE INDEX udx_story_category__story__cat ON story__category(story_instance__id, category__id);
CREATE INDEX fkx_story__story__category ON story__category(story_instance__id);
CREATE INDEX fkx_category__story__category ON story__category(category__id);

CREATE INDEX fkx_story__oc__story ON story__output_channel(story_instance__id);
CREATE INDEX fkx_story__oc__oc ON story__output_channel(output_channel__id);

CREATE INDEX fkx_story__story__contributor ON story__contributor(story_instance__id);
CREATE INDEX fkx_member__story__contributor ON story__contributor(member__id);

CREATE UNIQUE INDEX udx_attr_story__subsys__name ON attr_story(subsys, name);

CREATE INDEX idx_attr_story__name ON attr_story(LOWER(name));
CREATE INDEX idx_attr_story__subsys ON attr_story(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_story_val__obj_attr ON attr_story_val (object__id,attr__id);

CREATE INDEX fkx_story__attr_story_val ON attr_story_val(object__id);
CREATE INDEX fkx_attr_story__attr_story_val ON attr_story_val(attr__id);

CREATE UNIQUE INDEX udx_attr_story_meta__attr_name ON attr_story_meta (attr__id, name);

CREATE INDEX idx_attr_story_meta__name ON attr_story_meta(LOWER(name));

CREATE INDEX fkx_attr_story__attr_story_meta ON attr_story_meta(attr__id);

CREATE INDEX fdx_story__desk__id ON story(desk__id) WHERE desk__id > 0;
CREATE INDEX fdx_story__workflow__id ON story(workflow__id) WHERE workflow__id > 0;


CREATE SEQUENCE seq_formatting START 1024;

CREATE SEQUENCE seq_formatting_instance START 1024;

CREATE SEQUENCE seq_formatting_member START 1024;


CREATE SEQUENCE seq_attr_formatting START 1024;

CREATE SEQUENCE seq_attr_formatting_val START 1024;

CREATE SEQUENCE seq_attr_formatting_meta START 1024;


CREATE TABLE formatting (
    id                  NUMERIC(10,0)  NOT NULL
                                       DEFAULT NEXTVAL('seq_formatting'),
    name                VARCHAR(256),
    description         VARCHAR(1024),
    priority            NUMERIC(1,0)   NOT NULL
                                       DEFAULT 3
                                       CONSTRAINT ck_story__priority
                                         CHECK (priority BETWEEN 1 AND 5),
    usr__id             NUMERIC(10,0),  
    output_channel__id  NUMERIC(10,0)  NOT NULL,
    tplate_type         NUMERIC(1,0)   NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_formatting___tplate_type
                                         CHECK (tplate_type IN (1, 2, 3)),
    element__id         NUMERIC(10,0),
    category__id        NUMERIC(10,0),
    file_name           TEXT,
    current_version     NUMERIC(10,0)  NOT NULL,
    workflow__id        NUMERIC(10,0)  NOT NULL,
    desk__id            NUMERIC(10,0)  NOT NULL,
    published_version   NUMERIC(10, 0),
    deploy_status       NUMERIC(1,0)   NOT NULL
                                       DEFAULT 0
                                       CONSTRAINT ck_formatting__deploy_status
                                         CHECK (deploy_status IN (0,1)),
    deploy_date         TIMESTAMP,
    expire_date         TIMESTAMP,
    active              NUMERIC(1,0)   NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_formatting__active
                                         CHECK (active IN (0,1)),
    site__id            NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_formatting__id PRIMARY KEY (id)
);


CREATE TABLE formatting_instance (
    id              NUMERIC(10,0)  NOT NULL
                                       DEFAULT NEXTVAL('seq_formatting_instance'),
    formatting__id  NUMERIC(10,0)  NOT NULL,
    version         NUMERIC(10,0),
    usr__id         NUMERIC(10,0)  NOT NULL,
    file_name       TEXT,
    data            TEXT,
    checked_out     NUMERIC(1,0)   NOT NULL     
                                   DEFAULT 0
                                   CONSTRAINT ck_formatting_instance__active
                                     CHECK (checked_out IN (0,1)),
    CONSTRAINT pk_formatting_instance__id PRIMARY KEY (id)
);
        


CREATE TABLE formatting_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_formatting_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_formatting_member__id PRIMARY KEY (id)
);


CREATE TABLE attr_formatting (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_formatting'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_formatting__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_formatting__id PRIMARY KEY (id)
);



CREATE TABLE attr_formatting_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_formatting_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_formatting_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_formatting_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_formatting_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_formatting_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_formatting_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_formatting_meta__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_formatting__file_name__oc
       ON formatting(file_name, output_channel__id);
CREATE INDEX idx_formatting__name ON formatting(LOWER(name));
CREATE INDEX idx_formatting__file_name ON formatting(LOWER(file_name));
CREATE INDEX idx_formatting__description ON formatting(LOWER(description));
CREATE INDEX idx_formatting__deploy_date ON formatting(deploy_date);
CREATE INDEX fkx_usr__formatting ON formatting(usr__id);
CREATE INDEX fkx_output_channel__formatting ON formatting(output_channel__id);
CREATE INDEX fkx_element__formatting ON formatting(element__id);
CREATE INDEX fkx_category__formatting ON formatting(category__id);
CREATE INDEX fdx_formatting__desk__id ON formatting(desk__id) WHERE desk__id > 0;
CREATE INDEX fdx_formatting__workflow__id ON formatting(workflow__id) WHERE workflow__id > 0;
CREATE INDEX fkx_site__formatting ON formatting(site__id);

CREATE INDEX fkx_usr__formatting_instance ON formatting_instance(usr__id);
CREATE INDEX fkx_formatting__frmt_instance ON formatting_instance(formatting__id);

CREATE INDEX fkx_frmt__frmt_member ON formatting_member(object_id);
CREATE INDEX fkx_member__frmt_member ON formatting_member(member__id);

CREATE UNIQUE INDEX udx_attr_frmt__subsys__name ON attr_formatting(subsys, name);

CREATE INDEX idx_attr_frmt__name ON attr_formatting(LOWER(name));
CREATE INDEX idx_attr_frmt__subsys ON attr_formatting(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_frmt_val__obj_attr ON attr_formatting_val (object__id,attr__id);

CREATE INDEX fkx_frmt__attr_frmt_val ON attr_formatting_val(object__id);
CREATE INDEX fkx_attr_frmt__attr_frmt_val ON attr_formatting_val(attr__id);

CREATE UNIQUE INDEX udx_attr_frmt_meta__attr_name ON attr_formatting_meta (attr__id, name);

CREATE INDEX idx_attr_frmt_meta__name ON attr_formatting_meta(LOWER(name));

CREATE INDEX fkx_attr_frmt__attr_frmt_meta ON attr_formatting_meta(attr__id);


CREATE SEQUENCE seq_element START 1024;

CREATE SEQUENCE seq_element__output_channel START 1024;


CREATE SEQUENCE seq_element_member START 1024;

CREATE SEQUENCE seq_attr_element START 1024;

CREATE SEQUENCE seq_attr_element_val START 1024;

CREATE SEQUENCE seq_attr_element_meta START 1024;

CREATE SEQUENCE seq_element__site START 1024;


CREATE TABLE element  (
    id              NUMERIC(10,0)  NOT NULL
                                   DEFAULT NEXTVAL('seq_element'),
    name            VARCHAR(64)    NOT NULL,
    key_name        VARCHAR(64)    NOT NULL,
    description     VARCHAR(256),
    burner          NUMERIC(2,0)   NOT NULL DEFAULT 1,
    reference       NUMERIC(1,0)   NOT NULL
                                   DEFAULT 0
                                   CONSTRAINT ck_element__reference
                                     CHECK (reference IN (0,1)),
    type__id        NUMERIC(10,0)  NOT NULL,
    at_grp__id      NUMERIC(10,0),
    active          NUMERIC(1,0)   NOT NULL
                                   DEFAULT 1
                                   CONSTRAINT ck_element__active
                                    CHECK (active IN (0,1)),
    CONSTRAINT pk_element__id PRIMARY KEY (id)
);


CREATE TABLE element__site (
    id              NUMERIC(10,0)  NOT NULL
                                   DEFAULT NEXTVAL('seq_element__site'),
    element__id    NUMERIC(10)     NOT NULL,
    site__id       NUMERIC(10)     NOT NULL,
    active         NUMERIC(1)      DEFAULT 1
                                   NOT NULL
                                   CONSTRAINT ck_site_element__active
                                     CHECK (active IN (0,1)),
    primary_oc__id  NUMERIC(10,0) NOT NULL,
    CONSTRAINT pk_element__site__id PRIMARY KEY (id)
);


CREATE TABLE element__output_channel (
    id                  NUMERIC(10,0)  NOT NULL
                                       DEFAULT NEXTVAL('seq_element__output_channel'),
    element__id         NUMERIC(10,0)  NOT NULL,
    output_channel__id  NUMERIC(10,0)  NOT NULL,
    enabled             NUMERIC(1,0)   NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_at__oc__enabled
                                         CHECK (enabled IN (0,1)),
    active              NUMERIC(1,0)   NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_at__oc__active
                                         CHECK (active IN (0,1)),
    CONSTRAINT pk_at__oc__id PRIMARY KEY (id)
);


/*

CREATE TABLE element__language (
    id               NUMERIC(10)  NOT NULL
                                  DEFAULT NEXTVAL('seq_element__language'),
    element__id   NUMERIC(10)  NOT NULL,
    language__id     NUMERIC(10)  NOT NULL,
    active           NUMERIC(1)   NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_at__oc__active
                                    CHECK (active IN (0,1)),
    CONSTRAINT pk_element__language__id PRIMARY KEY (id)
);

*/


CREATE TABLE element_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_element_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_element_member__id PRIMARY KEY (id)
);


CREATE TABLE attr_element (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_element'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_element__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_element__id PRIMARY KEY (id)
);



CREATE TABLE attr_element_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_element_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_element_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_element_val__id PRIMARY KEY (id)
);


CREATE TABLE attr_element_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_element_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_element_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_element_meta__id PRIMARY KEY (id)
);

CREATE UNIQUE INDEX udx_element__key_name ON element(LOWER(key_name));
CREATE INDEX fkx_at_type__element ON element(type__id);
CREATE INDEX fkx_grp__element ON element(at_grp__id);


CREATE UNIQUE INDEX udx_at_oc_id__at__oc_id ON element__output_channel(element__id, output_channel__id);
CREATE INDEX fkx_output_channel__at_oc ON element__output_channel(output_channel__id);
CREATE INDEX fkx_element__at_oc ON element__output_channel(element__id);


CREATE INDEX fkx_element__at_member ON element_member(object_id);
CREATE INDEX fkx_member__at_member ON element_member(member__id);

CREATE UNIQUE INDEX udx_element__site on element__site(element__id, site__id);


CREATE UNIQUE INDEX udx_attr_at__subsys__name ON attr_element(subsys, name);

CREATE INDEX idx_attr_at__name ON attr_element(LOWER(name));
CREATE INDEX idx_attr_at__subsys ON attr_element(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_at_val__obj_attr ON attr_element_val (object__id,attr__id);

CREATE INDEX fkx_at__attr_at_val ON attr_element_val(object__id);
CREATE INDEX fkx_attr_at__attr_at_val ON attr_element_val(attr__id);

CREATE UNIQUE INDEX udx_attr_at_meta__attr_name ON attr_element_meta (attr__id, name);

CREATE INDEX idx_attr_at_meta__name ON attr_element_meta(LOWER(name));

CREATE INDEX fkx_attr_at__attr_at_meta ON attr_element_meta(attr__id);

CREATE INDEX fkx_element__element__site__element__id ON element__site(element__id);
CREATE INDEX fkx_site__element__site__site__id ON element__site(site__id);
CREATE INDEX fkx_output_channel__element__site ON element__site(primary_oc__id);





CREATE SEQUENCE seq_at_data START 1024;

CREATE SEQUENCE seq_attr_at_data START 1024;

CREATE SEQUENCE seq_attr_at_data_val START 1024;

CREATE SEQUENCE seq_attr_at_data_meta START 1024;



CREATE TABLE at_data (
    id              NUMERIC(10,0)   NOT NULL
                                    DEFAULT NEXTVAL('seq_element'),
    element__id     NUMERIC(10,0)   NOT NULL,
    key_name        VARCHAR(32),
    description     VARCHAR(256),
    place           NUMERIC(10,0)   NOT NULL,
    required        NUMERIC(1,0)    NOT NULL
                                    DEFAULT 0
                                    CONSTRAINT ck_at_data__required
                                      CHECK (required IN (0,1)),
    quantifier      VARCHAR(2),
    autopopulated   NUMERIC(1,0)    NOT NULL
                                    DEFAULT 0
                                      CONSTRAINT ck_at_data__autopopulated
                                      CHECK (autopopulated IN (0,1)),
    active          NUMERIC(1,0)    NOT NULL
                                    DEFAULT 1
                                    CONSTRAINT ck_at_data__active
                                      CHECK (active IN (0,1)),
    map_type__id     NUMERIC(10,0),
    publishable      NUMERIC(1,0)   NOT NULL
                                    DEFAULT 0
                                    CONSTRAINT ck_at_data__publishable
                                      CHECK (publishable IN (0,1)),
    max_length       NUMERIC(10,0),
    sql_type         VARCHAR(30),
    CONSTRAINT pk_at_data__id PRIMARY KEY (id)
);


CREATE TABLE attr_at_data (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_at_data'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_at_data__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_at_data__id PRIMARY KEY (id)
);


CREATE TABLE attr_at_data_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_at_data_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_at_data_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_at_data_val__id PRIMARY KEY (id)
);


CREATE TABLE attr_at_data_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_at_data_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     TEXT,
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_at_data_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_at_data_meta__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_atd__key_name__at_id ON at_data(lower_text_num(key_name, element__id));
CREATE INDEX fkx_map_type__atd on at_data(map_type__id);
CREATE INDEX fkx_element__atd on at_data(element__id);

CREATE UNIQUE INDEX udx_attr_atd__subsys__name ON attr_at_data(subsys, name);

CREATE INDEX idx_attr_atd__name ON attr_at_data(LOWER(name));
CREATE INDEX idx_attr_atd__subsys ON attr_at_data(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_atd_val__obj_attr ON attr_at_data_val (object__id,attr__id);

CREATE INDEX fkx_atd__attr_atd_val ON attr_at_data_val(object__id);
CREATE INDEX fkx_attr_atd__attr_atd_val ON attr_at_data_val(attr__id);

CREATE UNIQUE INDEX udx_attr_atd_meta__attr_name ON attr_at_data_meta (attr__id, name);

CREATE INDEX idx_attr_atd_meta__name ON attr_at_data_meta(LOWER(name));

CREATE INDEX fkx_attr_atd__attr_atd_meta ON attr_at_data_meta(attr__id);




CREATE SEQUENCE seq_category START  1024;

CREATE SEQUENCE seq_category_member START  1024;

CREATE SEQUENCE seq_attr_category START 1024;

CREATE SEQUENCE seq_attr_category_val START 1024;

CREATE SEQUENCE seq_attr_category_meta START 1024;


CREATE TABLE category (
    id               NUMERIC(10,0)   NOT NULL
                                     DEFAULT NEXTVAL('seq_category'),
    site__id         NUMERIC(10,0)   NOT NULL,
    directory        VARCHAR(128)    NOT NULL,
    uri              VARCHAR(256)    NOT NULL,
    name             VARCHAR(64),
    description      VARCHAR(256),
    parent_id        NUMERIC(10,0)   NOT NULL,
    asset_grp_id     NUMERIC(10,0)   NOT NULL,
    active           NUMERIC(1,0)    NOT NULL
                                     DEFAULT 1
                                     CONSTRAINT ck_category__active
                                       CHECK (active IN (0,1)),
    CONSTRAINT pk_category__id PRIMARY KEY (id)
);



CREATE TABLE category_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_category_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_category_member__id PRIMARY KEY (id)
);


CREATE TABLE attr_category (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_category'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_category__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_category__id PRIMARY KEY (id)
);




CREATE TABLE attr_category_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_category_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_category_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_category_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_category_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_category_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_category_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_category_meta__id PRIMARY KEY (id)
);


CREATE INDEX idx_category__directory ON category(LOWER(directory));
CREATE UNIQUE INDEX udx_category__site_uri ON category(site__id, uri);
CREATE INDEX idx_category__uri ON category(uri);
CREATE INDEX idx_category__lower_uri ON category(LOWER(uri));
CREATE INDEX idx_category__name ON category(LOWER(name));
CREATE INDEX idx_category__parent_id ON category(parent_id);
CREATE INDEX fkx_asset_grp__category ON category(asset_grp_id);

CREATE INDEX fkx_category__category_member ON category_member(object_id);
CREATE INDEX fkx_member__category_member ON category_member(member__id);
CREATE INDEX fkx_category__site ON category(site__id);

CREATE UNIQUE INDEX udx_attr_cat__subsys__name ON attr_category(subsys, name);

CREATE INDEX idx_attr_cat__name ON attr_category(LOWER(name));
CREATE INDEX idx_attr_cat__subsys ON attr_category(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_cat_val__obj_attr ON attr_category_val (object__id,attr__id);

CREATE INDEX fkx_cat__attr_cat_val ON attr_category_val(object__id);
CREATE INDEX fkx_attr_cat__attr_cat_val ON attr_category_val(attr__id);

CREATE UNIQUE INDEX udx_attr_cat_meta__attr_name ON attr_category_meta (attr__id, name);

CREATE INDEX idx_attr_cat_meta__name ON attr_category_meta(LOWER(name));

CREATE INDEX fkx_attr_cat__attr_cat_meta ON attr_category_meta(attr__id);




CREATE SEQUENCE seq_contact START 1024;
CREATE SEQUENCE seq_contact_value START 1024;


CREATE TABLE contact (
    id           NUMERIC(10, 0)    NOT NULL
                                   DEFAULT NEXTVAL('seq_contact'),
    type         VARCHAR(64)       NOT NULL,
    description	 VARCHAR(256),
    active       NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_contact__active
                                     CHECK (active IN (1,0)),
    alertable    NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 0
                                   CONSTRAINT ck_contact__alertable
                                     CHECK (alertable IN (1,0)),
    CONSTRAINT pk_contact__id PRIMARY KEY (id)
);


CREATE TABLE contact_value (
    id           NUMERIC(10, 0)    NOT NULL
                                   DEFAULT NEXTVAL('seq_contact_value'),
    contact__id  NUMERIC(10, 0)    NOT NULL,
    value	 VARCHAR(256)	   NOT NULL,
    active       NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_contact_value__active
                                     CHECK (active IN (1,0)),
    CONSTRAINT pk_contact_value__id PRIMARY KEY (id)
);

CREATE TABLE person__contact_value (
    person__id   NUMERIC(10, 0) NOT NULL,
    contact_value__id  NUMERIC(10, 0) NOT NULL,
    CONSTRAINT pk_person__contact_value PRIMARY KEY (person__id, contact_value__id)
);



CREATE UNIQUE INDEX udx_contact__type ON contact(LOWER(type));
CREATE INDEX idx_contact_value_value ON contact_value(LOWER(value));
CREATE INDEX fdx_contact__contact_value on contact_value(contact__id);

CREATE INDEX fkx_person__p_c_val ON person__contact_value(person__id);
CREATE INDEX fkx_contact_value__p_c_val ON person__contact_value(contact_value__id);


CREATE SEQUENCE seq_keyword START 1024;
CREATE SEQUENCE seq_keyword_member START 1024;



CREATE TABLE keyword (
    id               NUMERIC(10)   NOT NULL
                                   DEFAULT NEXTVAL('seq_keyword'),
    name             VARCHAR(256)  NOT NULL,
    screen_name      VARCHAR(256)  NOT NULL,
    sort_name        VARCHAR(256)  NOT NULL,
    active           NUMERIC(1)	   NOT NULL
                                   DEFAULT 1
                                   CONSTRAINT ck_keyword__active
                                     CHECK (active IN (0,1)),
    CONSTRAINT pk_keyword__id PRIMARY KEY (id)
);


CREATE TABLE story_keyword (
    story_id          NUMERIC(10,0)  NOT NULL,
    keyword_id        NUMERIC(10,0)  NOT NULL,
    PRIMARY KEY (story_id, keyword_id)
);



CREATE TABLE media_keyword (
    media_id         NUMERIC(10,0)  NOT NULL,
    keyword_id       NUMERIC(10,0)  NOT NULL,
    PRIMARY KEY (media_id, keyword_id)
);


CREATE TABLE category_keyword (
    category_id       NUMERIC(10,0)  NOT NULL,
    keyword_id        NUMERIC(10,0)  NOT NULL,
    PRIMARY KEY (category_id, keyword_id)
);


CREATE TABLE keyword_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_keyword_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_keyword_member__id PRIMARY KEY (id)
);





CREATE UNIQUE INDEX udx_keyword__name ON keyword(LOWER(name));
CREATE INDEX idx_keyword__screen_name ON keyword(LOWER(screen_name));
CREATE INDEX idx_keyword__sort_name   ON keyword(LOWER(sort_name));

CREATE INDEX fkx_keyword__keyword_member ON keyword_member(object_id);
CREATE INDEX fkx_member__keyword_member ON keyword_member(member__id);







CREATE SEQUENCE seq_org START 1024;

CREATE TABLE org (
    id           NUMERIC(10, 0)    NOT NULL
                                   DEFAULT NEXTVAL('seq_org'),
    name         VARCHAR(64)       NOT NULL,
    long_name    VARCHAR(128),
    personal     NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 0
                                   CONSTRAINT ck_org__personal
                                     CHECK (personal IN (1,0)),
    active       NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_org__active
                                     CHECK (active IN (1,0)),
    CONSTRAINT pk_org__id PRIMARY KEY (id)
);



CREATE INDEX idx_org__name ON org (LOWER(name));




CREATE SEQUENCE seq_addr START 1024;
CREATE SEQUENCE seq_addr_part START 1024;
CREATE SEQUENCE seq_addr_part_type START 1024;



CREATE TABLE addr (
    id         NUMERIC(10, 0)      NOT NULL
                                   DEFAULT NEXTVAL('seq_addr'),
    org__id    NUMERIC(10, 0)      NOT NULL,
    type       VARCHAR(64),
    active     NUMERIC(1, 0)       NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_addr__active
                                     CHECK (active IN (1,0)),
    CONSTRAINT pk_addr__id PRIMARY KEY (id)
);



CREATE TABLE addr_part_type (
    id         NUMERIC(10, 0)      NOT NULL
                                   DEFAULT NEXTVAL('seq_addr_part_type'),
    name      VARCHAR(64)          NOT NULL,
    active     NUMERIC(1, 0)       NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_addr_part_type__active
                                     CHECK (active IN (1,0)),
    CONSTRAINT pk_addr_part_type__id PRIMARY KEY (id)
);



CREATE TABLE addr_part (
    id                    NUMERIC(10, 0)  NOT NULL
                                                 DEFAULT NEXTVAL('seq_addr_part'),
    addr__id              NUMERIC(10, 0)  NOT NULL,
    addr_part_type__id    NUMERIC(10, 0)  NOT NULL,
    value                 VARCHAR(256)    NOT NULL,
    CONSTRAINT pk_addr_part__id PRIMARY KEY (id)
);


CREATE TABLE person_org__addr(
    addr__id          NUMERIC(10, 0)    NOT NULL,
    person_org__id    NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_person_org__addr__all PRIMARY KEY (addr__id,person_org__id)
);


CREATE INDEX idx_addr__type ON addr(LOWER(type));
CREATE UNIQUE INDEX udx_addr_part_type__name ON addr_part_type(LOWER(name));
CREATE INDEX idx_addr_part__value ON addr_part(LOWER(value));

CREATE INDEX fkx_org__addr ON addr(org__id);
CREATE INDEX fkx_addr__addr_part ON addr_part(addr__id);
CREATE INDEX fkx_addr_part_type__addr_part ON addr_part(addr_part_type__id);
CREATE INDEX fkx_addr__person_org_addr ON person_org__addr(addr__id);
CREATE INDEX fk_person_org__pers_org_addr ON person_org__addr(person_org__id);



CREATE SEQUENCE seq_person_org START 1024;

CREATE TABLE person_org(
    id            NUMERIC(10, 0)    NOT NULL
                                    DEFAULT NEXTVAL('seq_person_org'),
    person__id    NUMERIC(10, 0)    NOT NULL,
    org__id       NUMERIC(10, 0)    NOT NULL,
    role          VARCHAR(64),
    department    VARCHAR(64),
    title         VARCHAR(64),
    active        NUMERIC(1, 0)    NOT NULL 
                                   CONSTRAINT ck_person_org__active CHECK (active IN (1,0))
                                   DEFAULT 1,
    CONSTRAINT pk_person_org__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_person_org__person__org ON person_org(person__id, org__id, role);
CREATE INDEX idx_person_org__department ON person_org(LOWER(department));
CREATE INDEX fdx_person__person_org ON person_org(person__id);
CREATE INDEX fdx_org__person_org ON person_org(org__id);




CREATE SEQUENCE seq_source START 1024;



CREATE TABLE source (
    id            NUMERIC(10, 0)    NOT NULL
                                    DEFAULT NEXTVAL('seq_source'),
    org__id       NUMERIC(10, 0)    NOT NULL,
    name          VARCHAR(64)       NOT NULL,
    description   VARCHAR(256),
    expire        NUMERIC(4, 0)     NOT NULL
				    DEFAULT 0,
    active        NUMERIC(1, 0)     CONSTRAINT ck_source__active CHECK (active IN (1,0))
                                    DEFAULT 1,
    CONSTRAINT pk_source__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_source_name ON source(name);
CREATE INDEX fkx_source__org on source(org__id);






CREATE SEQUENCE seq_output_channel START 1024;
CREATE SEQUENCE seq_output_channel_include START 1024;
CREATE SEQUENCE seq_output_channel_member START 1024;


CREATE TABLE output_channel (
    id	         NUMERIC(10,0)  NOT NULL
                                DEFAULT NEXTVAL('seq_output_channel'),
    name             VARCHAR(64)    NOT NULL,
    description      VARCHAR(256),
    site__id         NUMERIC(10,0)  NOT NULL,
    protocol         VARCHAR(16),
    pre_path         VARCHAR(64),
    post_path        VARCHAR(64),
    filename         VARCHAR(32)    NOT NULL,
    file_ext         VARCHAR(32),
    primary_ce       NUMERIC(1,0),
    uri_format       VARCHAR(64)    NOT NULL,
    fixed_uri_format VARCHAR(64)    NOT NULL,
    uri_case         NUMERIC(1,0)   NOT NULL
                                    DEFAULT 1
                                    CONSTRAINT ck_output_channel__uri_case
                                      CHECK (uri_case IN (1,2,3)),
    use_slug         NUMERIC(1,0)   NOT NULL
                                    DEFAULT 0
                                    CONSTRAINT ck_output_channel__use_slug
                                      CHECK (use_slug IN (0,1)),
    active           NUMERIC(1,0)   NOT NULL
                                    DEFAULT 1
                                    CONSTRAINT ck_output_channel__active
                                      CHECK (active IN (0,1)),
    CONSTRAINT pk_output_channel__id PRIMARY KEY (id)
);



CREATE TABLE output_channel_include (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_output_channel_include'),
    output_channel__id         NUMERIC(10,0)  NOT NULL,
    include_oc_id              NUMERIC(10,0)  NOT NULL
                               CONSTRAINT ck_oc_include__include_oc_id
                                 CHECK (include_oc_id <> output_channel__id),
    CONSTRAINT pk_output_channel_include__id PRIMARY KEY (id)
);


CREATE TABLE output_channel_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_output_channel_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_output_channel_member__id PRIMARY KEY (id)
);

CREATE UNIQUE INDEX udx_output_channel__name_site
ON output_channel(lower_text_num(name, site__id));

CREATE INDEX fkx_site__output_channel ON output_channel(site__id);
CREATE INDEX idx_output_channel__filename ON output_channel(LOWER(filename));
CREATE INDEX idx_output_channel__file_ext ON output_channel(LOWER(file_ext));

CREATE INDEX fkx_output_channel__oc_include ON output_channel_include(output_channel__id);
CREATE INDEX fkx_oc__oc_include_inc ON output_channel_include(include_oc_id);
CREATE UNIQUE INDEX udx_output_channel_include ON output_channel_include(output_channel__id, include_oc_id);
CREATE INDEX fkx_output_channel__oc_member ON output_channel_member(object_id);
CREATE INDEX fkx_member__oc_member ON output_channel_member(member__id);




CREATE SEQUENCE seq_person START 1024;
CREATE SEQUENCE seq_person_member START 1024;


CREATE TABLE person (
    id        NUMERIC(10, 0)    NOT NULL
                                DEFAULT NEXTVAL('seq_person'),
    prefix    VARCHAR(32),
    lname     VARCHAR(64),
    fname     VARCHAR(64),
    mname     VARCHAR(64),
    suffix    VARCHAR(32),
    active    NUMERIC(1, 0)     NOT NULL 
                                DEFAULT 1
                                CONSTRAINT ck_person__active
                                  CHECK (active IN (1,0)),
    CONSTRAINT pk_person__id PRIMARY KEY (id)
);




CREATE TABLE person_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_person_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_person_member__id PRIMARY KEY (id)
);



CREATE INDEX idx_person__lname ON person(LOWER(lname));
CREATE INDEX idx_person__fname ON person(LOWER(fname));
CREATE INDEX idx_person__mname ON person(LOWER(mname));

CREATE INDEX fkx_person__person_member ON person_member(object_id);
CREATE INDEX fkx_member__person_member ON person_member(member__id);




CREATE TABLE usr (
    id           NUMERIC(10, 0)    NOT NULL,
    login        VARCHAR(128)      NOT NULL,
    password     CHAR(32)          NOT NULL,
    active       NUMERIC(1, 0)     NOT NULL 
                                   DEFAULT 1
                                   CONSTRAINT ck_usr__active
                                     CHECK (active IN (1,0)),
    CONSTRAINT pk_usr__id PRIMARY KEY (id)
);

CREATE INDEX idx_usr__login ON usr(LOWER(login));
CREATE UNIQUE INDEX udx_usr__login ON usr(LOWER(login)) WHERE active = 1;




CREATE SEQUENCE seq_site_member START 1024;



CREATE TABLE site (
    id          NUMERIC(10, 0)    NOT NULL,
    name        TEXT,
    description TEXT,
    domain_name TEXT,
    active      NUMERIC(1, 0)     NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_site__active
                                    CHECK (active IN (1,0)),
    CONSTRAINT pk_site__id PRIMARY KEY (id)
);




CREATE TABLE site_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_site_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_site_member__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_site__name ON site(LOWER(name));
CREATE UNIQUE INDEX udx_site__domain_name ON site(LOWER(domain_name));
CREATE INDEX fkx_site__site_member ON site_member(object_id);
CREATE INDEX fkx_member__site_member ON site_member(member__id);


CREATE SEQUENCE seq_workflow START  1024;
CREATE SEQUENCE seq_workflow_member START 1024;


CREATE TABLE workflow (
    id               NUMERIC(10)  NOT NULL
                                  DEFAULT NEXTVAL('seq_workflow'),
    name             VARCHAR(64)  NOT NULL,
    description      VARCHAR(256) NOT NULL,
    all_desk_grp_id  NUMERIC(10)  NOT NULL,
    req_desk_grp_id  NUMERIC(10)  NOT NULL,
    asset_grp_id     NUMERIC(10)  NOT NULL,
    head_desk_id     NUMERIC(10)  NOT NULL,
    type             NUMERIC(1)   NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_workflow__type
                                    CHECK (type IN (1,2,3)),
    active           NUMERIC(1)	  NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_workflow__active
                                    CHECK (active IN (0,1)),
    site__id         NUMERIC(10)  NOT NULL,
    CONSTRAINT pk_workflow__id PRIMARY KEY (id)
);


CREATE TABLE workflow_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_workflow_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_workflow_member__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_workflow__name__site__id
ON workflow(lower_text_num(name, site__id));
CREATE INDEX fkx_site__workflow__site__id ON workflow(site__id);
CREATE INDEX fkx_grp__workflow__all_desk_grp_id ON workflow(all_desk_grp_id);
CREATE INDEX fkx_grp__workflow__req_desk_grp_id ON workflow(req_desk_grp_id);
CREATE INDEX fkx_grp__workflow__asset_grp_id ON workflow(asset_grp_id);
CREATE INDEX fkx_workflow__workflow_member ON workflow_member(object_id);
CREATE INDEX fkx_member__workflow_member ON workflow_member(member__id);




CREATE SEQUENCE seq_desk START  1024;

CREATE SEQUENCE seq_desk_member START  1024;


CREATE TABLE desk (
    id              NUMERIC(10)   NOT NULL
                                  DEFAULT NEXTVAL('seq_desk'),
    name            VARCHAR(64)   NOT NULL,
    description     VARCHAR(256),
    pre_chk_rules   NUMERIC(10),
    post_chk_rules  NUMERIC(10),
    asset_grp       NUMERIC(10),
    publish         NUMERIC(1)    NOT NULL
                                  DEFAULT 0
                                  CONSTRAINT ck_desk__publish
                                    CHECK (publish IN (0,1)),
    active          NUMERIC(1)	  NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_desk__active
                                    CHECK (active IN (0,1)),
    CONSTRAINT pk_desk__id PRIMARY KEY (id)
);


CREATE TABLE desk_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_desk_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_desk_member__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_desk__name ON desk(LOWER(name));
CREATE INDEX fkx_asset_grp__desk ON desk(asset_grp);
CREATE INDEX fkx_pre_grp__desk ON desk(pre_chk_rules);
CREATE INDEX fkx_post_grp__desk ON desk(post_chk_rules);

CREATE INDEX fkx_desk__desk_member ON desk_member(object_id);
CREATE INDEX fkx_member__desk_member ON desk_member(member__id);



CREATE SEQUENCE seq_action START 1024;
CREATE SEQUENCE seq_attr_action START 1024;
CREATE SEQUENCE seq_attr_action_val START 1024;
CREATE SEQUENCE seq_attr_action_meta START 1024;



CREATE TABLE action (
    id               NUMERIC(10, 0)    NOT NULL
                                       DEFAULT NEXTVAL('seq_action'),
    ord              NUMERIC(3, 0)     NOT NULL,
    server_type__id  NUMERIC(10, 0)    NOT NULL,
    action_type__id  NUMERIC(10, 0)    NOT NULL,
    active           NUMERIC(1, 0)     NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_action__active
                                         CHECK (active IN (1,0)),
    CONSTRAINT pk_action__id PRIMARY KEY (id)
);



CREATE TABLE attr_action (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_action'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_action__active
                               CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_action__id PRIMARY KEY (id)
);



CREATE TABLE attr_action_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_action_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_action_val__active
				   CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_action_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_action_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_action_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_action_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_action_meta__id PRIMARY KEY (id)
);

CREATE INDEX fkx_action_type__action ON action(action_type__id);
CREATE INDEX fkx_server_type__action ON action(server_type__id);

CREATE UNIQUE INDEX udx_attr_action__subsys__name ON attr_action(subsys, name);

CREATE INDEX idx_attr_action__name ON attr_action(LOWER(name));
CREATE INDEX idx_attr_action__subsys ON attr_action(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_action_val__obj_attr ON attr_action_val (object__id,attr__id);

CREATE INDEX fkx_action__attr_action_val ON attr_action_val(object__id);
CREATE INDEX fkx_attr_action__attr_action_val ON attr_action_val(attr__id);

CREATE UNIQUE INDEX udx_attr_action_meta__attr_name ON attr_action_meta (attr__id, name);

CREATE INDEX idx_attr_action_meta__name ON attr_action_meta(LOWER(name));

CREATE INDEX fkx_attr_action__attr_action_meta ON attr_action_meta(attr__id);




CREATE SEQUENCE seq_action_type START 1024;



CREATE TABLE action_type (
    id            NUMERIC(10, 0)    NOT NULL
                                    DEFAULT NEXTVAL('seq_action_type'),
    name          VARCHAR(64)       NOT NULL,
    description   VARCHAR(256),
    active        NUMERIC(1, 0)     NOT NULL 
                                    DEFAULT 0
                                    CONSTRAINT ck_action_type__active
                                      CHECK (active IN (1,0)),
    CONSTRAINT pk_action_type__id PRIMARY KEY (id)
);



CREATE TABLE action_type__media_type (
    action_type__id  NUMERIC(10, 0)    NOT NULL,
    media_type__id    NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_action__media_type PRIMARY KEY (action_type__id, media_type__id)
);



CREATE UNIQUE INDEX udx_action_type__name ON action_type(LOWER(name));
CREATE INDEX fkx_media_type__at_mt ON action_type__media_type(media_type__id);
CREATE INDEX fkx_action_type__at_mt ON action_type__media_type(action_type__id);





CREATE SEQUENCE seq_resource START 1024;



CREATE TABLE media__resource(
    resource__id    NUMERIC(10, 0)    NOT NULL,
    media__id       NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_media__resource PRIMARY KEY (media__id, resource__id)
);



CREATE TABLE resource(
    id                  NUMERIC(10, 0)    NOT NULL
                                          DEFAULT NEXTVAL('seq_resource'),
    parent_id           NUMERIC(10, 0),
    media_type__id      NUMERIC(10, 0)    NOT NULL,
    path                VARCHAR(256)      NOT NULL,
    uri                 VARCHAR(256)      NOT NULL,
    size                NUMERIC(10, 0)    NOT NULL,
    mod_time            TIMESTAMP         NOT NULL,
    is_dir              NUMERIC(1, 0)     NOT NULL,
    CONSTRAINT pk_resource__id PRIMARY KEY (id)
);



CREATE TABLE story__resource(
    story__id       NUMERIC(10, 0)    NOT NULL,
    resource__id    NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_story__resource PRIMARY KEY (story__id,resource__id)
);


CREATE UNIQUE INDEX udx_resource__path__uri ON resource(path, uri);
CREATE INDEX idx_resource__path ON resource(path);
CREATE INDEX idx_resource__uri ON resource(uri);
CREATE INDEX idx_resource__mod_time ON resource(mod_time);
CREATE INDEX fkx_media_type__resource ON resource(media_type__id);
CREATE INDEX fkx_resource__resource ON resource(parent_id);

CREATE INDEX fkx_resource__media__resource ON media__resource(resource__id);
CREATE INDEX fkx_media__media__resource ON media__resource(media__id);

CREATE INDEX fkx_story__story__resource ON story__resource(story__id);
CREATE INDEX fkx_resource__story__resource ON story__resource(resource__id);



CREATE SEQUENCE seq_server START 1024;

CREATE TABLE server(
    id                 NUMERIC(10, 0)   NOT NULL
                                        DEFAULT NEXTVAL('seq_server'),
    server_type__id    NUMERIC(10, 0)   NOT NULL,
    host_name          VARCHAR(128)     NOT NULL,
    os		       CHAR(5)		NOT NULL,
    doc_root           VARCHAR(128)     NOT NULL,
    login              VARCHAR(64),
    password           VARCHAR(64),
    cookie             VARCHAR(512),
    active             NUMERIC(1, 0)   NOT NULL
                                       DEFAULT 1
                                       CONSTRAINT ck_server__active
                                         CHECK (active IN (1,0)),
    CONSTRAINT pk_server__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_server__name__st_id ON server(host_name, server_type__id);
CREATE INDEX fkx_server_type__server ON server(server_type__id);
CREATE INDEX idx_server__os ON server(os);



CREATE SEQUENCE seq_server_type START 1024;
CREATE SEQUENCE seq_dest_member START 1024;


CREATE TABLE server_type(
    id             NUMERIC(10, 0)    NOT NULL
                                     DEFAULT NEXTVAL('seq_server_type'),
    class__id      NUMERIC(10, 0)    NOT NULL,
    name           VARCHAR(64)       NOT NULL,
    description    VARCHAR(256),
    site__id       NUMERIC(10, 0)    NOT NULL,
    copyable       NUMERIC(1, 0)     NOT NULL
                                     DEFAULT 0
                                     CONSTRAINT ck_server_type__copyable
                                       CHECK (copyable IN (1,0)),
    publish        NUMERIC(1, 0)     NOT NULL
                                     DEFAULT 1
                                     CONSTRAINT ck_server_type__publish
                                       CHECK (publish IN (1,0)),
    preview        NUMERIC(1, 0)     NOT NULL
                                     DEFAULT 0
                                     CONSTRAINT ck_server_type__preview
                                       CHECK (preview IN (1,0)),
    active         NUMERIC(1, 0)     NOT NULL
                                     DEFAULT 1
                                     CONSTRAINT ck_server_type__active
                                       CHECK (active IN (1,0)),
    CONSTRAINT pk_server_type__id PRIMARY KEY (id)
);



CREATE TABLE server_type__output_channel(
    server_type__id    NUMERIC(10, 0)  NOT NULL,
    output_channel__id NUMERIC(10, 0)  NOT NULL,
    CONSTRAINT pk_server_type__output_channel
      PRIMARY KEY (server_type__id, output_channel__id)
);



CREATE TABLE dest_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_dest_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_dest_member__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_server_type__name_site
ON server_type(lower_text_num(name, site__id));

CREATE INDEX fkx_site__server_type ON server_type(site__id);
CREATE INDEX fkx_class__server_type ON server_type(class__id);

CREATE INDEX fkx_server_type__st_oc ON server_type__output_channel(server_type__id);
CREATE INDEX fk_output_channel__st_oc ON server_type__output_channel(output_channel__id);

CREATE INDEX fkx_dest__dest_member ON dest_member(object_id);
CREATE INDEX fkx_member__dest_member ON dest_member(member__id);





CREATE SEQUENCE seq_alert START 1024;



CREATE TABLE alert(
    id                NUMERIC(10, 0)    NOT NULL
                                        DEFAULT NEXTVAL('seq_alert'),
    alert_type__id    NUMERIC(10, 0)    NOT NULL,
    event__id         NUMERIC(10, 0)    NOT NULL,
    subject           VARCHAR(128),
    message           VARCHAR(512),
    timestamp         TIMESTAMP         NOT NULL
                                        DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT pk_alert__id PRIMARY KEY (id)
);

 
CREATE INDEX idx_alert__timestamp ON alert(timestamp);
CREATE INDEX fkx_alert_type__alert ON alert(alert_type__id);
CREATE INDEX fkx_event__alert ON alert(event__id);




CREATE SEQUENCE seq_alert_type START 1024;



CREATE TABLE alert_type (
    id                NUMERIC(10, 0)    NOT NULL
                                        DEFAULT NEXTVAL('seq_alert_type'),
    event_type__id    NUMERIC(10, 0)    NOT NULL,
    usr__id           NUMERIC(10, 0)    NOT NULL,
    name              VARCHAR(64)       NOT NULL,
    subject           VARCHAR(128),
    message           VARCHAR(512),
    active            NUMERIC(1, 0)     NOT NULL 
                                        CONSTRAINT ck_alert_type__active CHECK (active IN (1,0))
                                        DEFAULT 1,
    del               NUMERIC(1, 0)     NOT NULL 
                                        CONSTRAINT ck_alert_type__del CHECK (del IN (1,0))
                                        DEFAULT 0,
    CONSTRAINT pk_alert_type__id PRIMARY KEY (id)
);



CREATE TABLE alert_type__grp__contact(
    alert_type__id    NUMERIC(10, 0)    NOT NULL,
    contact__id       NUMERIC(10, 0)    NOT NULL,
    grp__id           NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_alert_type__grp__contact PRIMARY KEY (alert_type__id, contact__id, grp__id)
);



CREATE TABLE alert_type__usr__contact(
    alert_type__id    NUMERIC(10, 0)    NOT NULL,
    contact__id       NUMERIC(10, 0)    NOT NULL,
    usr__id           NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_alert_type__usr__contact PRIMARY KEY (alert_type__id, usr__id, contact__id)
);



CREATE UNIQUE INDEX udx_alert_type__name__usr__id
ON alert_type(lower_text_num(name, usr__id));

CREATE INDEX idx_alert_type__name ON alert_type(LOWER(name));
CREATE INDEX fkx_event_type__alert_type ON alert_type(event_type__id);
CREATE INDEX fkx_usr__alert_type ON alert_type(usr__id);

CREATE INDEX fkx_alert_type__grp__contact ON alert_type__grp__contact(alert_type__id);
CREATE INDEX fkx_contact__grp__contact ON alert_type__grp__contact(contact__id);
CREATE INDEX fkx_grp__grp__contact ON alert_type__grp__contact(grp__id);

CREATE INDEX fkx_alert_type__at_user__cont ON alert_type__usr__contact(alert_type__id);
CREATE INDEX fkx_contact__at_usr__contact  ON alert_type__usr__contact(contact__id);
CREATE INDEX fkx_usr__at_usr__contact ON alert_type__usr__contact(usr__id);




CREATE SEQUENCE seq_alert_type_rule START  1024;


CREATE TABLE alert_type_rule(
    id                NUMERIC(10, 0)  NOT NULL
                                      DEFAULT NEXTVAL('seq_alert_type_rule'),
    alert_type__id    NUMERIC(10, 0)  NOT NULL,
    attr              VARCHAR(64)     NOT NULL,
    operator          CHAR(2)         NOT NULL,
    value             VARCHAR(256)    NOT NULL,
    CONSTRAINT pk_alert_type_rule__id PRIMARY KEY (id)
);


CREATE INDEX idx_alert_type_rule__attr ON alert_type_rule(LOWER(attr));
CREATE INDEX idx_alert_type_rule__value ON alert_type_rule(LOWER(value));
CREATE INDEX fkx_alert_type__at_rule ON alert_type_rule(alert_type__id);





CREATE SEQUENCE seq_alerted START  1024;


CREATE TABLE alerted(
    id           NUMERIC(10, 0)    NOT NULL
                                   DEFAULT NEXTVAL('seq_alerted'),
    usr__id      NUMERIC(10, 0)    NOT NULL,
    alert__id    NUMERIC(10, 0)    NOT NULL,
    ack_time     TIMESTAMP,
    CONSTRAINT pk_alerted__id PRIMARY KEY (id)
);



CREATE TABLE alerted__contact_value(
    alerted__id	            NUMERIC(10, 0)  NOT NULL,
    contact__id             NUMERIC(10, 0)  NOT NULL,
    contact_value__value    VARCHAR(256)    NOT NULL,
    sent_time               TIMESTAMP,
    CONSTRAINT pk_alerted__contact_value PRIMARY KEY (alerted__id, contact__id, contact_value__value)
);


CREATE INDEX idx_alerted__ack_time ON alerted(ack_time);
CREATE INDEX fkx_alert__alerted ON alerted(alert__id);
CREATE INDEX fkx_usr__alerted ON alerted(usr__id);

CREATE INDEX idx_ac_value__sent_time ON alerted__contact_value(sent_time);
CREATE INDEX idx_ac_value__cv__value ON alerted__contact_value(contact_value__value);
CREATE INDEX fkx_alerted__alerted__contact ON alerted__contact_value(alerted__id);
CREATE INDEX fkx_contact__alerted__cont ON alerted__contact_value(contact__id);



/*


CREATE SEQUENCE seq_async  START  1024; 


CREATE TABLE async (
    id           NUMERIC(10,0) NOT NULL
                               DEFAULT NEXTVAL('seq_async'),
    name         VARCHAR(32)   NOT NULL,
    description  VARCHAR(256),
    file_name    VARCHAR(128),
    active       NUMERIC(1,0)  NOT NULL
                               DEFAULT 1
                               CONSTRAINT ck_async__active
                                          CHECK (active IN (0,1)),
    CONSTRAINT pk_async__id PRIMARY KEY (id)
);


 
CREATE UNIQUE INDEX udx_async__file_name ON async(LOWER(file_name));
CREATE INDEX idx_async__name ON async(LOWER(name));

*/



/* Commented out because attr_person won't be used in production (in this version).
   However, the examples still apply. --David, 23 Feb 2001


CREATE SEQUENCE seq_attr_person START 1024;

CREATE SEQUENCE seq_attr_person_val START 1024;

CREATE SEQUENCE seq_attr_person_meta START 1024;


CREATE TABLE attr_person (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_person'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_person__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_person__id PRIMARY KEY (id)
);



CREATE TABLE attr_person_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_person_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_person_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_person_val__id PRIMARY KEY (id)
);


CREATE TABLE attr_person_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_person_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_person_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_person_meta__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_attr_person__subsys__name ON attr_person(subsys, name);

CREATE INDEX idx_attr_person__name ON attr_person(LOWER(name));
CREATE INDEX idx_attr_person__subsys ON attr_person(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_person_val__obj_attr ON attr_person_val (object__id,attr__id);

CREATE INDEX fkx_person__attr_person_val ON attr_person_val(object__id);
CREATE INDEX fkx_attr_person__attr_person_val ON attr_person_val(attr__id);

CREATE UNIQUE INDEX udx_attr_person_meta__attr_name ON attr_person_meta (attr__id, name);

CREATE INDEX idx_attr_person_meta__name ON attr_person_meta(LOWER(name));

CREATE INDEX fkx_attr_person__attr_person_meta ON attr_person_meta(attr__id);

*/




CREATE SEQUENCE seq_class START 1024;


CREATE TABLE class(
    id              NUMERIC(10, 0)  NOT NULL
                                    DEFAULT NEXTVAL('seq_class'),
    key_name        VARCHAR(32)     NOT NULL
                                    CONSTRAINT ck_class__key_name
                                    CHECK (LOWER(key_name) = key_name),
    pkg_name        VARCHAR(128)    NOT NULL,
    disp_name       VARCHAR(128)    NOT NULL,
    plural_name	    VARCHAR(128)    NOT NULL,
    description     VARCHAR(256),
    distributor     NUMERIC(1, 0)   NOT NULL 
                                    CONSTRAINT ck_class__distributor 
                                        CHECK (distributor IN (1,0))
                                    DEFAULT 0,
    CONSTRAINT pk_class__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_class__key_name ON class(LOWER(key_name));
CREATE UNIQUE INDEX udx_class__pkg_name ON class(LOWER(pkg_name));
CREATE UNIQUE INDEX udx_class__disp__name ON class(LOWER(disp_name));




CREATE SEQUENCE seq_event START 1024;
CREATE SEQUENCE seq_event_attr START 1024;


CREATE TABLE event (
    id                NUMERIC(10, 0)    NOT NULL
                                        DEFAULT NEXTVAL('seq_event'),
    event_type__id    NUMERIC(10, 0)    NOT NULL,
    usr__id           NUMERIC(10, 0)    NOT NULL,
    obj_id            NUMERIC(10, 0)    NOT NULL,
    timestamp         TIMESTAMP         NOT NULL
                                        DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT pk_event__id PRIMARY KEY (id)
);

CREATE TABLE event_attr (
    id                   NUMERIC(10, 0)   NOT NULL
                                          DEFAULT NEXTVAL('seq_event_attr'),
    event__id            NUMERIC(10, 0)   NOT NULL,
    event_type_attr__id  NUMERIC(10, 0)   NOT NULL,
    value                VARCHAR(128),
    CONSTRAINT pk_event_attr__id PRIMARY KEY (id)
);


CREATE INDEX fkx_event_type__event ON event(event_type__id);
CREATE INDEX fkx_usr__event ON event(usr__id);
CREATE INDEX idx_event__timestamp ON event(timestamp);
CREATE INDEX idx_event__obj_id ON event(obj_id);

CREATE INDEX fkx_event__event_attr ON event_attr(event__id);
CREATE INDEX fkx_event_type_attr__event_attr ON event_attr(event_type_attr__id);




CREATE SEQUENCE seq_event_type START 1024;
CREATE SEQUENCE seq_event_type_attr START 1024;



CREATE TABLE event_type (
    id              NUMERIC(10,0)   NOT NULL
                                    DEFAULT NEXTVAL('seq_event_type'),
    key_name        VARCHAR(64)     NOT NULL,
    name            VARCHAR(64)     NOT NULL,
    description     VARCHAR(256)    NOT NULL,
    class__id       NUMERIC(10,0)   NOT NULL,
    active          NUMERIC(1, 0)   NOT NULL 
                                    CONSTRAINT ck_event_type__active CHECK (active IN (1,0))
                                    DEFAULT 1,
    CONSTRAINT pk_event_type__id PRIMARY KEY (id)
);


CREATE TABLE event_type_attr (
    id              NUMERIC(10, 0)  NOT NULL
                                    DEFAULT NEXTVAL('seq_event_type_attr'),
    event_type__id  NUMERIC(10, 0)  NOT NULL,
    name            VARCHAR(64)     NOT NULL,
    CONSTRAINT pk_event_type_attr__id PRIMARY KEY (id)
);    



CREATE UNIQUE INDEX udx_event_type__key_name ON event_type(LOWER(key_name));
CREATE UNIQUE INDEX udx_event_type__class_id__name ON event_type(class__id, name);

CREATE INDEX fkx_event_type__event_type_attr ON event_type_attr(event_type__id);

CREATE INDEX fkx_class__event_type ON event_type(class__id);





CREATE SEQUENCE seq_grp START  1024; 


CREATE TABLE grp (
    id           NUMERIC(10,0)    NOT NULL
                                  DEFAULT NEXTVAL('seq_grp'),
    parent_id    NUMERIC(10,0)    CONSTRAINT ck_grp__parent_id_not_eq_id
                                    CHECK (parent_id <> id),
    class__id    NUMERIC(10,0)    NOT NULL,
    name         VARCHAR(64),
    description  VARCHAR(256),
    secret       NUMERIC(1,0)     NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_grp__secret
                                    CHECK (secret IN (0,1)),
    permanent    NUMERIC(1,0)     NOT NULL
                                  DEFAULT 0
                                  CONSTRAINT ck_grp__permanent
                                    CHECK (permanent IN (0,1)),
    active      NUMERIC(1,0)      NOT NULL
                                  DEFAULT 1
                                  CONSTRAINT ck_grp__active
                                    CHECK (active IN (0,1)),
    CONSTRAINT pk_grp__id PRIMARY KEY (id)
);

CREATE INDEX idx_grp__name ON grp(LOWER(name));
CREATE INDEX idx_grp__description ON grp(LOWER(description));
CREATE INDEX fkx_grp__grp ON grp(parent_id);
CREATE INDEX fkx_class__grp ON grp(class__id);





CREATE SEQUENCE seq_alert_type_member START 1024;


CREATE TABLE alert_type_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_alert_type_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_alert_type_member__id PRIMARY KEY (id)
);

CREATE INDEX fkx_alert_type__alert_type_member ON alert_type_member(object_id);
CREATE INDEX fkx_member__alert_type_member ON alert_type_member(member__id);






CREATE SEQUENCE seq_contrib_type_member START 1024;



CREATE TABLE contrib_type_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_contrib_type_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_contrib_type_member__id PRIMARY KEY (id)
);






CREATE INDEX fkx_contrib_type__ctype_member ON contrib_type_member(object_id);
CREATE INDEX fkx_member__ctype_member ON contrib_type_member(member__id);







CREATE SEQUENCE seq_org_member START 1024;


CREATE TABLE org_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_org_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_org_member__id PRIMARY KEY (id)
);

CREATE INDEX fkx_org__org_member ON org_member(object_id);
CREATE INDEX fkx_member__org_member ON org_member(member__id);






CREATE SEQUENCE seq_grp_member START  1024;



CREATE TABLE grp_member (
    id            NUMERIC(10,0)   NOT NULL
                                  DEFAULT NEXTVAL('seq_grp_member'),
    object_id     NUMERIC(10,0)   NOT NULL,
    member__id    NUMERIC(10,0)	  NOT NULL,
    CONSTRAINT pk_grp_member__id PRIMARY KEY (id)
);



CREATE INDEX fkx_grp__grp_member ON grp_member(object_id);
CREATE INDEX fkx_member__grp_member ON grp_member(member__id);





CREATE SEQUENCE seq_member START  1024;
CREATE SEQUENCE seq_story_member START 1024;


CREATE TABLE member (
    id         NUMERIC(10,0)  NOT NULL
                              DEFAULT NEXTVAL('seq_member'),
    grp__id    NUMERIC(10,0)  NOT NULL,
    class__id  NUMERIC(10,0)  NOT NULL,
    active     NUMERIC(1,0)   NOT NULL
                              DEFAULT 1
                              CONSTRAINT ck_member__active
                                CHECK (active IN (0,1)),
    CONSTRAINT pk_member__id PRIMARY KEY (id)
);


CREATE INDEX fkx_grp__member ON member(grp__id);
CREATE INDEX fkx_grp__class ON member(class__id);


CREATE TABLE story_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_story_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_story_member__id PRIMARY KEY (id)
);

CREATE INDEX fkx_story__story_member ON story_member(object_id);
CREATE INDEX fkx_member__story_member ON story_member(member__id);





CREATE SEQUENCE seq_attr_member START  1024;

CREATE SEQUENCE seq_attr_member_val START  1024;

CREATE SEQUENCE seq_attr_member_meta START  1024;


CREATE TABLE attr_member (
    id         NUMERIC(10)   NOT NULL,
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_member__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_member__id PRIMARY KEY (id)
);


CREATE TABLE attr_member_val (
    id           NUMERIC(10)     NOT NULL,
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_member_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_member_val__id PRIMARY KEY (id)
);


CREATE TABLE attr_member_meta (
    id        NUMERIC(10)     NOT NULL,
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_member_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_member_meta__id PRIMARY KEY (id)
);


CREATE UNIQUE INDEX udx_attr_member__subsys__name ON attr_member(subsys, name);

CREATE INDEX idx_attr_member__name ON attr_member(LOWER(name));
CREATE INDEX idx_attr_member__subsys ON attr_member(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_member_val__obj_attr ON attr_member_val (object__id,attr__id);

CREATE INDEX fkx_member__attr_member_val ON attr_member_val(object__id);
CREATE INDEX fkx_attr_member__attr_member_val ON attr_member_val(attr__id);

CREATE UNIQUE INDEX udx_attr_member_meta__attr_name ON attr_member_meta (attr__id, name);

CREATE INDEX idx_attr_member_meta__name ON attr_member_meta(LOWER(name));

CREATE INDEX fkx_attr_member__attr_member_meta ON attr_member_meta(attr__id);




CREATE SEQUENCE seq_source_member START 1024;


CREATE TABLE source_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_source_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_source_member__id PRIMARY KEY (id)
);

CREATE INDEX fkx_source__source_member ON source_member(object_id);
CREATE INDEX fkx_member__source_member ON source_member(member__id);




CREATE SEQUENCE seq_user_member START 1024;


CREATE TABLE user_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_user_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_user_member__id PRIMARY KEY (id)
);

CREATE INDEX fkx_user__user_member ON user_member(object_id);
CREATE INDEX fkx_member__user_member ON user_member(member__id);





CREATE SEQUENCE seq_attr_grp START  1024;

CREATE SEQUENCE seq_attr_grp_val START  1024;

CREATE SEQUENCE seq_attr_grp_meta START  1024;


CREATE TABLE attr_grp (
    id         NUMERIC(10)   NOT NULL
                             DEFAULT NEXTVAL('seq_attr_grp'),
    subsys     VARCHAR(256)  NOT NULL,
    name       VARCHAR(256)  NOT NULL,
    sql_type   VARCHAR(30)   NOT NULL,
    active     NUMERIC(1)    DEFAULT 1
                             NOT NULL
                             CONSTRAINT ck_attr_grp__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_grp__id PRIMARY KEY (id)
);



CREATE TABLE attr_grp_val (
    id           NUMERIC(10)     NOT NULL
                                 DEFAULT NEXTVAL('seq_attr_grp_val'),
    object__id   NUMERIC(10)     NOT NULL,
    attr__id     NUMERIC(10)     NOT NULL,
    date_val     TIMESTAMP,
    short_val    VARCHAR(1024),
    blob_val     TEXT,
    serial       NUMERIC(1)      DEFAULT 0,
    active       NUMERIC(1)      DEFAULT 1
                                 NOT NULL
                                 CONSTRAINT ck_attr_grp_val__active CHECK (active IN (0,1)),
    CONSTRAINT pk_attr_grp_val__id PRIMARY KEY (id)
);



CREATE TABLE attr_grp_meta (
    id        NUMERIC(10)     NOT NULL
                              DEFAULT NEXTVAL('seq_attr_grp_meta'),
    attr__id  NUMERIC(10)     NOT NULL,
    name      VARCHAR(256)    NOT NULL,
    value     VARCHAR(2048),
    active    NUMERIC(1)      DEFAULT 1
                              NOT NULL
                              CONSTRAINT ck_attr_grp_meta__active CHECK (active IN (0,1)),
   CONSTRAINT pk_attr_grp_meta__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_attr_grp__subsys__name ON attr_grp(subsys, name);

CREATE INDEX idx_attr_grp__name ON attr_grp(LOWER(name));
CREATE INDEX idx_attr_grp__subsys ON attr_grp(LOWER(subsys));

CREATE UNIQUE INDEX udx_attr_grp_val__obj_attr ON attr_grp_val (object__id,attr__id);

CREATE INDEX fkx_grp__attr_grp_val ON attr_grp_val(object__id);
CREATE INDEX fkx_attr_grp__attr_grp_val ON attr_grp_val(attr__id);

CREATE UNIQUE INDEX udx_attr_grp_meta__attr_name ON attr_grp_meta (attr__id, name);

CREATE INDEX idx_attr_grp_meta__name ON attr_grp_meta(LOWER(name));

CREATE INDEX fkx_attr_grp__attr_grp_meta ON attr_grp_meta(attr__id);



CREATE SEQUENCE seq_job START 1024;
CREATE SEQUENCE seq_job_member START 1024;


CREATE TABLE job (
    id            NUMERIC(10, 0)    NOT NULL
                                    DEFAULT NEXTVAL('seq_job'),
    name          TEXT              NOT NULL,
    usr__id       NUMERIC(10, 0)    NOT NULL,
    sched_time    TIMESTAMP	    NOT NULL
				    DEFAULT CURRENT_TIMESTAMP,
    priority      NUMERIC(1,0)      NOT NULL 
                                    DEFAULT 3
                                    CONSTRAINT ck_job__priority 
                                      CHECK (priority BETWEEN 1 AND 5),
    comp_time     TIMESTAMP,
    expire        NUMERIC(1, 0)     NOT NULL
                                    DEFAULT 0
                                    CONSTRAINT ck_job__expire
				      CHECK (expire IN (1,0)),
    failed        NUMERIC(1, 0)     NOT NULL
                                    DEFAULT 0
                                    CONSTRAINT ck_job__failed
				      CHECK (failed IN (1,0)),
    tries	  NUMERIC(2, 0)	    NOT NULL
				    DEFAULT 0
                                    CONSTRAINT ck_job__tries
				      CHECK (tries BETWEEN 0 AND 10),
    executing     NUMERIC(1, 0)     NOT NULL 
                                    DEFAULT 0
                                    CONSTRAINT ck_job__executing
				      CHECK (executing IN (1,0)),
    class__id     NUMERIC(10,0)     NOT NULL,
    story__id     NUMERIC(10,0),
    media__id     NUMERIC(10,0),
    error_message TEXT,
    CONSTRAINT pk_job__id PRIMARY KEY (id)
);



CREATE TABLE job__resource(
    job__id         NUMERIC(10, 0)    NOT NULL,
    resource__id    NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_job__resource PRIMARY KEY (job__id,resource__id)
);



CREATE TABLE job__server_type(
    job__id            NUMERIC(10, 0)  NOT NULL,
    server_type__id     NUMERIC(10, 0) NOT NULL,
    CONSTRAINT pk_job__server_type PRIMARY KEY (job__id,server_type__id)
);


CREATE TABLE job_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_job_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_job_member__id PRIMARY KEY (id)
);


CREATE INDEX idx_job__name ON job(LOWER(name));
CREATE INDEX idx_job__sched_time ON job(sched_time);
CREATE INDEX idx_job__comp_time__is_null ON job(comp_time) WHERE comp_time is NULL;
CREATE INDEX idx_job__comp_time ON job(comp_time);
CREATE INDEX idx_job__executing ON job(executing);

CREATE INDEX fkx_job__job__resource ON job__resource(job__id);
CREATE INDEX fkx_usr__job ON job (usr__id);
CREATE INDEX fkx_resource__job__resource ON job__resource(resource__id);
CREATE INDEX fkx_job__job__server_type ON job__server_type(job__id);
CREATE INDEX fkx_srvr_type__job__srvr_type ON job__server_type(server_type__id);

CREATE INDEX fkx_job__job_member ON job_member(object_id);
CREATE INDEX fkx_member__job_member ON job_member(member__id);


/* Commented out because we're not using language stuff at this point.
   By David.



CREATE SEQUENCE seq_language START 1024;



CREATE TABLE language (
    id           NUMERIC(10,0)	NOT NULL
                                DEFAULT NEXTVAL('seq_language'),
    name         VARCHAR(64),
    description  VARCHAR(256),
    active       NUMERIC(1)     NOT NULL
                                DEFAULT 1
                                CONSTRAINT ck_language__active
                                  CHECK (active IN (0,1)),
    CONSTRAINT pk_language__id PRIMARY KEY (id)
);

CREATE UNIQUE INDEX udx_language__name ON language(LOWER(name));

*/



CREATE SEQUENCE seq_media_type START 1024;
CREATE SEQUENCE seq_media_type_ext START 1024;
CREATE SEQUENCE seq_media_type_member START 1024;


CREATE TABLE media_type (
    id             NUMERIC(10, 0)    NOT NULL
                                     DEFAULT NEXTVAL('seq_media_type'),
    name           VARCHAR(128)      NOT NULL,
    description    VARCHAR(256),
    active         NUMERIC(1, 0)     NOT NULL
                                     DEFAULT 1
                                     CONSTRAINT ck_media_type__active
                                       CHECK (active IN (1,0)),
    CONSTRAINT pk_media_type__id PRIMARY KEY (id)
);



CREATE TABLE media_type_ext (
    id                  NUMERIC(10, 0)    NOT NULL
                                          DEFAULT NEXTVAL('seq_media_type_ext'),
    media_type__id      NUMERIC(10, 0)    NOT NULL,
    extension           VARCHAR(10)       NOT NULL,
    CONSTRAINT pk_media_type_ext__id PRIMARY KEY (id)
);



CREATE TABLE media_type_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_media_type_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_media_type_member__id PRIMARY KEY (id)
);



CREATE UNIQUE INDEX udx_media_type__name ON media_type(LOWER(name));
CREATE UNIQUE INDEX udx_media_type_ext__extension ON media_type_ext(LOWER(extension));
CREATE INDEX fkx_media_type__media_type_ext ON media_type_ext(media_type__id);
CREATE INDEX fkx_media_type__media_type_member ON media_type_member(object_id);
CREATE INDEX fkx_member__media_type_member ON media_type_member(member__id);





CREATE SEQUENCE seq_pref START 1024;
CREATE SEQUENCE seq_usr_pref START 1024;
CREATE SEQUENCE seq_pref_member START 1024;




CREATE TABLE pref (
    id           NUMERIC(10, 0)  NOT NULL
                                 DEFAULT NEXTVAL('seq_pref'),
    name         VARCHAR(64)     NOT NULL,
    description  VARCHAR(256),
    value        VARCHAR(256),
    def          VARCHAR(256),
    manual	 NUMERIC(1,0) NOT NULL DEFAULT 0,
    opt_type     VARCHAR(16)  NOT NULL,
    can_be_overridden  NUMERIC(1,0)   NOT NULL DEFAULT 0,
                                      CONSTRAINT ck_pref__can_be_overridden
                                        CHECK (can_be_overridden IN (0,1)),
    CONSTRAINT ck_pref__manual CHECK (manual IN (0,1)),
    CONSTRAINT pk_pref__id PRIMARY KEY (id)
);


CREATE TABLE usr_pref (
    id           NUMERIC(10, 0)  NOT NULL
                                 DEFAULT NEXTVAL('seq_usr_pref'),
    pref__id     NUMERIC(10, 0)  NOT NULL,
    usr__id      NUMERIC(10, 0)  NOT NULL,
    value        VARCHAR(256)    NOT NULL,
    CONSTRAINT pk_usr_pref__pref__id__value PRIMARY KEY (id)
);


CREATE TABLE pref_opt (
    pref__id     NUMERIC(10, 0)  NOT NULL,
    value        VARCHAR(256)    NOT NULL,
    description  VARCHAR(256),
    CONSTRAINT pk_pref_opt__pref__id__value PRIMARY KEY (pref__id, value)
);



CREATE TABLE pref_member (
    id          NUMERIC(10,0)  NOT NULL
                               DEFAULT NEXTVAL('seq_pref_member'),
    object_id   NUMERIC(10,0)  NOT NULL,
    member__id  NUMERIC(10,0)  NOT NULL,
    CONSTRAINT pk_pref_member__id PRIMARY KEY (id)
);




CREATE UNIQUE INDEX udx_pref__name ON pref(LOWER(name));
CREATE UNIQUE INDEX udx_usr_pref__pref__id__usr__id ON usr_pref(pref__id, usr__id);
CREATE INDEX idx_usr_pref__usr__id ON usr_pref(usr__id);
CREATE INDEX fkx_pref__pref__opt ON pref_opt(pref__id);
CREATE INDEX fkx_pref__pref_member ON pref_member(object_id);
CREATE INDEX fkx_member__pref_member ON pref_member(member__id);




CREATE SEQUENCE seq_priv START 1024;



CREATE TABLE grp_priv (
    id         NUMERIC(10, 0)    NOT NULL
                                 DEFAULT NEXTVAL('seq_priv'),
    grp__id    NUMERIC(10, 0)    NOT NULL,
    value      NUMERIC(3, 0)     NOT NULL
                                 CONSTRAINT ck_grp_priv__value
                                   CHECK (value BETWEEN 1 AND 255),
    mtime      TIMESTAMP         NOT NULL
                                 DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT pk_grp_priv__id PRIMARY KEY (id)
);



CREATE TABLE grp_priv__grp_member (
    grp_priv__id    NUMERIC(10, 0)    NOT NULL,
    grp__id         NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_grp_priv__grp_member PRIMARY KEY (grp_priv__id,grp__id)
);

CREATE INDEX fkx_grp__grp_priv ON grp_priv(grp__id);
CREATE INDEX fkx_grp__grp_priv__grp_member ON grp_priv__grp_member(grp__id);
CREATE INDEX fkx_grp_priv__grp_priv__grp_member ON grp_priv__grp_member(grp_priv__id);


/*

CREATE TABLE grp_priv__grp(
    grp_priv__id    NUMERIC(10, 0)    NOT NULL,
    grp__id         NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_grp_priv__grp PRIMARY KEY (grp_priv__id,grp__id)
) 
;



CREATE TABLE grp_priv__person(
    grp_priv__id    NUMERIC(10, 0)    NOT NULL,
    person__id      NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_grp_priv__person PRIMARY KEY (grp_priv__id,person__id)
) 
;



CREATE TABLE grp_priv__usr(
    grp_priv__id    NUMERIC(10, 0)    NOT NULL,
    usr__id        NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_grp_priv__usr PRIMARY KEY (grp_priv__id,usr__id)
) 
;



CREATE TABLE priv_table(
    id      NUMERIC(10, 0)    NOT NULL,
    name    VARCHAR(30)    NOT NULL,
    CONSTRAINT pk_priv_table__id PRIMARY KEY (id)
) 
;



CREATE TABLE usr_priv(
    id          NUMERIC(10, 0)    NOT NULL,
    usr__id    NUMERIC(10, 0)    NOT NULL,
    value       NUMERIC(2, 0)     NOT NULL,
    CONSTRAINT pk_usr_priv__id PRIMARY KEY (id)
) 
;



CREATE TABLE usr_priv__grp(
    priv_usr__id    NUMERIC(10, 0)    NOT NULL,
    grp__id          NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_usr_priv__grp PRIMARY KEY (priv_usr__id,grp__id)
) 
;



CREATE TABLE usr_priv__person(
    usr_priv__id    NUMERIC(10, 0)    NOT NULL,
    person__id       NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_usr_priv__person PRIMARY KEY (usr_priv__id,person__id)
) 
;



CREATE TABLE usr_priv__usr(
    usr_priv__id    NUMERIC(10, 0)    NOT NULL,
    usr__id         NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_usr_priv__usr PRIMARY KEY (usr_priv__id,usr__id)
) 
;



CREATE TABLE usr_priv__grp_member(
    usr_priv__id    NUMERIC(10, 0)    NOT NULL,
    grp__id          NUMERIC(10, 0)    NOT NULL,
    CONSTRAINT pk_usr_priv__grp_member PRIMARY KEY (usr_priv__id,grp__id)
) 
;

*/




INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (1, 'Stories', 'Story Types', 1, 0, 0, 10, 0, 0, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (421, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (1, 1, 421); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (2, 'Image', 'Images', 1, 0, 1, 50, 0, 0, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (422, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (2, 2, 422); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (3, 'Insets', 'Inset Elements', 0, 0, 0, 10, 0, 0, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (423, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (3, 3, 423); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (4, 'Related Stories', 'Related Story Elements', 0, 0, 0, 10, 1, 0, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (424, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (4, 4, 424); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (5, 'Pages', 'Page Elements', 0, 1, 0, 10, 0, 0, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (425, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (5, 5, 425); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (6, 'Related Media', 'Related Media Elements', 0, 0, 0, 10, 0, 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (426, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (6, 6, 426); 

INSERT INTO at_type (id,name,description,top_level,paginated,media, biz_class__id,
                     related_story, related_media, fixed_url, active)
VALUES (7, 'Covers', 'Cover Story Types', 1, 0, 0, 10, 0, 0, 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (427, 28, 37, 1);

INSERT INTO element_type_member (id, object_id, member__id)
VALUES (7, 7, 427); 


INSERT INTO media_fields (id, biz_pkg, name, function_name, active)
VALUES (0, 50, 'Width', 'get_width', 1);

INSERT INTO media_fields (id,  biz_pkg, name, function_name, active)
VALUES (1, 50, 'Height', 'get_height', 1);

INSERT INTO media_fields (id, biz_pkg, name, function_name, active)
VALUES (2, 50, 'Color Type', 'get_color_type', 1);

INSERT INTO media_fields (id, biz_pkg, name, function_name, active)
VALUES (3, 50, 'Resolution', 'get_resolution', 1);

INSERT INTO media_fields (id, biz_pkg, name, function_name, active)
VALUES (4, 50, 'Compression', 'get_compression', 1);



/***************************************************************************
* Don't forget to update the event log in Bric/Util/EventType.val!
***************************************************************************/

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('502', 'Book Profile', 'A default book profile', '3', NULL,
        '1', '1', '11',
        '1', '/book_profile.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:21-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('503', 'Book Review', 'A default book review', '3', NULL,
        '1', '1', '3',
        '1', '/book_review.mc', '1', '0', '0',
        '1', '1','2001-07-30 13:34:22-07',NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('504', 'Column', 'A default column', '3', NULL,
        '1', '1', '2',
        '1', '/column.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:22-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('506', 'Inset', 'A generic inset', '3', NULL,
        '1', '1', '6',
        '1', '/inset.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:23-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ( '507', 'Page', 'A generic page', '3', NULL,
       '1', '1', '10',
       '1', '/page.mc', '1', '0', '0',
       '1', '1', '2001-07-30 13:34:20-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('509', 'Pull Quote', 'A generic pull quote', '3', NULL,
       '1', '1', '7',
       '1', '/pull_quote.mc', '1', '0', '0',
       '1', '1', '2001-07-30 13:34:20-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('510', 'Related Stories', 'A generic related stories template', '3', NULL,
        '1', '1', '8',
        '1', '/related_stories.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:21-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('511', 'Related Story', 'A generic related story', '3', NULL,
        '1', '1', '9',
        '1', '/related_story.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:21-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('512', 'Story', 'A generic story template', '3', NULL,
        '1', '1', '1',
        '1', '/story.mc', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:22-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('513', 'autohandler', 'A generic root level category template', '3', NULL,
        '1', '2', NULL,
        '1', '/autohandler', '1', '0', '0',
        '1', '1', '2001-07-30 13:34:22-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('514', 'Related Media', 'A default related media template', '3', NULL,
        '1', '1', '12',
        '1', '/related_media.mc', '1', '0', '0',
        '1', '1', '2001-08-01 14:51:34-07', NULL,
        '1', 100);

INSERT INTO formatting (id, name, description, priority, usr__id,
                        output_channel__id, tplate_type, element__id,
                        category__id, file_name, current_version, workflow__id, desk__id,
                        published_version, deploy_status, deploy_date, expire_date,
                        active, site__id)
VALUES ('515', 'Cover', 'A default cover template', '3', NULL,
        '1', '1', '13',
        '1', '/cover.mc', '1', '0', '0',
        '1', '1', '2001-08-01 14:51:34-07', NULL,
        '1', 100);


INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('501','502','1','0', '/book_profile.mc','0',
        '<!-- Start "Book Profile" -->\015\012<table>\015\012<tr>\015\012<td>Title</td>\015\012<td><% $element->get_data(''title'') %></td>\015\012</tr>\015\012<tr>\015\012<td>Author</td>\015\012<td><% $element->get_data(''author'') %></td>\015\012</tr>\015\012<tr>\015\012<td>Publisher</td>\015\012<td><% $element->get_data(''date'') %></td>\015\012</tr>\015\012</table>\015\012<!-- End "Book Profile" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('502','503','1','0','/book_review.mc','0',
        '<!-- Start "Book Review" -->\015\012\015\012%# Only show this if we are on the first page\015\012% unless ($burner->get_page) {\015\012<h1><% $story->get_title %></h1>\015\012<% $element->get_data(''deck'') %>\015\012<hr />\015\012% }\015\012\015\012%# Display all the pages of this story\015\012% $burner->display_pages(''page'');\015\012\015\012<br>\015\012Page <% $burner->get_page + 1 %>\015\012<!-- End "Book Review" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('503','504','1','0','/column.mc', '0',
        '<!-- Start "Column" -->\015\012\015\012%# Only show this if we are on the first page\015\012% unless ($burner->get_page) {\015\012<h1><% $story->get_title %></h1>\015\012<% $element->get_data(''deck'') %>\015\012<hr />\015\012% }\015\012\015\012%# Display all the pages of this story\015\012% $burner->display_pages(''page'');\015\012\015\012<br>\015\012Page <% $burner->get_page + 1 %>\015\012<!-- End "Column" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('505','506','1','0','/inset.mc', '0',
        '\015\012<!-- Start ''Inset'' -->\015\012<table>\015\012<tr><td>\015\012<% $element->get_data(''copy'') %>\015\012</td></tr>\015\012</table>\015\012<!-- End ''Inset'' -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('506','507','1','0','/page.mc', '0',
        '<!-- Start "Page" -->\015\012<%perl>\015\012foreach my $e ($element->get_elements) {\015\012    if ($e->has_name(''paragraph'')) {\015\012        $m->out(''<p>''.$e->get_data.''</p>'');\015\012\015\012    } elsif ($e->has_name(''pull_quote'')) {\015\012        $burner->display_element($e);\015\012\015\012    } elsif ($e->has_name(''inset'')) {\015\012        $burner->display_element($e);\015\012\015\012    }\015\012}\015\012</%perl>\015\012\015\012<hr />\015\012\015\012%# $burner numbers pages from ''0'' not ''1''.\015\012% my $pnum = $burner->get_page + 1;\015\012\015\012%# Show ''previous'' link\015\012% my $prev = $element->get_data(''previous'');\015\012% if ($prev) {\015\012<a href="index<% $pnum-2 != 0 ? $pnum-2 : '''' %>.html">\015\012&lt;&lt;&lt; Page <% $pnum - 1 %> : </a>\015\012<% $prev %>\015\012% }\015\012\015\012&nbsp;&nbsp;&nbsp;\015\012\015\012%# Show ''next'' link\015\012% my $next = $element->get_data(''next'');\015\012% if ($next) {\015\012<% $next %>\015\012<a href="index<% $pnum %>.html">\015\012 : Page <% $pnum + 1 %> &gt;&gt;&gt;\015\012</a>\015\012% }\015\012\015\012<!-- End "Page" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('508','509','1','0','/pull_quote.mc', '0',
        '<!-- Start "Pull Quote" -->\015\012&quot;<% $element->get_data(''quote'') %>&quot;\015\012<!-- End "Pull Quote" -->');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('509','510','1','0','/related_stories.mc', '0',
        '<!-- Start "Related Stories" -->\015\012% my @rel = $element->get_elements;\015\012\015\012% if (@rel > 0) {\015\012<table>\015\012\015\012% foreach my $rs (@rel) {\015\012<tr><td>\015\012% $burner->display_element($rs);\015\012</td></tr>\015\012% }\015\012\015\012</table>\015\012% }\015\012<!-- End "Related Stories" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('510','511','1','0','/related_story.mc', '0',
        '<!-- Start "Related Story" -->\015\012% my $rel_story = $element->get_related_story;\015\012<b>Title:</b>&nbsp;\015\012<% $element->get_data(''alternate_title'') || $rel_story->get_title %><br />\015\012<b>Teaser:</b>&nbsp;\015\012<% $element->get_data(''alternate_teaser'') ||\015\012$rel_story->get_description %><br />\015\012<!-- End "Related Story" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('511','512','1','0','/story.mc', '0',
        '<!-- Start "Story" -->\015\012\015\012%# Only show this if we are on the first page\015\012% unless ($burner->get_page     ) {\015\012<h1><% $story->get_title %></h1>\015\012<% $element->get_data(''deck'') %>\015\012<hr />\015\012% }\015\012\015\012%# Display all the pages of this story\015\012% $burner->display_pages(''page'');\015\012\015\012<br>\015\012Page <% $burner->get_page + 1 %>\015\012<!-- End "Story" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('512','513','1','0','/autohandler', '0',
       '<!-- Start "autohandler" -->\015\012<html>\015\012    <head>\015\012        <title><% $story->get_title %></title>\015\012    </head>\015\012    <body>\015\012% $burner->chain_next;\015\012    </body>\015\012</html>\015\012<!-- End "autohandler" -->\015\012');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('513','514','1','0','/related_media.mc', '0',
        '<!-- Start "Related Media" -->\015\012% my $rel_media = $element->get_related_media;\015\012\015\012%# This template only handles images.\015\012% if (substr($rel_media->get_media_type->get_name, 0, 5) eq ''image'') {\015\012<img src="<% $rel_media->get_uri %>">\015\012% }\015\012<!-- End "Related Media" -->');

INSERT INTO formatting_instance (id, formatting__id, version, usr__id, file_name,
                                 checked_out, data)
VALUES ('514','515','1','0','/cover.mc', '0',
        '<!-- Start "Cover" -->\015\012%# Lets make this a 3 column cover.\015\012% my @elem = $element->get_elements;\015\012%# Find the elements per column\015\012% my $per_col = int((scalar @elem)/3)+1;\015\012\015\012<table>\015\012<tr>\015\012<%perl>\015\012# Lay these elements out over three columns.\015\012while (scalar @elem) {\015\012    foreach (1..$per_col) {\015\012        my $e = shift @elem || last;\015\012        $burner->display_element($e);\015\012        $m->out(''<br />'');\015\012    }\015\012}\015\012</%perl>\015\012</tr>\015\012</table>\015\012<!-- End "Cover" -->\015\012');



INSERT INTO member VALUES ('515','33','19','1');
INSERT INTO member VALUES ('519','33','19','1');
INSERT INTO member VALUES ('521','33','19','1');
INSERT INTO member VALUES ('525','33','19','1');
INSERT INTO member VALUES ('528','33','19','1');
INSERT INTO member VALUES ('532','33','19','1');
INSERT INTO member VALUES ('535','33','19','1');
INSERT INTO member VALUES ('537','33','19','1');
INSERT INTO member VALUES ('540','33','19','1');
INSERT INTO member VALUES ('542','33','19','1');
INSERT INTO member VALUES ('544','33','19','1');
INSERT INTO member VALUES ('546','33','19','1');




INSERT INTO formatting_member VALUES ('501','502','515');
INSERT INTO formatting_member VALUES ('503','503','519');
INSERT INTO formatting_member VALUES ('505','504','521');
INSERT INTO formatting_member VALUES ('509','506','525');
INSERT INTO formatting_member VALUES ('511','507','528');
INSERT INTO formatting_member VALUES ('515','509','532');
INSERT INTO formatting_member VALUES ('517','510','535');
INSERT INTO formatting_member VALUES ('519','511','537');
INSERT INTO formatting_member VALUES ('521','512','540');
INSERT INTO formatting_member VALUES ('523','513','542');
INSERT INTO formatting_member VALUES ('525','514','544');
INSERT INTO formatting_member VALUES ('526','515','546');




INSERT INTO attr_formatting VALUES ('502','deskstamps','1','short','1');
INSERT INTO attr_formatting VALUES ('503','deskstamps','2','short','1');





INSERT INTO attr_formatting_val VALUES ('502','502','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('504','503','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('506','504','502',NULL,'106',NULL,NULL,'1');

INSERT INTO attr_formatting_val VALUES ('510','506','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('512','507','502',NULL,'106',NULL,NULL,'1');

INSERT INTO attr_formatting_val VALUES ('516','509','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('518','510','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('520','511','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('522','512','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('524','513','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('525','513','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('526','512','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('527','511','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('528','510','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('529','509','503',NULL,'107',NULL,NULL,'1');

INSERT INTO attr_formatting_val VALUES ('531','507','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('532','506','503',NULL,'107',NULL,NULL,'1');

INSERT INTO attr_formatting_val VALUES ('534','504','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('535','503','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('536','502','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('538','514','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('540','515','502',NULL,'106',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('542','514','503',NULL,'107',NULL,NULL,'1');
INSERT INTO attr_formatting_val VALUES ('544','515','503',NULL,'107',NULL,NULL,'1');


INSERT INTO grp (id,class__id,name,description)
VALUES (330,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (630, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (630, 330, 630);

INSERT INTO grp (id,class__id,name,description)
VALUES (331,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (631, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (631, 331, 631);

INSERT INTO grp (id,class__id,name,description)
VALUES (332,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (632, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (632, 332, 632);

INSERT INTO grp (id,class__id,name,description)
VALUES (333,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (633, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (633, 333, 633);

INSERT INTO grp (id,class__id,name,description)
VALUES (334,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (634, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (634, 334, 634);

INSERT INTO grp (id,class__id,name,description)
VALUES (335,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (635, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (635, 335, 635);

INSERT INTO grp (id,class__id,name,description)
VALUES (340,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (640, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (640, 340, 640);

INSERT INTO grp (id,class__id,name,description)
VALUES (341,24,'AssetType Group', 'Grouped containers');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (641, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (641, 341, 641);


INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (1, 'Story', 'story', 'A story element', 1, 330, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (1, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (410, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (11, 1, 410); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (1, 1, 1, 1, 1);

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (2, 'Column', 'column', 'A weekly column element', 1, 331, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (2, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (411, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (12, 2, 411); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (4, 2, 1, 1, 1);

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (3, 'Book Review', 'book_review', 'A book review element', 1, 332, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (3, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (412, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (13, 3, 412); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (7, 3, 1, 1, 1);


INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (4, 'Photograph', 'photograph', 'A photograph element', 2, 333, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (4, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (413, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (14, 4, 413); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (10, 4, 1, 1, 1);


INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (5, 'Illustration', 'illustration', 'An illustration element', 2, 334, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (5, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (414, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (15, 5, 414); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (13, 5, 1, 1, 1);


INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (6, 'Inset', 'inset', 'An inset element', 3, NULL, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (415, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (16, 6, 415); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (7, 'Pull Quote', 'pull_quote', 'A pull quote element', 3, NULL, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (416, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (17, 7, 416); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (8, 'Related Stories', 'related_stories', 'A related stories element.', 3, 341, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (417, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (18, 8, 417); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (9, 'Related Story', 'related_story', 'A related story element.', 4, NULL, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (418, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (19, 9, 418); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (10, 'Page', 'page',  'A page element.', 5, 340, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (419, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (20, 10, 419); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (11, 'Book Profile', 'book_profile', 'A book profile inset element.', 3, NULL, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (420, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (21, 11, 420); 

INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (12, 'Related Media', 'related_media', 'A related media element.', 6, NULL, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (437, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (22, 12, 437); 


INSERT INTO element (id, name, key_name, description, type__id, at_grp__id, active)
VALUES (13, 'Cover', 'cover', 'A cover element.', 7, 335, 1);

INSERT INTO element__site (element__id, site__id, primary_oc__id)
VALUES (13, 100, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (438, 27, 22, 1);

INSERT INTO element_member (id, object_id, member__id)
VALUES (23, 13, 438); 

INSERT INTO element__output_channel (id, element__id, output_channel__id,
                                     enabled, active)
VALUES (14, 13, 1, 1, 1);


INSERT INTO member (id, grp__id, class__id, active) 
VALUES (301, 330, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (1, 10, 301);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (302, 331, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (2, 10, 302);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (303, 332, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (3, 10, 303);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (305, 340, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (5, 7, 305);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (306, 340, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (6, 6, 306);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (307, 330, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (7, 7, 307);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (308, 341, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (8, 9, 308);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (309, 332, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (9, 11, 309);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (310, 335, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (10, 8, 310);

INSERT INTO member (id, grp__id, class__id, active) 
VALUES (311, 335, 22, 1);

INSERT INTO element_member (id, object_id, member__id) 
VALUES (24, 12, 311);






INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (1, 10, 'paragraph', 'A Paragraph of text.', 1, 0, '1', 1, 1, 0, 'blob');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (1, 'id_1', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (1, 1, 1, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (1, 1, 'cols', '50', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (2, 1, 'maxlength', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (3, 1, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (4, 1, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (5, 1, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (6, 1, 'rows', '8', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (7, 1, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (8, 1, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (9, 1, 'disp', 'Paragraph', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (10, 1, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (2, 10, 'previous', 'Describes previous page.', 2, 0, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (2, 'id_2', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (2, 2, 2, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (11, 2, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (12, 2, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (13, 2, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (14, 2, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (15, 2, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (16, 2, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (17, 2, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (18, 2, 'pos', '2', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (19, 2, 'disp', 'Previous', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (20, 2, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (3, 10, 'next', 'Describes next page.', 3, 0, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (3, 'id_3', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (3, 3, 3, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (21, 3, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (22, 3, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (23, 3, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (24, 3, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (25, 3, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (26, 3, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (27, 3, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (28, 3, 'pos', '3', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (29, 3, 'disp', 'Next', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (30, 3, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (4, 7, 'quote', 'The pull quote quotation.', 1, 1, '0', 1, 1, 1024, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (4, 'id_4', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (4, 4, 4, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (31, 4, 'cols', '40', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (32, 4, 'maxlength', '1024', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (33, 4, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (34, 4, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (35, 4, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (36, 4, 'rows', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (37, 4, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (38, 4, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (39, 4, 'disp', 'Quote', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (40, 4, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (5, 6, 'copy', 'The inset copy text.', 1, 1, '0', 1, 1, 1024, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (5, 'id_5', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (5, 5, 5, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (41, 5, 'cols', '50', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (42, 5, 'maxlength', '1024', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (43, 5, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (44, 5, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (45, 5, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (46, 5, 'rows', '8', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (47, 5, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (48, 5, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (49, 5, 'disp', 'Copy', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (50, 5, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (6, 9, 'alternate_title', 'Alternate title to the story''s own', 1, 0, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (6, 'id_6', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (6, 6, 6, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (51, 6, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (52, 6, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (53, 6, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (54, 6, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (55, 6, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (56, 6, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (57, 6, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (58, 6, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (59, 6, 'disp', 'Alternate Title', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (60, 6, 'type', 'text', 1);




INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (7, 9, 'alternate_teaser', 'Alternate teaser to the story''s own', 2, 0, '0', 1, 1, 512, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (7, 'id_7', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (7, 7, 7, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (61, 7, 'cols', '40', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (62, 7, 'maxlength', '512', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (63, 7, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (64, 7, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (65, 7, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (66, 7, 'rows', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (67, 7, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (68, 7, 'pos', '2', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (69, 7, 'disp', 'Alternate Teaser', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (70, 7, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (8, 11, 'title', 'The book''s title.', 1, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (8, 'id_8', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (8, 8, 8, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (71, 8, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (72, 8, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (73, 8, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (74, 8, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (75, 8, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (76, 8, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (77, 8, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (78, 8, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (79, 8, 'disp', 'Title', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (80, 8, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (9, 11, 'author', 'The author''s name.', 2, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (9, 'id_9', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (9, 9, 9, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (81, 9, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (82, 9, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (83, 9, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (84, 9, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (85, 9, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (86, 9, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (87, 9, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (88, 9, 'pos', '2', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (89, 9, 'disp', 'Author', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (90, 9, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (10, 11, 'publisher', 'The book''s publisher.', 3, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (10, 'id_10', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (10, 10, 10, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (91, 10, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (92, 10, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (93, 10, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (94, 10, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (95, 10, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (96, 10, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (97, 10, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (98, 10, 'pos', '3', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (99, 10, 'disp', 'Publisher', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (100, 10, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (11, 11, 'date', 'The date of publication.', 4, 1, '0', 1, 1, 0, 'date');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (11, 'id_11', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (11, 11, 11, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (101, 11, 'cols', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (102, 11, 'maxlength', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (103, 11, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (104, 11, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (105, 11, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (106, 11, 'rows', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (107, 11, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (108, 11, 'pos', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (109, 11, 'disp', 'Date', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (110, 11, 'type', 'date', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (12, 1, 'deck', 'A one-sentence teaser or subhead.', 1, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (12, 'id_12', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (12, 12, 12, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (111, 12, 'cols', '40', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (112, 12, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (113, 12, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (114, 12, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (115, 12, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (116, 12, 'rows', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (117, 12, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (118, 12, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (119, 12, 'disp', 'Deck', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (120, 12, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (13, 2, 'deck', 'A one-sentence teaser or subhead.', 1, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (13, 'id_13', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (13, 13, 13, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (121, 13, 'cols', '40', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (122, 13, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (123, 13, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (124, 13, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (125, 13, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (126, 13, 'rows', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (127, 13, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (128, 13, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (129, 13, 'disp', 'Deck', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (130, 13, 'type', 'textarea', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type)
VALUES (14, 3, 'deck', 'A one-sentence teaser or subhead.', 1, 1, '0', 1, 1, 256, 'short');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (14, 'id_14', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (14, 14, 14, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (131, 14, 'cols', '40', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (132, 14, 'maxlength', '256', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (133, 14, 'length', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (134, 14, 'vals', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (135, 14, 'multiple', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (136, 14, 'rows', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (137, 14, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (138, 14, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (139, 14, 'disp', 'Deck', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (140, 14, 'type', 'textarea', 1);




INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (15, 4, 'height', 'Autopopulated Height field.', 1, 1, '0', 1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (15, 'id_15', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (15, 15, 15, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (141, 15, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (142, 15, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (143, 15, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (144, 15, 'disp', 'Height', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (145, 15, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (16, 4, 'width', 'Autopopulated Width field.', 2, 1, '0', 1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (16, 'id_16', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (16, 16, 16, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (146, 16, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (147, 16, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (148, 16, 'pos', '2', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (149, 16, 'disp', 'Width', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (150, 16, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (17, 4, 'resolution', 'Autopopulated Resolution field.', 3, 1, '0', 1,
        0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (17, 'id_17', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (17, 17, 17, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (151, 17, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (152, 17, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (153, 17, 'pos', '3', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (154, 17, 'disp', 'Resolution', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (155, 17, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (18, 4, 'compression', 'Autopopulated Compression field.', 4, 1, '0',
        1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (18, 'id_18', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (18, 18, 18, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (156, 18, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (157, 18, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (158, 18, 'pos', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (159, 18, 'disp', 'Compression', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (160, 18, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (19, 4, 'color_type', 'Autopopulated Color Type field.', 5, 1, '0', 1,
        0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (19, 'id_19', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (19, 19, 19, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (161, 19, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (162, 19, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (163, 19, 'pos', '5', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (164, 19, 'disp', 'Color Type', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (165, 19, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (20, 5, 'height', 'Autopopulated Height field.', 1, 1, '0', 1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (20, 'id_20', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (20, 20, 20, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (166, 20, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (167, 20, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (168, 20, 'pos', '1', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (169, 20, 'disp', 'Height', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (170, 20, 'type', 'text', 1);



INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (21, 5, 'width', 'Autopopulated Width field.', 2, 1, '0', 1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (21, 'id_21', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (21, 21, 21, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (171, 21, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (172, 21, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (173, 21, 'pos', '2', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (174, 21, 'disp', 'Width', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (175, 21, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (22, 5, 'resolution', 'Autopopulated Resolution field.', 3, 1, '0', 1,
        0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (22, 'id_22', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (22, 22, 22, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (176, 22, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (177, 22, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (178, 22, 'pos', '3', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (179, 22, 'disp', 'Resolution', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (180, 22, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (23, 5, 'compression', 'Autopopulated Compression field.', 4, 1, '0',
        1, 0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (23, 'id_23', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (23, 23, 23, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (181, 23, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (182, 23, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (183, 23, 'pos', '4', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (184, 23, 'disp', 'Compression', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (185, 23, 'type', 'text', 1);


INSERT INTO at_data (id, element__id, key_name, description, place, required,
                     quantifier, active, publishable, max_length, sql_type, autopopulated)
VALUES (24, 5, 'color_type', 'Autopopulated Color Type field.', 5, 1, '0', 1,
        0, 0, 'short', '1');

INSERT INTO attr_at_data (id, subsys, name, sql_type, active)
VALUES (24, 'id_24', 'html_info', 'short', 1);

INSERT INTO attr_at_data_val (id, object__id, attr__id, active)
VALUES (24, 24, 24, 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (186, 24, 'length', '32', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (187, 24, 'value', '', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (188, 24, 'pos', '5', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (189, 24, 'disp', 'Color Type', 1);

INSERT INTO attr_at_data_meta (id, attr__id, name, value, active)
VALUES (190, 24, 'type', 'text', 1);


INSERT INTO category (id,site__id,directory, uri, parent_id, name, description,
                      asset_grp_id) 
VALUES (0, 100,'', '', 0, 'Master Root Category', 'Master Root Category', 68);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (58, 26, 20, 1);

INSERT INTO category_member (id, object_id, member__id)
VALUES (1, 0, 58); 


INSERT INTO category (id,site__id,directory, uri, parent_id, name, description,
                      asset_grp_id) 
VALUES (1, 100,'', '/', 0, 'Default Site Root Category',
        'Default Site root category', 68);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (61, 26, 20, 1);

INSERT INTO category_member (id, object_id, member__id)
VALUES (2, 1, 61); 

INSERT INTO contact (id, type, description, alertable, active)
VALUES (1, 'Primary Email', 'Primary Electronic Mail Address', 1, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (2, 'Secondary Email', 'Secondary Electronic Mail Address', 1, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (3, 'Business Phone', 'Business Phone Number', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (4, 'Home Phone', 'Home Phone Number', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (5, 'Fax', 'Fax Number', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (6, 'Mobile Phone', 'Mobile Phone Number', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (7, 'Pager', 'Pager Number', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (8, 'Pager Email', 'Email Address for Pager', 1, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (9, 'AIM ID', 'AOL Instant Messenger ID', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (10, 'ICQ ID', 'ICQ Messenger ID', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (11, 'MSN ID', 'Microsoft Messenger ID', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (12, 'Yahoo! Pager ID', 'Yahoo! Pager Messenger ID', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (13, 'Jabber ID', 'Jabber Messenger ID', 0, 1);

INSERT INTO contact (id, type, description, alertable, active)
VALUES (14, 'WWW', 'WWW URL', 0, 1);




INSERT INTO org (id, name)
VALUES (1, 'Internal');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (428, 3, 3, 1);

INSERT INTO org_member (id, object_id, member__id)
VALUES (1, 1, 428); 


DELETE FROM addr_part_type;

INSERT INTO addr_part_type (id, name, active)
VALUES (1, 'Line', 1);

INSERT INTO addr_part_type (id, name, active)
VALUES (2, 'City', 1);

INSERT INTO addr_part_type (id, name, active)
VALUES (3, 'State', 1);

INSERT INTO addr_part_type (id, name, active)
VALUES (4, 'Code', 1);

INSERT INTO addr_part_type (id, name, active)
VALUES (5, 'Country', 1);


INSERT INTO source (id, org__id, name, description, expire, active)
VALUES (1, 1, 'Internal', 'Ourselves.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (429, 5, 35, 1);

INSERT INTO source_member (id, object_id, member__id)
VALUES (1, 1, 429); 


INSERT INTO output_channel (id, name, description, pre_path, post_path,
	                    filename, file_ext, uri_format, fixed_uri_format,
                            uri_case, use_slug, primary_ce, site__id)
VALUES (1, 'Web', 'Output to the web', '', '', 'index', 'html',
        '/categories/year/month/day/slug/', '/categories/', 1, 0, 1, 100);


INSERT INTO member (id, grp__id, class__id, active)
VALUES (436, 23, 21, 1);

INSERT INTO output_channel_member (id, object_id, member__id)
VALUES (1, 1, 436);




INSERT INTO person (id, lname, fname, mname, prefix, suffix, active)
VALUES (0, 'Administrator', 'Bricolage', '', '', '', 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (0, 1, 1, 1);

INSERT INTO person_member (id, object_id, member__id)
VALUES (0, 0, 0); 




INSERT INTO usr (id, login, password, active)
VALUES (0, 'admin', 'd901271082743310476e5e7245e42120', 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (1, 2, 2, 1);

INSERT INTO user_member (id, object_id, member__id)
VALUES (0, 0, 1); 

INSERT INTO member (id, grp__id, class__id, active)
VALUES (2, 6, 2, 1);

INSERT INTO user_member (id, object_id, member__id)
VALUES (1, 0, 2); 





INSERT INTO site (id, name, description, domain_name, active)
VALUES (100, 'Default Site', 'The default site', 'www.example.com', 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (59, 47, 75, 1);

INSERT INTO site_member (id, object_id, member__id)
VALUES (1, 100, 59);
 

INSERT INTO workflow (id, name, description, asset_grp_id, all_desk_grp_id,
                      req_desk_grp_id, head_desk_id, type, active, site__id)
VALUES (0, 'Shelved', 'Hidden workflow for shelved assets', 0, 41, 42, 0, 2, 0, 100);

INSERT INTO workflow (id, name, description, asset_grp_id, all_desk_grp_id,
                      req_desk_grp_id, head_desk_id, type, active, site__id)
VALUES (101, 'Story', 'Story Workflow', 49, 41, 42, 101, 2, 1, 100);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (407, 25, 44, 1);

INSERT INTO workflow_member(id, object_id, member__id)
VALUES (1, 101, 407);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (49, NULL, 43, 'Workflow Assets', 'Assets group for workflow permissions', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (180, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (180, 49, 180);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (41, NULL, 40, 'All Workflow Desks', 'All desks available to a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (501, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (50, 41, 501);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (42, NULL, 40, 'Required Workflow Desks', 'Desks required in a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (502, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (51, 42, 502);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (201, 41, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (101, 101, 201);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (202, 42, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (102, 101, 202);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (203, 41, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (103, 102, 203);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (204, 41, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (104, 103, 204);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (205, 42, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (105, 103, 205);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (206, 41, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (106, 104, 206);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (207, 42, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (107, 104, 207);


INSERT INTO workflow (id, name, description, asset_grp_id, all_desk_grp_id,
                      req_desk_grp_id, head_desk_id, type, active, site__id)
VALUES (102, 'Media', 'Media Workflow', 51, 43, 44, 105, 3, 1, 100);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (408, 25, 44, 1);

INSERT INTO workflow_member(id, object_id, member__id)
VALUES (2, 102, 408);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (51, NULL, 43, 'Workflow Assets', 'Assets group for workflow permissions', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (181, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (181, 51, 181);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (43, NULL, 40, 'All Workflow Desks', 'All desks available to a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (503, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (52, 43, 503);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (44, NULL, 40, 'Required Workflow Desks', 'Desks required in a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (504, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (53, 44, 504);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (208, 43, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (108, 105, 208);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (209, 44, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (109, 105, 209);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (210, 43, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (110, 103, 210);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (211, 44, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (111, 103, 211);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (212, 43, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (112, 104, 212);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (213, 44, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (113, 104, 213);


INSERT INTO workflow (id, name, description, asset_grp_id, all_desk_grp_id,
                      req_desk_grp_id, head_desk_id, type, active, site__id)
VALUES (103, 'Template', 'Template Workflow', 52, 45, 46, 106, 1, 1, 100);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (409, 25, 44, 1);

INSERT INTO workflow_member(id, object_id, member__id)
VALUES (3, 103, 409);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (52, NULL, 43, 'Workflow Assets', 'Assets group for workflow permissions', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (182, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (182, 52, 182);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (45, NULL, 40, 'All Workflow Desks', 'All desks available to a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (505, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (54, 45, 505);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent, active)
VALUES (46, NULL, 40, 'Required Workflow Desks', 'Desks required in a workflow', 1, 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (506, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (55, 46, 506);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (214, 45, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (114, 106, 214);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (215, 46, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (115, 106, 215);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (216, 45, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (116, 107, 216);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (217, 46, 45, 1);

INSERT INTO desk_member(id, object_id, member__id)
VALUES (117, 107, 217);

/* All Desks Group */

INSERT INTO member (id, grp__id, class__id, active)
VALUES (171, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (121, 101, 171);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (172, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (122, 102, 172);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (173, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (123, 103, 173);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (174, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (124, 104, 174);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (175, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (125, 105, 175);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (176, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (126, 106, 176);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (177, 34, 45, 1);

INSERT INTO desk_member (id, object_id, member__id)
VALUES (127, 107, 177);




INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (0, 'Shelved', 'Hidden desk for shelved assets', NULL, NULL, 0, 0, 0);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (101, 'Edit', 'Edit Desk', NULL, NULL, 61, 0, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (102, 'Copy', 'Copy Desk', NULL, NULL, 62, 0, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (103, 'Legal', 'Legal Desk', NULL, NULL, 63, 0, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (104, 'Publish', 'Publish Desk', NULL, NULL, 64, 1, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (105, 'Art', 'Art Desk', NULL, NULL, 65, 0, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (106, 'Development', 'Development Desk', NULL, NULL, 66, 0, 1);

INSERT INTO desk (id, name, description, pre_chk_rules, post_chk_rules, asset_grp, publish, active)
VALUES (107, 'Deploy', 'Deploy Desk', NULL, NULL, 67, 1, 1);



INSERT INTO action_type ( id, name, description, active)
VALUES (1, 'Move', 'Puts resources on servers.', 1);

INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (1, 0);

INSERT INTO action_type ( id, name, description, active)
VALUES (4, 'Email', 'Email resources.', 1);

INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (4, 0);

INSERT INTO action_type ( id, name, description, active)
VALUES (5, 'DTD Validation', 'XML DTD validation.', 1);

/* Associate with text/html */
INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (5, 77);

/* Associate with text/xml */
INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (5, 86);

/* Associate with application/xhtml+xml */
INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (5, 92);

/*

These can be added back in once these modules have actually been implemented.

INSERT INTO action_type ( id, name, description, active)
VALUES (2, 'Akamaize', 'Akamaizes HTML resources.', 1);

INSERT INTO action_type ( id, name, description, active)
VALUES (3, 'Clean HTML', 'Cleans and reformats HTML Resources.', 1);

INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (2, 77);

INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (3, 77);

INSERT INTO action_type__media_type (action_type__id, media_type__id)
VALUES (3, 78);

*/
















INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (0, 'bric', 'Bric', 'Bricolage', 'Bricolagen', 'Bricolage Root Class', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (1, 'person', 'Bric::Biz::Person', 'Person', 'People', 'Person objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (2, 'user', 'Bric::Biz::Person::User', 'User', 'Users', 'User objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (3, 'org', 'Bric::Biz::Org', 'Organization', 'Organizations', 'Organization objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (4, 'event_type', 'Bric::Util::EventType', 'Event Type', 'Event Types', 'Event Type objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (5, 'event', 'Bric::Util::Event', 'Event', 'Events', 'Event objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (6, 'grp', 'Bric::Util::Grp', 'Group', 'Groups', 'Group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (7, 'event_grp', 'Bric::Util::Grp::Event', 'Event Group', 'Event Groups', 'Event Group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (8, 'user_grp', 'Bric::Util::Grp::User', 'User Group', 'User Groups', 'User Group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (9, 'contrib_type', 'Bric::Util::Grp::Person', 'Contributor Type', 'Contributor Types', 'Contributor Type objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (10, 'story', 'Bric::Biz::Asset::Business::Story', 'Story', 'Stories', 'Story Asset objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (11, 'ftp', 'Bric::Util::Trans::FTP', 'FTP', 'FTP Transport', 'Class with methods to move files via FTP.', 1);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (12, 'fs', 'Bric::Util::Trans::FS', 'File System', 'File System Transport', 'Class with methods to move files within the file system.', 1);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (13, 'mail', 'Bric::Util::Trans::Mail', 'Email', 'Email Transport', 'Class with methods to send email.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (14, 'action', 'Bric::Dist::Action', 'Action', 'Actions', 'Factory class for distribution actions.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (15, 'akamaize', 'Bric::Dist::Action::Akamaize', 'Akamaize', 'Akamaize', 'Action subclass that akamaizes resources.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (16, 'html_clean', 'Bric::Dist::Action::HTMLClean', 'Clean HTML', 'Clean HTML', 'Action subclass that cleans up and reformats HTML to make it nice and neat.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (17, 'org_grp', 'Bric::Util::Grp::Org', 'Organization Group', 'Organization Groups', 'Organization Group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (18, 'alert_type_grp', 'Bric::Util::Grp::AlertType', 'Alert Type Group', 'Alert Type Groups', 'Alert Type Group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (19, 'formatting', 'Bric::Biz::Asset::Formatting', 'Template', 'Templates', 'Templates', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor) 
VALUES (20, 'category', 'Bric::Biz::Category', 'Category', 'Categories', 'Categories', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (21, 'output_channel', 'Bric::Biz::OutputChannel', 'Output Channel', 'Output Channels', 'Output Channel', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (22, 'element', 'Bric::Biz::AssetType', 'Element', 'Elements', 'Element objects', 0);

/*
INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (23, 'category_grp', 'Bric::Util::Grp::Category', 'Hierarchical Category Group', 'Hierarchical Category Groups', 'Used to group together categories that have a hierarchical relationship to one another.', 0);
*/

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (24, 'asset_type_grp', 'Bric::Util::Grp::AssetType', 'Asset Type Group', 'Asset Type Groups', 'Asset Type Group', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (25, 'asset_version_grp', 'Bric::Util::Grp::AssetVersion', 'Asset Version Group', 
'Asset Version Groups', 'Asset Version Group', 0);


INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (28, 'keyword_grp', 'Bric::Util::Grp::Keyword', 'Keyword Group', 'Keyword Groups', 'Keyword group', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (29, 'element_data', 'Bric::Biz::AssetType::Parts::Data', 'Field', 'Fields', 'Fields', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (30, 'alert_type', 'Bric::Util::AlertType', 'Alert Type', 'Alert Types', 'Alert type', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (31, 'alert_type_rule', 'Bric::Util::AlertType::Parts::Rule', 'Alert Type Rule', 'Alert Type Rules', 'Alert Type rule', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (32, 'alert', 'Bric::Util::Alert', 'Alert', 'Alerts', 'Alert', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (33, 'recip', 'Bric::Util::Alerted', 'Recipient', 'Recipients', 'Alert recipients', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (34, 'recip_sent', 'Bric::Util::Alerted::Parts::Sent', 'Sent Alert', 'Sent Alerts', 'Sent Alert', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (35, 'source', 'Bric::Biz::Org::Source', 'Source', 'Sources', 'Source objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (36, 'source_grp', 'Bric::Util::Grp::Source', 'Source Group', 'Source Groups', 'Source group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (37, 'element_type', 'Bric::Biz::ATType', 'Element Type', 'Element Types', 'Element Type objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (38, 'grp_member', 'Bric::Util::Grp::Parts::Member', 'Group Member', 'Group Members', 'Members of a group', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (39, 'contrib', 'Bric::Util::Grp::Parts::Member::Contrib', 'Contributor', 'Contributors', 'Contributors', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (40, 'desk_grp', 'Bric::Util::Grp::Desk', 'Desk Group', 'Desk Groups', 'Desk Group', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (41, 'keyword', 'Bric::Biz::Keyword', 'Keyword', 'Keywords', 'Keyword', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (42, 'contact', 'Bric::Biz::Contact', 'Contact', 'Contacts', 'Contact objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (43, 'asset_grp', 'Bric::Util::Grp::Asset', 'Asset Group', 'Asset Groups', 'A group of asset objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (44, 'workflow', 'Bric::Biz::Workflow', 'Workflow', 'Workflows', 'Workflow objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (45, 'desk', 'Bric::Biz::Workflow::Parts::Desk', 'Desk', 'Desks', 'Desk objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (46, 'media', 'Bric::Biz::Asset::Business::Media', 'Media', 'Media', 'Media objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (47, 'category_set', 'Bric::Util::Grp::CategorySet', 'Category Group', 'Category Groups', 'A group of related categories', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (48, 'pref', 'Bric::Util::Pref', 'Preference', 'Preferences', 'Preference objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (49, 'audio', 'Bric::Biz::Asset::Business::Media::Audio', 'Audio',  'Audio', 'Audio Files', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (50, 'image', 'Bric::Biz::Asset::Business::Media::Image', 'Image',  'Images', 'Images', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (51, 'video', 'Bric::Biz::Asset::Business::Media::Video', 'Video',
'Videos', 'Videos', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (52, 'dest', 'Bric::Dist::ServerType', 'Destination', 'Destinations', 'Distribution destination profile objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (53, 'server', 'Bric::Dist::Server', 'Server', 'Servers', 'Server objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (54, 'job', 'Bric::Util::Job', 'Job', 'Jobs', 'Distribution job objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (55, 'resource', 'Bric::Dist::Resource', 'Resource', 'Resources', 'Distribution resource objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (56, 'action_type', 'Bric::Dist::ActionType', 'Action Type', 'Action Types', 'Distribution action type objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (57, 'biz', 'Bric::Biz::Asset::Business', 'Business Asset', 'Business Assets', 'Business Asset objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (58, 'pref_grp', 'Bric::Util::Grp::Pref', 'Preference Group', 'Preference Groups', 'Group of preferences', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (59, 'output_channel_grp', 'Bric::Util::Grp::OutputChannel', 'Output Channel Group', 'Output Channel Groups', 'Group of output channels', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (60, 'contrib_type_grp', 'Bric::Util::Grp::ContribType', 'Contributor Type Group', 'Contributor Type Groups', 'Group of contributor types', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (61, 'workflow_grp', 'Bric::Util::Grp::Workflow', 'Workflow Group', 'Workflow Groups', 'Group of workflows', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (62, 'dest_grp', 'Bric::Util::Grp::Dest', 'Destination Group', 'Destination Groups', 'Group of destinatinos', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (63, 'job_grp', 'Bric::Util::Grp::Job', 'Job Group', 'Job Groups', 'Group of jobs', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (64, 'element_type_grp', 'Bric::Util::Grp::ElementType', 'Element Type Group', 'Element Type Groups', 'Group of element types', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (65, 'story_grp', 'Bric::Util::Grp::Story', 'Story Group', 'Story Groups', 'Group of stories', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (66, 'media_grp', 'Bric::Util::Grp::Media', 'Media Group', 'Media Groups', 'Group of media', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (67, 'formatting_grp', 'Bric::Util::Grp::Formatting', 'Template Group', 'Template Groups', 'Group of templates', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (68, 'grp_grp', 'Bric::Util::Grp::Grp', 'Group Group', 'Group Groups', 'Group of groups', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (69, 'asset', 'Bric::Biz::Asset', 'Asset', 'Assets', 'Asset objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (70, 'element_grp', 'Bric::Util::Grp::Element', 'Element Group', 'Element Groups', 'Element group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (71, 'perm', 'Bric::Util::Priv', 'Permission', 'Permissions', 'Permission objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (72, 'media_type', 'Bric::Util::MediaType', 'Media Type', 'Media Types', 'Media Type objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (73, 'sftp', 'Bric::Util::Trans::SFTP', 'SFTP', 'SFTP Transport', 'Class with methods to move files via SFTP.', 1);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (74, 'webdav', 'Bric::Util::Trans::WebDAV', 'WebDAV', 'WebDAV Transport', 'Class with methods to move files via WebDAV', 1);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (75, 'site', 'Bric::Biz::Site', 'Site', 'Sites', 'Site class', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (76, 'site_grp', 'Bric::Util::Grp::Site', 'Site Group','Site Groups', 'Group of sites', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (77, 'media_type_grp', 'Bric::Util::Grp::MediaType', 'Media Type Group', 'Media Type Groups', 'Media type group objects', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (78, 'user_pref', 'Bric::Util::UserPref', 'User Preference', 'User Preferences', 'User preferences', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (79, 'dist_job', 'Bric::Util::Job::Dist', 'Distribution Job', 'Distribution Jobs', 'Distribution job objects.', 0);

INSERT INTO class (id, key_name, pkg_name, disp_name, plural_name, description, distributor)
VALUES (80, 'pub_job', 'Bric::Util::Job::Pub', 'Publication Job', 'Publication Jobs', 'Publication job objects.', 0);




    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_deploy', 'Template Deployed', 'Template was deployed.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_redeploy', 'Template Redeployed', 'Template was Redeployed.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_publish', 'Story Published', 'Story was published.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_republish', 'Story Republished', 'Story was republished.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_expire', 'Story Expired', 'Story was expired.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_clone', 'Story Cloned', 'Story was cloned.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_clone_create', 'Story Created as Clone', 'Story was created by cloning.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_publish', 'Media Published', 'Media was published.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_republish', 'Media Republished', 'Media was republished.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_expire', 'Media Expired', 'Media was expired.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_checkin', 'Template Checked In', 'Template was checked in.', 19, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Version');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_checkin', 'Story Checked In', 'Story was checked in.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Version');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_checkin', 'Media Checked In', 'Media was checked in.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Version');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_add_contrib', 'Contributor Added to Story', 'A contributor was associated with the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_del_contrib', 'Contributor Removed from Story', 'A contributor was dissociated from the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_add_contrib', 'Contributor Added to Media', 'A contributor was associated with the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_del_contrib', 'Contributor Removed from Media', 'A contributor was dissociated from the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_upload', 'Media File Uploaded', 'Media file was uploaded.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_add_category', 'Category Added to Story', 'A category was associated with the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Category');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_del_category', 'Category Removed from Story', 'A category was dissociated from the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Category');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_add_oc', 'Output Channel Added to Story',
                    'An output channel was associated with the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Output Channel');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_del_oc', 'Output Channel Removed from Story',
            'An output channel was dissociated from the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Output Channel');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_add_oc', 'Output Channel Added to Media',
                    'An output channel was associated with the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Output Channel');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_del_oc', 'Output Channel Removed from Media',
            'An output channel was dissociated from the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Output Channel');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_moved', 'Story Moved to Desk', 'Story moved onto a desk.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Desk');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_moved', 'Media Moved to Desk', 'Media moved onto a desk.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Desk');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_moved', 'Template Moved to Desk', 'Template moved onto a desk.', 19, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Desk');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_add_workflow', 'Story Moved into Workflow', 'Story moved into a workflow.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Workflow');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_add_workflow', 'Media Moved into Workflow', 'Media moved into a workflow.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Workflow');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_add_workflow', 'Template Moved into Workflow', 'Template moved into a workflow.', 19, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Workflow');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_rem_workflow', 'Story Removed from Workflow', 'Story removed from a workflow.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_rem_workflow', 'Media Removed from Workflow', 'Media removed from a workflow.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_rem_workflow', 'Template Removed from Workflow', 'Template removed from a workflow.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_checkout', 'Story Checked Out', 'Story was checked out.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_checkout', 'Media Checked Out', 'Media was checked out.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_checkout', 'Template Checked Out', 'Template was checked out.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_cancel_checkout', 'Story Check Out Canceled', 'Story check out was canceled.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_cancel_checkout', 'Media Check Out Canceled', 'Media check out was canceled.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_cancel_checkout', 'Template Check Out Canceled', 'Template check out was caneled.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_new', 'Story Created', 'Story profile was created.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_save', 'Story Changes Saved', 'Story profile changes were saved.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_deact', 'Story Deactivated', 'Story profile was deactivated.', 10, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_new', 'Media Created', 'Media profile was created.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_save', 'Media Changes Saved', 'Media profile changes were saved.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_deact', 'Media Deactivated', 'Media profile was deactivated.', 46, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_new', 'Template Created', 'Template profile was created.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_save', 'Template Changes Saved', 'Template profile changes were saved.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_deact', 'Template Deactivated', 'Template profile was deactivated.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'formatting_edit_code', 'Template Code Edited', 'Template profile code was edited.', 19, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_add_element', 'Element Added to Story', 'An element was added to the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Element');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_add_element', 'Element Added to Media', 'An element was added to the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Element');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_del_element', 'Element Deleted from Story', 'An element was deleted from the story.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Element');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_del_element', 'Element Deleted from Media', 'An element was deleted from the media.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Element');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'pref_save', 'Preference Changes Saved', 'Preference profile changes were saved.', 48, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'user_pref_save', 'User Preference Changes Saved', 'User preference profile changes were saved.', 78, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'user_pref_reset', 'User Preference Reset', 'User preference was reset to default.', 78, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'user_new', 'User Created', 'User profile was created.', 2, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'user_save', 'User Changes Saved', 'User profile changes were saved.', 2, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'user_deact', 'User Deactivated', 'User profile was deactivated.', 2, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'passwd_chg', 'User Password Changed', 'The password was changed.', 2, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'grp_new', 'Group Created', 'Group profile was created.', 6, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'grp_save', 'Group Saved', 'Group profile changes were saved.', 6, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'grp_deact', 'Group Deactivated', 'Group profile was deactivated.', 6, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'grp_perm_save', 'Group Permissions Changed', 'The permissions associated with the group were changed.', 6, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'dest_new', 'Destination Created', 'Destination profile was created.', 52, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'dest_save', 'Destination Saved', 'Destination profile changes were saved.', 52, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'dest_deact', 'Destination Deactivated', 'Destination profile was deactivated.', 52, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'server_new', 'Server Created', 'Server profile was created.', 53, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'server_save', 'Server Saved', 'Server profile changes were saved.', 53, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'server_act', 'Server Activated', 'Server profile was activated.', 53, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'server_deact', 'Server Deactivated', 'Server profile was deactivated.', 53, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'server_del', 'Server Deleted', 'Server profile was deleted.', 53, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'action_new', 'Action Created', 'Action profile was created.', 14, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'action_save', 'Action Saved', 'Action profile changes were saved.', 14, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'action_act', 'Action Activated', 'Action profile was activated.', 14, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'action_deact', 'Action Deactivated', 'Action profile was deactivated.', 14, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'action_del', 'Action Deleted', 'Action profile was deleted.', 14, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'output_channel_new', 'Output Channel Created', 'Output Channel profile was created.', 21, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'output_channel_save', 'Output Channel Changes Saved', 'Output Channel profile changes were saved.', 21, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'output_channel_deact', 'Output Channel Deactivated', 'Output Channel profile was deactivated.', 21, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_new', 'Contributor Created', 'Contributor profile was created.', 39, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_save', 'Contributor Changes Saved', 'Contributor profile changes were saved.', 39, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_deact', 'Contributor Deactivated', 'Contributor profile was deactivated.', 39, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_ext', 'Contributor Forked', 'Contributor profile was forked to become a new contributor profile.', 39, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_type_new', 'Contributor Type Created', 'Contributor Type profile was created.', 9, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_type_save', 'Contributor Type Changes Saved', 'Contributor Type profile changes were saved.', 9, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_type_deact', 'Contributor Type Deactivated', 'Contributor Type profile was deactivated.', 9, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_type_ext', 'Contributor Type Field Added', 'A new field was added to the Contributor Type profile.', 9, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'contrib_type_unext', 'Contributor Type Field Deleted', 'A field was deleted from the Contributor Type profile.', 9, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'workflow_new', 'Workflow Created', 'Workflow profile was created.', 44, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'workflow_save', 'Workflow Changes Saved', 'Workflow profile changes were saved.', 44, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'workflow_deact', 'Workflow Deactivated', 'Workflow profile was deactivated.', 44, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'workflow_add_desk', 'Desk Added to Workflow', 'A desk was added to the workflow profile.', 44, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Desk');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'workflow_del_desk', 'Desk Removed from Workflow', 'A desk was removed from the workflow profile.', 44, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Desk');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'desk_new', 'Desk Created', 'Desk profile was created.', 45, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'desk_save', 'Desk Changes Saved', 'Desk profile changes were saved.', 45, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'desk_deact', 'Desk Deactivated', 'Desk profile was deactivated.', 45, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'category_new', 'Category Created', 'Category profile was created.', 20, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'category_save', 'Category Changes Saved', 'Category profile changes were saved.', 20, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'category_deact', 'Category Deactivated', 'Category profile was deactivated.', 20, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'category_deact_cascade', 'Category and Subcategories Deactivated', 'Category profile and all its subcategory profiles were deactivated.', 20, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'source_new', 'Source Created', 'Source profile was created.', 35, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'source_save', 'Source Changes Saved', 'Source profile changes were saved.', 35, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'source_deact', 'Source Deactivated', 'Source profile was deactivated.', 35, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'org_new', 'Organization Created', 'Organization profile was created.', 3, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'org_save', 'Organization Changes Saved', 'Organization profile changes were saved.', 3, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'org_deact', 'Organization Deactivated', 'Organization profile was deactivated.', 3, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_new', 'Element Created', 'Element profile was created.', 22, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_save', 'Element Changes Saved', 'Element profile changes were saved.', 22, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_deact', 'Element Deactivated', 'Element profile was deactivated.', 22, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_attr_add', 'Field Added to Element', 'A field was added to the element profile.', 22, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_attr_del', 'Field Deleted from Element', 'A field was deleted from the element profile.', 22, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Name');

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_data_new', 'Element Data Created', 'Element Data was created.', 29, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_data_save', 'Element Data Saved in Element', 'Element Data was saved in the element data profile.', 29, 1);

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_data_del', 'Element Data Deleted from Element', 'Element Data was deleted from the element data profile.', 29, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_type_new', 'Element Type Created', 'Element Type profile was created.', 37, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_type_save', 'Element Type Changes Saved', 'Element Type profile changes were saved.', 37, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'element_type_deact', 'Element Type Deactivated', 'Element Type profile was deactivated.', 37, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'job_new', 'Job Created', 'Job was created.', 54, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'job_save', 'Job Changes Saved', 'Job changes were saved.', 54, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'job_cancel', 'Job Cancelled', 'Job was cancelled.', 54, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'job_exec', 'Job Executed', 'Job was executed.', 54, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_action', 'Action Applied to Resource', 'An action was applied to the resource.', 55, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Action');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_undo_action', 'Action Undone on Resource', 'An action was undone on the resource.', 55, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Action');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_new', 'Resource Created', 'Resource profile was created.', 55, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_save', 'Resource Changes Saved', 'Resource profile changes were saved.', 55, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_move', 'Resource Distributed', 'Resource was distributed.', 55, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Via');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'resource_remove', 'Resource Removed', 'Resource was removed.', 55, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'Via');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'alert_type_new', 'Alert Type Created', 'Alert Type was created.', 30, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'alert_type_save', 'Alert Type Saved', 'Alert Type profile changes were saved.', 30, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'alert_type_act', 'Alert Type Activated', 'Alert Type profile was activated.', 30, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'alert_type_deact', 'Alert Type Deactivated', 'Alert Type profile was deactivated.', 30, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'alert_type_del', 'Alert Type Deleted', 'Alert Type profile was deleted.', 30, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_type_new', 'Media Type Created', 'Media Type was created.', 72, 1);
 

    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_type_save', 'Media Type Saved', 'Media Type profile changes were saved.', 72, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_type_deact', 'Media Type Deactivated', 'Media Type profile was deactivated.', 72, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'keyword_new', 'Keyword Created', 'Keyword was created.', 41, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'keyword_save', 'Keyword Saved', 'Keyword profile changes were saved.', 41, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'keyword_deact', 'Keyword Deactivated', 'Keyword was deactivated.', 41, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'site_new', 'Site Created', 'Site was created.', 75, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'site_save', 'Site Saved', 'Site profile changes were saved.', 75, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'site_deact', 'Site Deactivated', 'Site was deactivated.', 75, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_aliased', 'Story Aliased', 'Story was aliased.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'To Site');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'story_alias_new', 'Story Created as Alias', 'Story was created as an alias.', 10, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'From Site');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_aliased', 'Media Aliased', 'Media was aliased.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'To Site');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'media_alias_new', 'Media Created as Alias', 'Media was created as an alias.', 46, 1);

    INSERT INTO event_type_attr (id, event_type__id, name)
    VALUES (NEXTVAL('seq_event_type_attr'), CURRVAL('seq_event_type'), 'From Site');


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'dist_job_failed', 'Distribution job failed', 'Distribution job failed due to error.', 79, 1);


    INSERT INTO event_type (id, key_name, name, description, class__id, active)
    VALUES (NEXTVAL('seq_event_type'), 'pub_job_failed', 'Publish job failed', 'Publish job failed due to error.', 80, 1);


/*****************************************************************************
 * All default events must be here, since they depend on the above being
 * run first.
 ****************************************************************************/


INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (502, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 502, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (503, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 503, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (504, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 504, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (506, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 506, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (507, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 507, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (509, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 509, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (510, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 510, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (511, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 511, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (512, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 512, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (513, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 513, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (514, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 514, CURRENT_TIMESTAMP);

INSERT INTO event (id, event_type__id, usr__id, obj_id, timestamp)
VALUES (515, (SELECT id FROM event_type WHERE key_name = 'formatting_new'),
        0, 515, CURRENT_TIMESTAMP);



INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (0, NULL, 6, 'Root Group', 'The mother of all groups.', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (112, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (1, 0, 112); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (1, 0, 9, 'All Contributors', 'All contributors in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (113, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (2, 1, 113); 

INSERT INTO member (id, grp__id, class__id, active)
VALUES (406, 24, 9, 1);

INSERT INTO contrib_type_member (id, object_id, member__id)
VALUES (1, 1, 406); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (2, 0, 8, 'All Users', 'All users of the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (114, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (3, 2, 114); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (3, 0, 17, 'All Organizations', 'All organizations in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (115, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (4, 3, 115); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (4, 0, 18, 'All Alert Types', 'All alert types in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (116, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (5, 4, 116); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (5, 0, 36, 'All Sources', 'All sources in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (117, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (6, 5, 117); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (6, NULL, 8, 'Global Admins', 'Users who can do anything.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (118, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (7, 6, 118); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (7, NULL, 8, 'Story Editors', 'Users who edit stories.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (119, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (8, 7, 119); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (8, NULL, 8, 'Media Producers', 'Users who produce and edit media.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (120, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (9, 8, 120); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (9, NULL, 8, 'Template Developers', 'Users who develop templates', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (121, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (10, 9, 121); 

/*

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (10, NULL, 8, 'Element Admins', 'Users who administer elements and element types.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (122, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (11, 10, 122); 


INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (11, NULL, 8, 'User Admins', 'Users who administer users.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (123, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (12, 11, 123); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (12, NULL, 8, 'Preference Admins', 'Users who administer preferences.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (124, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (13, 12, 124); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (13, NULL, 8, 'Group Admins', 'Users who administer groups.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (125, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (14, 13, 125); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (14, NULL, 8, 'Output Channel Admins', 'Users who administer output channels.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (126, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (15, 14, 126); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (15, NULL, 8, 'Contributor Admins', 'Users who administer contributors and contributor types.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (127, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (16, 15, 127); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (16, NULL, 8, 'Workflow Admins', 'Users who administer workflows.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (128, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (17, 16, 128); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (17, NULL, 8, 'Category Admins', 'Users who administer categories.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (129, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (18, 17, 129); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (18, NULL, 8, 'Source Admins', 'Users who administer sources.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (130, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (19, 18, 130); 

*/

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (19, NULL, 8, 'Distribution Admins', 'Users who administer distribution jobs.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (131, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (20, 19, 131); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (20, NULL, 8, 'Publishing Admins', 'Users who can use the publishing administration tools.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (132, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (21, 20, 131); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (21, NULL, 8, 'System Admins', 'Users who administer system administration tools.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (133, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (22, 21, 133); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (22, 0, 58, 'All Preferences', 'All preferences in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (134, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (23, 22, 134); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (23, NULL, 59, 'All Output Channels', 'All output channels in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (135, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (24, 23, 135); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (24, NULL, 60, 'All Contributor Types', 'All contributor types in the system.', 0, 1);
INSERT INTO member (id, grp__id, class__id, active)
VALUES (136, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (25, 24, 136); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (25, NULL, 61, 'All Workflows', 'All workflows in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (137, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (26, 25, 137); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (26, NULL, 47, 'All Categories', 'All categories in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (138, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (27, 26, 138); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (27, NULL, 70, 'All Elements', 'All elements in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (139, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (28, 27, 139); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (28, NULL, 64, 'All Element Types', 'All element types in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (140, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (29, 28, 140); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (29, NULL, 62, 'All Destinations', 'All destinations in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (141, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (30, 29, 141); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (30, NULL, 63, 'All Jobs', 'All distribution jobs in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (142, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (31, 30, 142); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (31, NULL, 65, 'All Stories', 'All stories in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (143, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (32, 31, 143); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (32, NULL, 66, 'All Media', 'All media in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (144, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (33, 32, 144); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (33, NULL, 67, 'All Templates', 'All templates in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (145, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (34, 33, 145); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (34, NULL, 40, 'All Desks', 'All desks in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (146, 34, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (35, 34, 146); 

/*

Unfortunately, there's not good way to include all assets in one group. Perhaps
we'll be able to add this functionality later, but for now, to give someone
access to all assets, give them access to 'All Stories', 'All Media', and 'All
Templates' instead.

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (34, NULL, 43, 'All Asssets', 'All assets in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (146, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (35, 34, 146);

*/

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (35, NULL, 68, 'All Groups', 'All groups in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (147, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (36, 35, 147);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (48, 0, 77, 'All Media Types', 'All media types in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (200, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (200, 48, 200);

/*

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (36, NULL, 8, 'Alert Type Admins', 'Users who administer alert types.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (148, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (37, 36, 148); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (37, NULL, 8, 'Contributor Type Admins', 'Users who administer contributor types.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (149, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (38, 37, 149); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (38, NULL, 8, 'Element Type Admins', 'Users who administer contributor types.', 0, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (150, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (39, 38, 150); 

*/

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (39, NULL, 9, 'Writers', 'People who contribute writing.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (151, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (40, 39, 151); 

INSERT INTO member (id, grp__id, class__id, active)
VALUES (152, 24, 9, 1);

INSERT INTO contrib_type_member (id, object_id, member__id)
VALUES (2, 39, 152);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (50, NULL, 28, 'All Keywords', 'All keywords in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (190, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (60, 50, 190);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (47, NULL, 76, 'All Sites', 'All sites in the system.', 0, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (165, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (56, 47, 165);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (100, NULL, 43, 'Secret Site Asset Group', NULL, 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (166, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (57, 100, 166);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (200, 0, 8, 'Default Site READ Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (700, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (700, 200, 700);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (201, 0, 8, 'Default Site EDIT Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (701, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (701, 201, 701);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (202, 0, 8, 'Default Site CREATE Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (702, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (702, 202, 702);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (203, 0, 8, 'Default Site DENY Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (703, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (703, 203, 703);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (204, 0, 8, 'Default Site RECALL Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (704, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (704, 204, 704);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (205, 0, 8, 'Default Site PUBLISH Users', '__Site 100 Users__', 1, 1);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (705, 3, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (705, 205, 705);

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (40, NULL, 9, 'Illustrators', 'People who provide original artwork.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (153, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (41, 40, 153); 

INSERT INTO member (id, grp__id, class__id, active)
VALUES (154, 24, 9, 1);

INSERT INTO contrib_type_member (id, object_id, member__id)
VALUES (3, 40, 154);


INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (61, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (157, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (42, 61, 157); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (62, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (158, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (43, 62, 158); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (63, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (159, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (44, 63, 159); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (64, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (160, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (45, 64, 160); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (65, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (161, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (46, 65, 161); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (66, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (162, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (47, 66, 162); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (67, NULL, 43, 'Desk Assets', 'A group for holding assets for Desk objects.', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (163, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (48, 67, 163); 

INSERT INTO grp (id, parent_id, class__id, name, description, secret, permanent)
VALUES (68, NULL, 43, 'Site 100 Category Assets', '/', 1, 0);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (164, 35, 6, 1);

INSERT INTO grp_member (id, object_id, member__id)
VALUES (49, 68, 164);


INSERT INTO attr_grp (id, subsys, name, sql_type, active)
VALUES (1, '_MEMBER_SUBSYS', 'Bio', 'blob', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (1, 1, 'maxlength', '0', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (2, 1, 'cols', '50', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (3, 1, 'length', '', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (4, 1, 'multiple', '', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (5, 1, 'vals', '', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (6, 1, 'rows', '5', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (7, 1, 'type', 'textarea', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (8, 1, 'disp', 'Bio', 1);

INSERT INTO attr_grp_meta (id, attr__id, name, value, active)
VALUES (9, 1, 'pos', '1', 1);

INSERT INTO attr_grp_val(id, object__id, attr__id, active)
VALUES (1, 39, 1, 1);

INSERT INTO attr_grp_val(id, object__id, attr__id, active)
VALUES (2, 40, 1, 1);






DELETE FROM media_type;

INSERT INTO media_type (id, name, description, active)
VALUES (0, 'none', 'Use when no MIME Type applies, or when they all do.', 1);

INSERT INTO media_type (id, name, description, active)
VALUES (1, 'application/andrew-inset', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (1, 1, 'ez');

INSERT INTO media_type (id, name, description, active)
VALUES (2, 'application/mac-binhex40', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (2, 2, 'hqx');

INSERT INTO media_type (id, name, description, active)
VALUES (3, 'application/mac-compactpro', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (3, 3, 'cpt');

INSERT INTO media_type (id, name, description, active)
VALUES (4, 'application/msword', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (4, 4, 'doc');

INSERT INTO media_type (id, name, description, active)
VALUES (5, 'application/octet-stream', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (5, 5, 'bin');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (6, 5, 'class');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (7, 5, 'dms');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (8, 5, 'exe');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (9, 5, 'lha');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (10, 5, 'lzh');

INSERT INTO media_type (id, name, description, active)
VALUES (6, 'application/oda', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (11, 6, 'oda');

INSERT INTO media_type (id, name, description, active)
VALUES (7, 'application/pdf', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (12, 7, 'pdf');

INSERT INTO media_type (id, name, description, active)
VALUES (8, 'application/postscript', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (13, 8, 'ai');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (14, 8, 'eps');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (15, 8, 'ps');

INSERT INTO media_type (id, name, description, active)
VALUES (9, 'application/smil', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (16, 9, 'smi');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (17, 9, 'smil');

INSERT INTO media_type (id, name, description, active)
VALUES (10, 'application/vnd.mif', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (18, 10, 'mif');

INSERT INTO media_type (id, name, description, active)
VALUES (11, 'application/vnd.ms-excel', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (19, 11, 'xls');

INSERT INTO media_type (id, name, description, active)
VALUES (12, 'application/vnd.ms-powerpoint', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (20, 12, 'ppt');

INSERT INTO media_type (id, name, description, active)
VALUES (13, 'application/vnd.wap.wbxml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (21, 13, 'wbxml');

INSERT INTO media_type (id, name, description, active)
VALUES (14, 'application/vnd.wap.wmlc', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (22, 14, 'wmlc');

INSERT INTO media_type (id, name, description, active)
VALUES (15, 'application/vnd.wap.wmlscriptc', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (23, 15, 'wmlsc');

INSERT INTO media_type (id, name, description, active)
VALUES (16, 'application/x-bcpio', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (24, 16, 'bcpio');

INSERT INTO media_type (id, name, description, active)
VALUES (17, 'application/x-cdlink', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (25, 17, 'vcd');

INSERT INTO media_type (id, name, description, active)
VALUES (18, 'application/x-chess-pgn', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (26, 18, 'pgn');

INSERT INTO media_type (id, name, description, active)
VALUES (19, 'application/x-cpio', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (27, 19, 'cpio');

INSERT INTO media_type (id, name, description, active)
VALUES (20, 'application/x-csh', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (28, 20, 'csh');

INSERT INTO media_type (id, name, description, active)
VALUES (21, 'application/x-director', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (29, 21, 'dcr');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (30, 21, 'dir');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (31, 21, 'dxr');

INSERT INTO media_type (id, name, description, active)
VALUES (22, 'application/x-dvi', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (32, 22, 'dvi');

INSERT INTO media_type (id, name, description, active)
VALUES (23, 'application/x-futuresplash', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (33, 23, 'spl');

INSERT INTO media_type (id, name, description, active)
VALUES (24, 'application/x-gtar', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (34, 24, 'gtar');

INSERT INTO media_type (id, name, description, active)
VALUES (25, 'application/x-hdf', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (35, 25, 'hdf');

INSERT INTO media_type (id, name, description, active)
VALUES (26, 'application/x-javascript', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (36, 26, 'js');

INSERT INTO media_type (id, name, description, active)
VALUES (27, 'application/x-koan', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (37, 27, 'skd');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (38, 27, 'skm');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (39, 27, 'skp');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (40, 27, 'skt');

INSERT INTO media_type (id, name, description, active)
VALUES (28, 'application/x-latex', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (41, 28, 'latex');

INSERT INTO media_type (id, name, description, active)
VALUES (29, 'application/x-netcdf', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (42, 29, 'cdf');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (43, 29, 'nc');

INSERT INTO media_type (id, name, description, active)
VALUES (30, 'application/x-sh', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (44, 30, 'sh');

INSERT INTO media_type (id, name, description, active)
VALUES (31, 'application/x-shar', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (45, 31, 'shar');

INSERT INTO media_type (id, name, description, active)
VALUES (32, 'application/x-shockwave-flash', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (46, 32, 'swf');

INSERT INTO media_type (id, name, description, active)
VALUES (33, 'application/x-stuffit', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (47, 33, 'sit');

INSERT INTO media_type (id, name, description, active)
VALUES (34, 'application/x-sv4cpio', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (48, 34, 'sv4cpio');

INSERT INTO media_type (id, name, description, active)
VALUES (35, 'application/x-sv4crc', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (49, 35, 'sv4crc');

INSERT INTO media_type (id, name, description, active)
VALUES (36, 'application/x-tar', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (50, 36, 'tar');

INSERT INTO media_type (id, name, description, active)
VALUES (37, 'application/x-tcl', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (51, 37, 'tcl');

INSERT INTO media_type (id, name, description, active)
VALUES (38, 'application/x-tex', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (52, 38, 'tex');

INSERT INTO media_type (id, name, description, active)
VALUES (39, 'application/x-texinfo', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (53, 39, 'texi');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (54, 39, 'texinfo');

INSERT INTO media_type (id, name, description, active)
VALUES (40, 'application/x-troff', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (55, 40, 'roff');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (56, 40, 't');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (57, 40, 'tr');

INSERT INTO media_type (id, name, description, active)
VALUES (41, 'application/x-troff-man', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (58, 41, 'man');

INSERT INTO media_type (id, name, description, active)
VALUES (42, 'application/x-troff-me', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (59, 42, 'me');

INSERT INTO media_type (id, name, description, active)
VALUES (43, 'application/x-troff-ms', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (60, 43, 'ms');

INSERT INTO media_type (id, name, description, active)
VALUES (44, 'application/x-ustar', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (61, 44, 'ustar');

INSERT INTO media_type (id, name, description, active)
VALUES (45, 'application/x-wais-source', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (62, 45, 'src');

INSERT INTO media_type (id, name, description, active)
VALUES (46, 'application/zip', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (63, 46, 'zip');

INSERT INTO media_type (id, name, description, active)
VALUES (47, 'audio/basic', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (64, 47, 'au');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (65, 47, 'snd');

INSERT INTO media_type (id, name, description, active)
VALUES (48, 'audio/midi', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (66, 48, 'kar');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (67, 48, 'mid');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (68, 48, 'midi');

INSERT INTO media_type (id, name, description, active)
VALUES (49, 'audio/mpeg', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (69, 49, 'mp2');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (70, 49, 'mp3');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (71, 49, 'mpga');

INSERT INTO media_type (id, name, description, active)
VALUES (50, 'audio/x-aiff', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (72, 50, 'aif');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (73, 50, 'aifc');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (74, 50, 'aiff');

INSERT INTO media_type (id, name, description, active)
VALUES (51, 'audio/x-pn-realaudio', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (75, 51, 'ram');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (76, 51, 'rm');

INSERT INTO media_type (id, name, description, active)
VALUES (52, 'audio/x-pn-realaudio-plugin', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (77, 52, 'rpm');

INSERT INTO media_type (id, name, description, active)
VALUES (53, 'audio/x-realaudio', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (78, 53, 'ra');

INSERT INTO media_type (id, name, description, active)
VALUES (54, 'audio/x-wav', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (79, 54, 'wav');

INSERT INTO media_type (id, name, description, active)
VALUES (55, 'chemical/x-pdb', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (80, 55, 'pdb');

INSERT INTO media_type (id, name, description, active)
VALUES (56, 'chemical/x-xyz', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (81, 56, 'xyz');

INSERT INTO media_type (id, name, description, active)
VALUES (57, 'image/bmp', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (82, 57, 'bmp');

INSERT INTO media_type (id, name, description, active)
VALUES (58, 'image/gif', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (83, 58, 'gif');

INSERT INTO media_type (id, name, description, active)
VALUES (59, 'image/ief', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (84, 59, 'ief');

INSERT INTO media_type (id, name, description, active)
VALUES (60, 'image/jpeg', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (85, 60, 'jpe');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (86, 60, 'jpeg');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (87, 60, 'jpg');

INSERT INTO media_type (id, name, description, active)
VALUES (61, 'image/png', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (88, 61, 'png');

INSERT INTO media_type (id, name, description, active)
VALUES (62, 'image/tiff', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (89, 62, 'tif');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (90, 62, 'tiff');

INSERT INTO media_type (id, name, description, active)
VALUES (63, 'image/vnd.wap.wbmp', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (91, 63, 'wbmp');

INSERT INTO media_type (id, name, description, active)
VALUES (64, 'image/x-cmu-raster', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (92, 64, 'ras');

INSERT INTO media_type (id, name, description, active)
VALUES (65, 'image/x-portable-anymap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (93, 65, 'pnm');

INSERT INTO media_type (id, name, description, active)
VALUES (66, 'image/x-portable-bitmap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (94, 66, 'pbm');

INSERT INTO media_type (id, name, description, active)
VALUES (67, 'image/x-portable-graymap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (95, 67, 'pgm');

INSERT INTO media_type (id, name, description, active)
VALUES (68, 'image/x-portable-pixmap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (96, 68, 'ppm');

INSERT INTO media_type (id, name, description, active)
VALUES (69, 'image/x-rgb', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (97, 69, 'rgb');

INSERT INTO media_type (id, name, description, active)
VALUES (70, 'image/x-xbitmap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (98, 70, 'xbm');

INSERT INTO media_type (id, name, description, active)
VALUES (71, 'image/x-xpixmap', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (99, 71, 'xpm');

INSERT INTO media_type (id, name, description, active)
VALUES (72, 'image/x-xwindowdump', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (100, 72, 'xwd');

INSERT INTO media_type (id, name, description, active)
VALUES (73, 'model/iges', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (101, 73, 'iges');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (102, 73, 'igs');

INSERT INTO media_type (id, name, description, active)
VALUES (74, 'model/mesh', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (103, 74, 'mesh');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (104, 74, 'msh');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (105, 74, 'silo');

INSERT INTO media_type (id, name, description, active)
VALUES (75, 'model/vrml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (106, 75, 'vrml');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (107, 75, 'wrl');

INSERT INTO media_type (id, name, description, active)
VALUES (76, 'text/css', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (108, 76, 'css');

INSERT INTO media_type (id, name, description, active)
VALUES (77, 'text/html', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (109, 77, 'htm');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (110, 77, 'html');

INSERT INTO media_type (id, name, description, active)
VALUES (78, 'text/plain', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (111, 78, 'asc');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (112, 78, 'txt');

INSERT INTO media_type (id, name, description, active)
VALUES (79, 'text/richtext', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (113, 79, 'rtx');

INSERT INTO media_type (id, name, description, active)
VALUES (80, 'text/rtf', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (114, 80, 'rtf');

INSERT INTO media_type (id, name, description, active)
VALUES (81, 'text/sgml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (115, 81, 'sgm');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (116, 81, 'sgml');

INSERT INTO media_type (id, name, description, active)
VALUES (82, 'text/tab-separated-values', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (117, 82, 'tsv');

INSERT INTO media_type (id, name, description, active)
VALUES (83, 'text/vnd.wap.wml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (118, 83, 'wml');

INSERT INTO media_type (id, name, description, active)
VALUES (84, 'text/vnd.wap.wmlscript', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (119, 84, 'wmls');

INSERT INTO media_type (id, name, description, active)
VALUES (85, 'text/x-setext', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (120, 85, 'etx');

INSERT INTO media_type (id, name, description, active)
VALUES (86, 'text/xml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (121, 86, 'xml');

INSERT INTO media_type (id, name, description, active)
VALUES (87, 'video/mpeg', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (122, 87, 'mpe');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (123, 87, 'mpeg');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (124, 87, 'mpg');

INSERT INTO media_type (id, name, description, active)
VALUES (88, 'video/quicktime', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (125, 88, 'mov');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (126, 88, 'qt');

INSERT INTO media_type (id, name, description, active)
VALUES (89, 'video/x-msvideo', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (127, 89, 'avi');

INSERT INTO media_type (id, name, description, active)
VALUES (90, 'video/x-sgi-movie', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (128, 90, 'movie');

INSERT INTO media_type (id, name, description, active)
VALUES (91, 'x-conference/x-cooltalk', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (129, 91, 'ice');

INSERT INTO media_type (id, name, description, active)
VALUES (92, 'application/xhtml+xml', NULL, 1);

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (130, 92, 'xhtml');

INSERT INTO media_type_ext (id, media_type__id, extension)
VALUES (131, 92, 'xht');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (800, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (800, 0, 800);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (801, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (801, 1, 801);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (802, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (802, 2, 802);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (803, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (803, 3, 803);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (804, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (804, 4, 804);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (805, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (805, 5, 805);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (806, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (806, 6, 806);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (807, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (807, 7, 807);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (808, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (808, 8, 808);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (809, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (809, 9, 809);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (810, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (810, 10, 810);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (811, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (811, 11, 811);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (812, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (812, 12, 812);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (813, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (813, 13, 813);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (814, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (814, 14, 814);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (815, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (815, 15, 815);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (816, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (816, 16, 816);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (817, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (817, 17, 817);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (818, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (818, 18, 818);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (819, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (819, 19, 819);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (820, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (820, 20, 820);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (821, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (821, 21, 821);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (822, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (822, 22, 822);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (823, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (823, 23, 823);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (824, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (824, 24, 824);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (825, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (825, 25, 825);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (826, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (826, 26, 826);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (827, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (827, 27, 827);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (828, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (828, 28, 828);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (829, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (829, 29, 829);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (830, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (830, 30, 830);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (831, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (831, 31, 831);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (832, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (832, 32, 832);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (833, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (833, 33, 833);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (834, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (834, 34, 834);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (835, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (835, 35, 835);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (836, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (836, 36, 836);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (837, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (837, 37, 837);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (838, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (838, 38, 838);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (839, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (839, 39, 839);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (840, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (840, 40, 840);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (841, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (841, 41, 841);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (842, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (842, 42, 842);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (843, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (843, 43, 843);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (844, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (844, 44, 844);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (845, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (845, 45, 845);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (846, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (846, 46, 846);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (847, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (847, 47, 847);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (848, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (848, 48, 848);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (849, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (849, 49, 849);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (850, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (850, 50, 850);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (851, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (851, 51, 851);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (852, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (852, 52, 852);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (853, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (853, 53, 853);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (854, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (854, 54, 854);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (855, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (855, 55, 855);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (856, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (856, 56, 856);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (857, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (857, 57, 857);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (858, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (858, 58, 858);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (859, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (859, 59, 859);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (860, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (860, 60, 860);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (861, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (861, 61, 861);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (862, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (862, 62, 862);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (863, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (863, 63, 863);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (864, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (864, 64, 864);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (865, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (865, 65, 865);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (866, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (866, 66, 866);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (867, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (867, 67, 867);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (868, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (868, 68, 868);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (869, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (869, 69, 869);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (870, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (870, 70, 870);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (871, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (871, 71, 871);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (872, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (872, 72, 872);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (873, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (873, 73, 873);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (874, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (874, 74, 874);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (875, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (875, 75, 875);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (876, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (876, 76, 876);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (877, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (877, 77, 877);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (878, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (878, 78, 878);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (879, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (879, 79, 879);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (880, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (880, 80, 880);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (881, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (881, 81, 881);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (882, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (882, 82, 882);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (883, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (883, 83, 883);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (884, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (884, 84, 884);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (885, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (885, 85, 885);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (886, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (886, 86, 886);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (887, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (887, 87, 887);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (888, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (888, 88, 888);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (889, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (889, 89, 889);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (890, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (890, 90, 890);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (891, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (891, 91, 891);

INSERT INTO member (id, grp__id, class__id, active)
VALUES (892, 48, 72, 1);

INSERT INTO media_type_member (id, object_id, member__id)
VALUES (892, 92, 892);

INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (1, 'Time Zone', 'Time Zone', 'America/Los_Angeles', 'America/Los_Angeles', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (401, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (1, 1, 401); 


INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'UTC', 'Coordinated Universal Time (UTC)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Cuba', 'Cuba');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Egypt', 'Egypt');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Eire', 'Eire');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Hongkong', 'Hong Kong');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Iceland', 'Iceland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Iran', 'Iran');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Israel', 'Israel');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Jamaica', 'Jamaica');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Japan', 'Japan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Kwajalein', 'Kwajalein');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Libya', 'Libya');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Navajo', 'Navajo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Singapore', 'Singapore');


/* The following TZ values were created with this Perl script, running on Red
Hat 6.2 (although many descriptions have been since hand-edited):

#!/usr/bin/perl -w

use strict;

open TZ, "</usr/share/zoneinfo/zone.tab" or die "Can't open file: $!\n";
while (<TZ>) {
    next if /^#/;
    chomp;
    my ($zone, $desc) = (split /\t/)[2..3];
    $zone =~ s/^\s+//;
    $zone =~ s/\s+$//;
    $zone =~ s/'/''/g;
    if ($desc) {
	$desc =~ s/^\s+//;
	$desc =~ s/\s+$//;
	$desc =~ s/'/''/g;
	$desc = ucfirst $desc;
    } else {
	($desc = $zone) =~ s/_/ /g;
    }
#    print "$zone: $desc\n";
    print qq{
INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, '$zone', '$desc');
};
}
close TZ;

*/

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Andorra', 'Europe/Andorra');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Dubai', 'Asia - Dubai');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kabul', 'Asia - Kabul');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Antigua', 'America - Antigua');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Anguilla', 'America - Anguilla');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Tirane', 'Europe - Tirane');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Yerevan', 'Asia - Yerevan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Curacao', 'America - Curacao');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Luanda', 'Africa - Luanda');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/McMurdo', 'McMurdo Station, Ross Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/South_Pole', 'Amundsen-Scott Station, South Pole');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/Palmer', 'Palmer Station, Anvers Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/Mawson', 'Mawson Station, Holme Bay');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/Davis', 'Davis Station, Vestfold Hills');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/Casey', 'Casey Station, Bailey Peninsula');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/DumontDUrville', 'Dumont-d''Urville Base');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Antarctica/Syowa', 'Syowa Station, E Ongul I');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Buenos_Aires', 'E Argentina - Buenos Aires');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Rosario', 'NE Argentina - Rosario');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cordoba', 'West Argentina - Cordoba');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Jujuy', 'Jujuy (JY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Catamarca', 'Catamarca (CT)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Mendoza', 'Mendoza (MZ)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Pago_Pago', 'Pacific - Pago Pago');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Vienna', 'Europe - Vienna');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Lord_Howe', 'Lord Howe Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Hobart', 'Tasmania');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Melbourne', 'Victoria');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Sydney', 'New South Wales - Sydney');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Broken_Hill', 'New South Wales - Broken Hill');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Brisbane', 'Queensland - Brisbane');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Lindeman', 'Queensland - Holiday Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Adelaide', 'South Australia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Darwin', 'Northern Territory');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Australia/Perth', 'Western Australia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Aruba', 'America - Aruba');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Baku', 'Asia - Baku');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Sarajevo', 'Europe - Sarajevo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Barbados', 'America - Barbados');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Dacca', 'Asia - Dacca');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Brussels', 'Europe - Brussels');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Ouagadougou', 'Africa - Ouagadougou');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Sofia', 'Europe - Sofia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Bahrain', 'Asia - Bahrain');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Bujumbura', 'Africa - Bujumbura');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Porto-Novo', 'Africa - Porto-Novo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Bermuda', 'Atlantic - Bermuda');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Brunei', 'Asia - Brunei');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/La_Paz', 'America - La Paz');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Noronha', 'Fernando de Noronha');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Belem', 'Amapa, E Para');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Fortaleza', 'NE Brazil - Fortaleza');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Araguaina', 'Tocantins');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Maceio', 'Alagoas, Sergipe');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Sao_Paulo', 'S & SE Brazil - Sao Paulo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cuiaba', 'Mato Grosso, Mato Grosso do Sul');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Porto_Velho', 'W Para, Rondonia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Boa_Vista', 'Roraima');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Manaus', 'Amazonas');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Porto_Acre', 'Acre');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Nassau', 'America - Nassau');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Thimbu', 'Asia - Thimbu');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Gaborone', 'Africa - Gaborone');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Minsk', 'Europe - Minsk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Belize', 'America - Belize');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/St_Johns', 'Newfoundland Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Halifax', 'Atlantic Time - Halifax');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Glace_Bay', 'Atlantic Time - Glace Bay');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Goose_Bay', 'Atlantic Time - East Labrador');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Montreal', 'Eastern Time - Montreal');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Nipigon', 'Eastern Time - Nipigon');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Thunder_Bay', 'Eastern Time - Thunder Bay');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Winnipeg', 'Central Time - Winnipeg');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Rainy_River', 'Central Time - Rainy River');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Pangnirtung', 'Central Time - Pangnirtung');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Iqaluit', 'Central Time - East Nunavut');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Rankin_Inlet', 'Central Time - Central Nunavut');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cambridge_Bay', 'Central Time - West Nunavut');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Regina', 'Central Standard Time - Regina');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Swift_Current', 'Central Standard Time - Swift Current');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Edmonton', 'Mountain Time - Edmonton');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Yellowknife', 'Mountain Time - Yellowknife');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Inuvik', 'Mountain Time - Inuvik');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Dawson_Creek', 'Mountain Standard Time - Dawson Creek');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Vancouver', 'Pacific Time - Vancouver');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Whitehorse', 'Pacific Time - Whitehorse');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Dawson', 'Pacific Time - Dawson');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Cocos', 'Indian - Cocos');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Kinshasa', 'West Dem. Rep. of Congo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Lubumbashi', 'East Dem. Rep. of Congo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Bangui', 'Africa - Bangui');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Brazzaville', 'Africa - Brazzaville');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Zurich', 'Europe - Zurich');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Abidjan', 'Africa - Abidjan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Rarotonga', 'Pacific - Rarotonga');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Santiago', 'America - Santiago');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Easter', 'Easter Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Douala', 'Africa - Douala');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Harbin', 'North Manchuria');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Shanghai', 'China coast');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Chungking', 'China mountains');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Urumqi', 'Tibet & Xinjiang');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kashgar', 'Eastern Turkestan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Bogota', 'America - Bogota');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Costa_Rica', 'America - Costa Rica');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Havana', 'America - Havana');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Cape_Verde', 'Atlantic - Cape Verde');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Christmas', 'Indian - Christmas');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Nicosia', 'Asia - Nicosia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Prague', 'Europe - Prague');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Berlin', 'Europe - Berlin');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Djibouti', 'Africa - Djibouti');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Copenhagen', 'Europe - Copenhagen');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Dominica', 'America - Dominica');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Santo_Domingo', 'America - Santo Domingo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Algiers', 'Africa - Algiers');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Guayaquil', 'America -Guayaquil');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Galapagos', 'Galapagos Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Tallinn', 'Europe - Tallinn');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Cairo', 'Africa - Cairo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/El_Aaiun', 'Africa - El Aaiun');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Asmera', 'Africa - Asmera');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Madrid', 'Europe - Madrid');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Ceuta', 'Ceuta & Melilla');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Canary', 'Canary Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Addis_Ababa', 'Africa - Addis Ababa');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Helsinki', 'Europe - Helsinki');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Fiji', 'Pacific - Fiji');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Stanley', 'Atlantic - Stanley');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Yap', 'Yap');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Truk', 'Truk (Chuuk)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Ponape', 'Ponape (Pohnpei)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Kosrae', 'Kosrae');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Faeroe', 'Atlantic - Faeroe');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Paris', 'Europe - Paris');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Libreville', 'Africa - Libreville');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/London', 'Great Britain');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Belfast', 'Northern Ireland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Grenada', 'America - Grenada');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Tbilisi', 'Asia - Tbilisi');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cayenne', 'America - Cayenne');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Accra', 'Africa - Accra');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Gibraltar', 'Europe - Gibraltar');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Scoresbysund', 'East Greenland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Godthab', 'Southwest Greenland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Thule', 'Northwest Greenland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Banjul', 'Africa - Banjul');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Conakry', 'Africa - Conakry');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Guadeloupe', 'America - Guadeloupe');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Malabo', 'Africa - Malabo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Athens', 'Europe - Athens');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/South_Georgia', 'Atlantic - South Georgia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Guatemala', 'America - Guatemala');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Guam', 'Pacific - Guam');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Bissau', 'Africa - Bissau');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Guyana', 'America - Guyana');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Hong_Kong', 'Asia - Hong Kong');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Tegucigalpa', 'America - Tegucigalpa');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Zagreb', 'Europe - Zagreb');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Port-au-Prince', 'America - Port-au-Prince');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Budapest', 'Europe - Budapest');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Jakarta', 'Java & Sumatra');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Ujung_Pandang', 'Borneo & Celebes');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Jayapura', 'Irian Jaya & the Moluccas');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Dublin', 'Europe - Dublin');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Jerusalem', 'Asia - Jerusalem');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Calcutta', 'Asia - Calcutta');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Chagos', 'Indian - Chagos');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Baghdad', 'Asia - Baghdad');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Tehran', 'Asia - Tehran');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Reykjavik', 'Atlantic - Reykjavik');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Rome', 'Europe - Rome');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Jamaica', 'America - Jamaica');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Amman', 'Asia - Amman');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Tokyo', 'Asia - Tokyo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Nairobi', 'Africa - Nairobi');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Bishkek', 'Asia - Bishkek');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Phnom_Penh', 'Asia - Phnom Penh');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Tarawa', 'Gilbert Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Enderbury', 'Phoenix Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Kiritimati', 'Line Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Comoro', 'Indian - Comoro');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/St_Kitts', 'America - St Kitts');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Pyongyang', 'Asia - Pyongyang');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Seoul', 'Asia - Seoul');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kuwait', 'Asia - Kuwait');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cayman', 'America - Cayman');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Almaty', 'East Kazakhstan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Aqtobe', 'Central Kazakhstan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Aqtau', 'West Kazakhstan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Vientiane', 'Asia - Vientiane');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Beirut', 'Asia - Beirut');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/St_Lucia', 'America - St Lucia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Vaduz', 'Europe - Vaduz');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Colombo', 'Asia - Colombo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Monrovia', 'Africa - Monrovia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Maseru', 'Africa - Maseru');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Vilnius', 'Europe - Vilnius');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Luxembourg', 'Europe - Luxembourg');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Riga', 'Europe - Riga');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Tripoli', 'Africa - Tripoli');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Casablanca', 'Africa - Casablanca');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Monaco', 'Europe - Monaco');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Chisinau', 'Europe - Chisinau');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Tiraspol', 'Transdniestria');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Antananarivo', 'Indian - Antananarivo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Majuro', 'Pacific - Majuro');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Kwajalein', 'Kwajalein');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Skopje', 'Europe - Skopje');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Bamako', 'Southwest Mali');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Timbuktu', 'Northeast Mali');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Rangoon', 'Asia - Rangoon');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Ulaanbaatar', 'Asia - Ulaanbaatar');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Hovd', 'Bayan-Olgiy, Hovd, Uvs');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Macao', 'Asia - Macao');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Saipan', 'Pacific - Saipan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Martinique', 'America - Martinique');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Nouakchott', 'Africa - Nouakchott');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Montserrat', 'America - Montserrat');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Malta', 'Europe - Malta');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Mauritius', 'Indian - Mauritius');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Maldives', 'Indian - Maldives');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Blantyre', 'Africa - Blantyre');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Mexico_City', 'Central Time - Mexico City');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Cancun', 'Central Time - Quintana Roo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Mazatlan', 'Mountain Time - Mazatlna');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Chihuahua', 'Mountain Time - Chihuahua');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Hermosillo', 'Mountain Standard Time - Sonora');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Tijuana', 'Pacific Time - Tijuana');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kuala_Lumpur', 'Peninsular Malaysia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kuching', 'Sabah & Sarawak');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Maputo', 'Africa - Maputo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Windhoek', 'Africa - Windhoek');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Noumea', 'Pacific - Noumea');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Niamey', 'Africa - Niamey');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Norfolk', 'Pacific - Norfolk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Lagos', 'Africa - Lagos');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Managua', 'America - Managua');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Amsterdam', 'Europe - Amsterdam');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Oslo', 'Europe - Oslo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Katmandu', 'Asia - Katmandu');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Nauru', 'Pacific - Nauru');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Niue', 'Pacific - Niue');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Auckland', 'Pacific - Auckland');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Chatham', 'Chatham Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Muscat', 'Asia - Muscat');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Panama', 'America - Panama');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Lima', 'America - Lima');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Tahiti', 'Society Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Marquesas', 'Marquesas Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Gambier', 'Gambier Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Port_Moresby', 'Pacific - Port Moresby');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Manila', 'Asia - Manila');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Karachi', 'Asia - Karachi');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Warsaw', 'Europe - Warsaw');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Miquelon', 'America - Miquelon');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Pitcairn', 'Pacific - Pitcairn');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Puerto_Rico', 'America - Puerto Rico');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Gaza', 'Asia - Gaza');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Lisbon', 'Europe - Lisbon');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Madeira', 'Madeira Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Azores', 'Azores');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Palau', 'Pacific - Palau');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Asuncion', 'America - Asuncion');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Qatar', 'Asia - Qatar');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Reunion', 'Indian - Reunion');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Bucharest', 'Europe - Bucharest');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Kaliningrad', 'Moscow-01 - Kaliningrad');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Moscow', 'Moscow+00 - west Russia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Samara', 'Moscow+01 - Caspian Sea');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Yekaterinburg', 'Moscow+02 - Urals');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Omsk', 'Moscow+03 - west Siberia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Novosibirsk', 'Moscow+03 - Novosibirsk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Krasnoyarsk', 'Moscow+04 - Yenisei River');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Irkutsk', 'Moscow+05 - Lake Baikal');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Yakutsk', 'Moscow+06 - Lena River');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Vladivostok', 'Moscow+07 - Amur River');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Magadan', 'Moscow+08 - Magadan & Sakhalin');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Kamchatka', 'Moscow+09 - Kamchatka');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Anadyr', 'Moscow+10 - Bering Sea');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Kigali', 'Africa - Kigali');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Riyadh', 'Asia - Riyadh');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Guadalcanal', 'Pacific - Guadalcanal');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Mahe', 'Indian - Mahe');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Khartoum', 'Africa - Khartoum');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Stockholm', 'Europe - Stockholm');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Singapore', 'Asia - Singapore');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/St_Helena', 'Atlantic - St Helena');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Ljubljana', 'Europe - Ljubljana');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Arctic/Longyearbyen', 'Svalbard');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Atlantic/Jan_Mayen', 'Jan Mayen');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Bratislava', 'Europe - Bratislava');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Freetown', 'Africa - Freetown');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/San_Marino', 'Europe - San Marino');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Dakar', 'Africa - Dakar');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Mogadishu', 'Africa - Mogadishu');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Paramaribo', 'America - Paramaribo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Sao_Tome', 'Africa - Sao Tome');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/El_Salvador', 'America - El Salvador');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Damascus', 'Asia - Damascus');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Mbabane', 'Africa - Mbabane');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Grand_Turk', 'America - Grand Turk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Ndjamena', 'Africa - Ndjamena');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Kerguelen', 'Indian - Kerguelen');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Lome', 'Africa - Lome');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Bangkok', 'Asia - Bangkok');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Dushanbe', 'Asia - Dushanbe');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Fakaofo', 'Pacific - Fakaofo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Ashkhabad', 'Asia - Ashkhabad');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Tunis', 'Africa - Tunis');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Tongatapu', 'Pacific - Tongatapu');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Dili', 'Asia - Dili');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Istanbul', 'Europe - Istanbul');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Port_of_Spain', 'America - Port of Spain');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Funafuti', 'Pacific - Funafuti');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Taipei', 'Asia - Taipei');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Dar_es_Salaam', 'Africa - Dar es Salaam');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Kiev', 'Europe - Kiev');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Uzhgorod', 'Ruthenia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Zaporozhye', 'Zaporozh''ye, E Lugansk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Simferopol', 'Central Crimea');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Kampala', 'Africa - Kampala');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Johnston', 'Johnston Atoll');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Midway', 'Midway Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Wake', 'Wake Island');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/New_York', 'Eastern Time');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Detroit', 'Eastern Time - Detroit');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Louisville', 'Eastern Time - Louisville, KY');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Indianapolis', 'Eastern Standard Time - Indianapolis');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Indiana/Marengo', 'Eastern Standard Time - Marengo, IN');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Indiana/Knox', 'Eastern Standard Time - Knox, IN');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Indiana/Vevay', 'Eastern Standard Time - Vevay, IN');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Chicago', 'Central Time - Chicago');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Menominee', 'Central Time - Menominee');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Denver', 'Mountain Time - Denver');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Boise', 'Mountain Time - Boise');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Shiprock', 'Mountain Time - Navajo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Phoenix', 'Mountain Standard Time - Arizona');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Los_Angeles', 'Pacific Time - Los Angeles');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Anchorage', 'Alaska Time');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Juneau', 'Alaska Time - Juneau');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Yakutat', 'Alaska Time - Yakutat');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Nome', 'Alaska Time - Nome');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Adak', 'Aleutian Islands');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Honolulu', 'Hawaii');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Montevideo', 'America - Montevideo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Samarkand', 'West Uzbekistan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Tashkent', 'East Uzbekistan');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Vatican', 'Europe - Vatican');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/St_Vincent', 'America - St Vincent');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Caracas', 'America - Caracas');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/Tortola', 'America - Tortola');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'America/St_Thomas', 'America - St Thomas');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Saigon', 'Asia - Saigon');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Efate', 'Pacific - Efate');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Wallis', 'Pacific - Wallis');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Pacific/Apia', 'Pacific - Apia');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Asia/Aden', 'Asia - Aden');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Indian/Mayotte', 'Indian - Mayotte');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Europe/Belgrade', 'Europe - Belgrade');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Johannesburg', 'Africa - Johannesburg');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Lusaka', 'Africa - Lusaka');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (1, 'Africa/Harare', 'Africa - Harare');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (2, 'List Name Format', 'How people''s names appear in lists.', '%l%, f', '%l%, f', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (402, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (2, 2, 402); 

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%l%, f% m', '"Clinton, William Jefferson"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%l%, f% M', '"Clinton, William J."');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%l%, f', '"Clinton, William"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%l%, F%M', '"Clinton, W.J."');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%l%, F% m', '"Clinton, W. Jefferson"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%f% m% l', '"William Jefferson Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%f% l', '"William Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%f% M% l', '"William J. Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%F%M% l', '"W.J. Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (2, '%F% m% l', '"W. Jefferson Clinton"');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (3, 'Name Format', 'The default format for people''s names.', '%f% l', '%f% l', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (403, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (3, 3, 403); 

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%l%, f% m', '"Clinton, William Jefferson"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%l%, f% M', '"Clinton, William J."');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%l%, f', '"Clinton, William"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%l%, F%M', '"Clinton, W.J."');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%l%, F% m', '"Clinton, W. Jefferson"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%f% m% l', '"William Jefferson Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%f% l', '"William Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%f% M% l', '"William J. Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%F%M% l', '"W.J. Clinton"');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (3, '%F% m% l', '"W. Jefferson Clinton"');


INSERT INTO pref (id, name, description, value, def, opt_type)
VALUES (5, 'Date/Time Format', 'How dates and times are displayed.', '%Y-%m-%d %T', '%Y-%m-%d %T', 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (405, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (5, 5, 405); 

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%Y-%m-%d %T', 'ISO-8601 Compliant (CCYY-MM-DD hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%Y-%m-%dT%T', 'ISO-8601 Strict (CCYY-MM-DDThh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%m/%d/%Y %T', 'U.S. (MM/DD/CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%m/%d/%Y', 'U.S. Date Only (MM/DD/CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%m/%d/%y %T', 'U.S. Short (MM/DD/YY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%m/%d/%y', 'U.S. Short Date Only (MM/DD/YY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%B %d, %Y %T', 'U.S. Long (Month DD, CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%b %d, %Y %T', 'U.S. Long Abbrev. (Mon DD, CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%B %d, %Y', 'U.S. Long Date Only (Month DD, CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%b %d, %Y', 'U.S. Long Abbrev. Date Only (Mon DD, CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d/%m/%Y %T', 'European (DD/MM/CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d/%m/%Y', 'European Date Only (DD/MM/CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d/%m/%y %T', 'European Short (DD/MM/YY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d/%m/%y', 'European Short Date Only (DD/MM/YY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d %B %Y %T', 'European Long (DD Month CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d %b %Y %T', 'European Long Abbrev. (DD Mon CCYY hh:mm:ss)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d %B, %Y', 'European Long Date Only (DD Month CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, '%d %b, %Y', 'European Long Abbrev. Date Only (DD Mon CCYY)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (5, 'epoch', 'Epoch Time (Seconds since 1970-01-01 00:00:00)');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (6, 'Permissions Widget', 'Permissions Widget', 'radio', 'radio', 0, 'radio');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (156, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (6, 6, 156); 

INSERT INTO pref_opt (pref__id, value, description)
VALUES (6, 'radio', 'Radio Buttons');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (6, 'select', 'Select List');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES ('10', 'Search Results / Page',
        'Controls the number of records displayed per page from searches',
        0, 0, 0, 'select');

INSERT INTO member (id, grp__id, class__id, active) VALUES (167, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id) VALUES (10, 10, 167);

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '0', 'Off');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '10', '10');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '20', '20');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '30', '30');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '40', '40');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (10, '50', '50');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES ('11', 'Bricolage Instance Name',
        'Label used in window titles and the Welcome to Bricolage message on the login page.',
        'Bricolage', 'Bricolage', 1, 'text');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (168, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (11, 11, 168); 

INSERT INTO pref_opt (pref__id, value, description)
VALUES (11, 'Bricolage', 'Bricolage');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (12, 'Default Search',
        'Whether Find Media and Find Stories use Simple or Advanced Search by default.',
        '0', '0', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (169, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (12, 12, 169);

INSERT INTO pref_opt (pref__id, value, description)
VALUES (12, '0', 'Simple');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (12, '1', 'Advanced');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (13, 'Default Asset Sort',
        'The default Story/Media field to sort on.',
        'cover_date', 'cover_date', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (170, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (13, 13, 170);

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'cover_date', 'Cover Date');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'priority', 'Priority');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'name', 'Title');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'category_name', 'Category');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'site_id', 'Site');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'element', 'Media Type');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (13, 'id', 'ID');



INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (14, 'Character Set',
        'The default character set to use for display.',
        'UTF-8', 'UTF-8', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (900, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (14, 14, 900);


INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'UTF-8', 'UTF-8');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-1', 'ISO-8859-1');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-2', 'ISO-8859-2');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-3', 'ISO-8859-3');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-4', 'ISO-8859-4');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-5', 'ISO-8859-5');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-6', 'ISO-8859-6');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-7', 'ISO-8859-7');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-8', 'ISO-8859-8');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-9', 'ISO-8859-9');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-10', 'ISO-8859-10');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-11', 'ISO-8859-11');


INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-13', 'ISO-8859-13');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-14', 'ISO-8859-14');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-15', 'ISO-8859-15');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-8859-16', 'ISO-8859-16');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'viscii', 'Viscii (Vietnamese)');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'gb-2312', 'GB-2312');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'Big5', 'Big5');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'euc-jp', 'EUC-JP');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'shiftjis', 'ShiftJIS');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-2022-jp', 'ISO-2022-JP');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'euc-kr', 'EUC-KR');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'iso-2022-kr', 'ISO-2022-KR');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'koi8-r', 'KOI8-R');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (14, 'koi8-u', 'KOI8-U');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (15, 'Language',
        'The default language to use for display.',
        'en_us', 'en_us', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (901, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (15, 15, 901);


INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'en_us', 'en_us');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'de_de', 'de_de');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'it_it', 'it_it');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'pt_pt', 'pt_pt');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'zh_tw', 'zh_tw');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'zh_cn', 'zh_cn');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'zh_hk', 'zh_hk');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'bo', 'bo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'km', 'km');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'ko_ko', 'ko_ko');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'lo', 'lo');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'my', 'my');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'ug', 'ug');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'vi_vn', 'vi_vn');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (15, 'ru_ru', 'ru_ru');


INSERT INTO pref (id, name, description, value, def, manual, opt_type)
VALUES (16, 'Filter by Site Context',
        'Filter search results by the site context.',
        '0', '0', 0, 'select');

INSERT INTO member (id, grp__id, class__id, active)
VALUES (902, 22, 48, 1);

INSERT INTO pref_member (id, object_id, member__id)
VALUES (16, 16, 902);

INSERT INTO pref_opt (pref__id, value, description)
VALUES (16, '0', 'Off');

INSERT INTO pref_opt (pref__id, value, description)
VALUES (16, '1', 'On');


/*

INSERT INTO grp_priv (id, grp__id, value)
VALUES(1, 15, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(1, 1);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(2, 11, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(2, 2);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(3, 18, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(3, 3);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(4, 18, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(4, 5);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(5, 36, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(5, 4);

*/

INSERT INTO grp_priv (id, grp__id, value)
VALUES(6, 7, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(6, 31);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(43, 7, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(43, 26);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(44, 7, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(44, 27);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(54, 7, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(54, 47);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(31, 7, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(31, 49);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(32, 7, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(32, 61);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(33, 7, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(33, 62);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(34, 7, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(34, 63);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(35, 7, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(35, 64);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(7, 8, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(7, 32);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(45, 8, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(45, 26);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(46, 8, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(46, 27);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(55, 8, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(55, 47);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(36, 8, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(36, 51);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(37, 8, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(37, 65);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(38, 8, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(38, 63);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(39, 8, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(39, 64);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(8, 9, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(8, 33);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(47, 9, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(47, 26);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(48, 9, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(48, 27);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(56, 9, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(56, 47);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(40, 9, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(40, 52);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(41, 9, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(41, 66);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(42, 9, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(42, 67);

/*

INSERT INTO grp_priv (id, grp__id, value)
VALUES(9, 10, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(9, 27);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(10, 12, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(10, 22);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(11, 13, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(11, 35);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(12, 14, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(12, 23);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(13, 16, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(13, 25);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(14, 17, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(14, 26);

*/

INSERT INTO grp_priv (id, grp__id, value)
VALUES(15, 19, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(15, 29);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(16, 19, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(16, 30);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(17, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(17, 23);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(18, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(18, 1);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(19, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(19, 24);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(20, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(20, 25);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(21, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(21, 26);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(22, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(22, 27);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(23, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(23, 28);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(24, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(24, 4);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(25, 20, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(25, 5);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(26, 21, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(26, 22);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(27, 21, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(27, 2);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(28, 21, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(28, 35);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(49, 21, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(49, 47);

/*

INSERT INTO grp_priv (id, grp__id, value)
VALUES(29, 37, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(29, 24);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(30, 38, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(30, 28);

*/

INSERT INTO grp_priv (id, grp__id, value)
VALUES(50, 200, 1);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(50, 100);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(51, 201, 2);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(51, 100);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(52, 202, 4);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(52, 100);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(53, 203, 255);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(53, 100);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(57, 204, 3);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(57, 100);

INSERT INTO grp_priv (id, grp__id, value)
VALUES(58, 205, 5);

INSERT INTO grp_priv__grp_member (grp_priv__id, grp__id)
VALUES(58, 100);



ALTER TABLE at_type ADD 
	CONSTRAINT fk_class__at_type FOREIGN KEY (biz_class__id)
	REFERENCES class(id) ON DELETE CASCADE;


ALTER TABLE    element_type_member
ADD CONSTRAINT fk_comp_type__comp_type_member FOREIGN KEY (object_id)
REFERENCES     at_type(id) ON DELETE CASCADE;

ALTER TABLE    element_type_member
ADD CONSTRAINT fk_member__comp_type_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;




ALTER TABLE media
ADD CONSTRAINT fk_source__media FOREIGN KEY (source__id)
	REFERENCES source(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_usr__media FOREIGN KEY (usr__id)
	REFERENCES usr(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_element__media FOREIGN KEY (element__id)
	REFERENCES element(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_workflow__media FOREIGN KEY (workflow__id)
	REFERENCES workflow(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_site__media FOREIGN KEY (site__id)
	REFERENCES site(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_media__media_id FOREIGN KEY (alias_id)
	REFERENCES media(id) ON DELETE RESTRICT;

ALTER TABLE media
ADD CONSTRAINT fk_desk__media FOREIGN KEY (desk__id)
	REFERENCES desk(id) ON DELETE RESTRICT;


ALTER TABLE media_instance
ADD CONSTRAINT fk_media__media_instance FOREIGN KEY (media__id)
	REFERENCES media(id) ON DELETE CASCADE;

ALTER TABLE media_instance
ADD CONSTRAINT fk_category__media_instance FOREIGN KEY (category__id)
	REFERENCES category(id) ON DELETE CASCADE;

ALTER TABLE media_instance
ADD CONSTRAINT fk_media_type__media_instance FOREIGN KEY (media_type__id)
	REFERENCES media_type(id) ON DELETE CASCADE;

ALTER TABLE media_instance
ADD CONSTRAINT fk_usr__media_instance FOREIGN KEY (usr__id)
	REFERENCES usr(id) ON DELETE CASCADE;

ALTER TABLE media_instance
ADD CONSTRAINT fk_primary_oc__media_instance FOREIGN KEY (primary_oc__id)
	REFERENCES output_channel(id) ON DELETE CASCADE;

ALTER TABLE media_uri
ADD CONSTRAINT fk_media__media_uri FOREIGN KEY (media__id)
    REFERENCES media(id) ON DELETE CASCADE;

ALTER TABLE media_uri
ADD CONSTRAINT fk_media__site__id FOREIGN KEY (site__id)
REFERENCES site(id) ON DELETE CASCADE;

ALTER TABLE media__output_channel 
ADD CONSTRAINT fk_media__oc__media FOREIGN KEY (media_instance__id)
	REFERENCES media_instance(id) ON DELETE CASCADE;

ALTER TABLE media__output_channel 
ADD CONSTRAINT fk_media__oc__oc FOREIGN KEY (output_channel__id)
	REFERENCES output_channel(id) ON DELETE CASCADE;


ALTER TABLE    media_member
ADD CONSTRAINT fk_media__media_member FOREIGN KEY (object_id)
REFERENCES     media(id) ON DELETE CASCADE;

ALTER TABLE    media_member
ADD CONSTRAINT fk_member__media_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;




ALTER TABLE attr_media_val ADD 
    CONSTRAINT fk_attr_media__attr_media_val FOREIGN KEY (attr__id)
    REFERENCES attr_media(id) ON DELETE CASCADE;

ALTER TABLE attr_media_val ADD
    CONSTRAINT fk_media__attr_media_val FOREIGN KEY (object__id)
    REFERENCES media(id) ON DELETE CASCADE;


ALTER TABLE attr_media_meta ADD 
    CONSTRAINT fk_attr_media__attr_media_meta FOREIGN KEY (attr__id)
    REFERENCES attr_media(id) ON DELETE CASCADE;






ALTER TABLE story_container_tile
ADD CONSTRAINT fk_sc_tile__sc_tile FOREIGN KEY (parent_id)
    REFERENCES story_container_tile(id) ON DELETE CASCADE;

ALTER TABLE story_container_tile
ADD CONSTRAINT fk_story__sc_tile FOREIGN KEY (object_instance_id)	
    REFERENCES story_instance(id) ON DELETE CASCADE;

ALTER TABLE story_container_tile
ADD CONSTRAINT fk_sc_tile__related_story FOREIGN KEY (related_instance__id)	
    REFERENCES story(id) ON DELETE CASCADE;

ALTER TABLE story_container_tile
ADD CONSTRAINT fk_sc_tile__related_media FOREIGN KEY (related_media__id)
    REFERENCES media(id) ON DELETE CASCADE;


ALTER TABLE media_container_tile
ADD CONSTRAINT fk_mc_tile__mc_tile FOREIGN KEY (parent_id)
    REFERENCES media_container_tile(id) ON DELETE CASCADE;

ALTER TABLE media_container_tile
ADD CONSTRAINT fk_media__mc_tile FOREIGN KEY (object_instance_id)
    REFERENCES media_instance(id) ON DELETE CASCADE;

/*
ALTER TABLE media_container_tile
ADD CONSTRAINT fk_mc_tile__related_story FOREIGN KEY (related_instance__id)
    REFERENCES story(id) ON DELETE CASCADE;

ALTER TABLE media_container_tile
ADD CONSTRAINT fk_mc_tile__related_media FOREIGN KEY (related_media__id)
    REFERENCES media(id) ON DELETE CASCADE;

*/



ALTER TABLE story_data_tile
ADD CONSTRAINT fk_story_instance__sd_tile FOREIGN KEY (object_instance_id)
	REFERENCES story_instance(id) ON DELETE CASCADE;

ALTER TABLE story_data_tile
ADD CONSTRAINT fk_sc_tile__sd_tile FOREIGN KEY (parent_id)
	REFERENCES story_container_tile(id) ON DELETE CASCADE;

ALTER TABLE story_data_tile
ADD CONSTRAINT fk_at_data__sd_tile FOREIGN KEY (element_data__id)
	REFERENCES at_data(id) ON DELETE CASCADE;


ALTER TABLE media_data_tile
ADD CONSTRAINT fk_media_instance__md_tile FOREIGN KEY (object_instance_id)
	REFERENCES media_instance(id) ON DELETE CASCADE;

ALTER TABLE media_data_tile
ADD CONSTRAINT fk_mc_tile__md_tile FOREIGN KEY (parent_id)
	REFERENCES media_container_tile(id) ON DELETE CASCADE;

ALTER TABLE media_data_tile
ADD CONSTRAINT fk_at_data__md_tile FOREIGN KEY (element_data__id)
	REFERENCES at_data(id) ON DELETE CASCADE;




ALTER TABLE story
ADD CONSTRAINT fk_source__story FOREIGN KEY (source__id)
	REFERENCES source(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_usr__story FOREIGN KEY (usr__id)
	REFERENCES usr(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_element__story FOREIGN KEY (element__id)
	REFERENCES element(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_workflow__story FOREIGN KEY (workflow__id)
	REFERENCES workflow(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_site__story FOREIGN KEY (site__id)
	REFERENCES site(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_story__story_id FOREIGN KEY (alias_id)
	REFERENCES story(id) ON DELETE RESTRICT;

ALTER TABLE story
ADD CONSTRAINT fk_desk__story FOREIGN KEY (desk__id)
	REFERENCES desk(id) ON DELETE RESTRICT;

ALTER TABLE story_instance
ADD CONSTRAINT fk_story__story_instance FOREIGN KEY (story__id)
	REFERENCES story(id) ON DELETE CASCADE;

ALTER TABLE story_instance
ADD CONSTRAINT fk_usr__story_instance FOREIGN KEY (usr__id)
	REFERENCES usr(id) ON DELETE SET NULL;

ALTER TABLE story_instance
ADD CONSTRAINT fk_primary_oc__story_instance FOREIGN KEY (primary_oc__id)
	REFERENCES output_channel(id) ON DELETE SET NULL;

ALTER TABLE story_uri
ADD CONSTRAINT fk_story__story_uri FOREIGN KEY (story__id)
    REFERENCES story(id) ON DELETE CASCADE;

ALTER TABLE story_uri
ADD CONSTRAINT fk_story__site__id FOREIGN KEY (site__id)
REFERENCES site(id) ON DELETE CASCADE;

ALTER TABLE story__output_channel 
ADD CONSTRAINT fk_story__oc__story FOREIGN KEY (story_instance__id)
	REFERENCES story_instance(id) ON DELETE CASCADE;

ALTER TABLE story__output_channel 
ADD CONSTRAINT fk_story__oc__oc FOREIGN KEY (output_channel__id)
	REFERENCES output_channel(id) ON DELETE CASCADE;

ALTER TABLE story__category 
ADD CONSTRAINT fk_story__story__category FOREIGN KEY (story_instance__id)
	REFERENCES story_instance(id) ON DELETE CASCADE;

ALTER TABLE story__category 
ADD CONSTRAINT fk_category__story__category FOREIGN KEY (category__id)
	REFERENCES category(id) ON DELETE CASCADE;


ALTER TABLE story__contributor
ADD CONSTRAINT fk_story__story__contributor FOREIGN KEY (story_instance__id)
	REFERENCES story_instance(id) ON DELETE CASCADE;

ALTER TABLE story__contributor
ADD CONSTRAINT fk_member__story__contributor FOREIGN KEY (member__id)
	REFERENCES member(id) ON DELETE CASCADE;






ALTER TABLE attr_story_val ADD 
    CONSTRAINT fk_attr_story__attr_story_val FOREIGN KEY (attr__id)
    REFERENCES attr_story(id) ON DELETE CASCADE;

ALTER TABLE attr_story_val ADD
    CONSTRAINT fk_story__attr_story_val FOREIGN KEY (object__id)
    REFERENCES story(id) ON DELETE CASCADE;


ALTER TABLE attr_story_meta ADD 
    CONSTRAINT fk_attr_story__attr_story_meta FOREIGN KEY (attr__id)
    REFERENCES attr_story(id) ON DELETE CASCADE;






ALTER TABLE formatting
    ADD CONSTRAINT fk_usr__formatting FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE RESTRICT;

ALTER TABLE formatting
    ADD CONSTRAINT fk_output_channel__formatting FOREIGN KEY (output_channel__id)
    REFERENCES output_channel(id) ON DELETE RESTRICT;

ALTER TABLE formatting
    ADD CONSTRAINT fk_element__formatting FOREIGN KEY (element__id)
    REFERENCES element(id) ON DELETE RESTRICT;

ALTER TABLE formatting
    ADD CONSTRAINT fk_category__formatting FOREIGN KEY (category__id)
    REFERENCES category(id) ON DELETE RESTRICT;

ALTER TABLE formatting
	ADD CONSTRAINT fk_workflow__formatting FOREIGN KEY (workflow__id)
	REFERENCES workflow(id) ON DELETE RESTRICT;

ALTER TABLE formatting
    ADD CONSTRAINT fk_site__formatting FOREIGN KEY (site__id)
    REFERENCES site(id) ON DELETE RESTRICT;

ALTER TABLE formatting
	ADD CONSTRAINT fk_desk__formatting FOREIGN KEY (desk__id)
	REFERENCES desk(id) ON DELETE RESTRICT;


ALTER TABLE formatting_instance
    ADD CONSTRAINT fk_formatting__frmt_instance FOREIGN KEY (formatting__id)
    REFERENCES formatting(id) ON DELETE CASCADE;

ALTER TABLE formatting_instance
    ADD CONSTRAINT fk_usr__format_instance FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE SET NULL;


ALTER TABLE    formatting_member
ADD CONSTRAINT fk_frmt__frmt_member FOREIGN KEY (object_id)
REFERENCES     formatting(id) ON DELETE CASCADE;

ALTER TABLE    formatting_member
ADD CONSTRAINT fk_member__frmt_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;




ALTER TABLE attr_formatting_val ADD 
    CONSTRAINT fk_attr_frmt__attr_frmt_val FOREIGN KEY (attr__id)
    REFERENCES attr_formatting(id) ON DELETE CASCADE;

ALTER TABLE attr_formatting_val ADD
    CONSTRAINT fk_frmt__attr_frmt_val FOREIGN KEY (object__id)
    REFERENCES formatting(id) ON DELETE CASCADE;


ALTER TABLE attr_formatting_meta ADD 
    CONSTRAINT fk_attr_frmt__attr_frmt_meta FOREIGN KEY (attr__id)
    REFERENCES attr_formatting(id) ON DELETE CASCADE;






ALTER TABLE element ADD 
	CONSTRAINT fk_at_type__element FOREIGN KEY (type__id)
	REFERENCES at_type(id) ON DELETE CASCADE;

ALTER TABLE element ADD 
	CONSTRAINT fk_grp__element FOREIGN KEY (at_grp__id)
	REFERENCES grp(id) ON DELETE CASCADE;


ALTER TABLE element__output_channel ADD
	CONSTRAINT fk_element__at_oc FOREIGN KEY (element__id)
	REFERENCES element(id) ON DELETE CASCADE;

ALTER TABLE element__output_channel ADD
	CONSTRAINT fk_output_channel__at_oc FOREIGN KEY (output_channel__id)
	REFERENCES output_channel(id) ON DELETE CASCADE;


/*

ALTER TABLE element__language ADD
	CONSTRAINT fk_at__at__lang FOREIGN KEY (element__id)
	REFERENCES element(id) ON DELETE CASCADE;
	
ALTER TABLE element__language ADD
	CONSTRAINT fk_lang__at__lang FOREIGN KEY (language__id)
	REFERENCES language(id) ON DELETE CASCADE;

*/


ALTER TABLE element_member ADD
	CONSTRAINT fk_element__at_member FOREIGN KEY (object_id)
	REFERENCES element(id) ON DELETE CASCADE;

ALTER TABLE category_member ADD
	CONSTRAINT fk_member__at_member FOREIGN KEY (member__id)
	REFERENCES member(id) ON DELETE CASCADE;




ALTER TABLE attr_element_val ADD 
    CONSTRAINT fk_attr_at__attr_at_val FOREIGN KEY (attr__id)
    REFERENCES attr_element(id) ON DELETE CASCADE;

ALTER TABLE attr_element_val ADD
    CONSTRAINT fk_at__attr_at_val FOREIGN KEY (object__id)
    REFERENCES element(id) ON DELETE CASCADE;


ALTER TABLE attr_element_meta ADD 
    CONSTRAINT fk_attr_at__attr_at_meta FOREIGN KEY (attr__id)
    REFERENCES attr_element(id) ON DELETE CASCADE;



ALTER TABLE element__site ADD 
    CONSTRAINT fk_site__element__site__site__id FOREIGN KEY (site__id)
    REFERENCES site(id) ON DELETE CASCADE;

ALTER TABLE element__site ADD 
    CONSTRAINT fk_element__element__site__element__id  FOREIGN KEY (element__id)
    REFERENCES element(id) ON DELETE CASCADE;

ALTER TABLE element__site ADD 
	CONSTRAINT fk_output_channel__element__site FOREIGN KEY (primary_oc__id)
	REFERENCES output_channel(id) ON DELETE CASCADE;



ALTER TABLE at_data ADD 
	CONSTRAINT fk_element__at_data FOREIGN KEY (element__id)
	REFERENCES element(id) ON DELETE CASCADE;





ALTER TABLE attr_at_data_val ADD 
    CONSTRAINT fk_attr_atd__attr_atd_val FOREIGN KEY (attr__id)
    REFERENCES attr_at_data(id) ON DELETE CASCADE;

ALTER TABLE attr_at_data_val ADD
    CONSTRAINT fk_atd__attr_atd_val FOREIGN KEY (object__id)
    REFERENCES at_data(id) ON DELETE CASCADE;


ALTER TABLE attr_at_data_meta ADD 
    CONSTRAINT fk_attr_atd__attr_atd_meta FOREIGN KEY (attr__id)
    REFERENCES attr_at_data(id) ON DELETE CASCADE;





ALTER TABLE category ADD
	CONSTRAINT fk_asset_grp__category FOREIGN KEY (asset_grp_id)
	REFERENCES grp(id) ON DELETE CASCADE;

ALTER TABLE category ADD
	CONSTRAINT fk_category__site FOREIGN KEY (site__id)
	REFERENCES site(id) ON DELETE CASCADE;


ALTER TABLE    category_member
ADD CONSTRAINT fk_category__category_member FOREIGN KEY (object_id)
REFERENCES     category(id) ON DELETE CASCADE;

ALTER TABLE    category_member
ADD CONSTRAINT fk_member__category_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE attr_category_val ADD 
    CONSTRAINT fk_attr_cat__attr_cat_val FOREIGN KEY (attr__id)
    REFERENCES attr_category(id) ON DELETE CASCADE;

ALTER TABLE attr_category_val ADD
    CONSTRAINT fk_cat__attr_cat_val FOREIGN KEY (object__id)
    REFERENCES category(id) ON DELETE CASCADE;


ALTER TABLE attr_category_meta ADD 
    CONSTRAINT fk_attr_cat__attr_cat_meta FOREIGN KEY (attr__id)
    REFERENCES attr_category(id) ON DELETE CASCADE;



ALTER TABLE    contact_value
ADD CONSTRAINT fk_contact__contact_value FOREIGN KEY (contact__id)
REFERENCES     contact(id) ON DELETE CASCADE;

ALTER TABLE    person__contact_value
ADD CONSTRAINT fk_person__p_c_val FOREIGN KEY (person__id)
REFERENCES     person(id) ON DELETE CASCADE;


ALTER TABLE    person__contact_value
ADD CONSTRAINT fk_contact_value__p_c_val FOREIGN KEY (contact_value__id)
REFERENCES     contact_value(id) ON DELETE CASCADE;



ALTER TABLE    keyword_member
ADD CONSTRAINT fk_keyword__keyword_member FOREIGN KEY (object_id)
REFERENCES     keyword(id) ON DELETE CASCADE;

ALTER TABLE    keyword_member
ADD CONSTRAINT fk_member__keyword_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;



ALTER TABLE    addr
ADD CONSTRAINT fk_org__addr FOREIGN KEY (org__id)
REFERENCES     org(id) ON DELETE CASCADE;

ALTER TABLE    addr_part
ADD CONSTRAINT fk_addr__addr_part FOREIGN KEY (addr__id)
REFERENCES     addr(id) ON DELETE CASCADE;

ALTER TABLE    addr_part
ADD CONSTRAINT fk_addr_part_type__addr_part FOREIGN KEY (addr_part_type__id)
REFERENCES     addr_part_type(id) ON DELETE CASCADE;

ALTER TABLE    person_org__addr
ADD CONSTRAINT fk_addr__person_org_addr FOREIGN KEY (addr__id)
REFERENCES     addr(id) ON DELETE CASCADE;

ALTER TABLE    person_org__addr
ADD CONSTRAINT fk_person_org__pers_org_addr FOREIGN KEY (person_org__id)
REFERENCES     person_org(id) ON DELETE CASCADE;




ALTER TABLE    person_org
ADD CONSTRAINT fk_org__person_org FOREIGN KEY (org__id)
REFERENCES     org(id) ON DELETE CASCADE;

ALTER TABLE    person_org
ADD CONSTRAINT fk_person__person_org FOREIGN KEY (person__id)
REFERENCES     person(id) ON DELETE CASCADE;




ALTER TABLE    source
ADD CONSTRAINT fk_org__source FOREIGN KEY (org__id)
REFERENCES     org(id) ON DELETE CASCADE;





ALTER TABLE    output_channel
ADD CONSTRAINT fk_site__output_channel FOREIGN KEY (site__id)
REFERENCES     site(id) ON DELETE CASCADE;

ALTER TABLE    output_channel_include
ADD CONSTRAINT fk_output_channel__oc_include FOREIGN KEY (output_channel__id)
REFERENCES     output_channel(id) ON DELETE CASCADE;

ALTER TABLE    output_channel_include
ADD CONSTRAINT fk_oc__oc_include_inc FOREIGN KEY (include_oc_id)
REFERENCES     output_channel(id) ON DELETE CASCADE;

ALTER TABLE    output_channel_member
ADD CONSTRAINT fk_output_channel__oc_member FOREIGN KEY (object_id)
REFERENCES     output_channel(id) ON DELETE CASCADE;

ALTER TABLE    output_channel_member
ADD CONSTRAINT fk_member__oc_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE    person_member
ADD CONSTRAINT fk_person__person_member FOREIGN KEY (object_id)
REFERENCES     person(id) ON DELETE CASCADE;

ALTER TABLE    person_member
ADD CONSTRAINT fk_member__person_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;



ALTER TABLE    usr
ADD CONSTRAINT fk_person__usr FOREIGN KEY (id)
REFERENCES     person(id) ON DELETE CASCADE;



/* The site's ID is a FK ref to the grp ID because Bric::Biz::Site uses
 * a Bric::Util::Grp::Asset ID as its own.
*/

ALTER TABLE    site
ADD CONSTRAINT fk_grp__site FOREIGN KEY (id)
REFERENCES     grp(id) ON DELETE CASCADE;

ALTER TABLE    site_member
ADD CONSTRAINT fk_site__site_member FOREIGN KEY (object_id)
REFERENCES     site(id) ON DELETE CASCADE;

ALTER TABLE    site_member
ADD CONSTRAINT fk_member__site_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;



ALTER TABLE    workflow
ADD CONSTRAINT fk_site__workflow__site__id FOREIGN KEY (site__id)
REFERENCES     site(id) ON DELETE CASCADE;



ALTER TABLE    workflow
ADD CONSTRAINT fk_grp__workflow__all_desk_grp_id FOREIGN KEY (all_desk_grp_id)
REFERENCES     grp(id) ON DELETE CASCADE;

ALTER TABLE    workflow
ADD CONSTRAINT fk_grp__workflow__req_desk_grp_id FOREIGN KEY (req_desk_grp_id)
REFERENCES     grp(id) ON DELETE CASCADE;

ALTER TABLE    workflow
ADD CONSTRAINT fk_grp__workflow__asset_grp_id FOREIGN KEY (asset_grp_id)
REFERENCES     grp(id) ON DELETE CASCADE;


ALTER TABLE    workflow_member
ADD CONSTRAINT fk_workflow__workflow_member FOREIGN KEY (object_id)
REFERENCES     workflow(id) ON DELETE CASCADE;

ALTER TABLE    workflow_member
ADD CONSTRAINT fk_member__workflow_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE desk ADD
	CONSTRAINT fk_pre_grp__desk FOREIGN KEY (pre_chk_rules)
	REFERENCES grp(id) ON DELETE CASCADE;
     
ALTER TABLE desk ADD
	CONSTRAINT fk_post_grp__desk FOREIGN KEY (post_chk_rules)
     	REFERENCES grp(id) ON DELETE CASCADE;  
     
ALTER TABLE desk ADD
	CONSTRAINT fk_asset_grp__desk FOREIGN KEY (asset_grp)
     	REFERENCES grp(id) ON DELETE CASCADE;


ALTER TABLE    desk_member
ADD CONSTRAINT fk_desk__desk_member FOREIGN KEY (object_id)
REFERENCES     desk(id) ON DELETE CASCADE;

ALTER TABLE    desk_member
ADD CONSTRAINT fk_member__desk_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;


ALTER TABLE attr_action_val ADD 
    CONSTRAINT fk_attr_action__attr_action_val FOREIGN KEY (attr__id)
    REFERENCES attr_action(id) ON DELETE CASCADE;

ALTER TABLE attr_action_val ADD
    CONSTRAINT fk_action__attr_action_val FOREIGN KEY (object__id)
    REFERENCES action(id) ON DELETE CASCADE;


ALTER TABLE attr_action_meta ADD 
    CONSTRAINT fk_attr_action__attr_action_meta FOREIGN KEY (attr__id)
    REFERENCES attr_action(id) ON DELETE CASCADE;



ALTER TABLE action ADD CONSTRAINT fk_action_type__action 
    FOREIGN KEY (action_type__id)
    REFERENCES action_type(id) ON DELETE CASCADE;

ALTER TABLE action ADD CONSTRAINT fk_server_type__action 
    FOREIGN KEY (server_type__id)
    REFERENCES server_type(id) ON DELETE CASCADE;




ALTER TABLE action_type__media_type ADD CONSTRAINT fk_action_type__at_mt
    FOREIGN KEY (action_type__id)
    REFERENCES action_type(id) ON DELETE CASCADE;

ALTER TABLE action_type__media_type ADD CONSTRAINT fk_media_type__at_mt
    FOREIGN KEY (media_type__id)
    REFERENCES media_type(id) ON DELETE CASCADE;





ALTER TABLE resource ADD CONSTRAINT fk_media_type__resource 
    FOREIGN KEY (media_type__id)
    REFERENCES media_type(id) ON DELETE CASCADE;

ALTER TABLE resource ADD CONSTRAINT fk_resource__resource
    FOREIGN KEY (parent_id)
    REFERENCES resource(id) ON DELETE CASCADE;



ALTER TABLE media__resource ADD CONSTRAINT fk_resource__media__resource 
    FOREIGN KEY (resource__id)
    REFERENCES resource(id) ON DELETE CASCADE;

ALTER TABLE media__resource ADD CONSTRAINT fk_media__media__resource 
    FOREIGN KEY (media__id)
    REFERENCES media(id) ON DELETE CASCADE;



ALTER TABLE story__resource ADD CONSTRAINT fk_resource__story__resource 
    FOREIGN KEY (resource__id)
    REFERENCES resource(id) ON DELETE CASCADE;

ALTER TABLE story__resource ADD CONSTRAINT fk_story__story__resource 
    FOREIGN KEY (story__id)
    REFERENCES story(id) ON DELETE CASCADE;





ALTER TABLE server ADD CONSTRAINT fk_server_type__server 
    FOREIGN KEY (server_type__id)
    REFERENCES server_type(id) ON DELETE CASCADE;




ALTER TABLE server_type ADD CONSTRAINT fk_class__server_type
    FOREIGN KEY (class__id)
    REFERENCES class(id) ON DELETE CASCADE;

ALTER TABLE server_type ADD CONSTRAINT fk_site__server_type
    FOREIGN KEY (site__id)
    REFERENCES site(id) ON DELETE CASCADE;


ALTER TABLE server_type__output_channel ADD CONSTRAINT fk_server_type__st_oc
    FOREIGN KEY (server_type__id)
    REFERENCES server_type(id) ON DELETE CASCADE;

ALTER TABLE server_type__output_channel ADD CONSTRAINT fk_output_channel__st_oc
    FOREIGN KEY (output_channel__id)
    REFERENCES output_channel(id) ON DELETE CASCADE;


ALTER TABLE    dest_member
ADD CONSTRAINT fk_dest__dest_member FOREIGN KEY (object_id)
REFERENCES     server_type(id) ON DELETE CASCADE;

ALTER TABLE    dest_member
ADD CONSTRAINT fk_member__dest_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE alert ADD CONSTRAINT fk_alert_type__alert 
    FOREIGN KEY (alert_type__id)
    REFERENCES alert_type(id) ON DELETE CASCADE
;

ALTER TABLE alert ADD CONSTRAINT fk_event__alert 
    FOREIGN KEY (event__id)
    REFERENCES EVENT(ID) ON DELETE CASCADE
;







ALTER TABLE    alert_type
ADD CONSTRAINT fk_event_type__alert_type FOREIGN KEY (event_type__id)
REFERENCES     event_type(ID) ON DELETE CASCADE;

ALTER TABLE    alert_type
ADD CONSTRAINT fk_usr__alert_type FOREIGN KEY (usr__id)
REFERENCES     usr(id) ON DELETE CASCADE;



ALTER TABLE    alert_type__grp__contact
ADD CONSTRAINT fk_alert_type__grp__contact FOREIGN KEY (alert_type__id)
REFERENCES     alert_type(id) ON DELETE CASCADE;

ALTER TABLE    alert_type__grp__contact
ADD CONSTRAINT fk_contact__grp__contact FOREIGN KEY (contact__id)
REFERENCES     contact(id) ON DELETE CASCADE;

ALTER TABLE    alert_type__grp__contact
ADD CONSTRAINT fk_grp__grp__contact FOREIGN KEY (grp__id)
REFERENCES     grp(id) ON DELETE CASCADE;



ALTER TABLE    alert_type__usr__contact
ADD CONSTRAINT fk_alert_type__at_user__cont FOREIGN KEY (alert_type__id)
REFERENCES     alert_type(id) ON DELETE CASCADE;

ALTER TABLE    alert_type__usr__contact
ADD CONSTRAINT fk_contact__at_usr__contact FOREIGN KEY (contact__id)
REFERENCES     contact(id) ON DELETE CASCADE;

ALTER TABLE    alert_type__usr__contact
ADD CONSTRAINT fk_usr__at_usr__contact FOREIGN KEY (usr__id)
REFERENCES     usr(id) ON DELETE CASCADE;






ALTER TABLE    alert_type_rule
ADD CONSTRAINT fk_alert_type__at_rule FOREIGN KEY (alert_type__id)
REFERENCES     alert_type(id) ON DELETE CASCADE;





ALTER TABLE alerted ADD CONSTRAINT fk_alert__alerted 
    FOREIGN KEY (alert__id)
    REFERENCES alert(id) ON DELETE CASCADE
;

ALTER TABLE alerted ADD CONSTRAINT fk_usr__alerted 
    FOREIGN KEY (usr__id)
    REFERENCES USR(ID) ON DELETE CASCADE
;



ALTER TABLE alerted__contact_value ADD CONSTRAINT fk_alerted__alerted__contact 
    FOREIGN KEY (alerted__id)
    REFERENCES alerted(id) ON DELETE CASCADE
;

ALTER TABLE alerted__contact_value ADD CONSTRAINT fk_contact__alerted__cont 
    FOREIGN KEY (contact__id)
    REFERENCES contact(id) ON DELETE CASCADE
;




/* Commented out because attr_person won't be used in production (in this version).
   However, the examples still apply. --David, 23 Feb 2001




ALTER TABLE attr_person_val ADD 
    CONSTRAINT fk_attr_person__attr_person_val FOREIGN KEY (attr__id)
    REFERENCES attr_person(id) ON DELETE CASCADE;

ALTER TABLE attr_person_val ADD
    CONSTRAINT fk_person__attr_person_val FOREIGN KEY (object__id)
    REFERENCES person(id) ON DELETE CASCADE;


ALTER TABLE attr_person_meta ADD 
    CONSTRAINT fk_attr_person__attr_person_meta FOREIGN KEY (attr__id)
    REFERENCES attr_person(id) ON DELETE CASCADE;

*/



ALTER TABLE    event
ADD CONSTRAINT fk_event_type__event FOREIGN KEY (event_type__id)
REFERENCES     event_type(id) ON DELETE CASCADE;

ALTER TABLE    event
ADD CONSTRAINT fk_usr__event FOREIGN KEY (usr__id)
REFERENCES     usr(id) ON DELETE CASCADE;

ALTER TABLE    event_attr
ADD CONSTRAINT fk_event__event_attr FOREIGN KEY (event__id)
REFERENCES     event(id) ON DELETE CASCADE;

ALTER TABLE    event_attr
ADD CONSTRAINT fk_event_type_attr__event_attr FOREIGN KEY (event_type_attr__id)
REFERENCES     event_type_attr(id) ON DELETE CASCADE;




ALTER TABLE    event_type
ADD CONSTRAINT fk_class__event_type FOREIGN KEY (class__id)
REFERENCES     class(id) ON DELETE CASCADE;

ALTER TABLE    event_type_attr
ADD CONSTRAINT fk_event_type__event_type_attr FOREIGN KEY (event_type__id)
REFERENCES     event_type(id) ON DELETE CASCADE;

/*

ALTER TABLE    event_type
ADD CONSTRAINT fk_grp_event_type FOREIGN KEY (grp__id)
REFERENCES     grp(id) ON DELETE CASCADE;

ALTER TABLE    event_member
ADD CONSTRAINT fk_event__event_member FOREIGN KEY (object_id)
REFERENCES     event(id) ON DELETE CASCADE;

ALTER TABLE    event_member
ADD CONSTRAINT fk_member__event_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;

*/




ALTER TABLE grp
ADD CONSTRAINT fk_grp__grp FOREIGN KEY (parent_id)
REFERENCES grp(id) ON DELETE CASCADE;

ALTER TABLE grp
ADD CONSTRAINT fk_class__grp FOREIGN KEY (class__id)
REFERENCES class(id) ON DELETE CASCADE;





ALTER TABLE    alert_type_member
ADD CONSTRAINT fk_alert_type__alert_type_member FOREIGN KEY (object_id)
REFERENCES     alert_type(id) ON DELETE CASCADE;

ALTER TABLE    alert_type_member
ADD CONSTRAINT fk_member__alert_type_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE    contrib_type_member
ADD CONSTRAINT fk_contrib_type__ctype_member FOREIGN KEY (object_id)
REFERENCES     grp(id) ON DELETE CASCADE;

ALTER TABLE    contrib_type_member
ADD CONSTRAINT fk_member__ctype_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;







/* Handled by Bric/Util/EventType.con */



ALTER TABLE    org_member
ADD CONSTRAINT fk_org__org_member FOREIGN KEY (object_id)
REFERENCES     org(id) ON DELETE CASCADE;

ALTER TABLE    org_member
ADD CONSTRAINT fk_member__org_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;




ALTER TABLE grp_member
ADD CONSTRAINT fk_grp__grp_member FOREIGN KEY (object_id)
REFERENCES grp(id) ON DELETE CASCADE;

ALTER TABLE grp_member
ADD CONSTRAINT fk_member__grp_member FOREIGN KEY (member__id)
REFERENCES member(id) ON DELETE CASCADE;



ALTER TABLE member
ADD CONSTRAINT fk_grp__member FOREIGN KEY (grp__id)
REFERENCES grp(id) ON DELETE CASCADE;

ALTER TABLE member
ADD CONSTRAINT fk_class__member FOREIGN KEY (class__id)
REFERENCES class(id) ON DELETE CASCADE;


ALTER TABLE    story_member
ADD CONSTRAINT fk_story__story_member FOREIGN KEY (object_id)
REFERENCES     story(id) ON DELETE CASCADE;

ALTER TABLE    story_member
ADD CONSTRAINT fk_member__story_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;







ALTER TABLE attr_member_val ADD 
    CONSTRAINT fk_attr_member__attr_member_val FOREIGN KEY (attr__id)
    REFERENCES attr_member(id) ON DELETE CASCADE;

ALTER TABLE attr_member_val ADD
    CONSTRAINT fk_member__attr_member_val FOREIGN KEY (object__id)
    REFERENCES member(id) ON DELETE CASCADE;


ALTER TABLE attr_member_meta ADD 
    CONSTRAINT fk_attr_member__attr_member_meta FOREIGN KEY (attr__id)
    REFERENCES attr_member(id) ON DELETE CASCADE;




ALTER TABLE    source_member
ADD CONSTRAINT fk_source__source_member FOREIGN KEY (object_id)
REFERENCES     source(id) ON DELETE CASCADE;

ALTER TABLE    source_member
ADD CONSTRAINT fk_member__source_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;



ALTER TABLE    user_member
ADD CONSTRAINT fk_user__user_member FOREIGN KEY (object_id)
REFERENCES     usr(id) ON DELETE CASCADE;

ALTER TABLE    user_member
ADD CONSTRAINT fk_member__user_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;






ALTER TABLE attr_grp_val ADD 
    CONSTRAINT fk_attr_grp__attr_grp_val FOREIGN KEY (attr__id)
    REFERENCES attr_grp(id) ON DELETE CASCADE;

ALTER TABLE attr_grp_val ADD
    CONSTRAINT fk_grp__attr_grp_val FOREIGN KEY (object__id)
    REFERENCES grp(id) ON DELETE CASCADE;


ALTER TABLE attr_grp_meta ADD 
    CONSTRAINT fk_attr_grp__attr_grp_meta FOREIGN KEY (attr__id)
    REFERENCES attr_grp(id) ON DELETE CASCADE;




ALTER TABLE job ADD CONSTRAINT fk_job__usr
    FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE CASCADE
;

ALTER TABLE job ADD CONSTRAINT fk_job__class
    FOREIGN KEY (class__id)
    REFERENCES class(id) ON DELETE CASCADE
;

ALTER TABLE job ADD CONSTRAINT fk_job__story
    FOREIGN KEY (story__id)
    REFERENCES story(id) ON DELETE CASCADE
;

ALTER TABLE job ADD CONSTRAINT fk_job__media
    FOREIGN KEY (media__id)
    REFERENCES media(id) ON DELETE CASCADE
;


ALTER TABLE job__resource ADD CONSTRAINT fk_job__job__resource
    FOREIGN KEY (job__id)
    REFERENCES job(id) ON DELETE CASCADE
;

ALTER TABLE job__resource ADD CONSTRAINT fk_resource__job__resource
    FOREIGN KEY (resource__id)
    REFERENCES resource(id) ON DELETE CASCADE
;



ALTER TABLE job__server_type ADD CONSTRAINT fk_job__job__server_type
    FOREIGN KEY (job__id)
    REFERENCES job(id) ON DELETE CASCADE
;

ALTER TABLE job__server_type ADD CONSTRAINT fk_srvr_type__job__srvr_type
    FOREIGN KEY (server_type__id)
    REFERENCES server_type(id) ON DELETE CASCADE
;


ALTER TABLE    job_member
ADD CONSTRAINT fk_job__job_member FOREIGN KEY (object_id)
REFERENCES     job(id) ON DELETE CASCADE;

ALTER TABLE    job_member
ADD CONSTRAINT fk_member__job_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;





ALTER TABLE media_type_ext ADD CONSTRAINT fk_media_type__media_type_ext
    FOREIGN KEY (media_type__id)
    REFERENCES media_type(id) ON DELETE CASCADE;


ALTER TABLE    media_type_member
ADD CONSTRAINT fk_media_type__media_type_member FOREIGN KEY (object_id)
REFERENCES     media_type(id) ON DELETE CASCADE;

ALTER TABLE    media_type_member
ADD CONSTRAINT fk_member__media_type_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;



ALTER TABLE    usr_pref
ADD CONSTRAINT fk_pref__usr_pref FOREIGN KEY (pref__id)
REFERENCES     pref(id) ON DELETE CASCADE;

ALTER TABLE    usr_pref
ADD CONSTRAINT fk_usr__usr_pref FOREIGN KEY (usr__id)
REFERENCES     usr(id) ON DELETE CASCADE;


ALTER TABLE    pref_opt
ADD CONSTRAINT fk_pref__pref_opt FOREIGN KEY (pref__id)
REFERENCES     pref(id) ON DELETE CASCADE;


ALTER TABLE    pref_member
ADD CONSTRAINT fk_pref__pref_member FOREIGN KEY (object_id)
REFERENCES     pref(id) ON DELETE CASCADE;

ALTER TABLE    pref_member
ADD CONSTRAINT fk_member__pref_member FOREIGN KEY (member__id)
REFERENCES     member(id) ON DELETE CASCADE;




ALTER TABLE    grp_priv
ADD CONSTRAINT fk_grp__grp_priv FOREIGN KEY (grp__id)
REFERENCES     grp(id) ON DELETE CASCADE;



ALTER TABLE    grp_priv__grp_member
ADD CONSTRAINT fk_grp_priv__grp_priv__grp_mem FOREIGN KEY (grp_priv__id)
REFERENCES     grp_priv(id) ON DELETE CASCADE;

ALTER TABLE    grp_priv__grp_member
ADD CONSTRAINT fk_grp__grp_priv__grp_member FOREIGN KEY (grp__id)
REFERENCES     grp(id) ON DELETE CASCADE;

/*


ALTER TABLE grp_priv__grp ADD CONSTRAINT fk_grp_priv__grp_priv__grp
    FOREIGN KEY (grp_priv__id)
    REFERENCES grp_priv(id) ON DELETE CASCADE
;

ALTER TABLE grp_priv__grp ADD CONSTRAINT fk_grp__grp_priv__grp
    FOREIGN KEY (grp__id)
    REFERENCES grp(id) ON DELETE CASCADE
;



ALTER TABLE grp_priv__person ADD CONSTRAINT fk_grp_priv__grp_priv__person
    FOREIGN KEY (grp_priv__id)
    REFERENCES grp_priv(id) ON DELETE CASCADE
;

ALTER TABLE grp_priv__person ADD CONSTRAINT fk_person__grp_priv__person
    FOREIGN KEY (person__id)
    REFERENCES person(id) ON DELETE CASCADE
;



ALTER TABLE grp_priv__usr ADD CONSTRAINT fk_grp_priv__grp_priv__usr 
    FOREIGN KEY (grp_priv__id)
    REFERENCES grp_priv(id) ON DELETE CASCADE
;

ALTER TABLE grp_priv__usr ADD CONSTRAINT fk_usr__grp_priv__usr 
    FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE CASCADE
;



ALTER TABLE priv_table ADD CONSTRAINT fk_class__priv_table
    FOREIGN KEY (id)
    REFERENCES class(id) ON DELETE CASCADE
;



ALTER TABLE usr_priv ADD CONSTRAINT fk_usr__usr_priv 
    FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE CASCADE
;



ALTER TABLE usr_priv__grp ADD CONSTRAINT fk_usr_priv__usr_priv_grp
    FOREIGN KEY (priv_usr__id)
    REFERENCES usr_priv(id) ON DELETE CASCADE
;

ALTER TABLE usr_priv__grp ADD CONSTRAINT fk_grp__usr_priv__grp
    FOREIGN KEY (grp__id)
    REFERENCES grp(id) ON DELETE CASCADE
;



ALTER TABLE usr_priv__person ADD CONSTRAINT fk_usr_priv__u_p_person
    FOREIGN KEY (usr_priv__id)
    REFERENCES usr_priv(id) ON DELETE CASCADE
;

ALTER TABLE usr_priv__person ADD CONSTRAINT fk_person__u_p_person
    FOREIGN KEY (person__id)
    REFERENCES person(id) ON DELETE CASCADE
;



ALTER TABLE usr_priv__usr ADD CONSTRAINT fk_usr__usr_priv__usr 
    FOREIGN KEY (usr__id)
    REFERENCES usr(id) ON DELETE CASCADE
;

ALTER TABLE usr_priv__usr ADD CONSTRAINT fk_usr_priv__usr_priv__usr 
    FOREIGN KEY (usr_priv__id)
    REFERENCES usr_priv(id) ON DELETE CASCADE
;



ALTER TABLE usr_priv__grp_member ADD CONSTRAINT fk_usr_priv__u_p_grp_member
    FOREIGN KEY (usr_priv__id)
    REFERENCES usr_priv(id) ON DELETE CASCADE
;

ALTER TABLE usr_priv__grp_member ADD CONSTRAINT fk_grp__u_p_grp_member
    FOREIGN KEY (grp__id)
    REFERENCES grp(id) ON DELETE CASCADE
;

*/


