
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Global structures for the bandwidth limited waveform support.
 */

#ifndef _BRISTOL_BLO_H
#define _BRISTOL_BLO_H

#define BRISTOL_BLO_SIZE 1024

#define BRISTOL_BLO 0x01
#define BRISTOL_LWF 0x02

extern int bloflags;

extern float blosine[BRISTOL_BLO_SIZE];
extern float blosquare[BRISTOL_BLO_SIZE];
extern float bloramp[BRISTOL_BLO_SIZE];
extern float blosaw[BRISTOL_BLO_SIZE];
extern float blotriangle[BRISTOL_BLO_SIZE];

extern void generateBLOwaveforms(int, float);

#endif /* _BRISTOL_BLO_H */

