/***************************************************************************
*	Brutal Chess Pre-Alpha Build
*	- alphabetaplayer.cpp
*
*	Authors: Maxwell Lazaroff, Michael Cook, and Joe Flint
*	Date Created : November 5th, 2005
*	Last Modified: November 5th, 2005
*
*	- description - Implements the methods of the AlphaBetaPlayer.
***************************************************************************/

#include <time.h>

#include "alphabetaplayer.h"

bool
isIsolatedPawn(int file, int rank, const Board &board, bool is_white)
{
	int right = file+1;
	int left  = file-1;
	if(right > 7)
		right = left;
	if(left < 0)
		left = right;
	for(int i=0; i<8; i++)
	{
		if(is_white)
		{
			if((board._board[right][i].getColor() == WHITE
			    && board._board[right][i].getUnit() == PAWN) ||
			   (board._board[left][i].getColor() == WHITE
			    && board._board[left][i].getUnit() == PAWN))
				return false;
		}
		else
		{
			if((board._board[right][i].getColor() == BLACK
			    && board._board[right][i].getUnit() == PAWN) ||
			   (board._board[left][i].getColor() == BLACK
			    && board._board[left][i].getUnit() == PAWN))
				return false;
		}
	}
	return true;
}

bool
isDoubledPawn(int file, int rank, const Board & board, bool is_white)
{
	if(isIsolatedPawn(file, rank, board, is_white))
		return false;

	for(int i=0; i<7; i++)
	{
		if(is_white)
		{
			if(i != rank
			   && board._board[file][i].getColor() == WHITE
			   && board._board[file][i].getUnit() == PAWN )
			   return true;
		}
		else
		{
			if(i != rank
			   && board._board[file][i].getColor() == BLACK
			   && board._board[file][i].getUnit() == PAWN )
			   return true;
		}
	}
	return false;
}
int
pawnBonus(int file, int rank, const Board & board, bool is_white, bool endgame)
{

	//The following commented out part I wrote and makes no sense in review
	//to me. Therefore until I figure out its use, it is taken out.

	/*
	if(is_white)
	{
		if(file == 0)
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[1][i].getColor() == WHITE
				   && board._board[1][i].getUnit() == PAWN)
					return 0;
			}
		}
		else if(file == 7)
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[6][i].getColor() == WHITE
				   && board._board[6][i].getUnit() == PAWN)
					return 0;
			}
		}
		else
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[file+1][i].getColor() == WHITE
				   && board._board[file+1][i].getUnit() == PAWN)
					return 0;
				if(board._board[file-1][i].getColor() == WHITE
				   && board._board[file-1][i].getUnit() == PAWN)
					return 0;
			}
		}
	}
	else
	{
		if(file == 0)
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[1][i].getColor() == BLACK
				   && board._board[1][i].getUnit() == PAWN)
					return 0;
			}
		}
		else if(file == 7)
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[6][i].getColor() == BLACK
				   && board._board[6][i].getUnit() == PAWN)
					return 0;
			}
		}
		else
		{
			for(int i = rank; i>=0; i--)
			{
				if(board._board[file+1][i].getColor() == BLACK
				   && board._board[file+1][i].getUnit() == PAWN)
					return 0;
				if(board._board[file-1][i].getColor() == BLACK
				   && board._board[file-1][i].getUnit() == PAWN)
					return 0;
			}
		}
	}
	*/
	int scoreModifier = -6;

	if(board.inDanger(is_white, rank, file))
		scoreModifier -=5;

	int pawnCount = 0;
	for(int i=0; i<8; i++)
	{
		if(board._board[file][i].getUnit() == PAWN)
			pawnCount++;
	}
	if(pawnCount == 1)
		scoreModifier -= 4;

	//Now we check for isolated pawns
	int halfBoardFile = 0;; //Will be used later for isolation penalty
	if(file == 4)
		halfBoardFile = 3;
	else if(file == 5)
		halfBoardFile = 2;
	else if(file == 6)
		halfBoardFile = 1;
	else if(file == 7)
		halfBoardFile = 0;
	else
		halfBoardFile = file;

	bool isIsolated = true;
	int right = file+1;
	int left  = file-1;
	if(right > 7)
		right = left;
	if(left < 0)
		left = right;
	for(int i=0; i<8; i++)
	{
		if(is_white)
		{
			if((board._board[right][i].getColor() == WHITE
			    && board._board[right][i].getUnit() == PAWN) ||
			   (board._board[left][i].getColor() == WHITE
			    && board._board[left][i].getUnit() == PAWN))
			{
				isIsolated = false;
				break;
			}
		}
		else
		{
			if((board._board[right][i].getColor() == BLACK
			    && board._board[right][i].getUnit() == PAWN) ||
			   (board._board[left][i].getColor() == BLACK
			    && board._board[left][i].getUnit() == PAWN))
			{
				isIsolated = false;
				break;
			}
		}
	}

	if(isIsolated)
	{
		switch(halfBoardFile)
		{
		case 0:
			scoreModifier -= 12;
			break;
		case 1:
			scoreModifier -= 14;
			break;
		case 2:
			scoreModifier -= 16;
			break;
		case 3:
			scoreModifier -= 20;
			break;
		default:
			break;
		}
	}
	//Now we check for doubled pawns.
	bool isDoubled = false;

	if(!isIsolated)
	{
		for(int i=0; i<7; i++)
		{
			if(is_white)
			{
				if(i != rank
				   && board._board[file][i].getColor() == WHITE
				   && board._board[file][i].getUnit() == PAWN )
					isDoubled = true;
			}
			else
			{
				if(i != rank
			       && board._board[file][i].getColor() == BLACK
			       && board._board[file][i].getUnit() == PAWN )
					isDoubled = true;
			}
		}
	}
	if(isDoubled)
		scoreModifier -= 12;

	//Pawns in front of k/q are bad pawns.
	if((file == 3 || file == 4) && rank == 1 && is_white)
	{
		if(board._board[file][2].getUnit() != EMPTY)
			scoreModifier -= 25;
		else
			scoreModifier -=10;
	}
	if((file == 3 || file == 4) && rank == 6 && !is_white)
	{
		if(board._board[file][5].getUnit() != EMPTY)
			scoreModifier -= 25;
		else
			scoreModifier -=10;
	}

	int kingfile = 0;
	int kingrank = 0;
	//Check for pawns close to the king.
	for(int i=0; i<8; i++)
	{
		for(int j=0; j<8; j++)
		{
			if(is_white)
			{
				if(board._board[i][j].getUnit() == KING
					&& board._board[i][j].getColor() == WHITE)
				{
					kingfile = j;
					kingrank = i;
				}
			}
			else
			{
				if(board._board[i][j].getUnit() == KING
					&& board._board[i][j].getColor() == BLACK)
				{
					kingfile = j;
					kingrank = i;
				}
			}
		}
	}

	if(abs(kingfile-file) <3 || abs(kingrank-rank) <3)
		scoreModifier += 10;

	//Passed pawn bonus.
	bool passedpawn = true;
	if(is_white)
	{
		if(file != 0)
		{
			for(int i=1; rank+i<8; i++)
			{
				if(board._board[file-1][rank+i].getUnit() == PAWN
					&& board._board[file-1][rank+i].getColor() == BLACK)
				{
					passedpawn = false;
					break;
				}
			}
		}
		else if(file != 7)
		{
			for(int i=1; rank+i<8; i++)
			{
				if(board._board[file+1][rank+i].getUnit() == PAWN
					&& board._board[file+1][rank+i].getColor() == BLACK)
				{
					passedpawn = false;
					break;
				}
			}
		}
	}
	else
	{
		if(file != 0)
		{
			for(int i=1; rank-i>=0; i++)
			{
				if(board._board[file-1][rank-i].getUnit() == PAWN
					&& board._board[file-1][rank-i].getColor() == WHITE)
				{
					passedpawn = false;
					break;
				}
			}
		}
		else if(file != 7)
		{
			for(int i=1; rank-i>=0; i++)
			{
				if(board._board[file+1][rank-i].getUnit() == PAWN
					&& board._board[file+1][rank-i].getColor() == WHITE)
				{
					passedpawn = false;
					break;
				}
			}
		}
	}

	int tempModifier = 0;
	if(passedpawn)
	{
		if(is_white)
		{
			bool squareSafe = true;
			tempModifier+=18;
			if(rank != 1)
				tempModifier += (rank-1)*22;
			for(int i = 1; rank+i<8; i++)
			{
				if(board._board[file][rank+i].getColor() == BLACK)
					squareSafe = false;
				if(squareSafe && board.inDanger(is_white, rank+i, file))
					squareSafe = false;
				if(squareSafe)
					tempModifier += 12;
				squareSafe = true;
			}
		}
		else
		{
			bool squareSafe = true;
			tempModifier+=18;
			if(rank != 6)
				tempModifier += (7-rank-1)*22;
			for(int i = 1; rank-i>=0; i++)
			{
				if(board._board[file][rank-i].getColor() == WHITE)
					squareSafe = false;
				if(squareSafe && board.inDanger(!is_white, rank-i, file))
					squareSafe = false;
				if(squareSafe)
					tempModifier += 12;
				squareSafe = true;
			}
		}
	}
	if(endgame)
		tempModifier *= 2;
	scoreModifier += tempModifier;

	if(endgame)
		scoreModifier += 2*(rank+1)*halfBoardFile;
	else
		scoreModifier += (rank+1)*halfBoardFile;

	return scoreModifier;

}

int
knightBonuses(int file, int rank, const Board & board, bool is_white, bool endgame)
{
	int bonusCounter = 0;

	if(file == 4)
		file = 3;
	if(file == 5)
		file = 2;
	if(file == 6)
		file = 1;
	if(file == 7)
		file = 0;

	switch(file)
	{
	case 0:
		switch(rank)
		{
		case 0:
			bonusCounter += 0;
			break;
		case 1:
			bonusCounter += 5;
			break;
		case 2:
			bonusCounter += 10;
			break;
		case 3:
			bonusCounter += 15;
			break;
		case 4:
			bonusCounter += 15;
			break;
		case 5:
			bonusCounter += 10;
			break;
		case 6:
			bonusCounter += 5;
			break;
		case 7:
			bonusCounter += 0;
			break;
		default:
			bonusCounter += 0;
			break;
		}
		break;
	case 1:
		switch(rank)
		{
		case 0:
			bonusCounter += 5;
			break;
		case 1:
			bonusCounter += 10;
			break;
		case 2:
			bonusCounter += 15;
			break;
		case 3:
			bonusCounter += 20;
			break;
		case 4:
			bonusCounter += 20;
			break;
		case 5:
			bonusCounter += 15;
			break;
		case 6:
			bonusCounter += 10;
			break;
		case 7:
			bonusCounter += 5;
			break;
		default:
			bonusCounter += 0;
			break;
		}
		break;
	case 2:
		switch(rank)
		{
		case 0:
			bonusCounter += 10;
			break;
		case 1:
			bonusCounter += 15;
			break;
		case 2:
			bonusCounter += 20;
			break;
		case 3:
			bonusCounter += 25;
			break;
		case 4:
			bonusCounter += 25;
			break;
		case 5:
			bonusCounter += 20;
			break;
		case 6:
			bonusCounter += 15;
			break;
		case 7:
			bonusCounter += 10;
			break;
		default:
			bonusCounter += 0;
			break;
		}
		break;
	case 3:
		switch(rank)
		{
		case 0:
			bonusCounter += 15;
			break;
		case 1:
			bonusCounter += 20;
			break;
		case 2:
			bonusCounter += 25;
			break;
		case 3:
			bonusCounter += 30;
			break;
		case 4:
			bonusCounter += 30;
			break;
		case 5:
			bonusCounter += 25;
			break;
		case 6:
			bonusCounter += 20;
			break;
		case 7:
			bonusCounter += 15;
			break;
		default:
			bonusCounter += 0;
			break;
		}
		break;
	default:
		bonusCounter += 0;
		break;
	}
	
	bool drivenBonus = false;;

	if(endgame)
	//Two squares away? Great for forking.
	//Can't be driven off by pawns? Good.
	{
		drivenBonus = true;
		if(is_white)
		{
			if(file > 1 && board._board[file-2][rank].getColor() == BLACK)
				bonusCounter += 4;
			if(file < 6 && board._board[file+2][rank].getColor() == BLACK)
				bonusCounter += 4;
			if(rank > 1 && board._board[file][rank-2].getColor() == BLACK)
				bonusCounter += 4;
			if(rank < 6 && board._board[file][rank+2].getColor() == BLACK)
				bonusCounter += 4;
			if(file > 0 && rank > 0
			   && board._board[file-1][rank-1].getColor() == BLACK)
			    bonusCounter += 4;
			if(file > 0 && rank < 7
			   && board._board[file-1][rank+1].getColor() == BLACK)
			    bonusCounter += 4;
			if(file < 7 && rank > 0
			   && board._board[file+1][rank-1].getColor() == BLACK)
			    bonusCounter += 4;
			if(file < 7 && rank < 7
			   && board._board[file+1][rank+1].getColor() == BLACK)
			    bonusCounter += 4;

			if(rank == 4)
			{
				if(file > 0 && (board._board[file-1][2].getColor() == BLACK
					|| board._board[file-1][1].getColor() ==BLACK))
					drivenBonus = false;
				if(file < 7 && (board._board[file+1][2].getColor() == BLACK
					|| board._board[file+1][1].getColor() ==BLACK))
					drivenBonus = false;
			}
			else if(rank > 2)
			{
				if(file > 0 && (board._board[file-1][rank-2].getColor() == BLACK))
					drivenBonus = false;
				if(file < 7 && (board._board[file+1][rank-2].getColor() == BLACK))
					drivenBonus = false;
			}
		}
		else
		{
			if(file > 1 && board._board[file-2][rank].getColor() == WHITE)
				bonusCounter += 4;
			if(file < 6 && board._board[file+2][rank].getColor() == WHITE)
				bonusCounter += 4;
			if(rank > 1 && board._board[file][rank-2].getColor() == WHITE)
				bonusCounter += 4;
			if(rank < 6 && board._board[file][rank+2].getColor() == WHITE)
				bonusCounter += 4;
			if(file > 0 && rank > 0
			   && board._board[file-1][rank-1].getColor() == WHITE)
			    bonusCounter += 4;
			if(file > 0 && rank < 7
			   && board._board[file-1][rank+1].getColor() == WHITE)
			    bonusCounter += 4;
			if(file < 7 && rank > 0
			   && board._board[file+1][rank-1].getColor() == WHITE)
			    bonusCounter += 4;
			if(file < 7 && rank < 7
			   && board._board[file+1][rank+1].getColor() == WHITE)
			    bonusCounter += 4;

			if(rank == 4)
			{
				if(file > 0 && (board._board[file-1][6].getColor() == WHITE
					|| board._board[file-1][5].getColor() ==WHITE))
					drivenBonus = false;
				if(file < 7 && (board._board[file+1][6].getColor() == WHITE
					|| board._board[file+1][5].getColor() ==WHITE))
					drivenBonus = false;
			}
			else if(rank < 5)
			{
				if(file > 0 && (board._board[file-1][rank+2].getColor() == WHITE))
					drivenBonus = false;
				if(file < 7 && (board._board[file+1][rank+2].getColor() == WHITE))
					drivenBonus = false;
			}
		}
	}

	if(drivenBonus)
		bonusCounter += 8;

	return bonusCounter;
}
int knightDistanceFromKings(int file, int rank, const Board & board)
{
	int blackKingRank = 0;
	int blackKingFile = 0;
	int whiteKingRank = 0;
	int whiteKingFile = 0;

	for(int i = 0; i<8; i++)
	{
		for(int j = 0; j<8; j++)
		{
			if(board._board[i][j].getColor() == BLACK
			   && board._board[i][j].getUnit() == KING)
			{
				blackKingFile = i;
				blackKingRank = j;
			}
			if(board._board[i][j].getColor() == WHITE
			   && board._board[i][j].getUnit() == KING)
			{
				whiteKingFile = i;
				whiteKingRank = j;
			}
		}
	}

	return (abs(blackKingRank-rank)+abs(blackKingFile-file)
		    +abs(whiteKingFile-file)+abs(whiteKingRank-rank));
}

int
queenBonuses(int file, int rank, const Board & board, bool is_white, bool endgame)
{
	if(!endgame)
		return 0;

	int blackKingRank = 0;
	int blackKingFile = 0;
	int whiteKingRank = 0;
	int whiteKingFile = 0;

	for(int i = 0; i<8; i++)
	{
		for(int j = 0; j<8; j++)
		{
			if(board._board[i][j].getColor() == BLACK
			   && board._board[i][j].getUnit() == KING)
			{
				blackKingFile = i;
				blackKingRank = j;
			}
			if(board._board[i][j].getColor() == WHITE
			   && board._board[i][j].getUnit() == KING)
			{
				whiteKingFile = i;
				whiteKingRank = j;
			}
		}
	}

	if(is_white)
		return -2*abs((file-blackKingFile)+(rank-blackKingRank));
	if(!is_white)
		return -2*abs((file-whiteKingFile)+(rank-whiteKingRank));

	return 0;
}

int
bishopBonuses(int file, int rank, const Board & board, bool is_white, bool endgame)
{
	int bonusCounter = 0;

	if(endgame)
		bonusCounter += 10;
	
	//Mobility bonuses
	bonusCounter -= 4;

	int tempfile = file;
	int temprank = rank;

	bool xray = false;
	bool breaker = false;

	while(temprank >0 && tempfile >0)
	{
		temprank--;
		tempfile--;

		if(board._board[temprank][tempfile].getUnit() == EMPTY)
			bonusCounter += 2;
		else if(board._board[temprank][tempfile].getUnit() != PAWN 
			    && board._board[tempfile][temprank].getUnit() != EMPTY
				&& !xray)
		{
			bonusCounter += 2;
			xray = true;
		}
		else if(board._board[temprank][tempfile].getUnit() == PAWN)
			break;
		else if(board._board[temprank][tempfile].getColor() == WHITE && xray)
		{
			if(!is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(!is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		else if(board._board[temprank][tempfile].getColor() == BLACK && xray)
		{
			if(is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		if(breaker)
			break;
	}
	tempfile = file;
	temprank = rank;
	breaker = false;
	while(temprank <7 && tempfile >0)
	{
		temprank++;
		tempfile--;

		if(board._board[temprank][tempfile].getUnit() == EMPTY)
			bonusCounter += 2;
		else if(board._board[temprank][tempfile].getUnit() != PAWN 
			    && board._board[tempfile][temprank].getUnit() != EMPTY
				&& !xray)
		{
			bonusCounter += 2;
			xray = true;
		}
		else if(board._board[temprank][tempfile].getUnit() == PAWN)
			break;
		else if(board._board[temprank][tempfile].getColor() == WHITE && xray)
		{
			if(!is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(!is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		else if(board._board[temprank][tempfile].getColor() == BLACK && xray)
		{
			if(is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		if(breaker)
			break;
	}
	tempfile = file;
	temprank = rank;
	breaker = false;
	while(temprank >0 && tempfile <7)
	{
		temprank--;
		tempfile++;

		if(board._board[temprank][tempfile].getUnit() == EMPTY)
			bonusCounter += 2;
		else if(board._board[temprank][tempfile].getUnit() != PAWN 
			    && board._board[tempfile][temprank].getUnit() != EMPTY
				&& !xray)
		{
			bonusCounter += 2;
			xray = true;
		}
		else if(board._board[temprank][tempfile].getUnit() == PAWN)
			break;
		else if(board._board[temprank][tempfile].getColor() == WHITE && xray)
		{
			if(!is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(!is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		else if(board._board[temprank][tempfile].getColor() == BLACK && xray)
		{
			if(is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		if(breaker)
			break;
	}
	tempfile = file;
	temprank = rank;
	breaker = false;
	while(temprank <7 && tempfile <7)
	{
		temprank++;
		tempfile++;

		if(board._board[temprank][tempfile].getUnit() == EMPTY)
			bonusCounter += 2;
		else if(board._board[temprank][tempfile].getUnit() != PAWN 
			    && board._board[tempfile][temprank].getUnit() != EMPTY
				&& !xray)
		{
			bonusCounter += 2;
			xray = true;
		}
		else if(board._board[temprank][tempfile].getUnit() == PAWN)
			break;
		else if(board._board[temprank][tempfile].getColor() == WHITE && xray)
		{
			if(!is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(!is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		else if(board._board[temprank][tempfile].getColor() == BLACK && xray)
		{
			if(is_white)
			{
				breaker = true;
				if(   board._board[temprank][tempfile].getUnit() == QUEEN
				   || board._board[temprank][tempfile].getUnit() == ROOK
				   || board._board[temprank][tempfile].getUnit() == KNIGHT
				   || board.inDanger(is_white, temprank, tempfile))
					bonusCounter += 8;
			}
			else
			{
				breaker = true;
				break;
			}
		}
		if(breaker)
			break;
	}

	bool quickpos = false;
	if(file == 0 || file == 7 || rank == 0 || rank == 7)
	{
		bonusCounter += 14;
		quickpos = true;
	}
	else if((file == 1 || file == 6 || rank == 1 || rank == 6) && !quickpos)
	{
		bonusCounter += 17;
		quickpos = true;
	}
	else if((file == 2 || file == 5 || rank == 2 || rank == 5) && !quickpos)
	{
		bonusCounter += 20;
		quickpos = true;
	}
	else
		bonusCounter += 22;
	
	return bonusCounter;
}

int 
evaluateBoard(const Board &board, bool &is_white)
{
	//8080 total points on board, neglecting the king.
	int endgamecount = 0;
	int balance = 0;

	//First thing to do is check for raw material balance.
	if(is_white)
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == QUEEN)
				{
					balance += 900;
					endgamecount +=900;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == ROOK)
				{
				    balance += 500;
					endgamecount += 500;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KNIGHT)
				{
				    balance += 330;
					endgamecount +=330;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == BISHOP)
				{
				    balance += 340;
					endgamecount += 340;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == PAWN)
				{
				    balance += 100;
					endgamecount += 100;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KING) {
					if( !ChessPlayer::inCheckmate( board, true ) ) {
				    	balance += 100000;
						balance -= 25*board.inDangerCount( true, i, j );
					}
				}
			}
		}
	}
	else
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == QUEEN)
				{
					balance += 900;
					endgamecount +=900;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == ROOK)
				{
				    balance += 500;
					endgamecount += 500;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KNIGHT)
				{
				    balance += 330;
					endgamecount +=330;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == BISHOP)
				{
				    balance += 340;
					endgamecount += 340;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == PAWN)
				{
				    balance += 100;
					endgamecount += 100;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KING) {
					if( !ChessPlayer::inCheckmate( board, false ) ) {
				    	balance += 100000;
						balance -= 25*board.inDangerCount( false, i, j );
					}
				}
			}
		}
	}


	if(is_white)
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == QUEEN)
				{
					balance -= 900;
					endgamecount += 900;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == ROOK)
				{
				    balance -= 500;
					endgamecount += 500;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KNIGHT)
				{
				    balance -= 330;
					endgamecount += 330;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == BISHOP)
				{
				    balance -= 340;
					endgamecount += 340;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == PAWN)
				{
				    balance -= 100;
					endgamecount += 100;
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KING) {
					if( !ChessPlayer::inCheckmate( board, false ) ) {
				    	balance -= 100000;
						balance += 25*board.inDangerCount( false, i, j );
					}
				}
			}
		}
	}
	else
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == QUEEN)
				{
					balance -= 900;
					endgamecount += 900;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == ROOK)
				{
				    balance -= 500;
					endgamecount += 500;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KNIGHT)
				{
				    balance -= 330;
					endgamecount += 330;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == BISHOP)
				{
				    balance -= 340;
					endgamecount += 340;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == PAWN)
				{
				    balance -= 100;
					endgamecount += 100;
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KING) {
					if( !ChessPlayer::inCheckmate( board, true ) ) {
				    	balance -= 100000;
						balance += 25*board.inDangerCount( true, i, j );
					}
				}
			}
		}
	}

	//determine end game or not. THIS IS A TWEAKABLE VALUE.
	bool endgame = false;
	if(endgamecount < 3500)
		endgame = true;

	//Now we adjust for mobility
	if(is_white)
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == BISHOP)
					balance += bishopBonuses(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == BISHOP)
					balance -= bishopBonuses(i, j, board, !is_white, endgame);
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == PAWN)
					balance += pawnBonus(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == PAWN)
					balance -= pawnBonus(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KNIGHT)
				{
					balance += knightBonuses(i, j, board, is_white, endgame);
					balance -= knightDistanceFromKings(i, j, board);
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KNIGHT)
				{
					balance -= knightBonuses(i, j, board, !is_white, endgame);
					balance += knightDistanceFromKings(i, j, board);
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == QUEEN)
					balance += queenBonuses(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == QUEEN)
					balance -= queenBonuses(i, j, board, !is_white, endgame);
			}
		}
	}
	else
	{
		for(int i = 0; i < 8; i++)
		{
			for(int j=0; j < 8; j++)
			{
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == BISHOP)
					balance += bishopBonuses(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == BISHOP)
					balance -= bishopBonuses(i, j, board, !is_white, endgame);
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == KNIGHT)
				{
					balance += knightBonuses(i, j, board, is_white, endgame);
					balance -= knightDistanceFromKings(i, j, board);
				}
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == KNIGHT)
				{
					balance -= knightBonuses(i, j, board, !is_white, endgame);
					balance += knightDistanceFromKings(i, j, board);
				}
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == PAWN)
					balance += pawnBonus(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == PAWN)	
					balance -= pawnBonus(i, j, board, is_white, endgame);		
				if(board._board[i][j].getColor() == BLACK
				   && board._board[i][j].getUnit() == QUEEN)
					balance += queenBonuses(i, j, board, is_white, endgame);
				if(board._board[i][j].getColor() == WHITE
				   && board._board[i][j].getUnit() == QUEEN)
					balance -= queenBonuses(i, j, board, !is_white, endgame);
			}
		}
	}
	return balance;
}
int 
alphaBeta(int depth, int alpha, int beta, bool is_white, const Board &board, 
		  BoardMove &move )
/***************************************************************************
*	alphaBeta()
*
*	- Uses alphabeta pruning on minimax tree to evaluate moves.
***************************************************************************/
{
	vector<BoardMove> posmoves;

	srand( (unsigned int)time(NULL) );

	if(depth == 0 || ChessPlayer::inCheckmate( board, is_white )
		|| ChessPlayer::inStalemate( board, is_white ) )
		return evaluateBoard(board, is_white);

	//GENERATE MOVES
	for( int i = 0; i < 8; i++ )
	{
		for( int j = 0; j < 8; j++ ) {
			if( ( board._board[i][j].getColor() == WHITE && is_white )
				|| ( board._board[i][j].getColor() == BLACK && !is_white ) )
			{
				// Found one
				bool isking = false;
				// Get the possible moves for each piece
				switch( board._board[i][j].getUnit() ) {
					case PAWN:
						posmoves.push_back( BoardMove( i, j, i+1, j ) );
						posmoves.push_back( BoardMove( i, j, i-1, j ) );
						posmoves.push_back( BoardMove( i, j, i+2, j ) );
						posmoves.push_back( BoardMove( i, j, i-2, j ) );
						posmoves.push_back( BoardMove( i, j, i+1, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i+1, j-1 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j-1 ) );
						break;
					case KNIGHT:
						posmoves.push_back( BoardMove( i, j, i+1, j+2 ) );
						posmoves.push_back( BoardMove( i, j, i+1, j-2 ) );
						posmoves.push_back( BoardMove( i, j, i+2, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i+2, j-1 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j+2 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j-2 ) );
						posmoves.push_back( BoardMove( i, j, i-2, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i-2, j-1 ) );
						break;
					case QUEEN:
					case BISHOP:
						for( int a = 0; a < 8; a++ ) {
							posmoves.push_back( BoardMove( i, j, i+a, j+a ) );
							posmoves.push_back( BoardMove( i, j, i-a, j-a ) );
							posmoves.push_back( BoardMove( i, j, i+a, j-a ) );
							posmoves.push_back( BoardMove( i, j, i-a, j+a ) );
						}
						if( board._board[i][j].getUnit() == BISHOP )
							break;
					case ROOK:
						for( int x = 0; x < 8; x++ )
							if( x != i )
								posmoves.push_back( BoardMove( i, j, x, j ) );
						for( int y = 0; y < 8; y++ )
							if( y != j )
								posmoves.push_back( BoardMove( i, j, i, y ) );
						break;
					case KING:
						isking = true;
						posmoves.push_back( BoardMove( i, j, i+1, j ) );
						posmoves.push_back( BoardMove( i, j, i+1, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j+1 ) );
						posmoves.push_back( BoardMove( i, j, i-1, j ) );
						posmoves.push_back( BoardMove( i, j, i-1, j-1 ) );
						posmoves.push_back( BoardMove( i, j, i, j-1 ) );
						posmoves.push_back( BoardMove( i, j, i+1, j-1 ) );
					default:
						break;
				}
			}
		}
	}

	
	Board testboard = board;
	BoardMove testmove = move;
	BoardMove validmove;
	int value;

	for(uint i=0; i<posmoves.size(); i++)
	{
		if( ChessPlayer::check_move(posmoves[i], testboard, is_white) ) {
			testboard.updateBoard(posmoves[i]);
			value = -alphaBeta(depth-1, -beta, -alpha, !is_white, testboard, testmove );
			testboard = board;
			
			if (value > alpha )
			{
				testmove = posmoves[i];
				move = posmoves[i];
				alpha = value;

				if( beta <= alpha )
					break;
			}
		}
	}

	return alpha;
}

BoardMove
AlphaBetaPlayer::decide_move(const Board & board, bool & white)
{
	BoardMove move;
	//alphaBeta(2, -10, 10, white, board, move);
	alphaBeta(3, -INT_MAX, INT_MAX, white, board, move );
	return move;
}

// End of file alphabetaplayer.cpp
