/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_INFOFIELD_H
#define INCLUDED_INFOFIELD_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QLINEEDIT_H
#include <qlineedit.h>
#define INCLUDED_QLINEEDIT_H
#endif // INCLUDED_QLINEEDIT_H

/*------- class declaration:
-------------------------------------------------------------------*/
class InfoField : public QLineEdit
{
public:
	InfoField( QWidget* const in_parent )
	: QLineEdit( in_parent )
	{
		setReadOnly( TRUE );
		setPaletteBackgroundColor( in_parent->paletteBackgroundColor() );
		setFrameShape( NoFrame );
		setFrameShadow( Plain );
		setAlignment( Qt::AlignLeft );
		setFocusPolicy( NoFocus );
	}
	
	InfoField( const QString& in_text, QWidget* const in_parent )
	: QLineEdit( in_text, in_parent )
	{
		setReadOnly( TRUE );
		setPaletteBackgroundColor( in_parent->paletteBackgroundColor() );
		setFrameShape( NoFrame );
		setFrameShadow( Plain );
		setAlignment( Qt::AlignLeft );
		setFocusPolicy( NoFocus );
	}
private:
	InfoField( const InfoField& );
	InfoField& operator=( const InfoField& );
};

#endif // INCLUDED_INFOFIELD_H
