/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SHARED_H
#define INCLUDED_SHARED_H

/*------- include files:
------------------------------------------------------------------*/
#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

/*------- forward declaration:
-------------------------------------------------------------------*/
class QPushButton;

/*------- class declaration:
--------------------------------------------------------------------*/
class Shared : public QObject
{
    Q_OBJECT

// ******* members *******
public:
	enum
	{
		FILE = 0,
		DIRECTORY
	};

private:
	static const QString MyDir;
	static const QString MyTmpDir;
	static const QString MyPackDir;
	static const QString MsgBoxDelErrorCaption;
	static const QString MsgBoxDelFileError;
	static const QString MsgBoxDelDirError;
	static const QString VersionMajor;
	static const QString VersionMinor;
	static const QString DeletingFileMsg;
public:	
    static bool    d_break;
	static const QString LicenceFileName;
	static const QString ProgramName;
	static const QString ProgramVersion;
	static const int     LayoutMargin;
	static const int     LayoutSpacing;
	static const int     OverStretch;
	static const QString ThisDir;
	static const QString ParentDir;
	static const QString TouchPrgName;
	static const QString ShellCd;
	static const QString NotReadableDir;
	static const QString FTP_Unconnected;
	static const QString FTP_HostLookup;
	static const QString FTP_Connecting;
	static const QString FTP_Connected;
	static const QString FTP_LoggedIn;
	static const QString FTP_Closing;
	static const QString FTP_Unknown;
	static const QChar   Spc;
	static const QString DirSep;
	static const QChar   Point;
	static const QChar   Colon;
	static const QChar   Semicolon;
	static const QChar   Stern;
	static const QChar   WidthMarker;
	static const QChar   Ampersand;
	static const QString EmptyStr;
	static const QString DateTimeMuster;
	static const QString MenuHelp;
	static const QString MenuAccess;
	static const QString MenuView;
	static const QString MenuEdit;
	static const QString MenuCopy;
	static const QString MenuRename;
	static const QString MenuMkDir;
	static const QString MenuDelete;
	static const QString MenuPack;
	static const QString MenuQuit;
	static const QString MenuEmpty;
	static const QString CmpDirIcon;
	static const QString CloseIcon;
	static const QString AcceptIcon;
	static const QString ApplyIcon;
	static const QString BreakIcon;
	static const QString SaveIcon;
	static const QString ReloadIcon;
	static const QString ResetIcon;
	static const QString TreeIcon;
	static const QString CloseBtnLabel;
	static const QString AcceptBtnLabel;
	static const QString SaveBtnLabel;
	static const QString CancelBtnLabel;
	static const QString ContinueBtnLabel;
	static const QString BreakBtnLabel;
	static const QString RunBtnLabel;
	static const QString YesBtnLabel;
	static const QString NoBtnLabel;
	static const QString OkBtnLabel;
	static const QString ReloadBtnLabel;
	static const QString ApplyBtnLabel;
	static const QString ResetBtnLabel;
	static const QString SelectBtnLabel;
	static const QString Information;
	static const QString Yes;
	static const QString No;
	static const QString KonsoleCall;

// ******* MEMBERS *******
private:
	static QString d_home_directory;
	static bool    d_file_filter_activ;
	static QString d_tmp_buffer;

// ******* methods *******
public:
	static void     toggle_file_filter      ();
	static void     toggle_file_filter      ( const bool in_flag );
	static int      get_file_filter         ();
	static QString  get_home_dir            ();
	static QString  get_my_dir              ();
	static QString  get_tmp_dir             ();
	static QString  get_pack_dir            ();
	static QString  get_subpath             ( const QString& in_base_path, const QString& in_current_path );
	static bool     create_path             ( const QString& in_existing, const QString& in_subdirs );
	static bool     remove_path_and_content ( const QString&, bool = FALSE, bool = FALSE, QDialog* = 0 );
	static bool     remove_file             ( const QString&, bool = FALSE, bool = FALSE, QDialog* = 0 );
	static void     add_icon                ( QPushButton* const in_button, const QString& in_icon_name );
	static bool     is_binary_file          ( const QString& in_fpath );
	static void    polish                  ( QWidget* const, const int, const int );
	static void    polish                  ( QWidget* const, const QSize& );
	static void    polish_width            ( QWidget* const, const int );
	static const QString& num2str          ( const Q_ULLONG, const char = ',' );
	static void    idle                    ();
	static void    clip_path               ( const QFontMetrics& in_fm, const int in_width, QString& in_out_path );
	static QString make_path               ( const QString&, const QString& );
	static void    clip_path               ( const QString&, QString&, QString& );
	static bool    is_dir_ok               ( const QString& );
	static bool    is_white_char           ( const QChar& );
	static bool    remove_white_chars      ( QString& );
	static bool    is_regular_file         ( const QString& );
	static void    auto_rename             ( QString& );
	static bool    is_user_root            ();
private:
    static bool   can_not_delete          ( const QString& in_fpath, const int in_type );
};

#endif // INCLUDED_SHARED_H
