/* headerwidget.c generated by valac 0.32.1, the Vala compiler
 * generated from headerwidget.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>


#define BUDGIE_TYPE_HEADER_EXPANDER (budgie_header_expander_get_type ())
#define BUDGIE_HEADER_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander))
#define BUDGIE_HEADER_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpanderClass))
#define BUDGIE_IS_HEADER_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_EXPANDER))
#define BUDGIE_IS_HEADER_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_EXPANDER))
#define BUDGIE_HEADER_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpanderClass))

typedef struct _BudgieHeaderExpander BudgieHeaderExpander;
typedef struct _BudgieHeaderExpanderClass BudgieHeaderExpanderClass;
typedef struct _BudgieHeaderExpanderPrivate BudgieHeaderExpanderPrivate;

#define BUDGIE_TYPE_HEADER_WIDGET (budgie_header_widget_get_type ())
#define BUDGIE_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget))
#define BUDGIE_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))
#define BUDGIE_IS_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_IS_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_HEADER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))

typedef struct _BudgieHeaderWidget BudgieHeaderWidget;
typedef struct _BudgieHeaderWidgetClass BudgieHeaderWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieHeaderWidgetPrivate BudgieHeaderWidgetPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_RAVEN_EXPANDER (budgie_raven_expander_get_type ())
#define BUDGIE_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander))
#define BUDGIE_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))
#define BUDGIE_IS_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_IS_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_RAVEN_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))

typedef struct _BudgieRavenExpander BudgieRavenExpander;
typedef struct _BudgieRavenExpanderClass BudgieRavenExpanderClass;
typedef struct _BudgieRavenExpanderPrivate BudgieRavenExpanderPrivate;

struct _BudgieHeaderExpander {
	GtkButton parent_instance;
	BudgieHeaderExpanderPrivate * priv;
};

struct _BudgieHeaderExpanderClass {
	GtkButtonClass parent_class;
};

struct _BudgieHeaderExpanderPrivate {
	GtkImage* image;
	gboolean _expanded;
	BudgieHeaderWidget* owner;
};

struct _BudgieHeaderWidget {
	GtkBox parent_instance;
	BudgieHeaderWidgetPrivate * priv;
};

struct _BudgieHeaderWidgetClass {
	GtkBoxClass parent_class;
};

struct _BudgieHeaderWidgetPrivate {
	GtkImage* image;
	GtkLabel* label;
	GtkButton* close_button;
	GtkBox* header_box;
	gboolean _expanded;
};

struct _BudgieRavenExpander {
	GtkBox parent_instance;
	BudgieRavenExpanderPrivate * priv;
	GtkRevealer* content;
};

struct _BudgieRavenExpanderClass {
	GtkBoxClass parent_class;
};

struct _BudgieRavenExpanderPrivate {
	BudgieHeaderWidget* header;
	gboolean track_animations;
};


static gpointer budgie_header_expander_parent_class = NULL;
static gpointer budgie_header_widget_parent_class = NULL;
static gpointer budgie_raven_expander_parent_class = NULL;

GType budgie_header_expander_get_type (void) G_GNUC_CONST;
GType budgie_header_widget_get_type (void) G_GNUC_CONST;
#define BUDGIE_HEADER_EXPANDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpanderPrivate))
enum  {
	BUDGIE_HEADER_EXPANDER_DUMMY_PROPERTY,
	BUDGIE_HEADER_EXPANDER_EXPANDED
};
BudgieHeaderExpander* budgie_header_expander_new (BudgieHeaderWidget* owner);
BudgieHeaderExpander* budgie_header_expander_construct (GType object_type, BudgieHeaderWidget* owner);
static void budgie_header_expander_real_clicked (GtkButton* base);
gboolean budgie_header_expander_get_expanded (BudgieHeaderExpander* self);
void budgie_header_expander_set_expanded (BudgieHeaderExpander* self, gboolean value);
void budgie_header_widget_set_expanded (BudgieHeaderWidget* self, gboolean value);
static void budgie_header_expander_finalize (GObject* obj);
static void _vala_budgie_header_expander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_header_expander_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BUDGIE_HEADER_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetPrivate))
enum  {
	BUDGIE_HEADER_WIDGET_DUMMY_PROPERTY,
	BUDGIE_HEADER_WIDGET_TEXT,
	BUDGIE_HEADER_WIDGET_ICON_NAME,
	BUDGIE_HEADER_WIDGET_CAN_CLOSE,
	BUDGIE_HEADER_WIDGET_EXPANDED
};
BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
static void __lambda10_ (BudgieHeaderWidget* self);
static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self);
void budgie_header_widget_set_text (BudgieHeaderWidget* self, const gchar* value);
void budgie_header_widget_set_icon_name (BudgieHeaderWidget* self, const gchar* value);
void budgie_header_widget_set_can_close (BudgieHeaderWidget* self, gboolean value);
const gchar* budgie_header_widget_get_text (BudgieHeaderWidget* self);
gchar* budgie_header_widget_get_icon_name (BudgieHeaderWidget* self);
gboolean budgie_header_widget_get_can_close (BudgieHeaderWidget* self);
gboolean budgie_header_widget_get_expanded (BudgieHeaderWidget* self);
static void budgie_header_widget_finalize (GObject* obj);
static void _vala_budgie_header_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_header_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType budgie_raven_expander_get_type (void) G_GNUC_CONST;
#define BUDGIE_RAVEN_EXPANDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderPrivate))
enum  {
	BUDGIE_RAVEN_EXPANDER_DUMMY_PROPERTY,
	BUDGIE_RAVEN_EXPANDER_EXPANDED
};
BudgieRavenExpander* budgie_raven_expander_new (BudgieHeaderWidget* header);
BudgieRavenExpander* budgie_raven_expander_construct (GType object_type, BudgieHeaderWidget* header);
static void __lambda11_ (BudgieRavenExpander* self);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void budgie_raven_expander_set_expanded (BudgieRavenExpander* self, gboolean value);
static void __lambda12_ (BudgieRavenExpander* self);
static void ___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda13_ (BudgieRavenExpander* self);
static void budgie_raven_expander_after_paint (BudgieRavenExpander* self, GdkFrameClock* clock);
static void _budgie_raven_expander_after_paint_gdk_frame_clock_after_paint (GdkFrameClock* _sender, gpointer self);
static void ___lambda13__gtk_widget_map (GtkWidget* _sender, gpointer self);
static void budgie_raven_expander_real_add (GtkContainer* base, GtkWidget* widget);
gboolean budgie_raven_expander_get_expanded (BudgieRavenExpander* self);
static void budgie_raven_expander_finalize (GObject* obj);
static void _vala_budgie_raven_expander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_raven_expander_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgieHeaderExpander* budgie_header_expander_construct (GType object_type, BudgieHeaderWidget* owner) {
	BudgieHeaderExpander * self = NULL;
	BudgieHeaderWidget* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkStyleContext* st = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	self = (BudgieHeaderExpander*) g_object_new (object_type, NULL);
	_tmp0_ = owner;
	self->priv->owner = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp1_;
	_tmp2_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	st = _tmp4_;
	gtk_style_context_add_class (st, "flat");
	gtk_style_context_add_class (st, "expander-button");
	_g_object_unref0 (st);
	return self;
}


BudgieHeaderExpander* budgie_header_expander_new (BudgieHeaderWidget* owner) {
	return budgie_header_expander_construct (BUDGIE_TYPE_HEADER_EXPANDER, owner);
}


static void budgie_header_expander_real_clicked (GtkButton* base) {
	BudgieHeaderExpander * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	BudgieHeaderWidget* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (BudgieHeaderExpander*) base;
	_tmp0_ = budgie_header_expander_get_expanded (self);
	_tmp1_ = _tmp0_;
	budgie_header_expander_set_expanded (self, !_tmp1_);
	_tmp2_ = self->priv->owner;
	_tmp3_ = budgie_header_expander_get_expanded (self);
	_tmp4_ = _tmp3_;
	budgie_header_widget_set_expanded (_tmp2_, _tmp4_);
}


gboolean budgie_header_expander_get_expanded (BudgieHeaderExpander* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_expanded;
	result = _tmp0_;
	return result;
}


void budgie_header_expander_set_expanded (BudgieHeaderExpander* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_expanded = _tmp0_;
	_tmp1_ = self->priv->_expanded;
	if (_tmp1_) {
		GtkImage* _tmp2_ = NULL;
		_tmp2_ = self->priv->image;
		g_object_set (_tmp2_, "icon-name", "pan-down-symbolic", NULL);
	} else {
		GtkImage* _tmp3_ = NULL;
		_tmp3_ = self->priv->image;
		g_object_set (_tmp3_, "icon-name", "pan-end-symbolic", NULL);
	}
	g_object_notify ((GObject *) self, "expanded");
}


static void budgie_header_expander_class_init (BudgieHeaderExpanderClass * klass) {
	budgie_header_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieHeaderExpanderPrivate));
	((GtkButtonClass *) klass)->clicked = budgie_header_expander_real_clicked;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_header_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_header_expander_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_header_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_EXPANDER_EXPANDED, g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_header_expander_instance_init (BudgieHeaderExpander * self) {
	self->priv = BUDGIE_HEADER_EXPANDER_GET_PRIVATE (self);
	self->priv->_expanded = TRUE;
	self->priv->owner = NULL;
}


static void budgie_header_expander_finalize (GObject* obj) {
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (budgie_header_expander_parent_class)->finalize (obj);
}


/**
 * Simple expander button for the header widget
 */
GType budgie_header_expander_get_type (void) {
	static volatile gsize budgie_header_expander_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_header_expander_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieHeaderExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_header_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieHeaderExpander), 0, (GInstanceInitFunc) budgie_header_expander_instance_init, NULL };
		GType budgie_header_expander_type_id;
		budgie_header_expander_type_id = g_type_register_static (gtk_button_get_type (), "BudgieHeaderExpander", &g_define_type_info, 0);
		g_once_init_leave (&budgie_header_expander_type_id__volatile, budgie_header_expander_type_id);
	}
	return budgie_header_expander_type_id__volatile;
}


static void _vala_budgie_header_expander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	switch (property_id) {
		case BUDGIE_HEADER_EXPANDER_EXPANDED:
		g_value_set_boolean (value, budgie_header_expander_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_header_expander_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieHeaderExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_EXPANDER, BudgieHeaderExpander);
	switch (property_id) {
		case BUDGIE_HEADER_EXPANDER_EXPANDED:
		budgie_header_expander_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void __lambda10_ (BudgieHeaderWidget* self) {
	g_signal_emit_by_name (self, "closed");
}


static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda10_ ((BudgieHeaderWidget*) self);
}


BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget) {
	BudgieHeaderWidget * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* _tmp20_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkStyleContext* _tmp28_ = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkStyleContext* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkButton* _tmp32_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	GtkBox* _tmp34_ = NULL;
	GtkButton* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	self = (BudgieHeaderWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "raven-header");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->header_box);
	self->priv->header_box = _tmp1_;
	_tmp2_ = self->priv->header_box;
	g_object_set ((GtkWidget*) _tmp2_, "margin", 3, NULL);
	_tmp3_ = self->priv->header_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp4_;
	_tmp5_ = self->priv->image;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 8);
	_tmp7_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp7_, 8);
	_tmp8_ = self->priv->header_box;
	_tmp9_ = self->priv->image;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp10_;
	_tmp11_ = self->priv->label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->label;
	gtk_label_set_line_wrap (_tmp12_, TRUE);
	_tmp13_ = self->priv->label;
	gtk_label_set_line_wrap_mode (_tmp13_, PANGO_WRAP_WORD);
	_tmp14_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	_tmp15_ = custom_widget;
	if (_tmp15_ != NULL) {
		GtkBox* _tmp16_ = NULL;
		GtkWidget* _tmp17_ = NULL;
		_tmp16_ = self->priv->header_box;
		_tmp17_ = custom_widget;
		gtk_box_pack_start (_tmp16_, _tmp17_, TRUE, TRUE, (guint) 0);
	} else {
		GtkBox* _tmp18_ = NULL;
		GtkLabel* _tmp19_ = NULL;
		_tmp18_ = self->priv->header_box;
		_tmp19_ = self->priv->label;
		gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, TRUE, TRUE, (guint) 0);
	}
	_tmp20_ = end_widget;
	if (_tmp20_ == NULL) {
		BudgieHeaderExpander* expander = NULL;
		BudgieHeaderExpander* _tmp21_ = NULL;
		GtkBox* _tmp22_ = NULL;
		BudgieHeaderExpander* _tmp23_ = NULL;
		_tmp21_ = budgie_header_expander_new (self);
		g_object_ref_sink (_tmp21_);
		expander = _tmp21_;
		_tmp22_ = self->priv->header_box;
		_tmp23_ = expander;
		gtk_box_pack_end (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (expander);
	} else {
		GtkBox* _tmp24_ = NULL;
		GtkWidget* _tmp25_ = NULL;
		_tmp24_ = self->priv->header_box;
		_tmp25_ = end_widget;
		gtk_box_pack_end (_tmp24_, _tmp25_, FALSE, FALSE, (guint) 0);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp26_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp26_;
	_tmp27_ = self->priv->close_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "flat");
	_tmp29_ = self->priv->close_button;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, "primary-control");
	_tmp31_ = self->priv->close_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = self->priv->close_button;
	_tmp33_ = gtk_bin_get_child ((GtkBin*) _tmp32_);
	gtk_widget_show (_tmp33_);
	_tmp34_ = self->priv->header_box;
	_tmp35_ = self->priv->close_button;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	_tmp36_ = self->priv->close_button;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) ___lambda10__gtk_button_clicked, self, 0);
	_tmp37_ = text;
	budgie_header_widget_set_text (self, _tmp37_);
	_tmp38_ = icon_name;
	budgie_header_widget_set_icon_name (self, _tmp38_);
	_tmp39_ = can_close;
	budgie_header_widget_set_can_close (self, _tmp39_);
	return self;
}


BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget) {
	return budgie_header_widget_construct (BUDGIE_TYPE_HEADER_WIDGET, text, icon_name, can_close, custom_widget, end_widget);
}


const gchar* budgie_header_widget_get_text (BudgieHeaderWidget* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	result = _tmp1_;
	return result;
}


void budgie_header_widget_set_text (BudgieHeaderWidget* self, const gchar* value) {
	gchar* t = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	t = _tmp1_;
	_tmp2_ = t;
	if (_tmp2_ != NULL) {
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		_tmp3_ = self->priv->label;
		_tmp4_ = value;
		gtk_label_set_label (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->label;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	} else {
		GtkLabel* _tmp6_ = NULL;
		_tmp6_ = self->priv->label;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
	}
	_g_free0 (t);
	g_object_notify ((GObject *) self, "text");
}


gchar* budgie_header_widget_get_icon_name (BudgieHeaderWidget* self) {
	gchar* result;
	GtkImage* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image;
	g_object_get (_tmp0_, "icon-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void budgie_header_widget_set_icon_name (BudgieHeaderWidget* self, const gchar* value) {
	gchar* iname = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	iname = _tmp1_;
	_tmp2_ = iname;
	if (_tmp2_ == NULL) {
		GtkImage* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		_tmp3_ = self->priv->image;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 8);
	} else {
		GtkImage* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkImage* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		_tmp5_ = self->priv->image;
		_tmp6_ = iname;
		gtk_image_set_from_icon_name (_tmp5_, _tmp6_, GTK_ICON_SIZE_MENU);
		_tmp7_ = self->priv->image;
		gtk_widget_show ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 0);
	}
	_g_free0 (iname);
	g_object_notify ((GObject *) self, "icon-name");
}


gboolean budgie_header_widget_get_can_close (BudgieHeaderWidget* self) {
	gboolean result;
	GtkButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->close_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


void budgie_header_widget_set_can_close (BudgieHeaderWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_) {
		GtkButton* _tmp1_ = NULL;
		_tmp1_ = self->priv->close_button;
		gtk_widget_show ((GtkWidget*) _tmp1_);
	} else {
		GtkButton* _tmp2_ = NULL;
		_tmp2_ = self->priv->close_button;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
	g_object_notify ((GObject *) self, "can-close");
}


gboolean budgie_header_widget_get_expanded (BudgieHeaderWidget* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_expanded;
	result = _tmp0_;
	return result;
}


void budgie_header_widget_set_expanded (BudgieHeaderWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_expanded = _tmp0_;
	g_object_notify ((GObject *) self, "expanded");
}


static void budgie_header_widget_class_init (BudgieHeaderWidgetClass * klass) {
	budgie_header_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieHeaderWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_header_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_header_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_header_widget_finalize;
	/** Display text */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Icon to show, if any */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether this headerwidget shows a close button
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_CAN_CLOSE, g_param_spec_boolean ("can-close", "can-close", "can-close", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Manage the expanded state of this expanding header widget
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_HEADER_WIDGET_EXPANDED, g_param_spec_boolean ("expanded", "expanded", "expanded", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Emitted when this widget has been closed
	     */
	g_signal_new ("closed", BUDGIE_TYPE_HEADER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_header_widget_instance_init (BudgieHeaderWidget * self) {
	self->priv = BUDGIE_HEADER_WIDGET_GET_PRIVATE (self);
	self->priv->image = NULL;
	self->priv->label = NULL;
	self->priv->close_button = NULL;
	self->priv->header_box = NULL;
	self->priv->_expanded = TRUE;
}


static void budgie_header_widget_finalize (GObject* obj) {
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->header_box);
	G_OBJECT_CLASS (budgie_header_widget_parent_class)->finalize (obj);
}


/**
 * Headered expander widget for use in groups within the Raven UI
 */
GType budgie_header_widget_get_type (void) {
	static volatile gsize budgie_header_widget_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_header_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieHeaderWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_header_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieHeaderWidget), 0, (GInstanceInitFunc) budgie_header_widget_instance_init, NULL };
		GType budgie_header_widget_type_id;
		budgie_header_widget_type_id = g_type_register_static (gtk_box_get_type (), "BudgieHeaderWidget", &g_define_type_info, 0);
		g_once_init_leave (&budgie_header_widget_type_id__volatile, budgie_header_widget_type_id);
	}
	return budgie_header_widget_type_id__volatile;
}


static void _vala_budgie_header_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	switch (property_id) {
		case BUDGIE_HEADER_WIDGET_TEXT:
		g_value_set_string (value, budgie_header_widget_get_text (self));
		break;
		case BUDGIE_HEADER_WIDGET_ICON_NAME:
		g_value_take_string (value, budgie_header_widget_get_icon_name (self));
		break;
		case BUDGIE_HEADER_WIDGET_CAN_CLOSE:
		g_value_set_boolean (value, budgie_header_widget_get_can_close (self));
		break;
		case BUDGIE_HEADER_WIDGET_EXPANDED:
		g_value_set_boolean (value, budgie_header_widget_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_header_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieHeaderWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget);
	switch (property_id) {
		case BUDGIE_HEADER_WIDGET_TEXT:
		budgie_header_widget_set_text (self, g_value_get_string (value));
		break;
		case BUDGIE_HEADER_WIDGET_ICON_NAME:
		budgie_header_widget_set_icon_name (self, g_value_get_string (value));
		break;
		case BUDGIE_HEADER_WIDGET_CAN_CLOSE:
		budgie_header_widget_set_can_close (self, g_value_get_boolean (value));
		break;
		case BUDGIE_HEADER_WIDGET_EXPANDED:
		budgie_header_widget_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void __lambda11_ (BudgieRavenExpander* self) {
	GtkWidget* _tmp0_ = NULL;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp0_);
	self->priv->track_animations = FALSE;
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda11_ ((BudgieRavenExpander*) self);
}


static void __lambda12_ (BudgieRavenExpander* self) {
	self->priv->track_animations = TRUE;
}


static void ___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda12_ ((BudgieRavenExpander*) self);
}


static void _budgie_raven_expander_after_paint_gdk_frame_clock_after_paint (GdkFrameClock* _sender, gpointer self) {
	budgie_raven_expander_after_paint ((BudgieRavenExpander*) self, _sender);
}


static void __lambda13_ (BudgieRavenExpander* self) {
	GdkFrameClock* clock = NULL;
	GtkRevealer* _tmp0_ = NULL;
	GdkFrameClock* _tmp1_ = NULL;
	GdkFrameClock* _tmp2_ = NULL;
	_tmp0_ = self->content;
	_tmp1_ = gtk_widget_get_frame_clock ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clock = _tmp2_;
	g_signal_connect_object (clock, "after-paint", (GCallback) _budgie_raven_expander_after_paint_gdk_frame_clock_after_paint, self, 0);
	_g_object_unref0 (clock);
}


static void ___lambda13__gtk_widget_map (GtkWidget* _sender, gpointer self) {
	__lambda13_ ((BudgieRavenExpander*) self);
}


BudgieRavenExpander* budgie_raven_expander_construct (GType object_type, BudgieHeaderWidget* header) {
	BudgieRavenExpander * self = NULL;
	BudgieHeaderWidget* _tmp0_ = NULL;
	BudgieHeaderWidget* _tmp1_ = NULL;
	BudgieHeaderWidget* _tmp2_ = NULL;
	GtkRevealer* _tmp3_ = NULL;
	GtkRevealer* _tmp4_ = NULL;
	BudgieHeaderWidget* _tmp5_ = NULL;
	GtkRevealer* _tmp6_ = NULL;
	GtkRevealer* _tmp7_ = NULL;
	GtkRevealer* _tmp8_ = NULL;
	self = (BudgieRavenExpander*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "margin-top", 8, NULL);
	_tmp0_ = header;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp1_;
	_tmp2_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->content);
	self->content = _tmp3_;
	_tmp4_ = self->content;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	_tmp5_ = self->priv->header;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "expanded", (GObject*) self, "expanded", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp6_ = self->content;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::child-revealed", (GCallback) ___lambda11__g_object_notify, self, G_CONNECT_AFTER);
	budgie_raven_expander_set_expanded (self, TRUE);
	_tmp7_ = self->content;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::reveal-child", (GCallback) ___lambda12__g_object_notify, self, 0);
	_tmp8_ = self->content;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "map", (GCallback) ___lambda13__gtk_widget_map, self, G_CONNECT_AFTER);
	return self;
}


BudgieRavenExpander* budgie_raven_expander_new (BudgieHeaderWidget* header) {
	return budgie_raven_expander_construct (BUDGIE_TYPE_RAVEN_EXPANDER, header);
}


/**
     * Repaint to address limitations in drawing model whereby animations
     * cause artifacts in the revealer animation
     */
static void budgie_raven_expander_after_paint (BudgieRavenExpander* self, GdkFrameClock* clock) {
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = self->priv->track_animations;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp1_);
}


static void budgie_raven_expander_real_add (GtkContainer* base, GtkWidget* widget) {
	BudgieRavenExpander * self;
	GtkRevealer* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	self = (BudgieRavenExpander*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->content;
	_tmp1_ = widget;
	gtk_container_add ((GtkContainer*) _tmp0_, _tmp1_);
}


gboolean budgie_raven_expander_get_expanded (BudgieRavenExpander* self) {
	gboolean result;
	GtkRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->content;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	result = _tmp1_;
	return result;
}


void budgie_raven_expander_set_expanded (BudgieRavenExpander* self, gboolean value) {
	GtkRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->content;
	_tmp1_ = value;
	gtk_revealer_set_reveal_child (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "expanded");
}


static void budgie_raven_expander_class_init (BudgieRavenExpanderClass * klass) {
	budgie_raven_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieRavenExpanderPrivate));
	((GtkContainerClass *) klass)->add = budgie_raven_expander_real_add;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_raven_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_raven_expander_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_EXPANDER_EXPANDED, g_param_spec_boolean ("expanded", "expanded", "expanded", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_raven_expander_instance_init (BudgieRavenExpander * self) {
	self->priv = BUDGIE_RAVEN_EXPANDER_GET_PRIVATE (self);
	self->priv->header = NULL;
	self->priv->track_animations = FALSE;
}


static void budgie_raven_expander_finalize (GObject* obj) {
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	_g_object_unref0 (self->content);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (budgie_raven_expander_parent_class)->finalize (obj);
}


/**
 * Simplify use of the header and expansion logic by rolling them both
 * into a custom widget
 */
GType budgie_raven_expander_get_type (void) {
	static volatile gsize budgie_raven_expander_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_raven_expander_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenExpander), 0, (GInstanceInitFunc) budgie_raven_expander_instance_init, NULL };
		GType budgie_raven_expander_type_id;
		budgie_raven_expander_type_id = g_type_register_static (gtk_box_get_type (), "BudgieRavenExpander", &g_define_type_info, 0);
		g_once_init_leave (&budgie_raven_expander_type_id__volatile, budgie_raven_expander_type_id);
	}
	return budgie_raven_expander_type_id__volatile;
}


static void _vala_budgie_raven_expander_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	switch (property_id) {
		case BUDGIE_RAVEN_EXPANDER_EXPANDED:
		g_value_set_boolean (value, budgie_raven_expander_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_raven_expander_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieRavenExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander);
	switch (property_id) {
		case BUDGIE_RAVEN_EXPANDER_EXPANDED:
		budgie_raven_expander_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



