/* powerstrip.c generated by valac 0.32.1, the Vala compiler
 * generated from powerstrip.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <gtk/gtk.h>


#define BUDGIE_TYPE_SCREEN_SAVER (budgie_screen_saver_get_type ())
#define BUDGIE_SCREEN_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREEN_SAVER, BudgieScreenSaver))
#define BUDGIE_IS_SCREEN_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREEN_SAVER))
#define BUDGIE_SCREEN_SAVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SCREEN_SAVER, BudgieScreenSaverIface))

typedef struct _BudgieScreenSaver BudgieScreenSaver;
typedef struct _BudgieScreenSaverIface BudgieScreenSaverIface;

#define BUDGIE_TYPE_SCREEN_SAVER_PROXY (budgie_screen_saver_proxy_get_type ())
typedef GDBusProxy BudgieScreenSaverProxy;
typedef GDBusProxyClass BudgieScreenSaverProxyClass;

#define BUDGIE_TYPE_SESSION_MANAGER (budgie_session_manager_get_type ())
#define BUDGIE_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SESSION_MANAGER, BudgieSessionManager))
#define BUDGIE_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SESSION_MANAGER))
#define BUDGIE_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SESSION_MANAGER, BudgieSessionManagerIface))

typedef struct _BudgieSessionManager BudgieSessionManager;
typedef struct _BudgieSessionManagerIface BudgieSessionManagerIface;

#define BUDGIE_TYPE_SESSION_MANAGER_PROXY (budgie_session_manager_proxy_get_type ())
typedef GDBusProxy BudgieSessionManagerProxy;
typedef GDBusProxyClass BudgieSessionManagerProxyClass;

#define BUDGIE_TYPE_POWER_STRIP (budgie_power_strip_get_type ())
#define BUDGIE_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStrip))
#define BUDGIE_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStripClass))
#define BUDGIE_IS_POWER_STRIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POWER_STRIP))
#define BUDGIE_IS_POWER_STRIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_POWER_STRIP))
#define BUDGIE_POWER_STRIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStripClass))

typedef struct _BudgiePowerStrip BudgiePowerStrip;
typedef struct _BudgiePowerStripClass BudgiePowerStripClass;
typedef struct _BudgiePowerStripPrivate BudgiePowerStripPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgiePowerStripSetupDbusData BudgiePowerStripSetupDbusData;

#define BUDGIE_TYPE_RAVEN (budgie_raven_get_type ())
#define BUDGIE_RAVEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN, BudgieRaven))
#define BUDGIE_RAVEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN, BudgieRavenClass))
#define BUDGIE_IS_RAVEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN))
#define BUDGIE_IS_RAVEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN))
#define BUDGIE_RAVEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN, BudgieRavenClass))

typedef struct _BudgieRaven BudgieRaven;
typedef struct _BudgieRavenClass BudgieRavenClass;
typedef struct _Block4Data Block4Data;

struct _BudgieScreenSaverIface {
	GTypeInterface parent_iface;
	void (*lock) (BudgieScreenSaver* self, GError** error);
};

struct _BudgieSessionManagerIface {
	GTypeInterface parent_iface;
	void (*Logout) (BudgieSessionManager* self, guint mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Logout_finish) (BudgieSessionManager* self, GAsyncResult* _res_, GError** error);
};

struct _BudgiePowerStrip {
	GtkEventBox parent_instance;
	BudgiePowerStripPrivate * priv;
};

struct _BudgiePowerStripClass {
	GtkEventBoxClass parent_class;
};

struct _BudgiePowerStripPrivate {
	BudgieScreenSaver* saver;
	BudgieSessionManager* session;
	GtkButton* lock_btn;
	GtkButton* power_btn;
};

struct _BudgiePowerStripSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgiePowerStrip* self;
	BudgieScreenSaver* _tmp0_;
	BudgieScreenSaver* _tmp1_;
	BudgieScreenSaver* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	BudgieSessionManager* _tmp5_;
	BudgieSessionManager* _tmp6_;
	BudgieSessionManager* _tmp7_;
	GError* _vala1_e;
	GtkButton* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	BudgiePowerStrip* self;
	BudgieRaven* raven;
};


static gpointer budgie_power_strip_parent_class = NULL;

GType budgie_screen_saver_proxy_get_type (void) G_GNUC_CONST;
guint budgie_screen_saver_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_screen_saver_get_type (void) G_GNUC_CONST;
void budgie_screen_saver_lock (BudgieScreenSaver* self, GError** error);
static void budgie_screen_saver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void budgie_screen_saver_proxy_lock (BudgieScreenSaver* self, GError** error);
static void budgie_screen_saver_proxy_budgie_screen_saver_interface_init (BudgieScreenSaverIface* iface);
static void _dbus_budgie_screen_saver_lock (BudgieScreenSaver* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_screen_saver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_screen_saver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_screen_saver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_screen_saver_unregister_object (gpointer user_data);
GType budgie_session_manager_proxy_get_type (void) G_GNUC_CONST;
guint budgie_session_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_session_manager_get_type (void) G_GNUC_CONST;
void budgie_session_manager_Logout (BudgieSessionManager* self, guint mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
void budgie_session_manager_Logout_finish (BudgieSessionManager* self, GAsyncResult* _res_, GError** error);
static void budgie_session_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void budgie_session_manager_proxy_Logout_async (BudgieSessionManager* self, guint mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void budgie_session_manager_proxy_Logout_finish (BudgieSessionManager* self, GAsyncResult* _res_, GError** error);
static void budgie_session_manager_proxy_budgie_session_manager_interface_init (BudgieSessionManagerIface* iface);
static void _dbus_budgie_session_manager_Logout (BudgieSessionManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_session_manager_Logout_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void budgie_session_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_session_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_session_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_session_manager_unregister_object (gpointer user_data);
GType budgie_power_strip_get_type (void) G_GNUC_CONST;
#define BUDGIE_POWER_STRIP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_POWER_STRIP, BudgiePowerStripPrivate))
enum  {
	BUDGIE_POWER_STRIP_DUMMY_PROPERTY
};
static void budgie_power_strip_setup_dbus_data_free (gpointer _data);
static void budgie_power_strip_setup_dbus (BudgiePowerStrip* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void budgie_power_strip_setup_dbus_finish (BudgiePowerStrip* self, GAsyncResult* _res_);
static gboolean budgie_power_strip_setup_dbus_co (BudgiePowerStripSetupDbusData* _data_);
static void budgie_power_strip_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType budgie_raven_get_type (void) G_GNUC_CONST;
BudgiePowerStrip* budgie_power_strip_new (BudgieRaven* raven);
BudgiePowerStrip* budgie_power_strip_construct (GType object_type, BudgieRaven* raven);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_);
void budgie_raven_set_expanded (BudgieRaven* self, gboolean exp);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda7_ (Block4Data* _data4_);
static void budgie_power_strip_lock_screen (BudgiePowerStrip* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (Block4Data* _data4_);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda9_ (BudgiePowerStrip* self, GObject* obj, GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void budgie_power_strip_finalize (GObject* obj);

static const GDBusArgInfo * const _budgie_screen_saver_dbus_arg_info_lock_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screen_saver_dbus_arg_info_lock_out[] = {NULL};
static const GDBusMethodInfo _budgie_screen_saver_dbus_method_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_budgie_screen_saver_dbus_arg_info_lock_in), (GDBusArgInfo **) (&_budgie_screen_saver_dbus_arg_info_lock_out)};
static const GDBusMethodInfo * const _budgie_screen_saver_dbus_method_info[] = {&_budgie_screen_saver_dbus_method_info_lock, NULL};
static const GDBusSignalInfo * const _budgie_screen_saver_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_screen_saver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_screen_saver_dbus_interface_info = {-1, "org.gnome.ScreenSaver", (GDBusMethodInfo **) (&_budgie_screen_saver_dbus_method_info), (GDBusSignalInfo **) (&_budgie_screen_saver_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_screen_saver_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_screen_saver_dbus_interface_vtable = {budgie_screen_saver_dbus_interface_method_call, budgie_screen_saver_dbus_interface_get_property, budgie_screen_saver_dbus_interface_set_property};
static const GDBusArgInfo _budgie_session_manager_dbus_arg_info_Logout_mode = {-1, "mode", "u"};
static const GDBusArgInfo * const _budgie_session_manager_dbus_arg_info_Logout_in[] = {&_budgie_session_manager_dbus_arg_info_Logout_mode, NULL};
static const GDBusArgInfo * const _budgie_session_manager_dbus_arg_info_Logout_out[] = {NULL};
static const GDBusMethodInfo _budgie_session_manager_dbus_method_info_Logout = {-1, "Logout", (GDBusArgInfo **) (&_budgie_session_manager_dbus_arg_info_Logout_in), (GDBusArgInfo **) (&_budgie_session_manager_dbus_arg_info_Logout_out)};
static const GDBusMethodInfo * const _budgie_session_manager_dbus_method_info[] = {&_budgie_session_manager_dbus_method_info_Logout, NULL};
static const GDBusSignalInfo * const _budgie_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_budgie_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_session_manager_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_session_manager_dbus_interface_vtable = {budgie_session_manager_dbus_interface_method_call, budgie_session_manager_dbus_interface_get_property, budgie_session_manager_dbus_interface_set_property};

void budgie_screen_saver_lock (BudgieScreenSaver* self, GError** error) {
	g_return_if_fail (self != NULL);
	BUDGIE_SCREEN_SAVER_GET_INTERFACE (self)->lock (self, error);
}


static void budgie_screen_saver_base_init (BudgieScreenSaverIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType budgie_screen_saver_get_type (void) {
	static volatile gsize budgie_screen_saver_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_screen_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenSaverIface), (GBaseInitFunc) budgie_screen_saver_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_screen_saver_type_id;
		budgie_screen_saver_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieScreenSaver", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_screen_saver_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_screen_saver_proxy_get_type);
		g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.ScreenSaver");
		g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_screen_saver_dbus_interface_info));
		g_type_set_qdata (budgie_screen_saver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_screen_saver_register_object);
		g_once_init_leave (&budgie_screen_saver_type_id__volatile, budgie_screen_saver_type_id);
	}
	return budgie_screen_saver_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieScreenSaverProxy, budgie_screen_saver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SCREEN_SAVER, budgie_screen_saver_proxy_budgie_screen_saver_interface_init) )
static void budgie_screen_saver_proxy_class_init (BudgieScreenSaverProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_screen_saver_proxy_g_signal;
}


static void budgie_screen_saver_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void budgie_screen_saver_proxy_init (BudgieScreenSaverProxy* self) {
}


static void budgie_screen_saver_proxy_lock (BudgieScreenSaver* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.ScreenSaver", "Lock");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void budgie_screen_saver_proxy_budgie_screen_saver_interface_init (BudgieScreenSaverIface* iface) {
	iface->lock = budgie_screen_saver_proxy_lock;
}


static void _dbus_budgie_screen_saver_lock (BudgieScreenSaver* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_screen_saver_lock (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_screen_saver_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Lock") == 0) {
		_dbus_budgie_screen_saver_lock (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_screen_saver_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_screen_saver_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_screen_saver_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_screen_saver_dbus_interface_info), &_budgie_screen_saver_dbus_interface_vtable, data, _budgie_screen_saver_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_screen_saver_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void budgie_session_manager_Logout (BudgieSessionManager* self, guint mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BUDGIE_SESSION_MANAGER_GET_INTERFACE (self)->Logout (self, mode, _callback_, _user_data_);
}


void budgie_session_manager_Logout_finish (BudgieSessionManager* self, GAsyncResult* _res_, GError** error) {
	BUDGIE_SESSION_MANAGER_GET_INTERFACE (self)->Logout_finish (self, _res_, error);
}


static void budgie_session_manager_base_init (BudgieSessionManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType budgie_session_manager_get_type (void) {
	static volatile gsize budgie_session_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_session_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieSessionManagerIface), (GBaseInitFunc) budgie_session_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_session_manager_type_id;
		budgie_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieSessionManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_session_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_session_manager_proxy_get_type);
		g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
		g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_session_manager_dbus_interface_info));
		g_type_set_qdata (budgie_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_session_manager_register_object);
		g_once_init_leave (&budgie_session_manager_type_id__volatile, budgie_session_manager_type_id);
	}
	return budgie_session_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieSessionManagerProxy, budgie_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SESSION_MANAGER, budgie_session_manager_proxy_budgie_session_manager_interface_init) )
static void budgie_session_manager_proxy_class_init (BudgieSessionManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_session_manager_proxy_g_signal;
}


static void budgie_session_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void budgie_session_manager_proxy_init (BudgieSessionManagerProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void budgie_session_manager_proxy_Logout_async (BudgieSessionManager* self, guint mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Logout");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (mode));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void budgie_session_manager_proxy_Logout_finish (BudgieSessionManager* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void budgie_session_manager_proxy_budgie_session_manager_interface_init (BudgieSessionManagerIface* iface) {
	iface->Logout = budgie_session_manager_proxy_Logout_async;
	iface->Logout_finish = budgie_session_manager_proxy_Logout_finish;
}


static void _dbus_budgie_session_manager_Logout (BudgieSessionManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint mode = 0U;
	GVariant* _tmp20_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_get_uint32 (_tmp20_);
	g_variant_unref (_tmp20_);
	budgie_session_manager_Logout (self, mode, (GAsyncReadyCallback) _dbus_budgie_session_manager_Logout_ready, invocation);
}


static void _dbus_budgie_session_manager_Logout_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	budgie_session_manager_Logout_finish ((BudgieSessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_session_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Logout") == 0) {
		_dbus_budgie_session_manager_Logout (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_session_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_session_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_session_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_session_manager_dbus_interface_info), &_budgie_session_manager_dbus_interface_vtable, data, _budgie_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_session_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void budgie_power_strip_setup_dbus_data_free (gpointer _data) {
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgiePowerStripSetupDbusData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void budgie_power_strip_setup_dbus (BudgiePowerStrip* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgiePowerStripSetupDbusData* _data_;
	BudgiePowerStrip* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgiePowerStripSetupDbusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_power_strip_setup_dbus);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_power_strip_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_power_strip_setup_dbus_co (_data_);
}


static void budgie_power_strip_setup_dbus_finish (BudgiePowerStrip* self, GAsyncResult* _res_) {
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void budgie_power_strip_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgiePowerStripSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_power_strip_setup_dbus_co (_data_);
}


static gboolean budgie_power_strip_setup_dbus_co (BudgiePowerStripSetupDbusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_SCREEN_SAVER_PROXY, 0, NULL, budgie_power_strip_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", "g-interface-info", g_type_get_qdata (BUDGIE_TYPE_SCREEN_SAVER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (BudgieScreenSaver*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->saver);
		_data_->self->priv->saver = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("powerstrip.vala:43: Unable to contact login manager: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally6:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_state_ = 2;
		g_async_initable_new_async (BUDGIE_TYPE_SESSION_MANAGER_PROXY, 0, NULL, budgie_power_strip_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (BUDGIE_TYPE_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = (BudgieSessionManager*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->self->priv->session);
		_data_->self->priv->session = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->power_btn;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp8_, FALSE);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_vala1_e;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("powerstrip.vala:50: Unable to contact GNOME Session: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally7:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgiePowerStrip* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->raven);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda4_ (Block4Data* _data4_) {
	BudgiePowerStrip* self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	{
		BudgieRaven* _tmp0_ = NULL;
		_tmp0_ = _data4_->raven;
		budgie_raven_set_expanded (_tmp0_, FALSE);
		g_spawn_command_line_async ("gnome-control-center", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("powerstrip.vala:75: Error invoking gnome-control-center: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda4_ (self);
}


static void __lambda7_ (Block4Data* _data4_) {
	BudgiePowerStrip* self;
	BudgieRaven* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->raven;
	budgie_raven_set_expanded (_tmp0_, FALSE);
	budgie_power_strip_lock_screen (self);
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda7_ (self);
}


static void __lambda8_ (Block4Data* _data4_) {
	BudgiePowerStrip* self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	{
		BudgieRaven* _tmp0_ = NULL;
		BudgieSessionManager* _tmp1_ = NULL;
		BudgieSessionManager* _tmp2_ = NULL;
		_tmp0_ = _data4_->raven;
		budgie_raven_set_expanded (_tmp0_, FALSE);
		_tmp1_ = self->priv->session;
		if (_tmp1_ == NULL) {
			return;
		}
		_tmp2_ = self->priv->session;
		budgie_session_manager_Logout (_tmp2_, (guint) 0, NULL, NULL);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("powerstrip.vala:102: Error invoking end session dialog: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ (self);
}


static void __lambda9_ (BudgiePowerStrip* self, GObject* obj, GAsyncResult* res) {
	BudgieScreenSaver* _tmp0_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->saver;
	if (_tmp0_ != NULL) {
		GtkButton* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		_tmp1_ = self->priv->lock_btn;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->priv->lock_btn;
		gtk_widget_show_all ((GtkWidget*) _tmp2_);
	}
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda9_ ((BudgiePowerStrip*) self, source_object, res);
	g_object_unref (self);
}


BudgiePowerStrip* budgie_power_strip_construct (GType object_type, BudgieRaven* raven) {
	BudgiePowerStrip * self = NULL;
	Block4Data* _data4_;
	BudgieRaven* _tmp0_ = NULL;
	BudgieRaven* _tmp1_ = NULL;
	GtkBox* bottom = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkButton* btn = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkStyleContext* _tmp27_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = raven;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->raven);
	_data4_->raven = _tmp1_;
	self = (BudgiePowerStrip*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 20);
	g_object_ref_sink (_tmp2_);
	bottom = _tmp2_;
	gtk_widget_set_margin_top ((GtkWidget*) self, 10);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, "raven-header");
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp4_, "powerstrip");
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp5_, "bottom");
	gtk_widget_set_halign ((GtkWidget*) bottom, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) bottom, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) bottom, 5);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) bottom);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "primary-control");
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("preferences-system-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp7_);
	btn = _tmp7_;
	_tmp8_ = btn;
	g_signal_connect_data (_tmp8_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp9_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	_tmp10_ = btn;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, "flat");
	_tmp12_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("system-lock-screen-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (btn);
	btn = _tmp13_;
	_tmp14_ = btn;
	g_signal_connect_data (_tmp14_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp15_ = btn;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->lock_btn);
	self->priv->lock_btn = _tmp16_;
	_tmp17_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	_tmp18_ = btn;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, "flat");
	_tmp20_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("system-shutdown-symbolic", GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (btn);
	btn = _tmp21_;
	_tmp22_ = btn;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->power_btn);
	self->priv->power_btn = _tmp23_;
	_tmp24_ = btn;
	g_signal_connect_data (_tmp24_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp25_ = btn;
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_START);
	_tmp26_ = btn;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
	gtk_style_context_add_class (_tmp27_, "flat");
	_tmp28_ = btn;
	gtk_box_pack_start (bottom, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	_tmp29_ = self->priv->lock_btn;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = self->priv->lock_btn;
	gtk_widget_hide ((GtkWidget*) _tmp30_);
	budgie_power_strip_setup_dbus (self, ___lambda9__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (btn);
	_g_object_unref0 (bottom);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}


BudgiePowerStrip* budgie_power_strip_new (BudgieRaven* raven) {
	return budgie_power_strip_construct (BUDGIE_TYPE_POWER_STRIP, raven);
}


static void budgie_power_strip_lock_screen (BudgiePowerStrip* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieScreenSaver* _tmp0_ = NULL;
		_tmp0_ = self->priv->saver;
		budgie_screen_saver_lock (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("powerstrip.vala:124: Cannot lock screen: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_power_strip_class_init (BudgiePowerStripClass * klass) {
	budgie_power_strip_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgiePowerStripPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_power_strip_finalize;
}


static void budgie_power_strip_instance_init (BudgiePowerStrip * self) {
	self->priv = BUDGIE_POWER_STRIP_GET_PRIVATE (self);
	self->priv->saver = NULL;
	self->priv->session = NULL;
	self->priv->lock_btn = NULL;
	self->priv->power_btn = NULL;
}


static void budgie_power_strip_finalize (GObject* obj) {
	BudgiePowerStrip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_POWER_STRIP, BudgiePowerStrip);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->lock_btn);
	_g_object_unref0 (self->priv->power_btn);
	G_OBJECT_CLASS (budgie_power_strip_parent_class)->finalize (obj);
}


GType budgie_power_strip_get_type (void) {
	static volatile gsize budgie_power_strip_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_power_strip_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgiePowerStripClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_power_strip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePowerStrip), 0, (GInstanceInitFunc) budgie_power_strip_instance_init, NULL };
		GType budgie_power_strip_type_id;
		budgie_power_strip_type_id = g_type_register_static (gtk_event_box_get_type (), "BudgiePowerStrip", &g_define_type_info, 0);
		g_once_init_leave (&budgie_power_strip_type_id__volatile, budgie_power_strip_type_id);
	}
	return budgie_power_strip_type_id__volatile;
}



