#ifndef FOLDER_LIST_H
#define FOLDER_LIST_H

/*
 * Folder list widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <libbuffy/MailFolder.h>

#include <sigc++/sigc++.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/treemodelsort.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/menu.h>

class FolderList : public Gtk::VBox, public MailFolderConsumer
{
public:
	typedef SigC::Signal1<void, MailFolder> type_signal_open_folder;

protected:

	Gtk::TreeView folderList;
	Glib::RefPtr<Gtk::ListStore> folderListModel;
	Glib::RefPtr<Gtk::TreeModelFilter> filteredModel;
	Glib::RefPtr<Gtk::TreeModelSort> sortedModel;
	Gtk::ScrolledWindow scrolledFolderList;

	bool viewEmpty, viewRead, viewImportant;

	/*
	Glib::ustring filter;

	Gtk::HBox filterHBox;
	Gtk::Label filterLabel;
	Gtk::Entry filterEdit;
	Gtk::Menu itemPopup;

	std::vector<std::string> selected;
	*/
	
	// Tree model columns
	class FolderListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		FolderListModelColumns() { add(folder); add(name); add(msg_new); add(msg_unread); add(msg_total); add(msg_flagged); }

		Gtk::TreeModelColumn<MailFolder> folder;
		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn<int> msg_new;
		Gtk::TreeModelColumn<int> msg_unread;
		Gtk::TreeModelColumn<int> msg_total;
		Gtk::TreeModelColumn<int> msg_flagged;
	};

	FolderListModelColumns folderListModelColumns;

	type_signal_open_folder _signal_open_folder;

	
	//void updateList();

	/*
	void on_filter_changed();
	void on_document_changed();
	*/
	bool on_event(GdkEvent* e);
	void on_row_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn*);
	bool filter_row(const Gtk::TreeModel::const_iterator& iter);

public:
	FolderList();
	virtual ~FolderList() {}

	void consume(MailFolder& folder);

	void clear();
	void do_update();
	bool do_timer_tick();

	void configureFilter(bool viewEmpty, bool viewRead, bool viewImportant);

	type_signal_open_folder signal_open_folder() throw ()
		{ return _signal_open_folder; }


	/*
	std::map< std::string, Tagcoll::TagSet > getAllFolders();
	std::map< std::string, Tagcoll::TagSet > getSelection();
	int getSelectionSize();
	*/

	//type_signal_changed signal_changed() throw () { return _signal_changed; }
	//virtual void do_changed();

	/*
	virtual void do_selection_changed();
	virtual void do_focus_in();
	virtual void on_itemList_drag_data_get(
			const Glib::RefPtr<Gdk::DragContext>&, Gtk::SelectionData& selection_data, guint, guint);
	virtual void on_itemList_drop_drag_data_received(
			const Glib::RefPtr<Gdk::DragContext>& context, int, int, const Gtk::SelectionData& selection_data, guint, guint time);
	virtual bool on_focus_in(GdkEventFocus*);

	// Signals
	type_signal_selection_changed signal_selection_changed() throw ()
		{ return _signal_selection_changed; }
	type_signal_focus_in signal_focus_in() throw ()
		{ return _signal_focus_in; }
	type_signal_request_tagcoll_change signal_request_tagcoll_change() throw ()
		{ return _signal_request_tagcoll_change; }
	type_signal_request_tagset_merge signal_request_tagset_merge() throw ()
		{ return _signal_request_tagset_merge; }
	type_signal_request_tagset_intersect signal_request_tagset_intersect() throw ()
		{ return _signal_request_tagset_intersect; }
	type_signal_request_item_copy signal_request_item_copy() throw ()
		{ return _signal_request_item_copy; }
	type_signal_request_item_move signal_request_item_move() throw ()
		{ return _signal_request_item_move; }
	type_signal_select_tagset signal_select_tagset() throw ()
		{ return _signal_select_tagset; }
	type_signal_select_tagset_other_panel signal_select_tagset_other_panel() throw ()
		{ return _signal_select_tagset_other_panel; }
	*/
};

// vim:set ts=4 sw=4:
#endif
