# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

from optparse import OptionParser

try:
    import utils
except:
    import launchpadBugs.utils as utils

class commandLine:
    def __init__(self, prog=None):
        parser = OptionParser(version=utils.find_version_number())
        if parser.get_prog_name() == "bughelper" or prog == "bughelper":
            parser.set_defaults(attachments=False, sourcepackage=None, 
                                url="", minbug=None, verbose=0,
                                case_sensitive=False,file=None)
            parser.set_usage(usage="""%prog --version
       %prog -p <source package> 
       %prog -l <Launchpad-URL>
       %prog -b <LP-Bugnumber>
Options:
    [-A]                                search in attachments too
    [-m <minimum bug number>]           only search in bugs with bug numbers 
                                        higher than <number>
    [-f <filter bugs listed>]           filter out certain bugs (also 
                                        comma-separated lists)
    [--status <status>]                 filter on given status
    [--importance <importance>]         filter on given importance
    [-v <number>]                       display inherited clues
    [-t <package> <condition> <info>]   try to find the <condition> and 
                                        display <info> when found (in addition 
                                        to stored clues)
    [-T <package> <condition> <info>]   try to find the <condition> and display 
                                        <info> when found (disregarding stored
                                        clues)
    [--format=<plain|html|wiki>]        format the output, default is plain
    [-c]                                case sensitive (off by default)
    [--closed]                          also look at closed bugs
    [--dups]                            also look at duplicates
    [-U]                                also consider upstream bugs (only in 
                                        combination with -p <package>
    [-H]                                use all clue files, if a bug has no
                                        source package assigned or no clue file
                                        for that package exists
    [--tag <tag>]                       filter on given tag
    [--lc <reporter|LP-user>]           filter on last comment
    [--reporter <reporter,...>]         filter on initial reporter
    [--nd (<|>)<int>]                   filter on given number of duplicates
    [--footer (s|t|st)]                 show (s)tatistical or date/(t)ime information
                                        in the footer, (st) for both
    [--cookie <filename>]               valid cookie-file for authentication
    [--debug]                           print debug information to stderr
    [--ignore_conflicts]                ignore conflicts in filter options""")
            parser.add_option("-p", "--package", type="string", 
                                    dest="sourcepackage", 
                                    metavar="package name", 
                                    help="Package")
            parser.add_option("-l", "--url", type="string", dest="url", 
                                    metavar="url", help="bug list URL")
            parser.add_option("-b", "--bugnr", type="int", dest="bugnr", 
                                    metavar="bugnr", help="Bugnumber")
            parser.add_option("-A", "--attachments", action="store_true", 
                                    dest="attachments", metavar="Attachments", 
                                    help="search attachments")
            parser.add_option("-m", "--minbug", type="int", dest="minbug",
                                    help="minimum bug number to search")
            parser.add_option("-f", "--filterbug", type="string", 
                                    dest="filterbug",
                                    help="doesn't print the bug numbers listed")
            parser.add_option("-v", "--verbose", type="int", dest="verbose",
                                    help="display inherited clues")
            parser.add_option("-t", "--try", type="string", nargs=3, 
                                    dest="try_clue", help="try clue")
            parser.add_option("-T", "--try-only", type="string", nargs=3,
                                    dest="try_only_clue", help="try only clue")
            parser.add_option("--format", type="string", dest="format", 
                                    default="plain", 
                                    help="format output type (plain|wiki|html)")
            parser.add_option("-c", "--case-sensitive", action="store_true", 
                                    dest="case_sensitive",
                                    metavar="Case Sensitive",
                                    help="case sensitive")
            parser.add_option("-C", "--closed", action="store_true", 
                                    dest="closed_bugs", metavar="closed bugs", 
                                    help="also look at closed bugs")
            parser.add_option("-d", "--dups", action="store_true", 
                                    dest="duplicates", metavar="duplicates", 
                                    help="also look at duplicates")
            parser.add_option("-U", "--upstream", action="store_true", 
                                    dest="upstream", metavar="upstream", 
                                    help="also consider upstream bugs")
            parser.add_option("-H", "--heuristic", action="store_true", 
                                    dest="heuristic", metavar="heuristic", 
                                    help="use all clue files, if no source \
package specified or no clue file exists")
            parser.add_option("--gen-config", action="store_true", 
                              dest="gen_config",
                              help="generate default config file")
            parser.add_option("--status", type="string", dest="status",
                              default="", help="status")
            parser.add_option("--importance", type="string", dest="importance",
                              default="", help="bug importance")
            parser.add_option("--tag", type="string", dest="tag",
                              default="", help="bug tag")
            parser.add_option("--lc", type="string", dest="lastcomment",
                              default="", help="filter on author of the last comment")
            parser.add_option("--reporter", type="string", dest="reporter",
                              default="", help="filter on the reporter")
            parser.add_option("--nd", type="string", dest="no_duplicates",
                              default="", help="number of duplicates")
            parser.add_option("--file", type="string", dest="file",
                              default="", help="print to file")
            parser.add_option("--footer", type="string", dest="footer",
                              default="", help="print information in the footer")
            parser.add_option("--cookie", type="string", dest="cookie",
                              default="", help="valid cookie-file for authentication")
            parser.add_option("--debug", action="store_true", dest="debug",
                              help="print debug infos to stderr")
            parser.add_option("--ignore_conflicts", action="store_true",
                                    dest="ignore_conflicts", 
                                    help="ignore conflicts in filter options")

        if parser.get_prog_name() == "bugnumbers":
            parser.set_defaults(package=None, url="", minbug=None,file=None)
            parser.set_usage(usage="""%prog --version
       %prog -p <package>
       %prog -l <Launchpad-URL>
Options:
    [-m <minimum bug number>]           only search in bugs with bug numbers higher 
                                        than <number>
    [-f <filter bugs listed>]           filter out certain bugs (also comma-separated 
                                        lists)
    [-U]                                also consider upstream bugs (only in 
                                        combination with -p <package>
    [--closed]                          also look at closed bugs
    [--dups]                            also look at duplicates
    [--count]                           count the number of comments
    [--stats]                           list statistical information
    [--status <status>]                 filter on given status
    [--importance <importance>]         filter on given importance
    [--sort <option>]                   sort output
    [--nd (<|>)<int>]                   filter on given number of duplicates
    [--tag <tag>]                       filter on given tag
    [--lc <reporter|LP-user>]           filter on last comment
    [--reporter <reporter,...>]         filter on initial reporter
    [--format=<plain|html|wiki>]        format the output, default is plain
    [--footer (s|t|st)]                 show (s)tatistical or date/(t)ime information
                                        in the footer, (st) for both for html output only
    [--cookie <filename>]               valid cookie-file for authentication
    [--ignore_conflicts]                ignore conflicts in filter options""")

            parser.add_option("-p", "--package", type="string", 
                                    dest="sourcepackage", 
                                    metavar="package name", help="Package")
            parser.add_option("-l", "--url", type="string", dest="url", 
                                    metavar="URL", help="bug list URL")
            parser.add_option("--stats", action="store_true",
                                    dest="stats", 
                                    help="lists statistical information")
            parser.add_option("-m", "--minbug", type="int", dest="minbug",
                                    help="minimum bug number to search")
            parser.add_option("-f", "--filterbug", type="string", 
                                    dest="filterbug",
                                    help="doesn't print the bug numbers listed")
            parser.add_option("-U", "--upstream", action="store_true", 
                                    dest="upstream", metavar="upstream", 
                                    help="also consider upstream bugs")
            parser.add_option("-C", "--closed", action="store_true", 
                                    dest="closed_bugs", metavar="closed bugs", 
                                    help="also look at closed bugs")
            parser.add_option("-d", "--dups", action="store_true", 
                                    dest="duplicates", metavar="duplicates", 
                                    help="also look at duplicates")
            parser.add_option("--count", action="store_true",
                                    dest="count", 
                                    help="counts the number of comments") 
            parser.add_option("--status", type="string", dest="status",
                              default="", help="status")
            parser.add_option("--importance", type="string", dest="importance",
                              default="", help="bug importance")
            parser.add_option("--tag", type="string", dest="tag",
                              default="", help="bug tag")
            parser.add_option("--nd", type="string", dest="no_duplicates",
                              default="", help="number of duplicates")
            parser.add_option("--sort", type="string", dest="sort",
                              default="", help="sort output")
            parser.add_option("--lc", type="string", dest="lastcomment",
                              default="", help="filter on author of the last comment")
            parser.add_option("--reporter", type="string", dest="reporter",
                              default="", help="filter on the reporter")
            parser.add_option("--file", type="string", dest="file",
                              default="", help="print to file")
            parser.add_option("--format", type="string", dest="format", 
                                    default="plain", 
                                    help="format output type (plain|wiki|html)")
            parser.add_option("--footer", type="string", dest="footer",
                              default="", help="print information in the footer")
            parser.add_option("--cookie", type="string", dest="cookie",
                              default="", help="valid cookie-file for authentication")
            parser.add_option("--ignore_conflicts", action="store_true",
                                    dest="ignore_conflicts", 
                                    help="ignore conflicts in filter options")


        if parser.get_prog_name() == "bugxml":
            parser.set_defaults(text='', clue='', package='')
            parser.set_usage(usage="""%prog --version
       %prog -e <text>
       %prog -v <clue file>
       %prog -a <package> <condition> <clue>
Options:
 to -a <package> <condition> <clue>:
    [-d <list of bugs>]         dont list listed bugs (comma separated list or
                                simple value""")
            parser.add_option("-e", type="string", dest="text", metavar="text", 
                                    help="text")
            parser.add_option("-v", type="string", dest="cluefile", 
                                    metavar="clue", help="clue file")
            parser.add_option("-a", "--simple-add", type="string", nargs=3, 
                                     dest="add", metavar="package name", 
                                     help="Package")
            parser.add_option("-d", "--dont-list", type="string", 
                                    dest="dontlist", metavar="dontlist", 
                                    help="add a dontlist tag to XML")

        if parser.get_prog_name() == "buginfo":
            parser.set_defaults(bugnr=None)
            parser.set_usage(usage="""%prog --version
       %prog --bugnr <Launchpad-Bug-Number>
Options:
    [--comments]                   list and count comments
    [--reporter]                   show reporter of a bug
    [--tags]                       list tags
    [--title]                      show title
    [--countcomments]              number of comments
    [-v]                           verbose output
    [--comment <num>]              show comment number <num>
    [--lastcomment]                show last comment
        [--author]                 show author of a comment
        [--date]                   show date of a comment""")
            parser.add_option("--bugnr", type="string", 
                                    dest="bugnr", 
                                    metavar="bugnumber", help="Launchpad-Bug-Number")
            parser.add_option("--comments", action="store_true",
                                    dest="comments", 
                                    help="list and count comments")
            parser.add_option("--reporter", action="store_true",
                                    dest="reporter", 
                                    help="show reporter of a bug") 
            parser.add_option("--tags", action="store_true",
                                    dest="tags", 
                                    help="list tags")
            parser.add_option("--title", action="store_true",
                                    dest="title", 
                                    help="show title")
            parser.add_option("--isduplicate", action="store_true",
                                    dest="isduplicate", 
                                    help="show what the bug is a duplicate of")
            parser.add_option("--countcomments", action="store_true",
                                    dest="countcomments", 
                                    help="number of comments")
            parser.add_option("-c", "--comment", type="int", dest="comment",
                                    help="show a certain comment")
            parser.add_option("-v", "--verbose", action="store_true", dest="verbose",
                                    help="verbose")
            parser.add_option("--author", action="store_true",
                                    dest="author", 
                                    help="show author of a comment")
            parser.add_option("--date", action="store_true",
                                    dest="date", 
                                    help="show date of a comment")
            parser.add_option("--lastcomment", action="store_true",
                                    dest="lastcomment", 
                                    help="show last comment")
        # options with arguments
        self.parser = parser
        if not prog:
            (self.options, self.args) = parser.parse_args()

