### BEGIN LICENSE
# Copyright (C) 2009 Rick Spencer rick.spencer@canonical.com
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3, as published 
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
try:
 import pygtk
 pygtk.require("2.0")
 import gtk
 import gobject
 import os
 from BugsPane import BugsPane
 from FindPackageDialog import FindPackageDialog
 from quickly.widgets.asynch_task_progressbox import AsynchTaskProgressBox
 import LaunchpadUtils

 from bughugger.bughuggerconfig import getdatapath


except Exception, inst:
 print "some dependencies for BugsPane are not available"
 raise inst

class TriageBugsPage(gtk.Frame):
 """TriageBugsPane: A widget to display bug_tasks for use as a tab in a tabbed UI.
 Handles showing a dialog to allow the user to search launchpad for a package
 and presents the new bug_tasks related to that package.

 """

 def __init__(self,launchpad,bug_task_list, keys=None):
  """Create an TeamBugsPage

  arguments:
  launchpad -- an instantiated launchpad instance
  bug_task_list -- a list of dictionaries that have bug_task data to display


  """

  gtk.Frame.__init__(self)
  self.launchpad = launchpad

  self.builder = gtk.Builder()
  ui_filename = os.path.join(getdatapath(), 'ui', 'TriageBugsPage.ui')

  self.builder.add_from_file(ui_filename)
  vbox = self.builder.get_object("vbox")
  self.builder.connect_signals(self)
  self.add(vbox)

  plugin_path = []
  plugin_path.append(os.path.join(os.environ["HOME"], ".bughugger", "plugins"))
  plugin_path.append("/usr/lib/bughugger/plugins")
  for path in plugin_path:
    sys.path.append(path)
 
  gtk.gdk.threads_enter() #stop main UI thread while updating ui
  self.__bug_pane = BugsPane(bug_task_list,keys)
  self.__bug_pane.connect("selection_changed",self.selection_changed)
  self.builder.get_object("bug_pane_frame").add(self.__bug_pane)
  self.__bug_pane.show()

  for path in plugin_path:
    #walk the directory
    for root, dirs, files in os.walk(path):
    #only load specific files as modules
      for f in files:
        if f.startswith("Plugin") and f.endswith(".py"):
          aMod = __import__(f.split(".")[0], globals(), locals(), [''])
          plugin = aMod.InitializePlugin(self.launchpad)
          button = gtk.ToolButton(None, plugin.buttontext)
          button.set_is_important(True)
          button.set_use_underline(True)
          button.show()
          button.connect("clicked",self.__plugin_action, (plugin.action, plugin.hide))
    
          toolbar = self.builder.get_object("toolbar1")
          toolbar.insert(button,toolbar.get_n_items())

  gtk.gdk.threads_leave()

 def __plugin_action(self, widget, data):
  func, hide = data

  #make a list of bug_tasks to pass to the function
  bug_tasks = []
  for row in self.__bug_pane.grid.selected_rows:
   if "__bug_task" not in row:
    if "__url" in row:
        print row["__url"]
        row["__bug_task"] = self.launchpad.load(row["__url"])
    else:
        print "no bug_task object found ... skipping"
  
   if "__bug_task" in row:
    bug_tasks.append(row["__bug_task"])

   #now pass in the list
  func(bug_tasks)

 def selection_changed(self, widget, bug_tasks = None):
  """selection_changed: called when the selection changes in the BugPane.
  Displays selected bug properly in the description view.
  Supplied bug_tasks is a list of bug_tasks selected in the BugPane treeview.

  """
  buff = self.builder.get_object("description_textview").get_buffer()
  if len(bug_tasks) > 1:
   #for multi-select show the count and titles in the description area
   txt = str(len(bug_tasks)) + " bug tasks selected:\n"
   for b in bug_tasks:
    try:
        txt += b["id"] + ": "
    except:
        pass
    try:
        txt += b["title"] + "\n"
    except:
        pass
   buff.set_text(txt)
  elif len(bug_tasks) == 1:
   #for a single select show the description for the selected bug_task
   
   #if there is no bug task in the dictionary, get the description
   #from launchpad, otherwise, get the description from the
   #bug task
   #TODO: Should store the description and use that if available
   if "__description" in bug_tasks[0]:
    description = bug_tasks[0]["__description"]
    self.__display_bug_description(self, (bug_tasks[0],description) )
   else:
    params = {"bug_task":bug_tasks[0]}
    task = AsynchTaskProgressBox(self.__get_description_async, params)
    task.connect("complete",self.__display_bug_description)
    task.start()

  else:
   buff.set_text("no bug tasks selected")

 def __get_description_async(self, params):
  bug_task = params["bug_task"]  
  bug_id = int(bug_task["id"])
  description = self.launchpad.bugs[bug_id].description
  bug_task["__description"] = description
  return (bug_task, description)

 def __display_bug_description(self, widget, data):
  bug_task, description = data
  buff = self.builder.get_object("description_textview").get_buffer()
  title = ""
  try:
   title = bug_tasks[0]["title"]
  except:
   pass
  if description == None:
   description = ""
  txt = title + "\n\n" + description
  buff.set_text(txt)


 def previous(self, widget, data = None):
  """previous: signal handler to select the bug_task previous in the list."""
  self.__bug_pane.select_previous()

 def next(self, widget, data = None):
  """next: signal handler to select the bug_task next in the list."""
  self.__bug_pane.select_next()

class PageTab(gtk.HBox):
 def __init__(self, label, pane):
  gtk.HBox.__init__(self,False,5)
  self.pack_start(label, False, False)
  label.show()
  close_button = gtk.Button()
  img = gtk.image_new_from_stock(gtk.STOCK_CLOSE, gtk.ICON_SIZE_SMALL_TOOLBAR)
  img.show()
  close_button.set_property("image",img)
  close_button.show()
  self.pack_end(close_button, False, False)
  close_button.connect("clicked", self.close_requested, pane)

 def close_requested(self, widget, pane):
  self.emit("close_requested",pane)

 __gsignals__ = {'close_requested' : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
        (gobject.TYPE_PYOBJECT,)),
        }
  
