#!/bin/sh
# https://bugs.launchpad.net/ubuntu/+source/bugzilla/+bug/419335
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

diff -Naur a/Bugzilla/Install/Filesystem.pm b/Bugzilla/Install/Filesystem.pm
--- a/Bugzilla/Install/Filesystem.pm	2010-07-14 01:09:27.000000000 +0200
+++ b/Bugzilla/Install/Filesystem.pm	2010-08-08 18:13:35.534125065 +0200
@@ -176,7 +176,7 @@
                                   dirs => $ws_dir_writeable },
          $webdotdir         => { files => $ws_writeable,
                                   dirs => $ws_dir_writeable },
-         graphs             => { files => $ws_writeable,
+         "$datadir/graphs"  => { files => $ws_writeable,
                                   dirs => $ws_dir_writeable },
 
          # Readable directories
@@ -228,7 +228,7 @@
         "$datadir/extensions"   => $ws_dir_readable,
         $attachdir              => $ws_dir_writeable,
         $extensionsdir          => $ws_dir_readable,
-        graphs                  => $ws_dir_writeable,
+        "$datadir/graphs"       => $ws_dir_writeable,
         $webdotdir              => $ws_dir_writeable,
         "$skinsdir/custom"      => $ws_dir_readable,
         "$skinsdir/contrib"     => $ws_dir_readable,
@@ -358,10 +358,10 @@
     my %files = %{$fs->{create_files}};
 
     my $datadir = bz_locations->{'datadir'};
-    # If the graphs/ directory doesn't exist, we're upgrading from
+    # If the $datadir/graphs/ directory doesn't exist, we're upgrading from
     # a version old enough that we need to update the $datadir/mining 
     # format.
-    if (-d "$datadir/mining" && !-d 'graphs') {
+    if (-d "$datadir/mining" && !-d "$datadir/graphs") {
         _update_old_charts($datadir);
     }
 
diff -Naur a/collectstats.pl b/collectstats.pl
--- a/collectstats.pl	2010-07-06 20:20:12.000000000 +0200
+++ b/collectstats.pl	2010-08-08 18:17:23.746133772 +0200
@@ -49,9 +49,11 @@
 # in the regenerate mode).
 $| = 1;
 
+my $datadir = bz_locations()->{'datadir'};
+
 # Tidy up after graphing module
 my $cwd = Cwd::getcwd();
-if (chdir("graphs")) {
+if (chdir("$datadir/graphs")) {
     unlink <./*.gif>;
     unlink <./*.png>;
     # chdir("..") doesn't work if graphs is a symlink, see bug 429378
@@ -68,8 +70,6 @@
     $regenerate = 1;
 }
 
-my $datadir = bz_locations()->{'datadir'};
-
 my @myproducts = map {$_->name} Bugzilla::Product->get_all;
 unshift(@myproducts, "-All-");
 
