# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'cualquiera',
    blacklisted => '(censuradas)',
    checking_for => 'Comprobando',
    checking_dbd      => 'Comprobando los módulos perl DBD disponibles...',
    checking_optional => 'Los siguientes módulos de Perl modules son opcionales:',
    checking_modules  => 'Comprobando módulos de perl...',
    chmod_failed      => '##path##: Fallo al cambiar los permisos: ##error##',
    chown_failed      => '##path##: Fallo al cambiar el propietario: ##error##',
    commands_dbd      => <<EOT,
DEBE EJECUTAR UNO DE LOS SIGUIENTES COMANDOS (dependiendo de la base de datos
que use):
EOT
    commands_optional => 'COMANDOS PARA INSTALAR MODULOS OPCIONALES:',
    commands_required => <<EOT,
COMANDOS PARA INSTALAR MODULOS REQUERIDOS (Usted *debe* ejecutar todos estos comandos
y volver a ejecutar este script):
EOT
    done => 'hecho.',
    extension_must_return_name => <<END,
##file## devolvió ##returned##, que no es un nombre válido para una extensión.
Las extensiones deben devolver su nombre, no <code>1</code> o un número. Vea
la documentación de Bugzilla::Extension para más detalles.
END
    feature_auth_ldap         => 'Identificación LDAP',
    feature_auth_radius       => 'Identificación RADIUS',
    feature_graphical_reports => 'Informes gráficos',
    feature_html_desc         => 'Más HTML en las descripciones de producto o grupo',
    feature_inbound_email     => 'Correo entrante',
    feature_jobqueue          => 'Encolamiento de correo',
    feature_jsonrpc           => 'Interfaz JSON-RPC',
    feature_new_charts        => 'Nuevas gráficas',
    feature_old_charts        => 'Gráficas antiguas',
    feature_mod_perl          => 'mod_perl',
    feature_moving            => 'Mover bugs entre instalaciones',
    feature_patch_viewer      => 'Visor de parches',
    feature_smtp_auth         => 'Identificación SMTP',
    feature_updates           => 'Actualización automática de las notificaciones',
    feature_xmlrpc            => 'XML-RPC Interface',

    header => "* Esto es Bugzilla versión ##bz_ver## en perl ##perl_ver##\n"
            . "* Ejecutándose sobre ##os_name## ##os_ver##",
    install_all => <<EOT,

Para intentar una instalación automática de cada módulo requerido y opcional
con un comando, haga:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
AVISO: Algunos de los datos en la columna ##table##.##column## es mayor que
su nuevo límite de logitud, ##max_length## caracteres. Los datos que necesitan
corregirse se exponen debajo con el valor de la columna ##id_column## primero y
luego el valor de la columna ##column## que necesita corregirse:

EOT
    install_module => 'Installing ##module## version ##version##...',
    installation_failed => '*** Instalación abortada. Lea los mensajes de arriba. ***',
    max_allowed_packet => <<EOT,
AVISO: Es necesario establecer el parámetro max_allowed_packet en la configuración
de MySQL al menos a ##needed##. Actualmente el valor es ##current##.
Puede poner este parámetro en la sección [mysqld] del fichero
de configuración de MySQL.
EOT
    min_version_required => "Versión mínima requerida: ",

# Note: When translating these "modules" messages, don't change the formatting
# if possible, because there is hardcoded formatting in 
# Bugzilla::Install::Requirements to match the box formatting.
    modules_message_db => <<EOT,
***********************************************************************
* ACCESO A LA BASE DE DATOS                                           *
***********************************************************************
* Para acceder a la base de datos, Bugzilla requiere que el           *
* módulo "DBD" correcto esté instalado para la base de datos que esté *
* ejecutándose. Vea debajo el ccomando correcto para instalar el      *
* módulo apropiado para su base de datos.                             *
EOT
    modules_message_optional => <<EOT,
***********************************************************************
* MODULOS OPCIONALES                                                  *
***********************************************************************
* Ciertos módulos de Perl no son requeridos por Bugzilla, pero        *
* instalando las últimas versiones obtiene acceso a características   *
* adicionales.                                                        *
*                                                                     *
* Los módulos opcionales que no tiene instalados están debajo,        *
* con el nombre de la caracteristica que habilitan. Debajo están los  *
* comandos para instalar cada módulo.                                 *
EOT
    modules_message_required => <<EOT,
***********************************************************************
* MODULOS REQUERIDOS                                                  *
***********************************************************************
* Bugzilla requiere que instale algunos módulos de Perl que o bien    *
* faltan en su sistema, o la versión del sistema es demasiado vieja.  *
* Vea debajo los comandos para instalar estos módulos.                *
EOT

    module_found => "se ha encontrado v##ver##",
    module_not_found => "no se encuentra",
    module_ok => 'ok',
    module_unknown_version => "se ha encontrado una versión desconocida",
    ppm_repo_add => <<EOT,
***********************************************************************
* Nota para usuarios de Windows                                       *
***********************************************************************
* Para instalar los módulos listados debajo, antes tiene que ejecutr  * 
* el siguiente comando como un Administrador:                          *
*                                                                     *
*   ppm repo add theory58S ##theory_url##
EOT
    ppm_repo_up => <<EOT,
*                                                                     *
* Después, tiene que hacer (también como un Administrator):                     *
*                                                                     *
*   ppm repo up theory58S                                             *
*                                                                     *
* Repita este último comando una y otra vez hasta que vea "theory58S" *
* en la parte superior de la lista mostrada.                          *
EOT
    template_precompile   => "Precompilando plantillas...",
    template_removal_failed => <<END,
AVISO: El directorio '##datadir##/template' no se pudo eliminar.
         Se ha movido dentro de '##datadir##/deleteme', que debe ser
         borrado manualmente para conservar espacio en disco.
END
    template_removing_dir => "Eliminado las plantillas compiladas existentes...",
);

1;
