# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'tout',
    blacklisted => '(liste noire)',
    checking_for => 'Vérification de',
    checking_dbd      => 'Vérification des modules Perl DBD disponibles…',
    checking_optional => 'Les modules Perl suivants sont optionnels :',
    checking_modules  => 'Vérification des modules Perl…',
    chmod_failed      => '##path##: Échec du changement des permissions : ##error##',
    chown_failed      => '##path##: Échec du changement de propriétaire : ##error##',
    commands_dbd      => <<EOT,
VOUS DEVEZ EXÉCUTER UNE DES COMMANDES SUIVANTES (en fonction de la base de
données que vous utilisez) :
EOT
    commands_optional => 'COMMANDES POUR INSTALLER LES MODULES OPTIONNELS :',
    commands_required => <<EOT,
COMMANDES POUR INSTALLER LES MODULES NÉCESSAIRES (Vous *devez* exécuter toutes les
commandes puis ré-exécuter ce script) :
EOT
    done => 'terminé.',
    extension_must_return_name => <<END,
##file## a renvoyé ##returned##, qui n'est pas un nom d'extension valide.
Les extensions doivent renvoyer leur nom, pas <code>1</code> ou un nombre.
Consultez la documentation de Bugzilla::Extension pour des détails.
END
    feature_auth_ldap         => 'Authentification LDAP',
    feature_auth_radius       => 'Authentification RADIUS',
    feature_graphical_reports => 'Rapports graphiques',
    feature_html_desc         => 'Plus de HTML dans les descriptions des produits et des groupes',
    feature_inbound_email     => 'Courrier entrant',
    feature_jobqueue          => "File d'attente de courrier",
    feature_jsonrpc           => 'Interface JSON-RPC',
    feature_new_charts        => 'Nouveaux graphiques',
    feature_old_charts        => 'Anciens graphiques',
    feature_mod_perl          => 'mod_perl',
    feature_moving            => 'Déplacement de bogues entre installations',
    feature_patch_viewer      => 'Visionneuse de correctifs',
    feature_smtp_auth         => 'Authentification SMTP',
    feature_updates           => 'Notifications de mises à jour automatiques',
    feature_xmlrpc            => 'Interface XML-RPC',

    header => "* Bugzilla ##bz_ver## avec Perl ##perl_ver##\n"
            . "* sur ##os_name## ##os_ver##",
    install_all => <<EOT,

Pour essayer d'installer automatiquement chaque module obligatoire et optionnel
en une seule commande, exécutez :

  ##perl## install-module.pl --all

EOT
    install_data_too_long   => <<EOT,
ATTENTION : Certaines données dans la colonne ##table##.##column## dépassent la nouvelle longueur
limite de ##max_length## caractères. Les données devant être corrigées sont indiquées ci-dessous,
avec la valeur de la colonne ##id_column## d'abord puis la valeur de la colonne ##column## devant
être corrigées :

EOT
    install_module => 'Installation de ##module## version ##version##…',
    installation_failed => '*** Installation interrompue. Lire les messages ci-dessus. ***',
    max_allowed_packet => <<EOT,
ATTENTION : Vous devez définir le paramètre max_allowed_packet dans votre
configuration MySQL à au moins ##needed##. Actuellement, il est défini à ##current##.
Vous pouvez définir ce paramètre dans la section [mysqld] de votre fichier de
configuration MySQL.
EOT
    min_version_required => "Version minimale requise : ",

# Note: When translating these "modules" messages, don't change the formatting
# if possible, because there is hardcoded formatting in 
# Bugzilla::Install::Requirements to match the box formatting.
    modules_message_db => <<EOT,
***********************************************************************
* ACCÈS À LA BASE DE DONNÉES                                          *
***********************************************************************
* Afin d'accéder à votre base de données, Bugzilla a besoin que le    *
* bon module "DBD" correspondant à votre base de données soit         *
* installé. Regardez ci-dessous la commande correcte à exécuter pour  *
* installer le module correspondant à votre base de données.          *
EOT
    modules_message_optional => <<EOT,
***********************************************************************
* MODULES OPTIONNELS                                                  *
***********************************************************************
* Certains modules Perl ne sont pas indispensables pour Bugzilla,     *
* mais en installant la dernière version, vous pourrez accéder à des  *
* fonctionnalités supplémentaires.                                    *
*                                                                     *
* Les modules optionnels que vous n'avez pas installés sont listés    *
* ci-dessous, avec le nom de la fonctionnalité qu'ils activent. Sous  *
* ce tableau se trouvent les commandes pour installer chaque module.  *
EOT
    modules_message_required => <<EOT,
***********************************************************************
* MODULES NÉCESSAIRES                                                 *
***********************************************************************
* Bugzilla a besoin que vous installiez certains modules Perl qui     *
* sont soit absents de votre système, soit dont la version est trop   *
* ancienne. Voir ci-dessous les commandes pour installer ces modules. *
EOT

    module_found => "v##ver## trouvé",
    module_not_found => "non trouvé",
    module_ok => 'ok',
    module_unknown_version => "version inconnue trouvée",
    no_such_module => "Il n'y a pas de module dans CPAN appelé ##module##.",
    ppm_repo_add => <<EOT,
***********************************************************************
* Note pour les utilisateurs Windows                                  *
***********************************************************************
* Pour installer les modules listés ci-dessous, vous devez d'abord    * 
* exécuter la commande suivante en tant qu'administrateur :           *
*                                                                     *
*   ppm repo add theory58S ##theory_url##
EOT
    ppm_repo_up => <<EOT,
*                                                                     *
* Ensuite, toujours en tant qu'administrateur, vous devez exécuter :  *
*                                                                     *
*   ppm repo up theory58S                                             *
*                                                                     *
* Répétez cette dernière commande jusqu'à ce que vous voyiez          *
* "theory58S" en haut de la liste affichée.                           *
EOT
    template_precompile   => "Précompilation des modèles…",
    template_removal_failed => <<END,
ATTENTION : Le répertoire « ##datadir##/template » n'a pas pu être supprimé.
         Il a été déplacé dans « ##datadir##/deleteme », qui devra être
         supprimé manuellement afin de gagner de l'espace disque.
END
    template_removing_dir => "Suppression des modèles compilés existants…",
);

1;
