#ifndef PENDULUM_GOLD_H
#define PENDULUM_GOLD_H

#include "LinearMath/btScalar.h"

/*
sPendulumGold data was created using the Python script,
thanks to Andreas Bihlmaier for the script.

#!/usr/bin/env python

from __future__ import print_function

import numpy as np
from scipy import integrate
import pylab as pl
import math
import argparse

theta_pos = 0
dtheta_pos = 1

def pendulum_system(Y, t):
  m = 10  # [kg]
  g = 9.81  # [m/s^2]
  l = 0.5  # [m]
  tau = 20  # [Nm]
  I = m * pow(l, 2)  # inertia
  return [Y[dtheta_pos], (tau - m*g*l*math.sin(Y[theta_pos])) / I]

def main():
  parser = argparse.ArgumentParser()
  parser.add_argument('--plot', action='store_true', default=False, help='Plot results')
  args = parser.parse_args()

  t = np.arange(0, 2, 0.001) # [s]
  theta0 = 0
  dtheta0 = 0
  theta = integrate.odeint(pendulum_system, [theta0, dtheta0], t)  # [rad]
  print("timestamp;theta;")
  for i in range(theta.shape[0]):
    print("%f;%f;" % (t[i], theta[i,theta_pos]))

  if args.plot:
    pl.plot(t, theta[:,theta_pos], '+')
    pl.show()


if __name__ == '__main__':
  main()
*/

//sPendulumGold stores scalar values of a simulated pendulum in tuples 'timestamp' and 'theta joint angle'
static btScalar sPendulumGold[]= 
{
0.000000,0.000000,
0.001000,0.000004,
0.002000,0.000016,
0.003000,0.000036,
0.004000,0.000064,
0.005000,0.000100,
0.006000,0.000144,
0.007000,0.000196,
0.008000,0.000256,
0.009000,0.000324,
0.010000,0.000400,
0.011000,0.000484,
0.012000,0.000576,
0.013000,0.000676,
0.014000,0.000784,
0.015000,0.000900,
0.016000,0.001024,
0.017000,0.001155,
0.018000,0.001295,
0.019000,0.001443,
0.020000,0.001599,
0.021000,0.001763,
0.022000,0.001934,
0.023000,0.002114,
0.024000,0.002302,
0.025000,0.002497,
0.026000,0.002701,
0.027000,0.002913,
0.028000,0.003132,
0.029000,0.003359,
0.030000,0.003595,
0.031000,0.003838,
0.032000,0.004089,
0.033000,0.004348,
0.034000,0.004615,
0.035000,0.004890,
0.036000,0.005173,
0.037000,0.005464,
0.038000,0.005762,
0.039000,0.006069,
0.040000,0.006383,
0.041000,0.006706,
0.042000,0.007036,
0.043000,0.007374,
0.044000,0.007720,
0.045000,0.008073,
0.046000,0.008435,
0.047000,0.008804,
0.048000,0.009181,
0.049000,0.009566,
0.050000,0.009959,
0.051000,0.010360,
0.052000,0.010768,
0.053000,0.011184,
0.054000,0.011608,
0.055000,0.012040,
0.056000,0.012480,
0.057000,0.012927,
0.058000,0.013382,
0.059000,0.013845,
0.060000,0.014315,
0.061000,0.014794,
0.062000,0.015280,
0.063000,0.015773,
0.064000,0.016275,
0.065000,0.016784,
0.066000,0.017300,
0.067000,0.017825,
0.068000,0.018357,
0.069000,0.018896,
0.070000,0.019443,
0.071000,0.019998,
0.072000,0.020561,
0.073000,0.021131,
0.074000,0.021709,
0.075000,0.022294,
0.076000,0.022887,
0.077000,0.023487,
0.078000,0.024095,
0.079000,0.024710,
0.080000,0.025333,
0.081000,0.025964,
0.082000,0.026602,
0.083000,0.027247,
0.084000,0.027900,
0.085000,0.028560,
0.086000,0.029228,
0.087000,0.029903,
0.088000,0.030586,
0.089000,0.031276,
0.090000,0.031973,
0.091000,0.032678,
0.092000,0.033390,
0.093000,0.034110,
0.094000,0.034836,
0.095000,0.035570,
0.096000,0.036312,
0.097000,0.037061,
0.098000,0.037817,
0.099000,0.038580,
0.100000,0.039350,
0.101000,0.040128,
0.102000,0.040913,
0.103000,0.041705,
0.104000,0.042504,
0.105000,0.043311,
0.106000,0.044124,
0.107000,0.044945,
0.108000,0.045773,
0.109000,0.046608,
0.110000,0.047450,
0.111000,0.048299,
0.112000,0.049155,
0.113000,0.050019,
0.114000,0.050889,
0.115000,0.051766,
0.116000,0.052650,
0.117000,0.053542,
0.118000,0.054440,
0.119000,0.055345,
0.120000,0.056257,
0.121000,0.057176,
0.122000,0.058101,
0.123000,0.059034,
0.124000,0.059973,
0.125000,0.060920,
0.126000,0.061873,
0.127000,0.062833,
0.128000,0.063799,
0.129000,0.064773,
0.130000,0.065753,
0.131000,0.066740,
0.132000,0.067733,
0.133000,0.068734,
0.134000,0.069740,
0.135000,0.070754,
0.136000,0.071774,
0.137000,0.072801,
0.138000,0.073834,
0.139000,0.074874,
0.140000,0.075920,
0.141000,0.076973,
0.142000,0.078032,
0.143000,0.079098,
0.144000,0.080170,
0.145000,0.081249,
0.146000,0.082334,
0.147000,0.083426,
0.148000,0.084524,
0.149000,0.085628,
0.150000,0.086738,
0.151000,0.087855,
0.152000,0.088978,
0.153000,0.090108,
0.154000,0.091243,
0.155000,0.092385,
0.156000,0.093533,
0.157000,0.094687,
0.158000,0.095848,
0.159000,0.097014,
0.160000,0.098187,
0.161000,0.099365,
0.162000,0.100550,
0.163000,0.101741,
0.164000,0.102937,
0.165000,0.104140,
0.166000,0.105349,
0.167000,0.106563,
0.168000,0.107784,
0.169000,0.109010,
0.170000,0.110242,
0.171000,0.111480,
0.172000,0.112724,
0.173000,0.113974,
0.174000,0.115230,
0.175000,0.116491,
0.176000,0.117758,
0.177000,0.119030,
0.178000,0.120309,
0.179000,0.121593,
0.180000,0.122882,
0.181000,0.124177,
0.182000,0.125478,
0.183000,0.126784,
0.184000,0.128096,
0.185000,0.129413,
0.186000,0.130736,
0.187000,0.132064,
0.188000,0.133398,
0.189000,0.134737,
0.190000,0.136081,
0.191000,0.137431,
0.192000,0.138786,
0.193000,0.140146,
0.194000,0.141512,
0.195000,0.142883,
0.196000,0.144259,
0.197000,0.145640,
0.198000,0.147026,
0.199000,0.148418,
0.200000,0.149814,
0.201000,0.151216,
0.202000,0.152623,
0.203000,0.154034,
0.204000,0.155451,
0.205000,0.156873,
0.206000,0.158299,
0.207000,0.159731,
0.208000,0.161167,
0.209000,0.162608,
0.210000,0.164054,
0.211000,0.165505,
0.212000,0.166961,
0.213000,0.168421,
0.214000,0.169886,
0.215000,0.171356,
0.216000,0.172830,
0.217000,0.174309,
0.218000,0.175793,
0.219000,0.177281,
0.220000,0.178774,
0.221000,0.180271,
0.222000,0.181773,
0.223000,0.183279,
0.224000,0.184790,
0.225000,0.186305,
0.226000,0.187824,
0.227000,0.189348,
0.228000,0.190876,
0.229000,0.192408,
0.230000,0.193945,
0.231000,0.195485,
0.232000,0.197030,
0.233000,0.198579,
0.234000,0.200133,
0.235000,0.201690,
0.236000,0.203251,
0.237000,0.204817,
0.238000,0.206386,
0.239000,0.207960,
0.240000,0.209537,
0.241000,0.211118,
0.242000,0.212703,
0.243000,0.214293,
0.244000,0.215885,
0.245000,0.217482,
0.246000,0.219082,
0.247000,0.220687,
0.248000,0.222295,
0.249000,0.223906,
0.250000,0.225521,
0.251000,0.227140,
0.252000,0.228762,
0.253000,0.230388,
0.254000,0.232018,
0.255000,0.233651,
0.256000,0.235287,
0.257000,0.236927,
0.258000,0.238570,
0.259000,0.240217,
0.260000,0.241867,
0.261000,0.243520,
0.262000,0.245176,
0.263000,0.246836,
0.264000,0.248499,
0.265000,0.250165,
0.266000,0.251834,
0.267000,0.253507,
0.268000,0.255182,
0.269000,0.256861,
0.270000,0.258542,
0.271000,0.260227,
0.272000,0.261914,
0.273000,0.263604,
0.274000,0.265298,
0.275000,0.266994,
0.276000,0.268693,
0.277000,0.270394,
0.278000,0.272099,
0.279000,0.273806,
0.280000,0.275516,
0.281000,0.277229,
0.282000,0.278944,
0.283000,0.280662,
0.284000,0.282382,
0.285000,0.284105,
0.286000,0.285830,
0.287000,0.287558,
0.288000,0.289288,
0.289000,0.291021,
0.290000,0.292756,
0.291000,0.294493,
0.292000,0.296233,
0.293000,0.297975,
0.294000,0.299719,
0.295000,0.301466,
0.296000,0.303214,
0.297000,0.304965,
0.298000,0.306718,
0.299000,0.308473,
0.300000,0.310230,
0.301000,0.311989,
0.302000,0.313750,
0.303000,0.315513,
0.304000,0.317278,
0.305000,0.319044,
0.306000,0.320813,
0.307000,0.322583,
0.308000,0.324355,
0.309000,0.326129,
0.310000,0.327905,
0.311000,0.329682,
0.312000,0.331461,
0.313000,0.333241,
0.314000,0.335024,
0.315000,0.336807,
0.316000,0.338592,
0.317000,0.340379,
0.318000,0.342167,
0.319000,0.343957,
0.320000,0.345748,
0.321000,0.347540,
0.322000,0.349334,
0.323000,0.351128,
0.324000,0.352925,
0.325000,0.354722,
0.326000,0.356520,
0.327000,0.358320,
0.328000,0.360121,
0.329000,0.361923,
0.330000,0.363726,
0.331000,0.365530,
0.332000,0.367335,
0.333000,0.369141,
0.334000,0.370947,
0.335000,0.372755,
0.336000,0.374564,
0.337000,0.376373,
0.338000,0.378183,
0.339000,0.379994,
0.340000,0.381806,
0.341000,0.383618,
0.342000,0.385431,
0.343000,0.387245,
0.344000,0.389059,
0.345000,0.390874,
0.346000,0.392689,
0.347000,0.394505,
0.348000,0.396321,
0.349000,0.398138,
0.350000,0.399955,
0.351000,0.401772,
0.352000,0.403590,
0.353000,0.405408,
0.354000,0.407226,
0.355000,0.409045,
0.356000,0.410864,
0.357000,0.412682,
0.358000,0.414501,
0.359000,0.416321,
0.360000,0.418140,
0.361000,0.419959,
0.362000,0.421778,
0.363000,0.423597,
0.364000,0.425417,
0.365000,0.427236,
0.366000,0.429055,
0.367000,0.430873,
0.368000,0.432692,
0.369000,0.434510,
0.370000,0.436328,
0.371000,0.438146,
0.372000,0.439963,
0.373000,0.441781,
0.374000,0.443597,
0.375000,0.445413,
0.376000,0.447229,
0.377000,0.449045,
0.378000,0.450859,
0.379000,0.452674,
0.380000,0.454487,
0.381000,0.456301,
0.382000,0.458113,
0.383000,0.459925,
0.384000,0.461736,
0.385000,0.463546,
0.386000,0.465356,
0.387000,0.467164,
0.388000,0.468972,
0.389000,0.470779,
0.390000,0.472585,
0.391000,0.474391,
0.392000,0.476195,
0.393000,0.477998,
0.394000,0.479800,
0.395000,0.481601,
0.396000,0.483402,
0.397000,0.485200,
0.398000,0.486998,
0.399000,0.488795,
0.400000,0.490590,
0.401000,0.492384,
0.402000,0.494177,
0.403000,0.495969,
0.404000,0.497759,
0.405000,0.499548,
0.406000,0.501336,
0.407000,0.503122,
0.408000,0.504906,
0.409000,0.506689,
0.410000,0.508471,
0.411000,0.510251,
0.412000,0.512029,
0.413000,0.513806,
0.414000,0.515581,
0.415000,0.517355,
0.416000,0.519127,
0.417000,0.520897,
0.418000,0.522665,
0.419000,0.524432,
0.420000,0.526196,
0.421000,0.527959,
0.422000,0.529720,
0.423000,0.531479,
0.424000,0.533236,
0.425000,0.534991,
0.426000,0.536745,
0.427000,0.538496,
0.428000,0.540245,
0.429000,0.541992,
0.430000,0.543736,
0.431000,0.545479,
0.432000,0.547220,
0.433000,0.548958,
0.434000,0.550694,
0.435000,0.552428,
0.436000,0.554159,
0.437000,0.555888,
0.438000,0.557615,
0.439000,0.559340,
0.440000,0.561062,
0.441000,0.562781,
0.442000,0.564498,
0.443000,0.566213,
0.444000,0.567925,
0.445000,0.569634,
0.446000,0.571341,
0.447000,0.573046,
0.448000,0.574747,
0.449000,0.576446,
0.450000,0.578143,
0.451000,0.579836,
0.452000,0.581527,
0.453000,0.583215,
0.454000,0.584901,
0.455000,0.586583,
0.456000,0.588263,
0.457000,0.589939,
0.458000,0.591613,
0.459000,0.593284,
0.460000,0.594952,
0.461000,0.596617,
0.462000,0.598279,
0.463000,0.599937,
0.464000,0.601593,
0.465000,0.603246,
0.466000,0.604895,
0.467000,0.606542,
0.468000,0.608185,
0.469000,0.609825,
0.470000,0.611461,
0.471000,0.613095,
0.472000,0.614725,
0.473000,0.616352,
0.474000,0.617975,
0.475000,0.619595,
0.476000,0.621212,
0.477000,0.622825,
0.478000,0.624435,
0.479000,0.626042,
0.480000,0.627645,
0.481000,0.629244,
0.482000,0.630840,
0.483000,0.632432,
0.484000,0.634021,
0.485000,0.635606,
0.486000,0.637187,
0.487000,0.638765,
0.488000,0.640339,
0.489000,0.641909,
0.490000,0.643476,
0.491000,0.645039,
0.492000,0.646598,
0.493000,0.648153,
0.494000,0.649704,
0.495000,0.651252,
0.496000,0.652795,
0.497000,0.654335,
0.498000,0.655870,
0.499000,0.657402,
0.500000,0.658930,
0.501000,0.660454,
0.502000,0.661973,
0.503000,0.663489,
0.504000,0.665001,
0.505000,0.666508,
0.506000,0.668011,
0.507000,0.669511,
0.508000,0.671006,
0.509000,0.672496,
0.510000,0.673983,
0.511000,0.675465,
0.512000,0.676943,
0.513000,0.678417,
0.514000,0.679886,
0.515000,0.681352,
0.516000,0.682812,
0.517000,0.684269,
0.518000,0.685721,
0.519000,0.687168,
0.520000,0.688611,
0.521000,0.690050,
0.522000,0.691484,
0.523000,0.692914,
0.524000,0.694339,
0.525000,0.695759,
0.526000,0.697175,
0.527000,0.698587,
0.528000,0.699994,
0.529000,0.701396,
0.530000,0.702793,
0.531000,0.704186,
0.532000,0.705574,
0.533000,0.706957,
0.534000,0.708336,
0.535000,0.709710,
0.536000,0.711079,
0.537000,0.712443,
0.538000,0.713803,
0.539000,0.715157,
0.540000,0.716507,
0.541000,0.717852,
0.542000,0.719192,
0.543000,0.720527,
0.544000,0.721857,
0.545000,0.723182,
0.546000,0.724502,
0.547000,0.725817,
0.548000,0.727127,
0.549000,0.728432,
0.550000,0.729732,
0.551000,0.731027,
0.552000,0.732317,
0.553000,0.733602,
0.554000,0.734881,
0.555000,0.736155,
0.556000,0.737425,
0.557000,0.738689,
0.558000,0.739948,
0.559000,0.741201,
0.560000,0.742449,
0.561000,0.743693,
0.562000,0.744930,
0.563000,0.746163,
0.564000,0.747390,
0.565000,0.748612,
0.566000,0.749828,
0.567000,0.751039,
0.568000,0.752245,
0.569000,0.753446,
0.570000,0.754640,
0.571000,0.755830,
0.572000,0.757014,
0.573000,0.758192,
0.574000,0.759365,
0.575000,0.760533,
0.576000,0.761695,
0.577000,0.762851,
0.578000,0.764002,
0.579000,0.765148,
0.580000,0.766287,
0.581000,0.767422,
0.582000,0.768550,
0.583000,0.769673,
0.584000,0.770790,
0.585000,0.771902,
0.586000,0.773008,
0.587000,0.774108,
0.588000,0.775202,
0.589000,0.776291,
0.590000,0.777374,
0.591000,0.778451,
0.592000,0.779522,
0.593000,0.780588,
0.594000,0.781648,
0.595000,0.782702,
0.596000,0.783750,
0.597000,0.784792,
0.598000,0.785829,
0.599000,0.786860,
0.600000,0.787884,
0.601000,0.788903,
0.602000,0.789916,
0.603000,0.790923,
0.604000,0.791924,
0.605000,0.792919,
0.606000,0.793908,
0.607000,0.794891,
0.608000,0.795868,
0.609000,0.796839,
0.610000,0.797804,
0.611000,0.798763,
0.612000,0.799716,
0.613000,0.800663,
0.614000,0.801603,
0.615000,0.802538,
0.616000,0.803466,
0.617000,0.804389,
0.618000,0.805305,
0.619000,0.806215,
0.620000,0.807119,
0.621000,0.808017,
0.622000,0.808909,
0.623000,0.809794,
0.624000,0.810673,
0.625000,0.811546,
0.626000,0.812413,
0.627000,0.813274,
0.628000,0.814128,
0.629000,0.814976,
0.630000,0.815817,
0.631000,0.816653,
0.632000,0.817482,
0.633000,0.818305,
0.634000,0.819121,
0.635000,0.819931,
0.636000,0.820735,
0.637000,0.821533,
0.638000,0.822324,
0.639000,0.823109,
0.640000,0.823887,
0.641000,0.824659,
0.642000,0.825424,
0.643000,0.826183,
0.644000,0.826936,
0.645000,0.827682,
0.646000,0.828422,
0.647000,0.829156,
0.648000,0.829882,
0.649000,0.830603,
0.650000,0.831317,
0.651000,0.832024,
0.652000,0.832725,
0.653000,0.833419,
0.654000,0.834107,
0.655000,0.834789,
0.656000,0.835463,
0.657000,0.836132,
0.658000,0.836793,
0.659000,0.837448,
0.660000,0.838097,
0.661000,0.838739,
0.662000,0.839374,
0.663000,0.840003,
0.664000,0.840625,
0.665000,0.841241,
0.666000,0.841850,
0.667000,0.842452,
0.668000,0.843048,
0.669000,0.843637,
0.670000,0.844219,
0.671000,0.844795,
0.672000,0.845364,
0.673000,0.845926,
0.674000,0.846481,
0.675000,0.847030,
0.676000,0.847573,
0.677000,0.848108,
0.678000,0.848637,
0.679000,0.849159,
0.680000,0.849674,
0.681000,0.850183,
0.682000,0.850685,
0.683000,0.851180,
0.684000,0.851668,
0.685000,0.852150,
0.686000,0.852625,
0.687000,0.853093,
0.688000,0.853554,
0.689000,0.854009,
0.690000,0.854456,
0.691000,0.854897,
0.692000,0.855331,
0.693000,0.855759,
0.694000,0.856179,
0.695000,0.856593,
0.696000,0.857000,
0.697000,0.857400,
0.698000,0.857793,
0.699000,0.858179,
0.700000,0.858559,
0.701000,0.858931,
0.702000,0.859297,
0.703000,0.859656,
0.704000,0.860008,
0.705000,0.860353,
0.706000,0.860691,
0.707000,0.861023,
0.708000,0.861347,
0.709000,0.861665,
0.710000,0.861976,
0.711000,0.862280,
0.712000,0.862577,
0.713000,0.862867,
0.714000,0.863150,
0.715000,0.863426,
0.716000,0.863696,
0.717000,0.863958,
0.718000,0.864214,
0.719000,0.864462,
0.720000,0.864704,
0.721000,0.864939,
0.722000,0.865166,
0.723000,0.865387,
0.724000,0.865601,
0.725000,0.865808,
0.726000,0.866008,
0.727000,0.866201,
0.728000,0.866388,
0.729000,0.866567,
0.730000,0.866739,
0.731000,0.866904,
0.732000,0.867063,
0.733000,0.867214,
0.734000,0.867358,
0.735000,0.867496,
0.736000,0.867626,
0.737000,0.867750,
0.738000,0.867867,
0.739000,0.867976,
0.740000,0.868079,
0.741000,0.868174,
0.742000,0.868263,
0.743000,0.868345,
0.744000,0.868420,
0.745000,0.868487,
0.746000,0.868548,
0.747000,0.868602,
0.748000,0.868649,
0.749000,0.868689,
0.750000,0.868721,
0.751000,0.868747,
0.752000,0.868766,
0.753000,0.868778,
0.754000,0.868783,
0.755000,0.868781,
0.756000,0.868772,
0.757000,0.868756,
0.758000,0.868733,
0.759000,0.868703,
0.760000,0.868666,
0.761000,0.868622,
0.762000,0.868571,
0.763000,0.868513,
0.764000,0.868449,
0.765000,0.868377,
0.766000,0.868298,
0.767000,0.868212,
0.768000,0.868119,
0.769000,0.868020,
0.770000,0.867913,
0.771000,0.867799,
0.772000,0.867679,
0.773000,0.867551,
0.774000,0.867416,
0.775000,0.867275,
0.776000,0.867126,
0.777000,0.866971,
0.778000,0.866809,
0.779000,0.866639,
0.780000,0.866463,
0.781000,0.866280,
0.782000,0.866089,
0.783000,0.865892,
0.784000,0.865688,
0.785000,0.865477,
0.786000,0.865259,
0.787000,0.865034,
0.788000,0.864802,
0.789000,0.864564,
0.790000,0.864318,
0.791000,0.864065,
0.792000,0.863806,
0.793000,0.863539,
0.794000,0.863266,
0.795000,0.862985,
0.796000,0.862698,
0.797000,0.862404,
0.798000,0.862103,
0.799000,0.861795,
0.800000,0.861480,
0.801000,0.861159,
0.802000,0.860830,
0.803000,0.860495,
0.804000,0.860152,
0.805000,0.859803,
0.806000,0.859447,
0.807000,0.859084,
0.808000,0.858714,
0.809000,0.858338,
0.810000,0.857954,
0.811000,0.857564,
0.812000,0.857167,
0.813000,0.856763,
0.814000,0.856352,
0.815000,0.855934,
0.816000,0.855510,
0.817000,0.855079,
0.818000,0.854641,
0.819000,0.854196,
0.820000,0.853744,
0.821000,0.853286,
0.822000,0.852820,
0.823000,0.852348,
0.824000,0.851869,
0.825000,0.851384,
0.826000,0.850892,
0.827000,0.850393,
0.828000,0.849887,
0.829000,0.849374,
0.830000,0.848855,
0.831000,0.848329,
0.832000,0.847796,
0.833000,0.847257,
0.834000,0.846711,
0.835000,0.846158,
0.836000,0.845598,
0.837000,0.845032,
0.838000,0.844459,
0.839000,0.843880,
0.840000,0.843293,
0.841000,0.842700,
0.842000,0.842101,
0.843000,0.841495,
0.844000,0.840882,
0.845000,0.840263,
0.846000,0.839637,
0.847000,0.839004,
0.848000,0.838365,
0.849000,0.837719,
0.850000,0.837067,
0.851000,0.836408,
0.852000,0.835742,
0.853000,0.835070,
0.854000,0.834391,
0.855000,0.833706,
0.856000,0.833015,
0.857000,0.832316,
0.858000,0.831612,
0.859000,0.830900,
0.860000,0.830183,
0.861000,0.829459,
0.862000,0.828728,
0.863000,0.827991,
0.864000,0.827247,
0.865000,0.826497,
0.866000,0.825741,
0.867000,0.824978,
0.868000,0.824209,
0.869000,0.823433,
0.870000,0.822651,
0.871000,0.821863,
0.872000,0.821068,
0.873000,0.820267,
0.874000,0.819459,
0.875000,0.818645,
0.876000,0.817825,
0.877000,0.816998,
0.878000,0.816166,
0.879000,0.815327,
0.880000,0.814481,
0.881000,0.813630,
0.882000,0.812772,
0.883000,0.811907,
0.884000,0.811037,
0.885000,0.810160,
0.886000,0.809278,
0.887000,0.808389,
0.888000,0.807493,
0.889000,0.806592,
0.890000,0.805684,
0.891000,0.804771,
0.892000,0.803851,
0.893000,0.802925,
0.894000,0.801993,
0.895000,0.801055,
0.896000,0.800110,
0.897000,0.799160,
0.898000,0.798203,
0.899000,0.797241,
0.900000,0.796272,
0.901000,0.795298,
0.902000,0.794317,
0.903000,0.793331,
0.904000,0.792338,
0.905000,0.791340,
0.906000,0.790335,
0.907000,0.789325,
0.908000,0.788309,
0.909000,0.787286,
0.910000,0.786258,
0.911000,0.785224,
0.912000,0.784184,
0.913000,0.783139,
0.914000,0.782087,
0.915000,0.781030,
0.916000,0.779966,
0.917000,0.778897,
0.918000,0.777823,
0.919000,0.776742,
0.920000,0.775656,
0.921000,0.774564,
0.922000,0.773466,
0.923000,0.772362,
0.924000,0.771253,
0.925000,0.770138,
0.926000,0.769018,
0.927000,0.767891,
0.928000,0.766760,
0.929000,0.765622,
0.930000,0.764479,
0.931000,0.763331,
0.932000,0.762177,
0.933000,0.761017,
0.934000,0.759852,
0.935000,0.758681,
0.936000,0.757505,
0.937000,0.756323,
0.938000,0.755136,
0.939000,0.753943,
0.940000,0.752745,
0.941000,0.751542,
0.942000,0.750333,
0.943000,0.749118,
0.944000,0.747899,
0.945000,0.746674,
0.946000,0.745444,
0.947000,0.744208,
0.948000,0.742967,
0.949000,0.741721,
0.950000,0.740470,
0.951000,0.739213,
0.952000,0.737951,
0.953000,0.736684,
0.954000,0.735412,
0.955000,0.734134,
0.956000,0.732852,
0.957000,0.731564,
0.958000,0.730271,
0.959000,0.728973,
0.960000,0.727670,
0.961000,0.726362,
0.962000,0.725049,
0.963000,0.723731,
0.964000,0.722408,
0.965000,0.721080,
0.966000,0.719747,
0.967000,0.718410,
0.968000,0.717067,
0.969000,0.715719,
0.970000,0.714366,
0.971000,0.713009,
0.972000,0.711647,
0.973000,0.710280,
0.974000,0.708908,
0.975000,0.707531,
0.976000,0.706150,
0.977000,0.704764,
0.978000,0.703373,
0.979000,0.701977,
0.980000,0.700577,
0.981000,0.699172,
0.982000,0.697763,
0.983000,0.696349,
0.984000,0.694930,
0.985000,0.693507,
0.986000,0.692079,
0.987000,0.690647,
0.988000,0.689210,
0.989000,0.687769,
0.990000,0.686323,
0.991000,0.684873,
0.992000,0.683419,
0.993000,0.681960,
0.994000,0.680496,
0.995000,0.679029,
0.996000,0.677557,
0.997000,0.676080,
0.998000,0.674600,
0.999000,0.673115,
1.000000,0.671626,
1.001000,0.670133,
1.002000,0.668635,
1.003000,0.667134,
1.004000,0.665628,
1.005000,0.664118,
1.006000,0.662604,
1.007000,0.661086,
1.008000,0.659564,
1.009000,0.658038,
1.010000,0.656508,
1.011000,0.654974,
1.012000,0.653436,
1.013000,0.651894,
1.014000,0.650348,
1.015000,0.648798,
1.016000,0.647245,
1.017000,0.645687,
1.018000,0.644126,
1.019000,0.642561,
1.020000,0.640992,
1.021000,0.639420,
1.022000,0.637844,
1.023000,0.636264,
1.024000,0.634680,
1.025000,0.633093,
1.026000,0.631502,
1.027000,0.629908,
1.028000,0.628310,
1.029000,0.626709,
1.030000,0.625104,
1.031000,0.623495,
1.032000,0.621883,
1.033000,0.620268,
1.034000,0.618649,
1.035000,0.617027,
1.036000,0.615402,
1.037000,0.613773,
1.038000,0.612141,
1.039000,0.610506,
1.040000,0.608867,
1.041000,0.607225,
1.042000,0.605580,
1.043000,0.603932,
1.044000,0.602281,
1.045000,0.600626,
1.046000,0.598969,
1.047000,0.597308,
1.048000,0.595645,
1.049000,0.593978,
1.050000,0.592308,
1.051000,0.590636,
1.052000,0.588960,
1.053000,0.587282,
1.054000,0.585601,
1.055000,0.583916,
1.056000,0.582230,
1.057000,0.580540,
1.058000,0.578847,
1.059000,0.577152,
1.060000,0.575454,
1.061000,0.573754,
1.062000,0.572050,
1.063000,0.570345,
1.064000,0.568636,
1.065000,0.566925,
1.066000,0.565212,
1.067000,0.563495,
1.068000,0.561777,
1.069000,0.560056,
1.070000,0.558332,
1.071000,0.556607,
1.072000,0.554878,
1.073000,0.553148,
1.074000,0.551415,
1.075000,0.549680,
1.076000,0.547943,
1.077000,0.546203,
1.078000,0.544461,
1.079000,0.542717,
1.080000,0.540971,
1.081000,0.539223,
1.082000,0.537473,
1.083000,0.535721,
1.084000,0.533966,
1.085000,0.532210,
1.086000,0.530452,
1.087000,0.528692,
1.088000,0.526930,
1.089000,0.525166,
1.090000,0.523400,
1.091000,0.521632,
1.092000,0.519863,
1.093000,0.518092,
1.094000,0.516319,
1.095000,0.514545,
1.096000,0.512768,
1.097000,0.510991,
1.098000,0.509211,
1.099000,0.507430,
1.100000,0.505648,
1.101000,0.503864,
1.102000,0.502078,
1.103000,0.500292,
1.104000,0.498503,
1.105000,0.496714,
1.106000,0.494923,
1.107000,0.493130,
1.108000,0.491337,
1.109000,0.489542,
1.110000,0.487746,
1.111000,0.485948,
1.112000,0.484150,
1.113000,0.482350,
1.114000,0.480549,
1.115000,0.478748,
1.116000,0.476945,
1.117000,0.475141,
1.118000,0.473336,
1.119000,0.471530,
1.120000,0.469724,
1.121000,0.467916,
1.122000,0.466108,
1.123000,0.464299,
1.124000,0.462489,
1.125000,0.460678,
1.126000,0.458866,
1.127000,0.457054,
1.128000,0.455242,
1.129000,0.453428,
1.130000,0.451614,
1.131000,0.449799,
1.132000,0.447984,
1.133000,0.446169,
1.134000,0.444353,
1.135000,0.442536,
1.136000,0.440719,
1.137000,0.438902,
1.138000,0.437084,
1.139000,0.435266,
1.140000,0.433448,
1.141000,0.431630,
1.142000,0.429811,
1.143000,0.427992,
1.144000,0.426173,
1.145000,0.424354,
1.146000,0.422535,
1.147000,0.420716,
1.148000,0.418896,
1.149000,0.417077,
1.150000,0.415258,
1.151000,0.413439,
1.152000,0.411620,
1.153000,0.409801,
1.154000,0.407983,
1.155000,0.406164,
1.156000,0.404346,
1.157000,0.402528,
1.158000,0.400710,
1.159000,0.398893,
1.160000,0.397076,
1.161000,0.395260,
1.162000,0.393444,
1.163000,0.391629,
1.164000,0.389814,
1.165000,0.387999,
1.166000,0.386185,
1.167000,0.384372,
1.168000,0.382559,
1.169000,0.380747,
1.170000,0.378936,
1.171000,0.377126,
1.172000,0.375316,
1.173000,0.373507,
1.174000,0.371699,
1.175000,0.369892,
1.176000,0.368085,
1.177000,0.366280,
1.178000,0.364476,
1.179000,0.362672,
1.180000,0.360870,
1.181000,0.359069,
1.182000,0.357269,
1.183000,0.355470,
1.184000,0.353672,
1.185000,0.351875,
1.186000,0.350080,
1.187000,0.348286,
1.188000,0.346493,
1.189000,0.344701,
1.190000,0.342911,
1.191000,0.341123,
1.192000,0.339335,
1.193000,0.337549,
1.194000,0.335765,
1.195000,0.333982,
1.196000,0.332201,
1.197000,0.330422,
1.198000,0.328644,
1.199000,0.326867,
1.200000,0.325093,
1.201000,0.323320,
1.202000,0.321549,
1.203000,0.319779,
1.204000,0.318012,
1.205000,0.316246,
1.206000,0.314483,
1.207000,0.312721,
1.208000,0.310961,
1.209000,0.309203,
1.210000,0.307448,
1.211000,0.305694,
1.212000,0.303942,
1.213000,0.302193,
1.214000,0.300445,
1.215000,0.298700,
1.216000,0.296957,
1.217000,0.295217,
1.218000,0.293478,
1.219000,0.291742,
1.220000,0.290009,
1.221000,0.288277,
1.222000,0.286548,
1.223000,0.284822,
1.224000,0.283098,
1.225000,0.281377,
1.226000,0.279658,
1.227000,0.277942,
1.228000,0.276228,
1.229000,0.274517,
1.230000,0.272809,
1.231000,0.271103,
1.232000,0.269400,
1.233000,0.267700,
1.234000,0.266003,
1.235000,0.264308,
1.236000,0.262617,
1.237000,0.260928,
1.238000,0.259242,
1.239000,0.257560,
1.240000,0.255880,
1.241000,0.254203,
1.242000,0.252530,
1.243000,0.250859,
1.244000,0.249192,
1.245000,0.247527,
1.246000,0.245866,
1.247000,0.244208,
1.248000,0.242554,
1.249000,0.240903,
1.250000,0.239255,
1.251000,0.237610,
1.252000,0.235969,
1.253000,0.234331,
1.254000,0.232696,
1.255000,0.231066,
1.256000,0.229438,
1.257000,0.227814,
1.258000,0.226194,
1.259000,0.224577,
1.260000,0.222964,
1.261000,0.221355,
1.262000,0.219749,
1.263000,0.218147,
1.264000,0.216549,
1.265000,0.214954,
1.266000,0.213364,
1.267000,0.211777,
1.268000,0.210194,
1.269000,0.208615,
1.270000,0.207040,
1.271000,0.205469,
1.272000,0.203902,
1.273000,0.202339,
1.274000,0.200780,
1.275000,0.199225,
1.276000,0.197674,
1.277000,0.196127,
1.278000,0.194585,
1.279000,0.193047,
1.280000,0.191512,
1.281000,0.189983,
1.282000,0.188457,
1.283000,0.186936,
1.284000,0.185419,
1.285000,0.183907,
1.286000,0.182399,
1.287000,0.180895,
1.288000,0.179396,
1.289000,0.177901,
1.290000,0.176411,
1.291000,0.174926,
1.292000,0.173445,
1.293000,0.171969,
1.294000,0.170497,
1.295000,0.169030,
1.296000,0.167568,
1.297000,0.166110,
1.298000,0.164657,
1.299000,0.163209,
1.300000,0.161766,
1.301000,0.160328,
1.302000,0.158894,
1.303000,0.157465,
1.304000,0.156042,
1.305000,0.154623,
1.306000,0.153209,
1.307000,0.151800,
1.308000,0.150397,
1.309000,0.148998,
1.310000,0.147604,
1.311000,0.146216,
1.312000,0.144833,
1.313000,0.143454,
1.314000,0.142081,
1.315000,0.140714,
1.316000,0.139351,
1.317000,0.137994,
1.318000,0.136642,
1.319000,0.135295,
1.320000,0.133954,
1.321000,0.132618,
1.322000,0.131288,
1.323000,0.129963,
1.324000,0.128643,
1.325000,0.127329,
1.326000,0.126021,
1.327000,0.124718,
1.328000,0.123420,
1.329000,0.122128,
1.330000,0.120842,
1.331000,0.119561,
1.332000,0.118286,
1.333000,0.117017,
1.334000,0.115753,
1.335000,0.114495,
1.336000,0.113243,
1.337000,0.111997,
1.338000,0.110757,
1.339000,0.109522,
1.340000,0.108293,
1.341000,0.107070,
1.342000,0.105853,
1.343000,0.104642,
1.344000,0.103437,
1.345000,0.102237,
1.346000,0.101044,
1.347000,0.099857,
1.348000,0.098676,
1.349000,0.097501,
1.350000,0.096332,
1.351000,0.095169,
1.352000,0.094012,
1.353000,0.092862,
1.354000,0.091717,
1.355000,0.090579,
1.356000,0.089447,
1.357000,0.088322,
1.358000,0.087202,
1.359000,0.086089,
1.360000,0.084982,
1.361000,0.083882,
1.362000,0.082787,
1.363000,0.081700,
1.364000,0.080618,
1.365000,0.079543,
1.366000,0.078475,
1.367000,0.077413,
1.368000,0.076357,
1.369000,0.075308,
1.370000,0.074266,
1.371000,0.073230,
1.372000,0.072200,
1.373000,0.071177,
1.374000,0.070161,
1.375000,0.069151,
1.376000,0.068148,
1.377000,0.067152,
1.378000,0.066163,
1.379000,0.065180,
1.380000,0.064203,
1.381000,0.063234,
1.382000,0.062271,
1.383000,0.061315,
1.384000,0.060366,
1.385000,0.059424,
1.386000,0.058488,
1.387000,0.057560,
1.388000,0.056638,
1.389000,0.055723,
1.390000,0.054815,
1.391000,0.053914,
1.392000,0.053020,
1.393000,0.052133,
1.394000,0.051253,
1.395000,0.050380,
1.396000,0.049514,
1.397000,0.048654,
1.398000,0.047802,
1.399000,0.046957,
1.400000,0.046119,
1.401000,0.045289,
1.402000,0.044465,
1.403000,0.043648,
1.404000,0.042839,
1.405000,0.042037,
1.406000,0.041242,
1.407000,0.040454,
1.408000,0.039673,
1.409000,0.038899,
1.410000,0.038133,
1.411000,0.037374,
1.412000,0.036622,
1.413000,0.035878,
1.414000,0.035141,
1.415000,0.034411,
1.416000,0.033688,
1.417000,0.032973,
1.418000,0.032265,
1.419000,0.031565,
1.420000,0.030872,
1.421000,0.030186,
1.422000,0.029508,
1.423000,0.028837,
1.424000,0.028174,
1.425000,0.027518,
1.426000,0.026869,
1.427000,0.026228,
1.428000,0.025595,
1.429000,0.024968,
1.430000,0.024350,
1.431000,0.023739,
1.432000,0.023135,
1.433000,0.022539,
1.434000,0.021951,
1.435000,0.021370,
1.436000,0.020797,
1.437000,0.020231,
1.438000,0.019673,
1.439000,0.019123,
1.440000,0.018580,
1.441000,0.018045,
1.442000,0.017517,
1.443000,0.016998,
1.444000,0.016485,
1.445000,0.015981,
1.446000,0.015484,
1.447000,0.014995,
1.448000,0.014513,
1.449000,0.014040,
1.450000,0.013574,
1.451000,0.013115,
1.452000,0.012665,
1.453000,0.012222,
1.454000,0.011787,
1.455000,0.011360,
1.456000,0.010940,
1.457000,0.010529,
1.458000,0.010125,
1.459000,0.009729,
1.460000,0.009341,
1.461000,0.008960,
1.462000,0.008587,
1.463000,0.008223,
1.464000,0.007866,
1.465000,0.007517,
1.466000,0.007175,
1.467000,0.006842,
1.468000,0.006516,
1.469000,0.006199,
1.470000,0.005889,
1.471000,0.005587,
1.472000,0.005293,
1.473000,0.005007,
1.474000,0.004729,
1.475000,0.004458,
1.476000,0.004196,
1.477000,0.003942,
1.478000,0.003695,
1.479000,0.003456,
1.480000,0.003226,
1.481000,0.003003,
1.482000,0.002788,
1.483000,0.002581,
1.484000,0.002382,
1.485000,0.002191,
1.486000,0.002008,
1.487000,0.001833,
1.488000,0.001666,
1.489000,0.001507,
1.490000,0.001356,
1.491000,0.001213,
1.492000,0.001077,
1.493000,0.000950,
1.494000,0.000831,
1.495000,0.000720,
1.496000,0.000617,
1.497000,0.000521,
1.498000,0.000434,
1.499000,0.000355,
1.500000,0.000283,
1.501000,0.000220,
1.502000,0.000165,
1.503000,0.000117,
1.504000,0.000078,
1.505000,0.000047,
1.506000,0.000023,
1.507000,0.000008,
1.508000,0.000001,
1.509000,0.000001,
1.510000,0.000010,
1.511000,0.000027,
1.512000,0.000051,
1.513000,0.000084,
1.514000,0.000125,
1.515000,0.000173,
1.516000,0.000230,
1.517000,0.000295,
1.518000,0.000367,
1.519000,0.000448,
1.520000,0.000537,
1.521000,0.000633,
1.522000,0.000738,
1.523000,0.000851,
1.524000,0.000971,
1.525000,0.001100,
1.526000,0.001236,
1.527000,0.001381,
1.528000,0.001533,
1.529000,0.001694,
1.530000,0.001862,
1.531000,0.002039,
1.532000,0.002223,
1.533000,0.002415,
1.534000,0.002615,
1.535000,0.002824,
1.536000,0.003040,
1.537000,0.003264,
1.538000,0.003496,
1.539000,0.003736,
1.540000,0.003984,
1.541000,0.004240,
1.542000,0.004503,
1.543000,0.004775,
1.544000,0.005054,
1.545000,0.005342,
1.546000,0.005637,
1.547000,0.005941,
1.548000,0.006252,
1.549000,0.006571,
1.550000,0.006897,
1.551000,0.007232,
1.552000,0.007575,
1.553000,0.007925,
1.554000,0.008283,
1.555000,0.008650,
1.556000,0.009024,
1.557000,0.009405,
1.558000,0.009795,
1.559000,0.010192,
1.560000,0.010598,
1.561000,0.011010,
1.562000,0.011431,
1.563000,0.011860,
1.564000,0.012296,
1.565000,0.012740,
1.566000,0.013192,
1.567000,0.013652,
1.568000,0.014119,
1.569000,0.014594,
1.570000,0.015077,
1.571000,0.015567,
1.572000,0.016065,
1.573000,0.016571,
1.574000,0.017085,
1.575000,0.017606,
1.576000,0.018134,
1.577000,0.018671,
1.578000,0.019215,
1.579000,0.019767,
1.580000,0.020326,
1.581000,0.020893,
1.582000,0.021467,
1.583000,0.022050,
1.584000,0.022639,
1.585000,0.023236,
1.586000,0.023841,
1.587000,0.024454,
1.588000,0.025073,
1.589000,0.025701,
1.590000,0.026335,
1.591000,0.026978,
1.592000,0.027628,
1.593000,0.028285,
1.594000,0.028949,
1.595000,0.029622,
1.596000,0.030301,
1.597000,0.030988,
1.598000,0.031682,
1.599000,0.032384,
1.600000,0.033093,
1.601000,0.033810,
1.602000,0.034533,
1.603000,0.035264,
1.604000,0.036003,
1.605000,0.036748,
1.606000,0.037501,
1.607000,0.038262,
1.608000,0.039029,
1.609000,0.039804,
1.610000,0.040586,
1.611000,0.041375,
1.612000,0.042171,
1.613000,0.042975,
1.614000,0.043785,
1.615000,0.044603,
1.616000,0.045428,
1.617000,0.046260,
1.618000,0.047099,
1.619000,0.047945,
1.620000,0.048799,
1.621000,0.049659,
1.622000,0.050526,
1.623000,0.051400,
1.624000,0.052282,
1.625000,0.053170,
1.626000,0.054065,
1.627000,0.054968,
1.628000,0.055877,
1.629000,0.056793,
1.630000,0.057716,
1.631000,0.058645,
1.632000,0.059582,
1.633000,0.060525,
1.634000,0.061476,
1.635000,0.062433,
1.636000,0.063397,
1.637000,0.064367,
1.638000,0.065345,
1.639000,0.066329,
1.640000,0.067319,
1.641000,0.068317,
1.642000,0.069321,
1.643000,0.070332,
1.644000,0.071349,
1.645000,0.072373,
1.646000,0.073403,
1.647000,0.074441,
1.648000,0.075484,
1.649000,0.076534,
1.650000,0.077591,
1.651000,0.078654,
1.652000,0.079724,
1.653000,0.080800,
1.654000,0.081882,
1.655000,0.082971,
1.656000,0.084066,
1.657000,0.085168,
1.658000,0.086276,
1.659000,0.087390,
1.660000,0.088511,
1.661000,0.089637,
1.662000,0.090770,
1.663000,0.091910,
1.664000,0.093055,
1.665000,0.094207,
1.666000,0.095364,
1.667000,0.096528,
1.668000,0.097698,
1.669000,0.098874,
1.670000,0.100056,
1.671000,0.101245,
1.672000,0.102439,
1.673000,0.103639,
1.674000,0.104845,
1.675000,0.106057,
1.676000,0.107275,
1.677000,0.108499,
1.678000,0.109729,
1.679000,0.110965,
1.680000,0.112206,
1.681000,0.113454,
1.682000,0.114707,
1.683000,0.115966,
1.684000,0.117230,
1.685000,0.118500,
1.686000,0.119776,
1.687000,0.121058,
1.688000,0.122345,
1.689000,0.123638,
1.690000,0.124936,
1.691000,0.126240,
1.692000,0.127550,
1.693000,0.128865,
1.694000,0.130185,
1.695000,0.131511,
1.696000,0.132843,
1.697000,0.134179,
1.698000,0.135522,
1.699000,0.136869,
1.700000,0.138222,
1.701000,0.139580,
1.702000,0.140943,
1.703000,0.142312,
1.704000,0.143686,
1.705000,0.145065,
1.706000,0.146449,
1.707000,0.147839,
1.708000,0.149233,
1.709000,0.150632,
1.710000,0.152037,
1.711000,0.153447,
1.712000,0.154861,
1.713000,0.156281,
1.714000,0.157705,
1.715000,0.159135,
1.716000,0.160569,
1.717000,0.162008,
1.718000,0.163452,
1.719000,0.164901,
1.720000,0.166355,
1.721000,0.167813,
1.722000,0.169276,
1.723000,0.170744,
1.724000,0.172217,
1.725000,0.173694,
1.726000,0.175176,
1.727000,0.176662,
1.728000,0.178153,
1.729000,0.179648,
1.730000,0.181148,
1.731000,0.182652,
1.732000,0.184161,
1.733000,0.185674,
1.734000,0.187192,
1.735000,0.188714,
1.736000,0.190240,
1.737000,0.191770,
1.738000,0.193305,
1.739000,0.194844,
1.740000,0.196387,
1.741000,0.197935,
1.742000,0.199486,
1.743000,0.201042,
1.744000,0.202601,
1.745000,0.204165,
1.746000,0.205733,
1.747000,0.207305,
1.748000,0.208881,
1.749000,0.210460,
1.750000,0.212044,
1.751000,0.213631,
1.752000,0.215222,
1.753000,0.216818,
1.754000,0.218416,
1.755000,0.220019,
1.756000,0.221625,
1.757000,0.223235,
1.758000,0.224849,
1.759000,0.226466,
1.760000,0.228087,
1.761000,0.229712,
1.762000,0.231340,
1.763000,0.232971,
1.764000,0.234606,
1.765000,0.236245,
1.766000,0.237886,
1.767000,0.239532,
1.768000,0.241180,
1.769000,0.242832,
1.770000,0.244487,
1.771000,0.246146,
1.772000,0.247807,
1.773000,0.249472,
1.774000,0.251140,
1.775000,0.252811,
1.776000,0.254485,
1.777000,0.256162,
1.778000,0.257843,
1.779000,0.259526,
1.780000,0.261212,
1.781000,0.262901,
1.782000,0.264593,
1.783000,0.266288,
1.784000,0.267986,
1.785000,0.269686,
1.786000,0.271390,
1.787000,0.273096,
1.788000,0.274805,
1.789000,0.276516,
1.790000,0.278230,
1.791000,0.279947,
1.792000,0.281666,
1.793000,0.283388,
1.794000,0.285112,
1.795000,0.286839,
1.796000,0.288568,
1.797000,0.290300,
1.798000,0.292034,
1.799000,0.293771,
1.800000,0.295509,
1.801000,0.297250,
1.802000,0.298994,
1.803000,0.300739,
1.804000,0.302487,
1.805000,0.304237,
1.806000,0.305989,
1.807000,0.307743,
1.808000,0.309499,
1.809000,0.311257,
1.810000,0.313017,
1.811000,0.314779,
1.812000,0.316543,
1.813000,0.318309,
1.814000,0.320077,
1.815000,0.321847,
1.816000,0.323618,
1.817000,0.325391,
1.818000,0.327166,
1.819000,0.328943,
1.820000,0.330721,
1.821000,0.332501,
1.822000,0.334282,
1.823000,0.336065,
1.824000,0.337850,
1.825000,0.339636,
1.826000,0.341423,
1.827000,0.343212,
1.828000,0.345003,
1.829000,0.346794,
1.830000,0.348587,
1.831000,0.350382,
1.832000,0.352177,
1.833000,0.353974,
1.834000,0.355772,
1.835000,0.357572,
1.836000,0.359372,
1.837000,0.361173,
1.838000,0.362976,
1.839000,0.364779,
1.840000,0.366584,
1.841000,0.368389,
1.842000,0.370196,
1.843000,0.372003,
1.844000,0.373811,
1.845000,0.375620,
1.846000,0.377430,
1.847000,0.379241,
1.848000,0.381052,
1.849000,0.382864,
1.850000,0.384677,
1.851000,0.386490,
1.852000,0.388304,
1.853000,0.390119,
1.854000,0.391934,
1.855000,0.393750,
1.856000,0.395566,
1.857000,0.397382,
1.858000,0.399199,
1.859000,0.401016,
1.860000,0.402834,
1.861000,0.404652,
1.862000,0.406470,
1.863000,0.408289,
1.864000,0.410107,
1.865000,0.411926,
1.866000,0.413745,
1.867000,0.415564,
1.868000,0.417383,
1.869000,0.419202,
1.870000,0.421022,
1.871000,0.422841,
1.872000,0.424660,
1.873000,0.426479,
1.874000,0.428298,
1.875000,0.430117,
1.876000,0.431936,
1.877000,0.433754,
1.878000,0.435572,
1.879000,0.437390,
1.880000,0.439208,
1.881000,0.441025,
1.882000,0.442842,
1.883000,0.444658,
1.884000,0.446474,
1.885000,0.448290,
1.886000,0.450105,
1.887000,0.451919,
1.888000,0.453733,
1.889000,0.455547,
1.890000,0.457359,
1.891000,0.459171,
1.892000,0.460983,
1.893000,0.462793,
1.894000,0.464603,
1.895000,0.466412,
1.896000,0.468221,
1.897000,0.470028,
1.898000,0.471834,
1.899000,0.473640,
1.900000,0.475445,
1.901000,0.477248,
1.902000,0.479051,
1.903000,0.480853,
1.904000,0.482653,
1.905000,0.484453,
1.906000,0.486251,
1.907000,0.488048,
1.908000,0.489844,
1.909000,0.491639,
1.910000,0.493432,
1.911000,0.495224,
1.912000,0.497015,
1.913000,0.498804,
1.914000,0.500592,
1.915000,0.502379,
1.916000,0.504164,
1.917000,0.505948,
1.918000,0.507730,
1.919000,0.509511,
1.920000,0.511290,
1.921000,0.513067,
1.922000,0.514843,
1.923000,0.516618,
1.924000,0.518390,
1.925000,0.520161,
1.926000,0.521930,
1.927000,0.523697,
1.928000,0.525463,
1.929000,0.527226,
1.930000,0.528988,
1.931000,0.530748,
1.932000,0.532506,
1.933000,0.534262,
1.934000,0.536016,
1.935000,0.537768,
1.936000,0.539518,
1.937000,0.541265,
1.938000,0.543011,
1.939000,0.544755,
1.940000,0.546496,
1.941000,0.548235,
1.942000,0.549972,
1.943000,0.551707,
1.944000,0.553439,
1.945000,0.555169,
1.946000,0.556897,
1.947000,0.558623,
1.948000,0.560346,
1.949000,0.562066,
1.950000,0.563784,
1.951000,0.565500,
1.952000,0.567213,
1.953000,0.568924,
1.954000,0.570632,
1.955000,0.572337,
1.956000,0.574040,
1.957000,0.575740,
1.958000,0.577438,
1.959000,0.579132,
1.960000,0.580824,
1.961000,0.582514,
1.962000,0.584200,
1.963000,0.585884,
1.964000,0.587565,
1.965000,0.589242,
1.966000,0.590917,
1.967000,0.592589,
1.968000,0.594259,
1.969000,0.595925,
1.970000,0.597588,
1.971000,0.599248,
1.972000,0.600905,
1.973000,0.602559,
1.974000,0.604210,
1.975000,0.605857,
1.976000,0.607502,
1.977000,0.609143,
1.978000,0.610781,
1.979000,0.612416,
1.980000,0.614047,
1.981000,0.615676,
1.982000,0.617301,
1.983000,0.618922,
1.984000,0.620540,
1.985000,0.622155,
1.986000,0.623766,
1.987000,0.625374,
1.988000,0.626979,
1.989000,0.628579,
1.990000,0.630177,
1.991000,0.631770,
1.992000,0.633361,
1.993000,0.634947,
1.994000,0.636530,
1.995000,0.638109,
1.996000,0.639685,
1.997000,0.641257,
1.998000,0.642825,
1.999000,0.644389
};

#endif //PENDULUM_GOLD_H
