/***************************************************************************
 *   Copyright (C) 2004 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ALBARANESPROVEEDOR_H
#define ALBARANESPROVEEDOR_H

#include <QLineEdit>

#include "company.h"
#include "busquedaproveedor.h"
#include "busquedaarticulo.h"
#include "funcaux.h"
#include "subform2bf.h"
#include "ficha.h"


/// Clase que maneja el subformulario de los albaranes de proveedor.
/** Deriva de la clase SubForm2Bf.
    Reimplementa los metodos de carga para que trabajan con la tabla albaranp.
*/
class AlbaranesProveedorListSubform : public SubForm2Bf {
    Q_OBJECT

public:
    AlbaranesProveedorListSubform(QWidget *parent = 0);
    ~AlbaranesProveedorListSubform() {};

public slots:
    virtual void cargar() {
        _depura("AlbaranesProveedorListSubform::cargar\n", 0);
        QString SQLQuery = "SELECT * FROM albaranp";
        cursor2 *cur = companyact()->cargacursor(SQLQuery);
        SubForm3::cargar(cur);
        delete cur;
    };
    virtual void cargar(QString query) {
        SubForm3::cargar(query);
    };
};


#include "ui_albaranesproveedorlistbase.h"


/// Clase que controla la pantalla de listado de albaranes a proveedor.
/// \TODO: Deberia derivar de Ficha o Listado en lugar de QWidget.
class AlbaranesProveedor : public Ficha, public Ui_AlbaranesProveedorListBase {
    Q_OBJECT
private:
    /// El puntero m_companyact que se propaga por practicamente todas las clases de la aplicacion.
    company *m_companyact;

    /// Indicador de modo edicion o modo seleccion
    /// == 0 es modo edicion.
    /// == 1 es modo selector.
    int m_modo;
    
    /// En el caso de estar en modo seleccion esta variable de clase indicara el identificador seleccionado.
    QString mdb_idalbaranp;

public:
    AlbaranesProveedor(QWidget *parent = 0, Qt::WFlags flag = 0);
    AlbaranesProveedor(company *comp = NULL, QWidget *parent = 0, Qt::WFlags flag = 0);
    ~AlbaranesProveedor();
    void presenta();
    void modoseleccion() {
        m_modo = 1;
    };
    void modoedicion() {
        m_modo = 0;
    };
    void setcompany(company *comp) {
        m_companyact = comp;
        m_proveedor->setcompany(comp);
        m_articulo->setcompany(comp);
        mui_list->setcompany(comp);
    };
    QString idalbaranp() {
        return mdb_idalbaranp;
    };
    void hideBotonera() {
        m_botonera->hide();
    };
    void showBotonera() {
        m_botonera->show();
    };
    void hideBusqueda() {
        m_busqueda->hide();
    };
    void showBusqueda() {
        m_busqueda->show();
    };
    void imprimir();
    void meteWindow(QString nom, QObject *obj) {
        if (m_companyact != NULL) {
            m_companyact->meteWindow(nom, obj);
        } // end if
    };
    void setidproveedor(QString val) {
        m_proveedor->setidproveedor(val);
    };
    void setidarticulo(QString val) {
        m_articulo->setidarticulo(val);
    };
    QString generaFiltro();
    void editar(int);
    virtual int sacaWindow();
    virtual void on_mui_borrar_clicked();

public slots:
    virtual void on_m_filtro_textChanged(const QString &text) {
        if (text.size() >= 3)
            on_mui_actualizar_clicked();
    };
    void on_mui_list_itemDoubleClicked(QTableWidgetItem *) {
        on_mui_editar_clicked();
    };
    virtual void on_mui_editar_clicked();
    virtual void on_mui_crear_clicked()  {
        if (m_companyact != NULL)
            m_companyact->s_newAlbaranPro();
    };
    virtual void on_mui_imprimir_clicked() {
        imprimir();
    };
    virtual void on_mui_actualizar_clicked() {
        presenta();
    };
    virtual void on_mui_configurar_toggled(bool checked) {
        if (checked) {
            mui_list->showConfig();
        } else {
            mui_list->hideConfig();
        } // end if
    };

signals:
    void selected(QString);
};

#endif

