
//SIMPLE
template <typename Type>
concept bool Simple()
{
    return requires(Type object)
        {
            ++object;
            *object;
            object.operator bool();
        };
};
//=

//              static_cast<bool>(object);
//            {object} -> bool;
//     operator int() const;

//OBJECT
struct Object
{
    Object &operator++();
    int operator*();
    operator bool() const;
};

template <Simple Type>
void fun(Type const &type);
//=

int main()
{
    fun(Object{});
}
