#include <type_traits>
#include <vector>
#include <string>
#include <iostream>

template <typename Data, template <typename> typename Container>
struct Process
{
    Process()
    {
        std::cout << "Generic\n";
    }
};

//BACK
template <typename Data, template <typename> typename Container>
concept bool BackContainer()
{
    return requires(Container<Data> cd)
        {
            cd.pop_back();
            {cd.back()} -> Data &;
        };
}
//=

//PROCESS
template <typename Data, template <typename> typename  Container>
    requires BackContainer<Data, Container>()
class Process <Data, Container>
{};
//=

//    Process()
//    {
//        std::cout << "Constrained\n";
//    }

#include <queue>

template <typename Data>
using Vector = std::vector<Data>;

template <typename Data>
using Queue = std::queue<Data>;

int main()
{
    Process<std::string, Vector> proc1;
    Process<std::string, Queue> proc2;
}
