/*
 * Calcurse - text-based organizer
 * Copyright (c) 2004-2005 Frederic Culot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Send your feedback or comments to : calcurse@culot.org
 * Calcurse home page : http://culot.org/calcurse
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>

#include "event.h"
#include "calendar.h"
#include "vars.h"

  /* Load the calendar */
void
update_cal_panel(int y_cal, int x_cal, int nl_cal,
		 int nc_cal, int sel_month, int sel_year, int sel_day,
		 int day, int month, int year)
{
	int c_day, c_day_1, day_1_sav, numdays, j;
	struct event_s *i;
	unsigned yr, mo;
	int ofs_x, ofs_y;
	int event_this_day;

	// Initialisation
	erase_panel(y_cal, x_cal, nl_cal, nc_cal);	// remove the previous calendar
	mo = sel_month;
	yr = sel_year;

	// Offset for centering calendar in window
	ofs_y = y_cal + 2 + (nl_cal - 9) / 2;
	ofs_x = x_cal + (nc_cal - 27) / 2;

	//checking the number of days in february
	numdays = days[mo - 1];
	if (2 == mo && isBissextile(yr))
		++numdays;

	//the first calendar day will be monday
	c_day_1 = (int) ((ymd_to_scalar(yr, mo, 1) - (long) 1) % 7L);

	//Write the current month and year on top of the calendar
	attron(COLOR_PAIR(6));
	mvprintw(ofs_y,
		 x_cal + (nc_cal - (strlen(monthnames[mo - 1]) + 5)) / 2,
		 "%s %d", monthnames[mo - 1], sel_year);
	attroff(COLOR_PAIR(6));
	++ofs_y;

	//prints the days
	attron(COLOR_PAIR(6));
	for (j = 0; j < 7; j++) {
		mvprintw(ofs_y, ofs_x + 4 * j, "%s", daynames[1 + j]);
	}
	attroff(COLOR_PAIR(6));

	day_1_sav = (c_day_1 + 1) * 3 + c_day_1 - 7;

	for (c_day = 1; c_day <= numdays; ++c_day, ++c_day_1, c_day_1 %= 7) {
		event_this_day = 0;
		for (i = eventlist; i != 0; i = i->next)	//check if the day contains an appointment
			if (event_inday
			    (i,
			     date2sec(sel_year, sel_month, c_day, 0, 0))) {
				event_this_day = 1;
				break;
			}
		if (!c_day_1 && 1 != c_day) {	//go to next line, the week is over
			++ofs_y;
			ofs_x = x_cal + 2 - day_1_sav - 4 * c_day - 1;
		}
		if (c_day == day && month == sel_month && day != sel_day)	//this is today, so print it in yellow
		{
			attron(COLOR_PAIR(5));
			mvprintw(ofs_y + 1,
				 ofs_x + day_1_sav + 4 * c_day + 1, "%2d",
				 c_day);
			attroff(COLOR_PAIR(5));
		} else if (c_day == sel_day && (day != sel_day | month != sel_month))	//this is the selected day, print it in red
		{
			attron(COLOR_PAIR(1));
			mvprintw(ofs_y + 1,
				 ofs_x + day_1_sav + 4 * c_day + 1, "%2d",
				 c_day);
			attroff(COLOR_PAIR(1));
		} else if (c_day == sel_day && day == sel_day && month == sel_month && year == sel_year)	//today is the selected day
		{
			attron(COLOR_PAIR(8));
			mvprintw(ofs_y + 1,
				 ofs_x + day_1_sav + 4 * c_day + 1, "%2d",
				 c_day);
			attroff(COLOR_PAIR(8));
		} else if (event_this_day == 1) {
			attron(COLOR_PAIR(4));
			mvprintw(ofs_y + 1,
				 ofs_x + day_1_sav + 4 * c_day + 1, "%2d",
				 c_day);
			attroff(COLOR_PAIR(4));
		}

		else		// otherwise, print normal days in black
			mvprintw(ofs_y + 1,
				 ofs_x + day_1_sav + 4 * c_day + 1, "%2d",
				 c_day);

	}
}

int isBissextile(unsigned annee)
{
	return annee % 400 == 0 || (annee % 4 == 0 && annee % 100 != 0);
}

// convertion functions
static unsigned months_to_days(unsigned mois)
{
	return (mois * 3057 - 3007) / 100;
}


static long years_to_days(unsigned annee)
{
	return annee * 365L + annee / 4 - annee / 100 + annee / 400;
}

long ymd_to_scalar(unsigned annee, unsigned mois, unsigned jour)
{
	long scalaire;
	scalaire = jour + months_to_days(mois);
	if (mois > 2)
		scalaire -= isBissextile(annee) ? 1 : 2;
	annee--;
	scalaire += years_to_days(annee);
	return scalaire;
}

/* Goto day in calendar */
void
goto_day(int colr, int day, int month, int year,
	 int *sel_day, int *sel_month, int *sel_year)
{
	char selected_day[50] = "";
	int dday, dmonth, dyear;
	int wrong_day = 0;
	char mesg[] = "The day you entered is not valid";

	while (wrong_day != 1) {
		attron(COLOR_PAIR(colr));
		mvprintw(row - 2, 0,
			 "Enter the day to go to [ENTER for today] : dd/mm/yyyy");
		getstring(selected_day, 0, row - 1);
		attroff(COLOR_PAIR(colr));
		if (strlen(selected_day) == 0)	// go to today
		{
			*sel_day = day;
			*sel_month = month;
			*sel_year = year;
			break;
		} else {
			sscanf(selected_day, "%u/%u/%u", &dday, &dmonth,
			       &dyear);
			//check if the entered day is correct
			if ((dday <= 0) | (dday >= 32))
				wrong_day = 1;
			if ((dmonth <= 0) | (dmonth >= 13))
				wrong_day = 1;
			if ((dyear <= 0) | (dyear >= 3000))
				wrong_day = 1;
			//go to chosen day
			if (wrong_day != 1) {
				*sel_day = dday;
				*sel_month = dmonth;
				*sel_year = dyear;
			} else {
				cal_error(mesg, col, row);
			}
			break;
		}
	}
	return;
}
