#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
dnevniavaz.ba
'''

import re
from calibre.web.feeds.recipes import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import Tag

class DnevniAvaz(BasicNewsRecipe):
    title                 = 'Dnevni Avaz'
    __author__            = 'Darko Miletic'
    description           = 'Latest news from Bosnia'
    publisher             = 'Dnevni Avaz'
    category              = 'news, politics, Bosnia and Herzegovina'
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'utf-8'
    use_embedded_content  = False
    remove_javascript     = True
    cover_url             = 'http://www.dnevniavaz.ba/img/logo.gif'
    lang                  = 'bs-BA'
    language = 'bs'

    direction             = 'ltr'

    extra_css = '@font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif1, serif} .article_description{font-family: serif1, serif}'

    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        }

    preprocess_regexps = [(re.compile(u'\u0110'), lambda match: u'\u00D0')]

    keep_only_tags = [dict(name='div', attrs={'id':['fullarticle-title','fullarticle-leading','fullarticle-date','fullarticle-text','articleauthor']})]

    remove_tags = [dict(name=['object','link','base'])]

    feeds = [
               (u'Najnovije'     , u'http://www.dnevniavaz.ba/rss/novo'     )
              ,(u'Najpopularnije', u'http://www.dnevniavaz.ba/rss/popularno')
            ]

    def replace_tagname(self,soup,tagname,tagid,newtagname):
        headtag = soup.find(tagname,attrs={'id':tagid})
        if headtag:
           headtag.name = newtagname
        return

    def preprocess_html(self, soup):
        soup.html['xml:lang'] = self.lang
        soup.html['lang']     = self.lang
        mlang = Tag(soup,'meta',[("http-equiv","Content-Language"),("content",self.lang)])
        mcharset = Tag(soup,'meta',[("http-equiv","Content-Type"),("content","text/html; charset=UTF-8")])
        soup.head.insert(0,mlang)
        soup.head.insert(1,mcharset)
        self.replace_tagname(soup,'div','fullarticle-title'  ,'h1')
        self.replace_tagname(soup,'div','fullarticle-leading','h3')
        self.replace_tagname(soup,'div','fullarticle-date'   ,'h5')
        return self.adeify_images(soup)
