""" Collection of python utility-methodes commonly used by other
    bibliograph packages.
    From http://pypi.python.org/pypi/bibliograph.core/
    from Tom Gross <itconsense@gmail.com>

    Adapted for calibre use

    Zope Public License (ZPL) Version 2.1

    A copyright notice accompanies this license document that
    identifies the copyright holders.

    This license has been certified as open source. It has also
    been designated as GPL compatible by the Free Software
    Foundation (FSF).

    Redistribution and use in source and binary forms, with or
    without modification, are permitted provided that the
    following conditions are met:

    1. Redistributions in source code must retain the
       accompanying copyright notice, this list of conditions,
       and the following disclaimer.

    2. Redistributions in binary form must reproduce the accompanying
       copyright notice, this list of conditions, and the
       following disclaimer in the documentation and/or other
       materials provided with the distribution.

    3. Names of the copyright holders must not be used to
       endorse or promote products derived from this software
       without prior written permission from the copyright
       holders.

    4. The right to distribute this software or to use it for
       any purpose does not give you the right to use
       Servicemarks (sm) or Trademarks (tm) of the copyright
       holders. Use of them is covered by separate agreement
       with the copyright holders.

    5. If any files are modified, you must cause the modified
       files to carry prominent notices stating that you changed
       the files and the date of any change.

    Disclaimer

      THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS''
      AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
      NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
      AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
      NO EVENT SHALL THE COPYRIGHT HOLDERS BE
      LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
      EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
      LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
      LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
      HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
      CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
      OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
      SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
      DAMAGE.
    """

__author__  = 'sengian <sengian1 at gmail.com>'
__docformat__ = 'restructuredtext en'

import re
import string

from calibre.utils.mreplace import MReplace

utf8enc2latex_mapping = {  # {{{
    # This is a mapping of Unicode characters to LaTeX equivalents.
    # The information has been extracted from
    # <http://www.w3.org/2003/entities/xml/unicode.xml>, written by
    # David Carlisle and Sebastian Rahtz.
    #
    # The extraction has been done by the "create_unimap.py" script
    # located at <http://docutils.sf.net/tools/dev/create_unimap.py>.

    # Fix some encoding problem between cp1252 and latin1
    # from http://www.microsoft.com/typography/unicode/1252.htm
    '\x80': '{\\texteuro}',  # EURO SIGN
    '\x82': '{,}',  # SINGLE LOW-9 QUOTATION MARK
    '\x83': '$f$',  # LATIN SMALL LETTER F WITH HOOK
    '\x84': '{,,}',  # DOUBLE LOW-9 QUOTATION MARK
    '\x85': '{\\ldots}',  # HORIZONTAL ELLIPSIS
    '\x86': '{\\textdagger}',  # DAGGER
    '\x87': '{\\textdaggerdbl}',  # DOUBLE DAGGER
    '\x88': '{\textasciicircum}',  # MODIFIER LETTER CIRCUMFLEX ACCENT
    '\x89': '{\\textperthousand}',  # PER MILLE SIGN
    '\x8A': '{\\v{S}}',  # LATIN CAPITAL LETTER S WITH CARON
    '\x8B': '{\\guilsinglleft}',  # SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    '\x8C': '{\\OE}',  # LATIN CAPITAL LIGATURE OE
    '\x8E': '{\\v{Z}}',  # LATIN CAPITAL LETTER Z WITH CARON
    '\x91': '{`}',  # LEFT SINGLE QUOTATION MARK
    '\x92': "{'}",  # RIGHT SINGLE QUOTATION MARK
    '\x93': '{\\textquotedblleft}',  # LEFT DOUBLE QUOTATION MARK
    '\x94': '{\\textquotedblright}',  # RIGHT DOUBLE QUOTATION MARK
    '\x95': '{\\textbullet}',  # BULLET
    '\x96': '{\\textendash}',  # EN DASH
    '\x97': '{\\textemdash}',  # EM DASH
    '\x98': '{\\texttildelow}',  # SMALL TILDE
    '\x99': '{\\texttrademark}',  # TRADE MARK SIGN
    '\x9A': '{\\v{s}}',  # LATIN SMALL LETTER S WITH CARON
    '\x9B': '{\\guilsinglright}',  # SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    '\x9C': '{\\oe}',  # LATIN SMALL LIGATURE OE
    '\x9E': '{\\v{z}}',  # LATIN SMALL LETTER Z WITH CARON
    '\x9F': '{\\"{Y}}',  # LATIN CAPITAL LETTER Y WITH DIAERESIS

    '\xa1': '{\\textexclamdown}',
    '\xa2': '{\\textcent}',
    '\xa3': '{\\textsterling}',
    '\xa4': '{\\textcurrency}',
    '\xa5': '{\\textyen}',
    '\xa6': '{\\textbrokenbar}',
    '\xa7': '{\\textsection}',
    '\xa8': '{\\textasciidieresis}',
    '\xa9': '{\\textcopyright}',
    '\xaa': '{\\textordfeminine}',
    '\xab': '{\\guillemotleft}',
    '\xad': '$\\-$',
    '\xae': '{\\textregistered}',
    '\xaf': '{\\textasciimacron}',
    '\xb0': '{\\textdegree}',
    '\xb6': '{\\textparagraph}',
    '\xba': '{\\textordmasculine}',
    '\xbb': '{\\guillemotright}',
    '\xbc': '{\\textonequarter}',
    '\xbd': '{\\textonehalf}',
    '\xbe': '{\\textthreequarters}',
    '\xbf': '{\\textquestiondown}',
    '\xc6': '{\\AE}',
    '\xd0': '{\\DH}',
    '\xd7': '{\\texttimes}',
    '\xd8': '{\\O}',
    '\xde': '{\\TH}',
    '\xdf': '{\\ss}',
    '\xe6': '{\\ae}',
    '\xf0': '{\\dh}',
    '\xf8': '{\\o}',
    '\xfe': '{\\th}',
    '\u0100': '{\\={A}}',
    '\u0101': '{\\={a}}',
    '\u0108': '{\\^{C}}',
    '\u0109': '{\\^{c}}',
    '\u010a': '{\\.{C}}',
    '\u010b': '{\\.{c}}',
    '\u0110': '{\\DJ}',
    '\u0111': '{\\dj}',
    '\u0112': '{\\={E}}',
    '\u0113': '{\\={e}}',
    '\u0114': '{\\u{E}}',
    '\u0115': '{\\u{e}}',
    '\u0116': '{\\.{E}}',
    '\u0117': '{\\.{e}}',
    '\u011c': '{\\^{G}}',
    '\u011d': '{\\^{g}}',
    '\u0120': '{\\.{G}}',
    '\u0121': '{\\.{g}}',
    '\u0122': '{\\c{G}}',
    '\u0123': '{\\c{g}}',
    '\u0124': '{\\^{H}}',
    '\u0125': '{\\^{h}}',
    '\u0126': '{{\\fontencoding{LELA}\\selectfont\\char40}}',
    '\u0127': '$\\Elzxh$',
    '\u0128': '{\\~{I}}',
    '\u0129': '{\\~{\\i}}',
    '\u012a': '{\\={I}}',
    '\u012b': '{\\={\\i}}',
    '\u012c': '{\\u{I}}',
    '\u012d': '{\\u{\\i}}',
    '\u012e': '{\\k{I}}',
    '\u012f': '{\\k{i}}',
    '\u0131': '{\\i}',
    '\u0132': '{IJ}',
    '\u0133': '{ij}',
    '\u0134': '{\\^{J}}',
    '\u0135': '{\\^{\\j}}',
    '\u0136': '{\\c{K}}',
    '\u0137': '{\\c{k}}',
    '\u0138': '{{\\fontencoding{LELA}\\selectfont\\char91}}',
    '\u013b': '{\\c{L}}',
    '\u013c': '{\\c{l}}',
    '\u013f': '{{\\fontencoding{LELA}\\selectfont\\char201}}',
    '\u0140': '{{\\fontencoding{LELA}\\selectfont\\char202}}',
    '\u0141': '{\\L}',
    '\u0142': '{\\l}',
    '\u0145': '{\\c{N}}',
    '\u0146': '{\\c{n}}',
    '\u0149': "{'n}",
    '\u014a': '{\\NG}',
    '\u014b': '{\\ng}',
    '\u014c': '{\\={O}}',
    '\u014d': '{\\={o}}',
    '\u014e': '{\\u{O}}',
    '\u014f': '{\\u{o}}',
    '\u0152': '{\\OE}',
    '\u0153': '{\\oe}',
    '\u0156': '{\\c{R}}',
    '\u0157': '{\\c{r}}',
    '\u015c': '{\\^{S}}',
    '\u015d': '{\\^{s}}',
    '\u0166': '{{\\fontencoding{LELA}\\selectfont\\char47}}',
    '\u0167': '{{\\fontencoding{LELA}\\selectfont\\char63}}',
    '\u0168': '{\\~{U}}',
    '\u0169': '{\\~{u}}',
    '\u016a': '{\\={U}}',
    '\u016b': '{\\={u}}',
    '\u016c': '{\\u{U}}',
    '\u016d': '{\\u{u}}',
    '\u0172': '{\\k{U}}',
    '\u0173': '{\\k{u}}',
    '\u0174': '{\\^{W}}',
    '\u0175': '{\\^{w}}',
    '\u0176': '{\\^{Y}}',
    '\u0177': '{\\^{y}}',
    '\u0195': '{\\texthvlig}',
    '\u019e': '{\\textnrleg}',
    '\u01aa': '$\\eth$',
    '\u01ba': '{{\\fontencoding{LELA}\\selectfont\\char195}}',
    '\u01c2': '{\\textdoublepipe}',
    '\u01f5': "{\\'{g}}",
    '\u0250': '$\\Elztrna$',
    '\u0252': '$\\Elztrnsa$',
    '\u0254': '$\\Elzopeno$',
    '\u0256': '$\\Elzrtld$',
    '\u0258': '{{\\fontencoding{LEIP}\\selectfont\\char61}}',
    '\u0259': '$\\Elzschwa$',
    '\u025b': '$\\varepsilon$',
    '\u0261': '{g}',
    '\u0263': '$\\Elzpgamma$',
    '\u0264': '$\\Elzpbgam$',
    '\u0265': '$\\Elztrnh$',
    '\u026c': '$\\Elzbtdl$',
    '\u026d': '$\\Elzrtll$',
    '\u026f': '$\\Elztrnm$',
    '\u0270': '$\\Elztrnmlr$',
    '\u0271': '$\\Elzltlmr$',
    '\u0272': '{\\Elzltln}',
    '\u0273': '$\\Elzrtln$',
    '\u0277': '$\\Elzclomeg$',
    '\u0278': '{\\textphi}',
    '\u0279': '$\\Elztrnr$',
    '\u027a': '$\\Elztrnrl$',
    '\u027b': '$\\Elzrttrnr$',
    '\u027c': '$\\Elzrl$',
    '\u027d': '$\\Elzrtlr$',
    '\u027e': '$\\Elzfhr$',
    '\u027f': '{{\\fontencoding{LEIP}\\selectfont\\char202}}',
    '\u0282': '$\\Elzrtls$',
    '\u0283': '$\\Elzesh$',
    '\u0287': '$\\Elztrnt$',
    '\u0288': '$\\Elzrtlt$',
    '\u028a': '$\\Elzpupsil$',
    '\u028b': '$\\Elzpscrv$',
    '\u028c': '$\\Elzinvv$',
    '\u028d': '$\\Elzinvw$',
    '\u028e': '$\\Elztrny$',
    '\u0290': '$\\Elzrtlz$',
    '\u0292': '$\\Elzyogh$',
    '\u0294': '$\\Elzglst$',
    '\u0295': '$\\Elzreglst$',
    '\u0296': '$\\Elzinglst$',
    '\u029e': '{\\textturnk}',
    '\u02a4': '$\\Elzdyogh$',
    '\u02a7': '$\\Elztesh$',
    '\u02bc': "{'}",
    '\u02c7': '{\\textasciicaron}',
    '\u02c8': '$\\Elzverts$',
    '\u02cc': '$\\Elzverti$',
    '\u02d0': '$\\Elzlmrk$',
    '\u02d1': '$\\Elzhlmrk$',
    '\u02d2': '$\\Elzsbrhr$',
    '\u02d3': '$\\Elzsblhr$',
    '\u02d4': '$\\Elzrais$',
    '\u02d5': '$\\Elzlow$',
    '\u02d8': '{\\textasciibreve}',
    '\u02d9': '{\\textperiodcentered}',
    '\u02da': '{\\r{}}',
    '\u02db': '{\\k{}}',
    '\u02dc': '{\\texttildelow}',
    '\u02e5': '{\\tone{55}}',
    '\u02e6': '{\\tone{44}}',
    '\u02e7': '{\\tone{33}}',
    '\u02e8': '{\\tone{22}}',
    '\u02e9': '{\\tone{11}}',
    '\u0300': '{\\`}',
    '\u0301': "{\\'}",
    '\u0302': '{\\^}',
    '\u0303': '{\\~}',
    '\u0304': '{\\=}',
    '\u0306': '{\\u}',
    '\u0307': '{\\.}',
    '\u0308': '{\\"}',
    '\u030a': '{\\r}',
    '\u030b': '{\\H}',
    '\u030c': '{\\v}',
    '\u030f': '{\\cyrchar\\C}',
    '\u0311': '{{\\fontencoding{LECO}\\selectfont\\char177}}',
    '\u0318': '{{\\fontencoding{LECO}\\selectfont\\char184}}',
    '\u0319': '{{\\fontencoding{LECO}\\selectfont\\char185}}',
    '\u0321': '$\\Elzpalh$',
    '\u0322': '{\\Elzrh}',
    '\u0327': '{\\c}',
    '\u0328': '{\\k}',
    '\u032a': '$\\Elzsbbrg$',
    '\u032b': '{{\\fontencoding{LECO}\\selectfont\\char203}}',
    '\u032f': '{{\\fontencoding{LECO}\\selectfont\\char207}}',
    '\u0335': '{\\Elzxl}',
    '\u0336': '{\\Elzbar}',
    '\u0337': '{{\\fontencoding{LECO}\\selectfont\\char215}}',
    '\u0338': '{{\\fontencoding{LECO}\\selectfont\\char216}}',
    '\u033a': '{{\\fontencoding{LECO}\\selectfont\\char218}}',
    '\u033b': '{{\\fontencoding{LECO}\\selectfont\\char219}}',
    '\u033c': '{{\\fontencoding{LECO}\\selectfont\\char220}}',
    '\u033d': '{{\\fontencoding{LECO}\\selectfont\\char221}}',
    '\u0361': '{{\\fontencoding{LECO}\\selectfont\\char225}}',
    '\u0386': "{\\'{A}}",
    '\u0388': "{\\'{E}}",
    '\u0389': "{\\'{H}}",
    '\u038a': "{\\'{}{I}}",
    '\u038c': "{\\'{}O}",
    '\u038e': "$\\mathrm{'Y}$",
    '\u038f': "$\\mathrm{'\\Omega}$",
    '\u0390': '$\\acute{\\ddot{\\iota}}$',
    '\u0391': '$\\Alpha$',
    '\u0392': '$\\Beta$',
    '\u0393': '$\\Gamma$',
    '\u0394': '$\\Delta$',
    '\u0395': '$\\Epsilon$',
    '\u0396': '$\\Zeta$',
    '\u0397': '$\\Eta$',
    '\u0398': '$\\Theta$',
    '\u0399': '$\\Iota$',
    '\u039a': '$\\Kappa$',
    '\u039b': '$\\Lambda$',
    '\u039c': '$M$',
    '\u039d': '$N$',
    '\u039e': '$\\Xi$',
    '\u039f': '$O$',
    '\u03a0': '$\\Pi$',
    '\u03a1': '$\\Rho$',
    '\u03a3': '$\\Sigma$',
    '\u03a4': '$\\Tau$',
    '\u03a5': '$\\Upsilon$',
    '\u03a6': '$\\Phi$',
    '\u03a8': '$\\Psi$',
    '\u03a9': '$\\Omega$',
    '\u03aa': '$\\mathrm{\\ddot{I}}$',
    '\u03ab': '$\\mathrm{\\ddot{Y}}$',
    '\u03ac': "{\\'{$\\alpha$}}",
    '\u03ad': '$\\acute{\\epsilon}$',
    '\u03ae': '$\\acute{\\eta}$',
    '\u03af': '$\\acute{\\iota}$',
    '\u03b0': '$\\acute{\\ddot{\\upsilon}}$',
    '\u03b1': '$\\alpha$',
    '\u03b2': '$\\beta$',
    '\u03b3': '$\\gamma$',
    '\u03b4': '$\\delta$',
    '\u03b5': '$\\epsilon$',
    '\u03b6': '$\\zeta$',
    '\u03b7': '$\\eta$',
    '\u03b8': '{\\texttheta}',
    '\u03b9': '$\\iota$',
    '\u03ba': '$\\kappa$',
    '\u03bb': '$\\lambda$',
    '\u03bc': '$\\mu$',
    '\u03be': '$\\xi$',
    '\u03bf': '$o$',
    '\u03c0': '$\\pi$',
    '\u03c1': '$\\rho$',
    '\u03c2': '$\\varsigma$',
    '\u03c3': '$\\sigma$',
    '\u03c4': '$\\tau$',
    '\u03c5': '$\\upsilon$',
    '\u03c6': '$\\varphi$',
    '\u03c7': '$\\chi$',
    '\u03c8': '$\\psi$',
    '\u03c9': '$\\omega$',
    '\u03ca': '$\\ddot{\\iota}$',
    '\u03cb': '$\\ddot{\\upsilon}$',
    '\u03cc': "{\\'{o}}",
    '\u03cd': '$\\acute{\\upsilon}$',
    '\u03ce': '$\\acute{\\omega}$',
    '\u03d0': '{\\Pisymbol{ppi022}{87}}',
    '\u03d1': '{\\textvartheta}',
    '\u03d2': '$\\Upsilon$',
    '\u03d5': '$\\phi$',
    '\u03d6': '$\\varpi$',
    '\u03da': '$\\Stigma$',
    '\u03dc': '$\\Digamma$',
    '\u03dd': '$\\digamma$',
    '\u03de': '$\\Koppa$',
    '\u03e0': '$\\Sampi$',
    '\u03f0': '$\\varkappa$',
    '\u03f1': '$\\varrho$',
    '\u03f4': '{\\textTheta}',
    '\u03f6': '$\\backepsilon$',
    '\u0403': "{\\cyrchar{\\'\\CYRG}}",
    '\u040c': "{\\cyrchar{\\'\\CYRK}}",
    '\u0453': "{\\cyrchar{\\'\\cyrg}}",
    '\u045c': "{\\cyrchar{\\'\\cyrk}}",
    '\u0460': '{\\cyrchar\\CYROMEGA}',
    '\u0461': '{\\cyrchar\\cyromega}',
    '\u0464': '{\\cyrchar\\CYRIOTE}',
    '\u0465': '{\\cyrchar\\cyriote}',
    '\u0466': '{\\cyrchar\\CYRLYUS}',
    '\u0467': '{\\cyrchar\\cyrlyus}',
    '\u0468': '{\\cyrchar\\CYRIOTLYUS}',
    '\u0469': '{\\cyrchar\\cyriotlyus}',
    '\u046c': '{\\cyrchar\\CYRIOTBYUS}',
    '\u046d': '{\\cyrchar\\cyriotbyus}',
    '\u046e': '{\\cyrchar\\CYRKSI}',
    '\u046f': '{\\cyrchar\\cyrksi}',
    '\u0470': '{\\cyrchar\\CYRPSI}',
    '\u0471': '{\\cyrchar\\cyrpsi}',
    '\u0478': '{\\cyrchar\\CYRUK}',
    '\u0479': '{\\cyrchar\\cyruk}',
    '\u047a': '{\\cyrchar\\CYROMEGARND}',
    '\u047b': '{\\cyrchar\\cyromegarnd}',
    '\u047c': '{\\cyrchar\\CYROMEGATITLO}',
    '\u047d': '{\\cyrchar\\cyromegatitlo}',
    '\u047e': '{\\cyrchar\\CYROT}',
    '\u047f': '{\\cyrchar\\cyrot}',
    '\u0480': '{\\cyrchar\\CYRKOPPA}',
    '\u0481': '{\\cyrchar\\cyrkoppa}',
    '\u0482': '{\\cyrchar\\cyrthousands}',
    '\u0488': '{\\cyrchar\\cyrhundredthousands}',
    '\u0489': '{\\cyrchar\\cyrmillions}',
    '\u2002': '{\\hspace{0.6em}}',
    '\u2003': '{\\hspace{1em}}',
    '\u2004': '{\\hspace{0.33em}}',
    '\u2005': '{\\hspace{0.25em}}',
    '\u2006': '{\\hspace{0.166em}}',
    '\u2007': '{\\hphantom{0}}',
    '\u2008': '{\\hphantom{,}}',
    '\u2009': '{\\hspace{0.167em}}',
    '\u200a': '$\\mkern1mu$',
    '\u2010': '{-}',
    '\u2013': '{\\textendash}',
    '\u2014': '{\\textemdash}',
    '\u2015': '{\\rule{1em}{1pt}}',
    '\u201b': '$\\Elzreapos$',
    '\u201c': '{\\textquotedblleft}',
    '\u201d': '{\\textquotedblright}',
    '\u2020': '{\\textdagger}',
    '\u2021': '{\\textdaggerdbl}',
    '\u2022': '{\\textbullet}',
    '\u2024': '{.}',
    '\u2025': '{..}',
    '\u2030': '{\\textperthousand}',
    '\u2031': '{\\textpertenthousand}',
    '\u2033': "${''}$",
    '\u2034': "${'''}$",
    '\u2035': '$\\backprime$',
    '\u2039': '{\\guilsinglleft}',
    '\u203a': '{\\guilsinglright}',
    '\u2057': "$''''$",
    '\u205f': '{\\mkern4mu}',
    '\u2060': '{\\nolinebreak}',
    '\u20a7': '{\\ensuremath{\\Elzpes}}',
    '\u20ac': '{\\texteuro}',
    '\u20db': '$\\dddot$',
    '\u20dc': '$\\ddddot$',
    '\u2102': '$\\mathbb{C}$',
    '\u210a': '{\\mathscr{g}}',
    '\u210b': '$\\mathscr{H}$',
    '\u210c': '$\\mathfrak{H}$',
    '\u210d': '$\\mathbb{H}$',
    '\u210f': '$\\hslash$',
    '\u2110': '$\\mathscr{I}$',
    '\u2111': '$\\mathfrak{I}$',
    '\u2112': '$\\mathscr{L}$',
    '\u2113': '$\\mathscr{l}$',
    '\u2115': '$\\mathbb{N}$',
    '\u2118': '$\\wp$',
    '\u2119': '$\\mathbb{P}$',
    '\u211a': '$\\mathbb{Q}$',
    '\u211b': '$\\mathscr{R}$',
    '\u211c': '$\\mathfrak{R}$',
    '\u211d': '$\\mathbb{R}$',
    '\u2122': '{\\texttrademark}',
    '\u2124': '$\\mathbb{Z}$',
    '\u2128': '$\\mathfrak{Z}$',
    '\u2129': '$\\ElsevierGlyph{2129}$',
    '\u212b': '{\\AA}',
    '\u212c': '$\\mathscr{B}$',
    '\u212d': '$\\mathfrak{C}$',
    '\u212f': '$\\mathscr{e}$',
    '\u2130': '$\\mathscr{E}$',
    '\u2131': '$\\mathscr{F}$',
    '\u2133': '$\\mathscr{M}$',
    '\u2134': '$\\mathscr{o}$',
    '\u2135': '$\\aleph$',
    '\u2136': '$\\beth$',
    '\u2137': '$\\gimel$',
    '\u2138': '$\\daleth$',
    '\u2153': '$\\textfrac{1}{3}$',
    '\u2154': '$\\textfrac{2}{3}$',
    '\u2155': '$\\textfrac{1}{5}$',
    '\u2156': '$\\textfrac{2}{5}$',
    '\u2157': '$\\textfrac{3}{5}$',
    '\u2158': '$\\textfrac{4}{5}$',
    '\u2159': '$\\textfrac{1}{6}$',
    '\u215a': '$\\textfrac{5}{6}$',
    '\u215b': '$\\textfrac{1}{8}$',
    '\u215c': '$\\textfrac{3}{8}$',
    '\u215d': '$\\textfrac{5}{8}$',
    '\u215e': '$\\textfrac{7}{8}$',
    '\u2194': '$\\leftrightarrow$',
    '\u2195': '$\\updownarrow$',
    '\u2196': '$\\nwarrow$',
    '\u2197': '$\\nearrow$',
    '\u2198': '$\\searrow$',
    '\u2199': '$\\swarrow$',
    '\u219a': '$\\nleftarrow$',
    '\u219b': '$\\nrightarrow$',
    '\u219c': '$\\arrowwaveright$',
    '\u219d': '$\\arrowwaveright$',
    '\u219e': '$\\twoheadleftarrow$',
    '\u21a0': '$\\twoheadrightarrow$',
    '\u21a2': '$\\leftarrowtail$',
    '\u21a3': '$\\rightarrowtail$',
    '\u21a6': '$\\mapsto$',
    '\u21a9': '$\\hookleftarrow$',
    '\u21aa': '$\\hookrightarrow$',
    '\u21ab': '$\\looparrowleft$',
    '\u21ac': '$\\looparrowright$',
    '\u21ad': '$\\leftrightsquigarrow$',
    '\u21ae': '$\\nleftrightarrow$',
    '\u21b0': '$\\Lsh$',
    '\u21b1': '$\\Rsh$',
    '\u21b3': '$\\ElsevierGlyph{21B3}$',
    '\u21b6': '$\\curvearrowleft$',
    '\u21b7': '$\\curvearrowright$',
    '\u21ba': '$\\circlearrowleft$',
    '\u21bb': '$\\circlearrowright$',
    '\u21bc': '$\\leftharpoonup$',
    '\u21bd': '$\\leftharpoondown$',
    '\u21be': '$\\upharpoonright$',
    '\u21bf': '$\\upharpoonleft$',
    '\u21c0': '$\\rightharpoonup$',
    '\u21c1': '$\\rightharpoondown$',
    '\u21c2': '$\\downharpoonright$',
    '\u21c3': '$\\downharpoonleft$',
    '\u21c4': '$\\rightleftarrows$',
    '\u21c5': '$\\dblarrowupdown$',
    '\u21c6': '$\\leftrightarrows$',
    '\u21c7': '$\\leftleftarrows$',
    '\u21c8': '$\\upuparrows$',
    '\u21c9': '$\\rightrightarrows$',
    '\u21ca': '$\\downdownarrows$',
    '\u21cb': '$\\leftrightharpoons$',
    '\u21cc': '$\\rightleftharpoons$',
    '\u21cd': '$\\nLeftarrow$',
    '\u21ce': '$\\nLeftrightarrow$',
    '\u21cf': '$\\nRightarrow$',
    '\u21d0': '$\\Leftarrow$',
    '\u21d1': '$\\Uparrow$',
    '\u21d2': '$\\Rightarrow$',
    '\u21d3': '$\\Downarrow$',
    '\u21d4': '$\\Leftrightarrow$',
    '\u21d5': '$\\Updownarrow$',
    '\u21da': '$\\Lleftarrow$',
    '\u21db': '$\\Rrightarrow$',
    '\u21dd': '$\\rightsquigarrow$',
    '\u21f5': '$\\DownArrowUpArrow$',
    '\u2200': '$\\forall$',
    '\u2201': '$\\complement$',
    '\u2202': '$\\partial$',
    '\u2203': '$\\exists$',
    '\u2204': '$\\nexists$',
    '\u2205': '$\\varnothing$',
    '\u2207': '$\\nabla$',
    '\u2208': '$\\in$',
    '\u2209': '$\\not\\in$',
    '\u220b': '$\\ni$',
    '\u220c': '$\\not\\ni$',
    '\u220f': '$\\prod$',
    '\u2210': '$\\coprod$',
    '\u2211': '$\\sum$',
    '\u2213': '$\\mp$',
    '\u2214': '$\\dotplus$',
    '\u2216': '$\\setminus$',
    '\u2217': '${_\\ast}$',
    '\u2218': '$\\circ$',
    '\u2219': '$\\bullet$',
    '\u221a': '$\\surd$',
    '\u221d': '$\\propto$',
    '\u221e': '$\\infty$',
    '\u221f': '$\\rightangle$',
    '\u2220': '$\\angle$',
    '\u2221': '$\\measuredangle$',
    '\u2222': '$\\sphericalangle$',
    '\u2223': '$\\mid$',
    '\u2224': '$\\nmid$',
    '\u2225': '$\\parallel$',
    '\u2226': '$\\nparallel$',
    '\u2227': '$\\wedge$',
    '\u2228': '$\\vee$',
    '\u2229': '$\\cap$',
    '\u222a': '$\\cup$',
    '\u222b': '$\\int$',
    '\u222c': '$\\int\\!\\int$',
    '\u222d': '$\\int\\!\\int\\!\\int$',
    '\u222e': '$\\oint$',
    '\u222f': '$\\surfintegral$',
    '\u2230': '$\\volintegral$',
    '\u2231': '$\\clwintegral$',
    '\u2232': '$\\ElsevierGlyph{2232}$',
    '\u2233': '$\\ElsevierGlyph{2233}$',
    '\u2234': '$\\therefore$',
    '\u2235': '$\\because$',
    '\u2237': '$\\Colon$',
    '\u2238': '$\\ElsevierGlyph{2238}$',
    '\u223a': '$\\mathbin{{:}\\!\\!{-}\\!\\!{:}}$',
    '\u223b': '$\\homothetic$',
    '\u223c': '$\\sim$',
    '\u223d': '$\\backsim$',
    '\u223e': '$\\lazysinv$',
    '\u2240': '$\\wr$',
    '\u2241': '$\\not\\sim$',
    '\u2242': '$\\ElsevierGlyph{2242}$',
    '\u2243': '$\\simeq$',
    '\u2244': '$\\not\\simeq$',
    '\u2245': '$\\cong$',
    '\u2246': '$\\approxnotequal$',
    '\u2247': '$\\not\\cong$',
    '\u2248': '$\\approx$',
    '\u2249': '$\\not\\approx$',
    '\u224a': '$\\approxeq$',
    '\u224b': '$\\tildetrpl$',
    '\u224c': '$\\allequal$',
    '\u224d': '$\\asymp$',
    '\u224e': '$\\Bumpeq$',
    '\u224f': '$\\bumpeq$',
    '\u2250': '$\\doteq$',
    '\u2251': '$\\doteqdot$',
    '\u2252': '$\\fallingdotseq$',
    '\u2253': '$\\risingdotseq$',
    '\u2254': '{:=}',
    '\u2255': '$=:$',
    '\u2256': '$\\eqcirc$',
    '\u2257': '$\\circeq$',
    '\u2259': '$\\estimates$',
    '\u225a': '$\\ElsevierGlyph{225A}$',
    '\u225b': '$\\starequal$',
    '\u225c': '$\\triangleq$',
    '\u225f': '$\\ElsevierGlyph{225F}$',
    '\u2260': '$\\not =$',
    '\u2262': '$\\not\\equiv$',
    '\u2264': '$\\leq$',
    '\u2265': '$\\geq$',
    '\u2266': '$\\leqq$',
    '\u2267': '$\\geqq$',
    '\u2268': '$\\lneqq$',
    '\u2269': '$\\gneqq$',
    '\u226a': '$\\ll$',
    '\u226b': '$\\gg$',
    '\u226c': '$\\between$',
    '\u226d': '$\\not\\kern-0.3em\\times$',
    '\u226e': '$\\not<$',
    '\u226f': '$\\not>$',
    '\u2270': '$\\not\\leq$',
    '\u2271': '$\\not\\geq$',
    '\u2272': '$\\lessequivlnt$',
    '\u2273': '$\\greaterequivlnt$',
    '\u2274': '$\\ElsevierGlyph{2274}$',
    '\u2275': '$\\ElsevierGlyph{2275}$',
    '\u2276': '$\\lessgtr$',
    '\u2277': '$\\gtrless$',
    '\u2278': '$\\notlessgreater$',
    '\u2279': '$\\notgreaterless$',
    '\u227a': '$\\prec$',
    '\u227b': '$\\succ$',
    '\u227c': '$\\preccurlyeq$',
    '\u227d': '$\\succcurlyeq$',
    '\u227e': '$\\precapprox$',
    '\u227f': '$\\succapprox$',
    '\u2280': '$\\not\\prec$',
    '\u2281': '$\\not\\succ$',
    '\u2282': '$\\subset$',
    '\u2283': '$\\supset$',
    '\u2284': '$\\not\\subset$',
    '\u2285': '$\\not\\supset$',
    '\u2286': '$\\subseteq$',
    '\u2287': '$\\supseteq$',
    '\u2288': '$\\not\\subseteq$',
    '\u2289': '$\\not\\supseteq$',
    '\u228a': '$\\subsetneq$',
    '\u228b': '$\\supsetneq$',
    '\u228e': '$\\uplus$',
    '\u228f': '$\\sqsubset$',
    '\u2290': '$\\sqsupset$',
    '\u2291': '$\\sqsubseteq$',
    '\u2292': '$\\sqsupseteq$',
    '\u2293': '$\\sqcap$',
    '\u2294': '$\\sqcup$',
    '\u2295': '$\\oplus$',
    '\u2296': '$\\ominus$',
    '\u2297': '$\\otimes$',
    '\u2298': '$\\oslash$',
    '\u2299': '$\\odot$',
    '\u229a': '$\\circledcirc$',
    '\u229b': '$\\circledast$',
    '\u229d': '$\\circleddash$',
    '\u229e': '$\\boxplus$',
    '\u229f': '$\\boxminus$',
    '\u22a0': '$\\boxtimes$',
    '\u22a1': '$\\boxdot$',
    '\u22a2': '$\\vdash$',
    '\u22a3': '$\\dashv$',
    '\u22a4': '$\\top$',
    '\u22a5': '$\\perp$',
    '\u22a7': '$\\truestate$',
    '\u22a8': '$\\forcesextra$',
    '\u22a9': '$\\Vdash$',
    '\u22aa': '$\\Vvdash$',
    '\u22ab': '$\\VDash$',
    '\u22ac': '$\\nvdash$',
    '\u22ad': '$\\nvDash$',
    '\u22ae': '$\\nVdash$',
    '\u22af': '$\\nVDash$',
    '\u22b2': '$\\vartriangleleft$',
    '\u22b3': '$\\vartriangleright$',
    '\u22b4': '$\\trianglelefteq$',
    '\u22b5': '$\\trianglerighteq$',
    '\u22b6': '$\\original$',
    '\u22b7': '$\\image$',
    '\u22b8': '$\\multimap$',
    '\u22b9': '$\\hermitconjmatrix$',
    '\u22ba': '$\\intercal$',
    '\u22bb': '$\\veebar$',
    '\u22be': '$\\rightanglearc$',
    '\u22c0': '$\\ElsevierGlyph{22C0}$',
    '\u22c1': '$\\ElsevierGlyph{22C1}$',
    '\u22c2': '$\\bigcap$',
    '\u22c3': '$\\bigcup$',
    '\u22c4': '$\\diamond$',
    '\u22c5': '$\\cdot$',
    '\u22c6': '$\\star$',
    '\u22c7': '$\\divideontimes$',
    '\u22c8': '$\\bowtie$',
    '\u22c9': '$\\ltimes$',
    '\u22ca': '$\\rtimes$',
    '\u22cb': '$\\leftthreetimes$',
    '\u22cc': '$\\rightthreetimes$',
    '\u22cd': '$\\backsimeq$',
    '\u22ce': '$\\curlyvee$',
    '\u22cf': '$\\curlywedge$',
    '\u22d0': '$\\Subset$',
    '\u22d1': '$\\Supset$',
    '\u22d2': '$\\Cap$',
    '\u22d3': '$\\Cup$',
    '\u22d4': '$\\pitchfork$',
    '\u22d6': '$\\lessdot$',
    '\u22d7': '$\\gtrdot$',
    '\u22d8': '$\\verymuchless$',
    '\u22d9': '$\\verymuchgreater$',
    '\u22da': '$\\lesseqgtr$',
    '\u22db': '$\\gtreqless$',
    '\u22de': '$\\curlyeqprec$',
    '\u22df': '$\\curlyeqsucc$',
    '\u22e2': '$\\not\\sqsubseteq$',
    '\u22e3': '$\\not\\sqsupseteq$',
    '\u22e5': '$\\Elzsqspne$',
    '\u22e6': '$\\lnsim$',
    '\u22e7': '$\\gnsim$',
    '\u22e8': '$\\precedesnotsimilar$',
    '\u22e9': '$\\succnsim$',
    '\u22ea': '$\\ntriangleleft$',
    '\u22eb': '$\\ntriangleright$',
    '\u22ec': '$\\ntrianglelefteq$',
    '\u22ed': '$\\ntrianglerighteq$',
    '\u22ee': '$\\vdots$',
    '\u22ef': '$\\cdots$',
    '\u22f0': '$\\upslopeellipsis$',
    '\u22f1': '$\\downslopeellipsis$',
    '\u2305': '{\\barwedge}',
    '\u2306': '$\\perspcorrespond$',
    '\u2308': '$\\lceil$',
    '\u2309': '$\\rceil$',
    '\u230a': '$\\lfloor$',
    '\u230b': '$\\rfloor$',
    '\u2315': '$\\recorder$',
    '\u2316': '$\\mathchar"2208$',
    '\u231c': '$\\ulcorner$',
    '\u231d': '$\\urcorner$',
    '\u231e': '$\\llcorner$',
    '\u231f': '$\\lrcorner$',
    '\u2322': '$\\frown$',
    '\u2323': '$\\smile$',
    '\u233d': '$\\ElsevierGlyph{E838}$',
    '\u23a3': '$\\Elzdlcorn$',
    '\u23b0': '$\\lmoustache$',
    '\u23b1': '$\\rmoustache$',
    '\u2423': '{\\textvisiblespace}',
    '\u2460': '{\\ding{172}}',
    '\u2461': '{\\ding{173}}',
    '\u2462': '{\\ding{174}}',
    '\u2463': '{\\ding{175}}',
    '\u2464': '{\\ding{176}}',
    '\u2465': '{\\ding{177}}',
    '\u2466': '{\\ding{178}}',
    '\u2467': '{\\ding{179}}',
    '\u2468': '{\\ding{180}}',
    '\u2469': '{\\ding{181}}',
    '\u24c8': '$\\circledS$',
    '\u2506': '$\\Elzdshfnc$',
    '\u2519': '$\\Elzsqfnw$',
    '\u2571': '$\\diagup$',
    '\u25a0': '{\\ding{110}}',
    '\u25a1': '$\\square$',
    '\u25aa': '$\\blacksquare$',
    '\u25ad': '$\\fbox{~~}$',
    '\u25af': '$\\Elzvrecto$',
    '\u25b1': '$\\ElsevierGlyph{E381}$',
    '\u25b2': '{\\ding{115}}',
    '\u25b3': '$\\bigtriangleup$',
    '\u25b4': '$\\blacktriangle$',
    '\u25b5': '$\\vartriangle$',
    '\u25b8': '$\\blacktriangleright$',
    '\u25b9': '$\\triangleright$',
    '\u25bc': '{\\ding{116}}',
    '\u25bd': '$\\bigtriangledown$',
    '\u25be': '$\\blacktriangledown$',
    '\u25bf': '$\\triangledown$',
    '\u25c2': '$\\blacktriangleleft$',
    '\u25c3': '$\\triangleleft$',
    '\u25c6': '{\\ding{117}}',
    '\u25ca': '$\\lozenge$',
    '\u25cb': '$\\bigcirc$',
    '\u25cf': '{\\ding{108}}',
    '\u25d0': '$\\Elzcirfl$',
    '\u25d1': '$\\Elzcirfr$',
    '\u25d2': '$\\Elzcirfb$',
    '\u25d7': '{\\ding{119}}',
    '\u25d8': '$\\Elzrvbull$',
    '\u25e7': '$\\Elzsqfl$',
    '\u25e8': '$\\Elzsqfr$',
    '\u25ea': '$\\Elzsqfse$',
    '\u2605': '{\\ding{72}}',
    '\u2606': '{\\ding{73}}',
    '\u260e': '{\\ding{37}}',
    '\u261b': '{\\ding{42}}',
    '\u261e': '{\\ding{43}}',
    '\u263e': '{\\rightmoon}',
    '\u263f': '{\\mercury}',
    '\u2640': '{\\venus}',
    '\u2642': '{\\male}',
    '\u2643': '{\\jupiter}',
    '\u2644': '{\\saturn}',
    '\u2645': '{\\uranus}',
    '\u2646': '{\\neptune}',
    '\u2647': '{\\pluto}',
    '\u2648': '{\\aries}',
    '\u2649': '{\\taurus}',
    '\u264a': '{\\gemini}',
    '\u264b': '{\\cancer}',
    '\u264c': '{\\leo}',
    '\u264d': '{\\virgo}',
    '\u264e': '{\\libra}',
    '\u264f': '{\\scorpio}',
    '\u2650': '{\\sagittarius}',
    '\u2651': '{\\capricornus}',
    '\u2652': '{\\aquarius}',
    '\u2653': '{\\pisces}',
    '\u2660': '{\\ding{171}}',
    '\u2662': '$\\diamond$',
    '\u2663': '{\\ding{168}}',
    '\u2665': '{\\ding{170}}',
    '\u2666': '{\\ding{169}}',
    '\u2669': '{\\quarternote}',
    '\u266d': '$\\flat$',
    '\u266e': '$\\natural$',
    '\u266f': '$\\sharp$',
    '\u2701': '{\\ding{33}}',
    '\u2702': '{\\ding{34}}',
    '\u2703': '{\\ding{35}}',
    '\u2704': '{\\ding{36}}',
    '\u2706': '{\\ding{38}}',
    '\u2707': '{\\ding{39}}',
    '\u2708': '{\\ding{40}}',
    '\u2709': '{\\ding{41}}',
    '\u270c': '{\\ding{44}}',
    '\u270d': '{\\ding{45}}',
    '\u270e': '{\\ding{46}}',
    '\u270f': '{\\ding{47}}',
    '\u2710': '{\\ding{48}}',
    '\u2711': '{\\ding{49}}',
    '\u2712': '{\\ding{50}}',
    '\u2713': '{\\ding{51}}',
    '\u2714': '{\\ding{52}}',
    '\u2715': '{\\ding{53}}',
    '\u2716': '{\\ding{54}}',
    '\u2717': '{\\ding{55}}',
    '\u2718': '{\\ding{56}}',
    '\u2719': '{\\ding{57}}',
    '\u271a': '{\\ding{58}}',
    '\u271b': '{\\ding{59}}',
    '\u271c': '{\\ding{60}}',
    '\u271d': '{\\ding{61}}',
    '\u271e': '{\\ding{62}}',
    '\u271f': '{\\ding{63}}',
    '\u2720': '{\\ding{64}}',
    '\u2721': '{\\ding{65}}',
    '\u2722': '{\\ding{66}}',
    '\u2723': '{\\ding{67}}',
    '\u2724': '{\\ding{68}}',
    '\u2725': '{\\ding{69}}',
    '\u2726': '{\\ding{70}}',
    '\u2727': '{\\ding{71}}',
    '\u2729': '{\\ding{73}}',
    '\u272a': '{\\ding{74}}',
    '\u272b': '{\\ding{75}}',
    '\u272c': '{\\ding{76}}',
    '\u272d': '{\\ding{77}}',
    '\u272e': '{\\ding{78}}',
    '\u272f': '{\\ding{79}}',
    '\u2730': '{\\ding{80}}',
    '\u2731': '{\\ding{81}}',
    '\u2732': '{\\ding{82}}',
    '\u2733': '{\\ding{83}}',
    '\u2734': '{\\ding{84}}',
    '\u2735': '{\\ding{85}}',
    '\u2736': '{\\ding{86}}',
    '\u2737': '{\\ding{87}}',
    '\u2738': '{\\ding{88}}',
    '\u2739': '{\\ding{89}}',
    '\u273a': '{\\ding{90}}',
    '\u273b': '{\\ding{91}}',
    '\u273c': '{\\ding{92}}',
    '\u273d': '{\\ding{93}}',
    '\u273e': '{\\ding{94}}',
    '\u273f': '{\\ding{95}}',
    '\u2740': '{\\ding{96}}',
    '\u2741': '{\\ding{97}}',
    '\u2742': '{\\ding{98}}',
    '\u2743': '{\\ding{99}}',
    '\u2744': '{\\ding{100}}',
    '\u2745': '{\\ding{101}}',
    '\u2746': '{\\ding{102}}',
    '\u2747': '{\\ding{103}}',
    '\u2748': '{\\ding{104}}',
    '\u2749': '{\\ding{105}}',
    '\u274a': '{\\ding{106}}',
    '\u274b': '{\\ding{107}}',
    '\u274d': '{\\ding{109}}',
    '\u274f': '{\\ding{111}}',
    '\u2750': '{\\ding{112}}',
    '\u2751': '{\\ding{113}}',
    '\u2752': '{\\ding{114}}',
    '\u2756': '{\\ding{118}}',
    '\u2758': '{\\ding{120}}',
    '\u2759': '{\\ding{121}}',
    '\u275a': '{\\ding{122}}',
    '\u275b': '{\\ding{123}}',
    '\u275c': '{\\ding{124}}',
    '\u275d': '{\\ding{125}}',
    '\u275e': '{\\ding{126}}',
    '\u2761': '{\\ding{161}}',
    '\u2762': '{\\ding{162}}',
    '\u2763': '{\\ding{163}}',
    '\u2764': '{\\ding{164}}',
    '\u2765': '{\\ding{165}}',
    '\u2766': '{\\ding{166}}',
    '\u2767': '{\\ding{167}}',
    '\u2776': '{\\ding{182}}',
    '\u2777': '{\\ding{183}}',
    '\u2778': '{\\ding{184}}',
    '\u2779': '{\\ding{185}}',
    '\u277a': '{\\ding{186}}',
    '\u277b': '{\\ding{187}}',
    '\u277c': '{\\ding{188}}',
    '\u277d': '{\\ding{189}}',
    '\u277e': '{\\ding{190}}',
    '\u277f': '{\\ding{191}}',
    '\u2780': '{\\ding{192}}',
    '\u2781': '{\\ding{193}}',
    '\u2782': '{\\ding{194}}',
    '\u2783': '{\\ding{195}}',
    '\u2784': '{\\ding{196}}',
    '\u2785': '{\\ding{197}}',
    '\u2786': '{\\ding{198}}',
    '\u2787': '{\\ding{199}}',
    '\u2788': '{\\ding{200}}',
    '\u2789': '{\\ding{201}}',
    '\u278a': '{\\ding{202}}',
    '\u278b': '{\\ding{203}}',
    '\u278c': '{\\ding{204}}',
    '\u278d': '{\\ding{205}}',
    '\u278e': '{\\ding{206}}',
    '\u278f': '{\\ding{207}}',
    '\u2790': '{\\ding{208}}',
    '\u2791': '{\\ding{209}}',
    '\u2792': '{\\ding{210}}',
    '\u2793': '{\\ding{211}}',
    '\u2794': '{\\ding{212}}',
    '\u2798': '{\\ding{216}}',
    '\u2799': '{\\ding{217}}',
    '\u279a': '{\\ding{218}}',
    '\u279b': '{\\ding{219}}',
    '\u279c': '{\\ding{220}}',
    '\u279d': '{\\ding{221}}',
    '\u279e': '{\\ding{222}}',
    '\u279f': '{\\ding{223}}',
    '\u27a0': '{\\ding{224}}',
    '\u27a1': '{\\ding{225}}',
    '\u27a2': '{\\ding{226}}',
    '\u27a3': '{\\ding{227}}',
    '\u27a4': '{\\ding{228}}',
    '\u27a5': '{\\ding{229}}',
    '\u27a6': '{\\ding{230}}',
    '\u27a7': '{\\ding{231}}',
    '\u27a8': '{\\ding{232}}',
    '\u27a9': '{\\ding{233}}',
    '\u27aa': '{\\ding{234}}',
    '\u27ab': '{\\ding{235}}',
    '\u27ac': '{\\ding{236}}',
    '\u27ad': '{\\ding{237}}',
    '\u27ae': '{\\ding{238}}',
    '\u27af': '{\\ding{239}}',
    '\u27b1': '{\\ding{241}}',
    '\u27b2': '{\\ding{242}}',
    '\u27b3': '{\\ding{243}}',
    '\u27b4': '{\\ding{244}}',
    '\u27b5': '{\\ding{245}}',
    '\u27b6': '{\\ding{246}}',
    '\u27b7': '{\\ding{247}}',
    '\u27b8': '{\\ding{248}}',
    '\u27b9': '{\\ding{249}}',
    '\u27ba': '{\\ding{250}}',
    '\u27bb': '{\\ding{251}}',
    '\u27bc': '{\\ding{252}}',
    '\u27bd': '{\\ding{253}}',
    '\u27be': '{\\ding{254}}',
    '\u27f5': '$\\longleftarrow$',
    '\u27f6': '$\\longrightarrow$',
    '\u27f7': '$\\longleftrightarrow$',
    '\u27f8': '$\\Longleftarrow$',
    '\u27f9': '$\\Longrightarrow$',
    '\u27fa': '$\\Longleftrightarrow$',
    '\u27fc': '$\\longmapsto$',
    '\u27ff': '$\\sim\\joinrel\\leadsto$',
    '\u2905': '$\\ElsevierGlyph{E212}$',
    '\u2912': '$\\UpArrowBar$',
    '\u2913': '$\\DownArrowBar$',
    '\u2923': '$\\ElsevierGlyph{E20C}$',
    '\u2924': '$\\ElsevierGlyph{E20D}$',
    '\u2925': '$\\ElsevierGlyph{E20B}$',
    '\u2926': '$\\ElsevierGlyph{E20A}$',
    '\u2927': '$\\ElsevierGlyph{E211}$',
    '\u2928': '$\\ElsevierGlyph{E20E}$',
    '\u2929': '$\\ElsevierGlyph{E20F}$',
    '\u292a': '$\\ElsevierGlyph{E210}$',
    '\u2933': '$\\ElsevierGlyph{E21C}$',
    '\u2936': '$\\ElsevierGlyph{E21A}$',
    '\u2937': '$\\ElsevierGlyph{E219}$',
    '\u2940': '$\\Elolarr$',
    '\u2941': '$\\Elorarr$',
    '\u2942': '$\\ElzRlarr$',
    '\u2944': '$\\ElzrLarr$',
    '\u2947': '$\\Elzrarrx$',
    '\u294e': '$\\LeftRightVector$',
    '\u294f': '$\\RightUpDownVector$',
    '\u2950': '$\\DownLeftRightVector$',
    '\u2951': '$\\LeftUpDownVector$',
    '\u2952': '$\\LeftVectorBar$',
    '\u2953': '$\\RightVectorBar$',
    '\u2954': '$\\RightUpVectorBar$',
    '\u2955': '$\\RightDownVectorBar$',
    '\u2956': '$\\DownLeftVectorBar$',
    '\u2957': '$\\DownRightVectorBar$',
    '\u2958': '$\\LeftUpVectorBar$',
    '\u2959': '$\\LeftDownVectorBar$',
    '\u295a': '$\\LeftTeeVector$',
    '\u295b': '$\\RightTeeVector$',
    '\u295c': '$\\RightUpTeeVector$',
    '\u295d': '$\\RightDownTeeVector$',
    '\u295e': '$\\DownLeftTeeVector$',
    '\u295f': '$\\DownRightTeeVector$',
    '\u2960': '$\\LeftUpTeeVector$',
    '\u2961': '$\\LeftDownTeeVector$',
    '\u296e': '$\\UpEquilibrium$',
    '\u296f': '$\\ReverseUpEquilibrium$',
    '\u2970': '$\\RoundImplies$',
    '\u297c': '$\\ElsevierGlyph{E214}$',
    '\u297d': '$\\ElsevierGlyph{E215}$',
    '\u2980': '$\\Elztfnc$',
    '\u2985': '$\\ElsevierGlyph{3018}$',
    '\u2986': '$\\Elroang$',
    '\u2993': '$<\\kern-0.58em($',
    '\u2994': '$\\ElsevierGlyph{E291}$',
    '\u2999': '$\\Elzddfnc$',
    '\u299c': '$\\Angle$',
    '\u29a0': '$\\Elzlpargt$',
    '\u29b5': '$\\ElsevierGlyph{E260}$',
    '\u29b6': '$\\ElsevierGlyph{E61B}$',
    '\u29ca': '$\\ElzLap$',
    '\u29cb': '$\\Elzdefas$',
    '\u29cf': '$\\LeftTriangleBar$',
    '\u29d0': '$\\RightTriangleBar$',
    '\u29dc': '$\\ElsevierGlyph{E372}$',
    '\u29eb': '$\\blacklozenge$',
    '\u29f4': '$\\RuleDelayed$',
    '\u2a04': '$\\Elxuplus$',
    '\u2a05': '$\\ElzThr$',
    '\u2a06': '$\\Elxsqcup$',
    '\u2a07': '$\\ElzInf$',
    '\u2a08': '$\\ElzSup$',
    '\u2a0d': '$\\ElzCint$',
    '\u2a0f': '$\\clockoint$',
    '\u2a10': '$\\ElsevierGlyph{E395}$',
    '\u2a16': '$\\sqrint$',
    '\u2a25': '$\\ElsevierGlyph{E25A}$',
    '\u2a2a': '$\\ElsevierGlyph{E25B}$',
    '\u2a2d': '$\\ElsevierGlyph{E25C}$',
    '\u2a2e': '$\\ElsevierGlyph{E25D}$',
    '\u2a2f': '$\\ElzTimes$',
    '\u2a34': '$\\ElsevierGlyph{E25E}$',
    '\u2a35': '$\\ElsevierGlyph{E25E}$',
    '\u2a3c': '$\\ElsevierGlyph{E259}$',
    '\u2a3f': '$\\amalg$',
    '\u2a53': '$\\ElzAnd$',
    '\u2a54': '$\\ElzOr$',
    '\u2a55': '$\\ElsevierGlyph{E36E}$',
    '\u2a56': '$\\ElOr$',
    '\u2a5e': '$\\perspcorrespond$',
    '\u2a5f': '$\\Elzminhat$',
    '\u2a63': '$\\ElsevierGlyph{225A}$',
    '\u2a6e': '$\\stackrel{*}{=}$',
    '\u2a75': '$\\Equal$',
    '\u2a7d': '$\\leqslant$',
    '\u2a7e': '$\\geqslant$',
    '\u2a85': '$\\lessapprox$',
    '\u2a86': '$\\gtrapprox$',
    '\u2a87': '$\\lneq$',
    '\u2a88': '$\\gneq$',
    '\u2a89': '$\\lnapprox$',
    '\u2a8a': '$\\gnapprox$',
    '\u2a8b': '$\\lesseqqgtr$',
    '\u2a8c': '$\\gtreqqless$',
    '\u2a95': '$\\eqslantless$',
    '\u2a96': '$\\eqslantgtr$',
    '\u2a9d': '$\\Pisymbol{ppi020}{117}$',
    '\u2a9e': '$\\Pisymbol{ppi020}{105}$',
    '\u2aa1': '$\\NestedLessLess$',
    '\u2aa2': '$\\NestedGreaterGreater$',
    '\u2aaf': '$\\preceq$',
    '\u2ab0': '$\\succeq$',
    '\u2ab5': '$\\precneqq$',
    '\u2ab6': '$\\succneqq$',
    '\u2ab7': '$\\precapprox$',
    '\u2ab8': '$\\succapprox$',
    '\u2ab9': '$\\precnapprox$',
    '\u2aba': '$\\succnapprox$',
    '\u2ac5': '$\\subseteqq$',
    '\u2ac6': '$\\supseteqq$',
    '\u2acb': '$\\subsetneqq$',
    '\u2acc': '$\\supsetneqq$',
    '\u2aeb': '$\\ElsevierGlyph{E30D}$',
    '\u2af6': '$\\Elztdcol$',
    '\u2afd': '${{/}\\!\\!{/}}$',
    '\u300a': '$\\ElsevierGlyph{300A}$',
    '\u300b': '$\\ElsevierGlyph{300B}$',
    '\u3018': '$\\ElsevierGlyph{3018}$',
    '\u3019': '$\\ElsevierGlyph{3019}$',
    '\u301a': '$\\openbracketleft$',
    '\u301b': '$\\openbracketright$',
    '\ufb00': '{ff}',
    '\ufb01': '{fi}',
    '\ufb02': '{fl}',
    '\ufb03': '{ffi}',
    '\ufb04': '{ffl}',
    '\U0001d400': '$\\mathbf{A}$',
    '\U0001d401': '$\\mathbf{B}$',
    '\U0001d402': '$\\mathbf{C}$',
    '\U0001d403': '$\\mathbf{D}$',
    '\U0001d404': '$\\mathbf{E}$',
    '\U0001d405': '$\\mathbf{F}$',
    '\U0001d406': '$\\mathbf{G}$',
    '\U0001d407': '$\\mathbf{H}$',
    '\U0001d408': '$\\mathbf{I}$',
    '\U0001d409': '$\\mathbf{J}$',
    '\U0001d40a': '$\\mathbf{K}$',
    '\U0001d40b': '$\\mathbf{L}$',
    '\U0001d40c': '$\\mathbf{M}$',
    '\U0001d40d': '$\\mathbf{N}$',
    '\U0001d40e': '$\\mathbf{O}$',
    '\U0001d40f': '$\\mathbf{P}$',
    '\U0001d410': '$\\mathbf{Q}$',
    '\U0001d411': '$\\mathbf{R}$',
    '\U0001d412': '$\\mathbf{S}$',
    '\U0001d413': '$\\mathbf{T}$',
    '\U0001d414': '$\\mathbf{U}$',
    '\U0001d415': '$\\mathbf{V}$',
    '\U0001d416': '$\\mathbf{W}$',
    '\U0001d417': '$\\mathbf{X}$',
    '\U0001d418': '$\\mathbf{Y}$',
    '\U0001d419': '$\\mathbf{Z}$',
    '\U0001d41a': '$\\mathbf{a}$',
    '\U0001d41b': '$\\mathbf{b}$',
    '\U0001d41c': '$\\mathbf{c}$',
    '\U0001d41d': '$\\mathbf{d}$',
    '\U0001d41e': '$\\mathbf{e}$',
    '\U0001d41f': '$\\mathbf{f}$',
    '\U0001d420': '$\\mathbf{g}$',
    '\U0001d421': '$\\mathbf{h}$',
    '\U0001d422': '$\\mathbf{i}$',
    '\U0001d423': '$\\mathbf{j}$',
    '\U0001d424': '$\\mathbf{k}$',
    '\U0001d425': '$\\mathbf{l}$',
    '\U0001d426': '$\\mathbf{m}$',
    '\U0001d427': '$\\mathbf{n}$',
    '\U0001d428': '$\\mathbf{o}$',
    '\U0001d429': '$\\mathbf{p}$',
    '\U0001d42a': '$\\mathbf{q}$',
    '\U0001d42b': '$\\mathbf{r}$',
    '\U0001d42c': '$\\mathbf{s}$',
    '\U0001d42d': '$\\mathbf{t}$',
    '\U0001d42e': '$\\mathbf{u}$',
    '\U0001d42f': '$\\mathbf{v}$',
    '\U0001d430': '$\\mathbf{w}$',
    '\U0001d431': '$\\mathbf{x}$',
    '\U0001d432': '$\\mathbf{y}$',
    '\U0001d433': '$\\mathbf{z}$',
    '\U0001d434': '$\\mathsl{A}$',
    '\U0001d435': '$\\mathsl{B}$',
    '\U0001d436': '$\\mathsl{C}$',
    '\U0001d437': '$\\mathsl{D}$',
    '\U0001d438': '$\\mathsl{E}$',
    '\U0001d439': '$\\mathsl{F}$',
    '\U0001d43a': '$\\mathsl{G}$',
    '\U0001d43b': '$\\mathsl{H}$',
    '\U0001d43c': '$\\mathsl{I}$',
    '\U0001d43d': '$\\mathsl{J}$',
    '\U0001d43e': '$\\mathsl{K}$',
    '\U0001d43f': '$\\mathsl{L}$',
    '\U0001d440': '$\\mathsl{M}$',
    '\U0001d441': '$\\mathsl{N}$',
    '\U0001d442': '$\\mathsl{O}$',
    '\U0001d443': '$\\mathsl{P}$',
    '\U0001d444': '$\\mathsl{Q}$',
    '\U0001d445': '$\\mathsl{R}$',
    '\U0001d446': '$\\mathsl{S}$',
    '\U0001d447': '$\\mathsl{T}$',
    '\U0001d448': '$\\mathsl{U}$',
    '\U0001d449': '$\\mathsl{V}$',
    '\U0001d44a': '$\\mathsl{W}$',
    '\U0001d44b': '$\\mathsl{X}$',
    '\U0001d44c': '$\\mathsl{Y}$',
    '\U0001d44d': '$\\mathsl{Z}$',
    '\U0001d44e': '$\\mathsl{a}$',
    '\U0001d44f': '$\\mathsl{b}$',
    '\U0001d450': '$\\mathsl{c}$',
    '\U0001d451': '$\\mathsl{d}$',
    '\U0001d452': '$\\mathsl{e}$',
    '\U0001d453': '$\\mathsl{f}$',
    '\U0001d454': '$\\mathsl{g}$',
    '\U0001d456': '$\\mathsl{i}$',
    '\U0001d457': '$\\mathsl{j}$',
    '\U0001d458': '$\\mathsl{k}$',
    '\U0001d459': '$\\mathsl{l}$',
    '\U0001d45a': '$\\mathsl{m}$',
    '\U0001d45b': '$\\mathsl{n}$',
    '\U0001d45c': '$\\mathsl{o}$',
    '\U0001d45d': '$\\mathsl{p}$',
    '\U0001d45e': '$\\mathsl{q}$',
    '\U0001d45f': '$\\mathsl{r}$',
    '\U0001d460': '$\\mathsl{s}$',
    '\U0001d461': '$\\mathsl{t}$',
    '\U0001d462': '$\\mathsl{u}$',
    '\U0001d463': '$\\mathsl{v}$',
    '\U0001d464': '$\\mathsl{w}$',
    '\U0001d465': '$\\mathsl{x}$',
    '\U0001d466': '$\\mathsl{y}$',
    '\U0001d467': '$\\mathsl{z}$',
    '\U0001d468': '$\\mathbit{A}$',
    '\U0001d469': '$\\mathbit{B}$',
    '\U0001d46a': '$\\mathbit{C}$',
    '\U0001d46b': '$\\mathbit{D}$',
    '\U0001d46c': '$\\mathbit{E}$',
    '\U0001d46d': '$\\mathbit{F}$',
    '\U0001d46e': '$\\mathbit{G}$',
    '\U0001d46f': '$\\mathbit{H}$',
    '\U0001d470': '$\\mathbit{I}$',
    '\U0001d471': '$\\mathbit{J}$',
    '\U0001d472': '$\\mathbit{K}$',
    '\U0001d473': '$\\mathbit{L}$',
    '\U0001d474': '$\\mathbit{M}$',
    '\U0001d475': '$\\mathbit{N}$',
    '\U0001d476': '$\\mathbit{O}$',
    '\U0001d477': '$\\mathbit{P}$',
    '\U0001d478': '$\\mathbit{Q}$',
    '\U0001d479': '$\\mathbit{R}$',
    '\U0001d47a': '$\\mathbit{S}$',
    '\U0001d47b': '$\\mathbit{T}$',
    '\U0001d47c': '$\\mathbit{U}$',
    '\U0001d47d': '$\\mathbit{V}$',
    '\U0001d47e': '$\\mathbit{W}$',
    '\U0001d47f': '$\\mathbit{X}$',
    '\U0001d480': '$\\mathbit{Y}$',
    '\U0001d481': '$\\mathbit{Z}$',
    '\U0001d482': '$\\mathbit{a}$',
    '\U0001d483': '$\\mathbit{b}$',
    '\U0001d484': '$\\mathbit{c}$',
    '\U0001d485': '$\\mathbit{d}$',
    '\U0001d486': '$\\mathbit{e}$',
    '\U0001d487': '$\\mathbit{f}$',
    '\U0001d488': '$\\mathbit{g}$',
    '\U0001d489': '$\\mathbit{h}$',
    '\U0001d48a': '$\\mathbit{i}$',
    '\U0001d48b': '$\\mathbit{j}$',
    '\U0001d48c': '$\\mathbit{k}$',
    '\U0001d48d': '$\\mathbit{l}$',
    '\U0001d48e': '$\\mathbit{m}$',
    '\U0001d48f': '$\\mathbit{n}$',
    '\U0001d490': '$\\mathbit{o}$',
    '\U0001d491': '$\\mathbit{p}$',
    '\U0001d492': '$\\mathbit{q}$',
    '\U0001d493': '$\\mathbit{r}$',
    '\U0001d494': '$\\mathbit{s}$',
    '\U0001d495': '$\\mathbit{t}$',
    '\U0001d496': '$\\mathbit{u}$',
    '\U0001d497': '$\\mathbit{v}$',
    '\U0001d498': '$\\mathbit{w}$',
    '\U0001d499': '$\\mathbit{x}$',
    '\U0001d49a': '$\\mathbit{y}$',
    '\U0001d49b': '$\\mathbit{z}$',
    '\U0001d49c': '$\\mathscr{A}$',
    '\U0001d49e': '$\\mathscr{C}$',
    '\U0001d49f': '$\\mathscr{D}$',
    '\U0001d4a2': '$\\mathscr{G}$',
    '\U0001d4a5': '$\\mathscr{J}$',
    '\U0001d4a6': '$\\mathscr{K}$',
    '\U0001d4a9': '$\\mathscr{N}$',
    '\U0001d4aa': '$\\mathscr{O}$',
    '\U0001d4ab': '$\\mathscr{P}$',
    '\U0001d4ac': '$\\mathscr{Q}$',
    '\U0001d4ae': '$\\mathscr{S}$',
    '\U0001d4af': '$\\mathscr{T}$',
    '\U0001d4b0': '$\\mathscr{U}$',
    '\U0001d4b1': '$\\mathscr{V}$',
    '\U0001d4b2': '$\\mathscr{W}$',
    '\U0001d4b3': '$\\mathscr{X}$',
    '\U0001d4b4': '$\\mathscr{Y}$',
    '\U0001d4b5': '$\\mathscr{Z}$',
    '\U0001d4b6': '$\\mathscr{a}$',
    '\U0001d4b7': '$\\mathscr{b}$',
    '\U0001d4b8': '$\\mathscr{c}$',
    '\U0001d4b9': '$\\mathscr{d}$',
    '\U0001d4bb': '$\\mathscr{f}$',
    '\U0001d4bd': '$\\mathscr{h}$',
    '\U0001d4be': '$\\mathscr{i}$',
    '\U0001d4bf': '$\\mathscr{j}$',
    '\U0001d4c0': '$\\mathscr{k}$',
    '\U0001d4c1': '$\\mathscr{l}$',
    '\U0001d4c2': '$\\mathscr{m}$',
    '\U0001d4c3': '$\\mathscr{n}$',
    '\U0001d4c5': '$\\mathscr{p}$',
    '\U0001d4c6': '$\\mathscr{q}$',
    '\U0001d4c7': '$\\mathscr{r}$',
    '\U0001d4c8': '$\\mathscr{s}$',
    '\U0001d4c9': '$\\mathscr{t}$',
    '\U0001d4ca': '$\\mathscr{u}$',
    '\U0001d4cb': '$\\mathscr{v}$',
    '\U0001d4cc': '$\\mathscr{w}$',
    '\U0001d4cd': '$\\mathscr{x}$',
    '\U0001d4ce': '$\\mathscr{y}$',
    '\U0001d4cf': '$\\mathscr{z}$',
    '\U0001d4d0': '$\\mathmit{A}$',
    '\U0001d4d1': '$\\mathmit{B}$',
    '\U0001d4d2': '$\\mathmit{C}$',
    '\U0001d4d3': '$\\mathmit{D}$',
    '\U0001d4d4': '$\\mathmit{E}$',
    '\U0001d4d5': '$\\mathmit{F}$',
    '\U0001d4d6': '$\\mathmit{G}$',
    '\U0001d4d7': '$\\mathmit{H}$',
    '\U0001d4d8': '$\\mathmit{I}$',
    '\U0001d4d9': '$\\mathmit{J}$',
    '\U0001d4da': '$\\mathmit{K}$',
    '\U0001d4db': '$\\mathmit{L}$',
    '\U0001d4dc': '$\\mathmit{M}$',
    '\U0001d4dd': '$\\mathmit{N}$',
    '\U0001d4de': '$\\mathmit{O}$',
    '\U0001d4df': '$\\mathmit{P}$',
    '\U0001d4e0': '$\\mathmit{Q}$',
    '\U0001d4e1': '$\\mathmit{R}$',
    '\U0001d4e2': '$\\mathmit{S}$',
    '\U0001d4e3': '$\\mathmit{T}$',
    '\U0001d4e4': '$\\mathmit{U}$',
    '\U0001d4e5': '$\\mathmit{V}$',
    '\U0001d4e6': '$\\mathmit{W}$',
    '\U0001d4e7': '$\\mathmit{X}$',
    '\U0001d4e8': '$\\mathmit{Y}$',
    '\U0001d4e9': '$\\mathmit{Z}$',
    '\U0001d4ea': '$\\mathmit{a}$',
    '\U0001d4eb': '$\\mathmit{b}$',
    '\U0001d4ec': '$\\mathmit{c}$',
    '\U0001d4ed': '$\\mathmit{d}$',
    '\U0001d4ee': '$\\mathmit{e}$',
    '\U0001d4ef': '$\\mathmit{f}$',
    '\U0001d4f0': '$\\mathmit{g}$',
    '\U0001d4f1': '$\\mathmit{h}$',
    '\U0001d4f2': '$\\mathmit{i}$',
    '\U0001d4f3': '$\\mathmit{j}$',
    '\U0001d4f4': '$\\mathmit{k}$',
    '\U0001d4f5': '$\\mathmit{l}$',
    '\U0001d4f6': '$\\mathmit{m}$',
    '\U0001d4f7': '$\\mathmit{n}$',
    '\U0001d4f8': '$\\mathmit{o}$',
    '\U0001d4f9': '$\\mathmit{p}$',
    '\U0001d4fa': '$\\mathmit{q}$',
    '\U0001d4fb': '$\\mathmit{r}$',
    '\U0001d4fc': '$\\mathmit{s}$',
    '\U0001d4fd': '$\\mathmit{t}$',
    '\U0001d4fe': '$\\mathmit{u}$',
    '\U0001d4ff': '$\\mathmit{v}$',
    '\U0001d500': '$\\mathmit{w}$',
    '\U0001d501': '$\\mathmit{x}$',
    '\U0001d502': '$\\mathmit{y}$',
    '\U0001d503': '$\\mathmit{z}$',
    '\U0001d504': '$\\mathfrak{A}$',
    '\U0001d505': '$\\mathfrak{B}$',
    '\U0001d507': '$\\mathfrak{D}$',
    '\U0001d508': '$\\mathfrak{E}$',
    '\U0001d509': '$\\mathfrak{F}$',
    '\U0001d50a': '$\\mathfrak{G}$',
    '\U0001d50d': '$\\mathfrak{J}$',
    '\U0001d50e': '$\\mathfrak{K}$',
    '\U0001d50f': '$\\mathfrak{L}$',
    '\U0001d510': '$\\mathfrak{M}$',
    '\U0001d511': '$\\mathfrak{N}$',
    '\U0001d512': '$\\mathfrak{O}$',
    '\U0001d513': '$\\mathfrak{P}$',
    '\U0001d514': '$\\mathfrak{Q}$',
    '\U0001d516': '$\\mathfrak{S}$',
    '\U0001d517': '$\\mathfrak{T}$',
    '\U0001d518': '$\\mathfrak{U}$',
    '\U0001d519': '$\\mathfrak{V}$',
    '\U0001d51a': '$\\mathfrak{W}$',
    '\U0001d51b': '$\\mathfrak{X}$',
    '\U0001d51c': '$\\mathfrak{Y}$',
    '\U0001d51e': '$\\mathfrak{a}$',
    '\U0001d51f': '$\\mathfrak{b}$',
    '\U0001d520': '$\\mathfrak{c}$',
    '\U0001d521': '$\\mathfrak{d}$',
    '\U0001d522': '$\\mathfrak{e}$',
    '\U0001d523': '$\\mathfrak{f}$',
    '\U0001d524': '$\\mathfrak{g}$',
    '\U0001d525': '$\\mathfrak{h}$',
    '\U0001d526': '$\\mathfrak{i}$',
    '\U0001d527': '$\\mathfrak{j}$',
    '\U0001d528': '$\\mathfrak{k}$',
    '\U0001d529': '$\\mathfrak{l}$',
    '\U0001d52a': '$\\mathfrak{m}$',
    '\U0001d52b': '$\\mathfrak{n}$',
    '\U0001d52c': '$\\mathfrak{o}$',
    '\U0001d52d': '$\\mathfrak{p}$',
    '\U0001d52e': '$\\mathfrak{q}$',
    '\U0001d52f': '$\\mathfrak{r}$',
    '\U0001d530': '$\\mathfrak{s}$',
    '\U0001d531': '$\\mathfrak{t}$',
    '\U0001d532': '$\\mathfrak{u}$',
    '\U0001d533': '$\\mathfrak{v}$',
    '\U0001d534': '$\\mathfrak{w}$',
    '\U0001d535': '$\\mathfrak{x}$',
    '\U0001d536': '$\\mathfrak{y}$',
    '\U0001d537': '$\\mathfrak{z}$',
    '\U0001d538': '$\\mathbb{A}$',
    '\U0001d539': '$\\mathbb{B}$',
    '\U0001d53b': '$\\mathbb{D}$',
    '\U0001d53c': '$\\mathbb{E}$',
    '\U0001d53d': '$\\mathbb{F}$',
    '\U0001d53e': '$\\mathbb{G}$',
    '\U0001d540': '$\\mathbb{I}$',
    '\U0001d541': '$\\mathbb{J}$',
    '\U0001d542': '$\\mathbb{K}$',
    '\U0001d543': '$\\mathbb{L}$',
    '\U0001d544': '$\\mathbb{M}$',
    '\U0001d546': '$\\mathbb{O}$',
    '\U0001d54a': '$\\mathbb{S}$',
    '\U0001d54b': '$\\mathbb{T}$',
    '\U0001d54c': '$\\mathbb{U}$',
    '\U0001d54d': '$\\mathbb{V}$',
    '\U0001d54e': '$\\mathbb{W}$',
    '\U0001d54f': '$\\mathbb{X}$',
    '\U0001d550': '$\\mathbb{Y}$',
    '\U0001d552': '$\\mathbb{a}$',
    '\U0001d553': '$\\mathbb{b}$',
    '\U0001d554': '$\\mathbb{c}$',
    '\U0001d555': '$\\mathbb{d}$',
    '\U0001d556': '$\\mathbb{e}$',
    '\U0001d557': '$\\mathbb{f}$',
    '\U0001d558': '$\\mathbb{g}$',
    '\U0001d559': '$\\mathbb{h}$',
    '\U0001d55a': '$\\mathbb{i}$',
    '\U0001d55b': '$\\mathbb{j}$',
    '\U0001d55c': '$\\mathbb{k}$',
    '\U0001d55d': '$\\mathbb{l}$',
    '\U0001d55e': '$\\mathbb{m}$',
    '\U0001d55f': '$\\mathbb{n}$',
    '\U0001d560': '$\\mathbb{o}$',
    '\U0001d561': '$\\mathbb{p}$',
    '\U0001d562': '$\\mathbb{q}$',
    '\U0001d563': '$\\mathbb{r}$',
    '\U0001d564': '$\\mathbb{s}$',
    '\U0001d565': '$\\mathbb{t}$',
    '\U0001d566': '$\\mathbb{u}$',
    '\U0001d567': '$\\mathbb{v}$',
    '\U0001d568': '$\\mathbb{w}$',
    '\U0001d569': '$\\mathbb{x}$',
    '\U0001d56a': '$\\mathbb{y}$',
    '\U0001d56b': '$\\mathbb{z}$',
    '\U0001d56c': '$\\mathslbb{A}$',
    '\U0001d56d': '$\\mathslbb{B}$',
    '\U0001d56e': '$\\mathslbb{C}$',
    '\U0001d56f': '$\\mathslbb{D}$',
    '\U0001d570': '$\\mathslbb{E}$',
    '\U0001d571': '$\\mathslbb{F}$',
    '\U0001d572': '$\\mathslbb{G}$',
    '\U0001d573': '$\\mathslbb{H}$',
    '\U0001d574': '$\\mathslbb{I}$',
    '\U0001d575': '$\\mathslbb{J}$',
    '\U0001d576': '$\\mathslbb{K}$',
    '\U0001d577': '$\\mathslbb{L}$',
    '\U0001d578': '$\\mathslbb{M}$',
    '\U0001d579': '$\\mathslbb{N}$',
    '\U0001d57a': '$\\mathslbb{O}$',
    '\U0001d57b': '$\\mathslbb{P}$',
    '\U0001d57c': '$\\mathslbb{Q}$',
    '\U0001d57d': '$\\mathslbb{R}$',
    '\U0001d57e': '$\\mathslbb{S}$',
    '\U0001d57f': '$\\mathslbb{T}$',
    '\U0001d580': '$\\mathslbb{U}$',
    '\U0001d581': '$\\mathslbb{V}$',
    '\U0001d582': '$\\mathslbb{W}$',
    '\U0001d583': '$\\mathslbb{X}$',
    '\U0001d584': '$\\mathslbb{Y}$',
    '\U0001d585': '$\\mathslbb{Z}$',
    '\U0001d586': '$\\mathslbb{a}$',
    '\U0001d587': '$\\mathslbb{b}$',
    '\U0001d588': '$\\mathslbb{c}$',
    '\U0001d589': '$\\mathslbb{d}$',
    '\U0001d58a': '$\\mathslbb{e}$',
    '\U0001d58b': '$\\mathslbb{f}$',
    '\U0001d58c': '$\\mathslbb{g}$',
    '\U0001d58d': '$\\mathslbb{h}$',
    '\U0001d58e': '$\\mathslbb{i}$',
    '\U0001d58f': '$\\mathslbb{j}$',
    '\U0001d590': '$\\mathslbb{k}$',
    '\U0001d591': '$\\mathslbb{l}$',
    '\U0001d592': '$\\mathslbb{m}$',
    '\U0001d593': '$\\mathslbb{n}$',
    '\U0001d594': '$\\mathslbb{o}$',
    '\U0001d595': '$\\mathslbb{p}$',
    '\U0001d596': '$\\mathslbb{q}$',
    '\U0001d597': '$\\mathslbb{r}$',
    '\U0001d598': '$\\mathslbb{s}$',
    '\U0001d599': '$\\mathslbb{t}$',
    '\U0001d59a': '$\\mathslbb{u}$',
    '\U0001d59b': '$\\mathslbb{v}$',
    '\U0001d59c': '$\\mathslbb{w}$',
    '\U0001d59d': '$\\mathslbb{x}$',
    '\U0001d59e': '$\\mathslbb{y}$',
    '\U0001d59f': '$\\mathslbb{z}$',
    '\U0001d5a0': '$\\mathsf{A}$',
    '\U0001d5a1': '$\\mathsf{B}$',
    '\U0001d5a2': '$\\mathsf{C}$',
    '\U0001d5a3': '$\\mathsf{D}$',
    '\U0001d5a4': '$\\mathsf{E}$',
    '\U0001d5a5': '$\\mathsf{F}$',
    '\U0001d5a6': '$\\mathsf{G}$',
    '\U0001d5a7': '$\\mathsf{H}$',
    '\U0001d5a8': '$\\mathsf{I}$',
    '\U0001d5a9': '$\\mathsf{J}$',
    '\U0001d5aa': '$\\mathsf{K}$',
    '\U0001d5ab': '$\\mathsf{L}$',
    '\U0001d5ac': '$\\mathsf{M}$',
    '\U0001d5ad': '$\\mathsf{N}$',
    '\U0001d5ae': '$\\mathsf{O}$',
    '\U0001d5af': '$\\mathsf{P}$',
    '\U0001d5b0': '$\\mathsf{Q}$',
    '\U0001d5b1': '$\\mathsf{R}$',
    '\U0001d5b2': '$\\mathsf{S}$',
    '\U0001d5b3': '$\\mathsf{T}$',
    '\U0001d5b4': '$\\mathsf{U}$',
    '\U0001d5b5': '$\\mathsf{V}$',
    '\U0001d5b6': '$\\mathsf{W}$',
    '\U0001d5b7': '$\\mathsf{X}$',
    '\U0001d5b8': '$\\mathsf{Y}$',
    '\U0001d5b9': '$\\mathsf{Z}$',
    '\U0001d5ba': '$\\mathsf{a}$',
    '\U0001d5bb': '$\\mathsf{b}$',
    '\U0001d5bc': '$\\mathsf{c}$',
    '\U0001d5bd': '$\\mathsf{d}$',
    '\U0001d5be': '$\\mathsf{e}$',
    '\U0001d5bf': '$\\mathsf{f}$',
    '\U0001d5c0': '$\\mathsf{g}$',
    '\U0001d5c1': '$\\mathsf{h}$',
    '\U0001d5c2': '$\\mathsf{i}$',
    '\U0001d5c3': '$\\mathsf{j}$',
    '\U0001d5c4': '$\\mathsf{k}$',
    '\U0001d5c5': '$\\mathsf{l}$',
    '\U0001d5c6': '$\\mathsf{m}$',
    '\U0001d5c7': '$\\mathsf{n}$',
    '\U0001d5c8': '$\\mathsf{o}$',
    '\U0001d5c9': '$\\mathsf{p}$',
    '\U0001d5ca': '$\\mathsf{q}$',
    '\U0001d5cb': '$\\mathsf{r}$',
    '\U0001d5cc': '$\\mathsf{s}$',
    '\U0001d5cd': '$\\mathsf{t}$',
    '\U0001d5ce': '$\\mathsf{u}$',
    '\U0001d5cf': '$\\mathsf{v}$',
    '\U0001d5d0': '$\\mathsf{w}$',
    '\U0001d5d1': '$\\mathsf{x}$',
    '\U0001d5d2': '$\\mathsf{y}$',
    '\U0001d5d3': '$\\mathsf{z}$',
    '\U0001d5d4': '$\\mathsfbf{A}$',
    '\U0001d5d5': '$\\mathsfbf{B}$',
    '\U0001d5d6': '$\\mathsfbf{C}$',
    '\U0001d5d7': '$\\mathsfbf{D}$',
    '\U0001d5d8': '$\\mathsfbf{E}$',
    '\U0001d5d9': '$\\mathsfbf{F}$',
    '\U0001d5da': '$\\mathsfbf{G}$',
    '\U0001d5db': '$\\mathsfbf{H}$',
    '\U0001d5dc': '$\\mathsfbf{I}$',
    '\U0001d5dd': '$\\mathsfbf{J}$',
    '\U0001d5de': '$\\mathsfbf{K}$',
    '\U0001d5df': '$\\mathsfbf{L}$',
    '\U0001d5e0': '$\\mathsfbf{M}$',
    '\U0001d5e1': '$\\mathsfbf{N}$',
    '\U0001d5e2': '$\\mathsfbf{O}$',
    '\U0001d5e3': '$\\mathsfbf{P}$',
    '\U0001d5e4': '$\\mathsfbf{Q}$',
    '\U0001d5e5': '$\\mathsfbf{R}$',
    '\U0001d5e6': '$\\mathsfbf{S}$',
    '\U0001d5e7': '$\\mathsfbf{T}$',
    '\U0001d5e8': '$\\mathsfbf{U}$',
    '\U0001d5e9': '$\\mathsfbf{V}$',
    '\U0001d5ea': '$\\mathsfbf{W}$',
    '\U0001d5eb': '$\\mathsfbf{X}$',
    '\U0001d5ec': '$\\mathsfbf{Y}$',
    '\U0001d5ed': '$\\mathsfbf{Z}$',
    '\U0001d5ee': '$\\mathsfbf{a}$',
    '\U0001d5ef': '$\\mathsfbf{b}$',
    '\U0001d5f0': '$\\mathsfbf{c}$',
    '\U0001d5f1': '$\\mathsfbf{d}$',
    '\U0001d5f2': '$\\mathsfbf{e}$',
    '\U0001d5f3': '$\\mathsfbf{f}$',
    '\U0001d5f4': '$\\mathsfbf{g}$',
    '\U0001d5f5': '$\\mathsfbf{h}$',
    '\U0001d5f6': '$\\mathsfbf{i}$',
    '\U0001d5f7': '$\\mathsfbf{j}$',
    '\U0001d5f8': '$\\mathsfbf{k}$',
    '\U0001d5f9': '$\\mathsfbf{l}$',
    '\U0001d5fa': '$\\mathsfbf{m}$',
    '\U0001d5fb': '$\\mathsfbf{n}$',
    '\U0001d5fc': '$\\mathsfbf{o}$',
    '\U0001d5fd': '$\\mathsfbf{p}$',
    '\U0001d5fe': '$\\mathsfbf{q}$',
    '\U0001d5ff': '$\\mathsfbf{r}$',
    '\U0001d600': '$\\mathsfbf{s}$',
    '\U0001d601': '$\\mathsfbf{t}$',
    '\U0001d602': '$\\mathsfbf{u}$',
    '\U0001d603': '$\\mathsfbf{v}$',
    '\U0001d604': '$\\mathsfbf{w}$',
    '\U0001d605': '$\\mathsfbf{x}$',
    '\U0001d606': '$\\mathsfbf{y}$',
    '\U0001d607': '$\\mathsfbf{z}$',
    '\U0001d608': '$\\mathsfsl{A}$',
    '\U0001d609': '$\\mathsfsl{B}$',
    '\U0001d60a': '$\\mathsfsl{C}$',
    '\U0001d60b': '$\\mathsfsl{D}$',
    '\U0001d60c': '$\\mathsfsl{E}$',
    '\U0001d60d': '$\\mathsfsl{F}$',
    '\U0001d60e': '$\\mathsfsl{G}$',
    '\U0001d60f': '$\\mathsfsl{H}$',
    '\U0001d610': '$\\mathsfsl{I}$',
    '\U0001d611': '$\\mathsfsl{J}$',
    '\U0001d612': '$\\mathsfsl{K}$',
    '\U0001d613': '$\\mathsfsl{L}$',
    '\U0001d614': '$\\mathsfsl{M}$',
    '\U0001d615': '$\\mathsfsl{N}$',
    '\U0001d616': '$\\mathsfsl{O}$',
    '\U0001d617': '$\\mathsfsl{P}$',
    '\U0001d618': '$\\mathsfsl{Q}$',
    '\U0001d619': '$\\mathsfsl{R}$',
    '\U0001d61a': '$\\mathsfsl{S}$',
    '\U0001d61b': '$\\mathsfsl{T}$',
    '\U0001d61c': '$\\mathsfsl{U}$',
    '\U0001d61d': '$\\mathsfsl{V}$',
    '\U0001d61e': '$\\mathsfsl{W}$',
    '\U0001d61f': '$\\mathsfsl{X}$',
    '\U0001d620': '$\\mathsfsl{Y}$',
    '\U0001d621': '$\\mathsfsl{Z}$',
    '\U0001d622': '$\\mathsfsl{a}$',
    '\U0001d623': '$\\mathsfsl{b}$',
    '\U0001d624': '$\\mathsfsl{c}$',
    '\U0001d625': '$\\mathsfsl{d}$',
    '\U0001d626': '$\\mathsfsl{e}$',
    '\U0001d627': '$\\mathsfsl{f}$',
    '\U0001d628': '$\\mathsfsl{g}$',
    '\U0001d629': '$\\mathsfsl{h}$',
    '\U0001d62a': '$\\mathsfsl{i}$',
    '\U0001d62b': '$\\mathsfsl{j}$',
    '\U0001d62c': '$\\mathsfsl{k}$',
    '\U0001d62d': '$\\mathsfsl{l}$',
    '\U0001d62e': '$\\mathsfsl{m}$',
    '\U0001d62f': '$\\mathsfsl{n}$',
    '\U0001d630': '$\\mathsfsl{o}$',
    '\U0001d631': '$\\mathsfsl{p}$',
    '\U0001d632': '$\\mathsfsl{q}$',
    '\U0001d633': '$\\mathsfsl{r}$',
    '\U0001d634': '$\\mathsfsl{s}$',
    '\U0001d635': '$\\mathsfsl{t}$',
    '\U0001d636': '$\\mathsfsl{u}$',
    '\U0001d637': '$\\mathsfsl{v}$',
    '\U0001d638': '$\\mathsfsl{w}$',
    '\U0001d639': '$\\mathsfsl{x}$',
    '\U0001d63a': '$\\mathsfsl{y}$',
    '\U0001d63b': '$\\mathsfsl{z}$',
    '\U0001d63c': '$\\mathsfbfsl{A}$',
    '\U0001d63d': '$\\mathsfbfsl{B}$',
    '\U0001d63e': '$\\mathsfbfsl{C}$',
    '\U0001d63f': '$\\mathsfbfsl{D}$',
    '\U0001d640': '$\\mathsfbfsl{E}$',
    '\U0001d641': '$\\mathsfbfsl{F}$',
    '\U0001d642': '$\\mathsfbfsl{G}$',
    '\U0001d643': '$\\mathsfbfsl{H}$',
    '\U0001d644': '$\\mathsfbfsl{I}$',
    '\U0001d645': '$\\mathsfbfsl{J}$',
    '\U0001d646': '$\\mathsfbfsl{K}$',
    '\U0001d647': '$\\mathsfbfsl{L}$',
    '\U0001d648': '$\\mathsfbfsl{M}$',
    '\U0001d649': '$\\mathsfbfsl{N}$',
    '\U0001d64a': '$\\mathsfbfsl{O}$',
    '\U0001d64b': '$\\mathsfbfsl{P}$',
    '\U0001d64c': '$\\mathsfbfsl{Q}$',
    '\U0001d64d': '$\\mathsfbfsl{R}$',
    '\U0001d64e': '$\\mathsfbfsl{S}$',
    '\U0001d64f': '$\\mathsfbfsl{T}$',
    '\U0001d650': '$\\mathsfbfsl{U}$',
    '\U0001d651': '$\\mathsfbfsl{V}$',
    '\U0001d652': '$\\mathsfbfsl{W}$',
    '\U0001d653': '$\\mathsfbfsl{X}$',
    '\U0001d654': '$\\mathsfbfsl{Y}$',
    '\U0001d655': '$\\mathsfbfsl{Z}$',
    '\U0001d656': '$\\mathsfbfsl{a}$',
    '\U0001d657': '$\\mathsfbfsl{b}$',
    '\U0001d658': '$\\mathsfbfsl{c}$',
    '\U0001d659': '$\\mathsfbfsl{d}$',
    '\U0001d65a': '$\\mathsfbfsl{e}$',
    '\U0001d65b': '$\\mathsfbfsl{f}$',
    '\U0001d65c': '$\\mathsfbfsl{g}$',
    '\U0001d65d': '$\\mathsfbfsl{h}$',
    '\U0001d65e': '$\\mathsfbfsl{i}$',
    '\U0001d65f': '$\\mathsfbfsl{j}$',
    '\U0001d660': '$\\mathsfbfsl{k}$',
    '\U0001d661': '$\\mathsfbfsl{l}$',
    '\U0001d662': '$\\mathsfbfsl{m}$',
    '\U0001d663': '$\\mathsfbfsl{n}$',
    '\U0001d664': '$\\mathsfbfsl{o}$',
    '\U0001d665': '$\\mathsfbfsl{p}$',
    '\U0001d666': '$\\mathsfbfsl{q}$',
    '\U0001d667': '$\\mathsfbfsl{r}$',
    '\U0001d668': '$\\mathsfbfsl{s}$',
    '\U0001d669': '$\\mathsfbfsl{t}$',
    '\U0001d66a': '$\\mathsfbfsl{u}$',
    '\U0001d66b': '$\\mathsfbfsl{v}$',
    '\U0001d66c': '$\\mathsfbfsl{w}$',
    '\U0001d66d': '$\\mathsfbfsl{x}$',
    '\U0001d66e': '$\\mathsfbfsl{y}$',
    '\U0001d66f': '$\\mathsfbfsl{z}$',
    '\U0001d670': '$\\mathtt{A}$',
    '\U0001d671': '$\\mathtt{B}$',
    '\U0001d672': '$\\mathtt{C}$',
    '\U0001d673': '$\\mathtt{D}$',
    '\U0001d674': '$\\mathtt{E}$',
    '\U0001d675': '$\\mathtt{F}$',
    '\U0001d676': '$\\mathtt{G}$',
    '\U0001d677': '$\\mathtt{H}$',
    '\U0001d678': '$\\mathtt{I}$',
    '\U0001d679': '$\\mathtt{J}$',
    '\U0001d67a': '$\\mathtt{K}$',
    '\U0001d67b': '$\\mathtt{L}$',
    '\U0001d67c': '$\\mathtt{M}$',
    '\U0001d67d': '$\\mathtt{N}$',
    '\U0001d67e': '$\\mathtt{O}$',
    '\U0001d67f': '$\\mathtt{P}$',
    '\U0001d680': '$\\mathtt{Q}$',
    '\U0001d681': '$\\mathtt{R}$',
    '\U0001d682': '$\\mathtt{S}$',
    '\U0001d683': '$\\mathtt{T}$',
    '\U0001d684': '$\\mathtt{U}$',
    '\U0001d685': '$\\mathtt{V}$',
    '\U0001d686': '$\\mathtt{W}$',
    '\U0001d687': '$\\mathtt{X}$',
    '\U0001d688': '$\\mathtt{Y}$',
    '\U0001d689': '$\\mathtt{Z}$',
    '\U0001d68a': '$\\mathtt{a}$',
    '\U0001d68b': '$\\mathtt{b}$',
    '\U0001d68c': '$\\mathtt{c}$',
    '\U0001d68d': '$\\mathtt{d}$',
    '\U0001d68e': '$\\mathtt{e}$',
    '\U0001d68f': '$\\mathtt{f}$',
    '\U0001d690': '$\\mathtt{g}$',
    '\U0001d691': '$\\mathtt{h}$',
    '\U0001d692': '$\\mathtt{i}$',
    '\U0001d693': '$\\mathtt{j}$',
    '\U0001d694': '$\\mathtt{k}$',
    '\U0001d695': '$\\mathtt{l}$',
    '\U0001d696': '$\\mathtt{m}$',
    '\U0001d697': '$\\mathtt{n}$',
    '\U0001d698': '$\\mathtt{o}$',
    '\U0001d699': '$\\mathtt{p}$',
    '\U0001d69a': '$\\mathtt{q}$',
    '\U0001d69b': '$\\mathtt{r}$',
    '\U0001d69c': '$\\mathtt{s}$',
    '\U0001d69d': '$\\mathtt{t}$',
    '\U0001d69e': '$\\mathtt{u}$',
    '\U0001d69f': '$\\mathtt{v}$',
    '\U0001d6a0': '$\\mathtt{w}$',
    '\U0001d6a1': '$\\mathtt{x}$',
    '\U0001d6a2': '$\\mathtt{y}$',
    '\U0001d6a3': '$\\mathtt{z}$',
    '\U0001d6a8': '$\\mathbf{\\Alpha}$',
    '\U0001d6a9': '$\\mathbf{\\Beta}$',
    '\U0001d6aa': '$\\mathbf{\\Gamma}$',
    '\U0001d6ab': '$\\mathbf{\\Delta}$',
    '\U0001d6ac': '$\\mathbf{\\Epsilon}$',
    '\U0001d6ad': '$\\mathbf{\\Zeta}$',
    '\U0001d6ae': '$\\mathbf{\\Eta}$',
    '\U0001d6af': '$\\mathbf{\\Theta}$',
    '\U0001d6b0': '$\\mathbf{\\Iota}$',
    '\U0001d6b1': '$\\mathbf{\\Kappa}$',
    '\U0001d6b2': '$\\mathbf{\\Lambda}$',
    '\U0001d6b3': '$M$',
    '\U0001d6b4': '$N$',
    '\U0001d6b5': '$\\mathbf{\\Xi}$',
    '\U0001d6b6': '$O$',
    '\U0001d6b7': '$\\mathbf{\\Pi}$',
    '\U0001d6b8': '$\\mathbf{\\Rho}$',
    '\U0001d6b9': '{\\mathbf{\\vartheta}}',
    '\U0001d6ba': '$\\mathbf{\\Sigma}$',
    '\U0001d6bb': '$\\mathbf{\\Tau}$',
    '\U0001d6bc': '$\\mathbf{\\Upsilon}$',
    '\U0001d6bd': '$\\mathbf{\\Phi}$',
    '\U0001d6be': '$\\mathbf{\\Chi}$',
    '\U0001d6bf': '$\\mathbf{\\Psi}$',
    '\U0001d6c0': '$\\mathbf{\\Omega}$',
    '\U0001d6c1': '$\\mathbf{\\nabla}$',
    '\U0001d6c2': '$\\mathbf{\\Alpha}$',
    '\U0001d6c3': '$\\mathbf{\\Beta}$',
    '\U0001d6c4': '$\\mathbf{\\Gamma}$',
    '\U0001d6c5': '$\\mathbf{\\Delta}$',
    '\U0001d6c6': '$\\mathbf{\\Epsilon}$',
    '\U0001d6c7': '$\\mathbf{\\Zeta}$',
    '\U0001d6c8': '$\\mathbf{\\Eta}$',
    '\U0001d6c9': '$\\mathbf{\\theta}$',
    '\U0001d6ca': '$\\mathbf{\\Iota}$',
    '\U0001d6cb': '$\\mathbf{\\Kappa}$',
    '\U0001d6cc': '$\\mathbf{\\Lambda}$',
    '\U0001d6cd': '$M$',
    '\U0001d6ce': '$N$',
    '\U0001d6cf': '$\\mathbf{\\Xi}$',
    '\U0001d6d0': '$O$',
    '\U0001d6d1': '$\\mathbf{\\Pi}$',
    '\U0001d6d2': '$\\mathbf{\\Rho}$',
    '\U0001d6d3': '$\\mathbf{\\varsigma}$',
    '\U0001d6d4': '$\\mathbf{\\Sigma}$',
    '\U0001d6d5': '$\\mathbf{\\Tau}$',
    '\U0001d6d6': '$\\mathbf{\\Upsilon}$',
    '\U0001d6d7': '$\\mathbf{\\Phi}$',
    '\U0001d6d8': '$\\mathbf{\\Chi}$',
    '\U0001d6d9': '$\\mathbf{\\Psi}$',
    '\U0001d6da': '$\\mathbf{\\Omega}$',
    '\U0001d6db': '$\\partial$',
    '\U0001d6dc': '$\\in$',
    '\U0001d6dd': '{\\mathbf{\\vartheta}}',
    '\U0001d6de': '{\\mathbf{\\varkappa}}',
    '\U0001d6df': '{\\mathbf{\\phi}}',
    '\U0001d6e0': '{\\mathbf{\\varrho}}',
    '\U0001d6e1': '{\\mathbf{\\varpi}}',
    '\U0001d6e2': '$\\mathsl{\\Alpha}$',
    '\U0001d6e3': '$\\mathsl{\\Beta}$',
    '\U0001d6e4': '$\\mathsl{\\Gamma}$',
    '\U0001d6e5': '$\\mathsl{\\Delta}$',
    '\U0001d6e6': '$\\mathsl{\\Epsilon}$',
    '\U0001d6e7': '$\\mathsl{\\Zeta}$',
    '\U0001d6e8': '$\\mathsl{\\Eta}$',
    '\U0001d6e9': '$\\mathsl{\\Theta}$',
    '\U0001d6ea': '$\\mathsl{\\Iota}$',
    '\U0001d6eb': '$\\mathsl{\\Kappa}$',
    '\U0001d6ec': '$\\mathsl{\\Lambda}$',
    '\U0001d6ed': '$M$',
    '\U0001d6ee': '$N$',
    '\U0001d6ef': '$\\mathsl{\\Xi}$',
    '\U0001d6f0': '$O$',
    '\U0001d6f1': '$\\mathsl{\\Pi}$',
    '\U0001d6f2': '$\\mathsl{\\Rho}$',
    '\U0001d6f3': '{\\mathsl{\\vartheta}}',
    '\U0001d6f4': '$\\mathsl{\\Sigma}$',
    '\U0001d6f5': '$\\mathsl{\\Tau}$',
    '\U0001d6f6': '$\\mathsl{\\Upsilon}$',
    '\U0001d6f7': '$\\mathsl{\\Phi}$',
    '\U0001d6f8': '$\\mathsl{\\Chi}$',
    '\U0001d6f9': '$\\mathsl{\\Psi}$',
    '\U0001d6fa': '$\\mathsl{\\Omega}$',
    '\U0001d6fb': '$\\mathsl{\\nabla}$',
    '\U0001d6fc': '$\\mathsl{\\Alpha}$',
    '\U0001d6fd': '$\\mathsl{\\Beta}$',
    '\U0001d6fe': '$\\mathsl{\\Gamma}$',
    '\U0001d6ff': '$\\mathsl{\\Delta}$',
    '\U0001d700': '$\\mathsl{\\Epsilon}$',
    '\U0001d701': '$\\mathsl{\\Zeta}$',
    '\U0001d702': '$\\mathsl{\\Eta}$',
    '\U0001d703': '$\\mathsl{\\Theta}$',
    '\U0001d704': '$\\mathsl{\\Iota}$',
    '\U0001d705': '$\\mathsl{\\Kappa}$',
    '\U0001d706': '$\\mathsl{\\Lambda}$',
    '\U0001d707': '$M$',
    '\U0001d708': '$N$',
    '\U0001d709': '$\\mathsl{\\Xi}$',
    '\U0001d70a': '$O$',
    '\U0001d70b': '$\\mathsl{\\Pi}$',
    '\U0001d70c': '$\\mathsl{\\Rho}$',
    '\U0001d70d': '$\\mathsl{\\varsigma}$',
    '\U0001d70e': '$\\mathsl{\\Sigma}$',
    '\U0001d70f': '$\\mathsl{\\Tau}$',
    '\U0001d710': '$\\mathsl{\\Upsilon}$',
    '\U0001d711': '$\\mathsl{\\Phi}$',
    '\U0001d712': '$\\mathsl{\\Chi}$',
    '\U0001d713': '$\\mathsl{\\Psi}$',
    '\U0001d714': '$\\mathsl{\\Omega}$',
    '\U0001d715': '$\\partial$',
    '\U0001d716': '$\\in$',
    '\U0001d717': '{\\mathsl{\\vartheta}}',
    '\U0001d718': '{\\mathsl{\\varkappa}}',
    '\U0001d719': '{\\mathsl{\\phi}}',
    '\U0001d71a': '{\\mathsl{\\varrho}}',
    '\U0001d71b': '{\\mathsl{\\varpi}}',
    '\U0001d71c': '$\\mathbit{\\Alpha}$',
    '\U0001d71d': '$\\mathbit{\\Beta}$',
    '\U0001d71e': '$\\mathbit{\\Gamma}$',
    '\U0001d71f': '$\\mathbit{\\Delta}$',
    '\U0001d720': '$\\mathbit{\\Epsilon}$',
    '\U0001d721': '$\\mathbit{\\Zeta}$',
    '\U0001d722': '$\\mathbit{\\Eta}$',
    '\U0001d723': '$\\mathbit{\\Theta}$',
    '\U0001d724': '$\\mathbit{\\Iota}$',
    '\U0001d725': '$\\mathbit{\\Kappa}$',
    '\U0001d726': '$\\mathbit{\\Lambda}$',
    '\U0001d727': '$M$',
    '\U0001d728': '$N$',
    '\U0001d729': '$\\mathbit{\\Xi}$',
    '\U0001d72a': '$O$',
    '\U0001d72b': '$\\mathbit{\\Pi}$',
    '\U0001d72c': '$\\mathbit{\\Rho}$',
    '\U0001d72d': '{\\mathbit{O}}',
    '\U0001d72e': '$\\mathbit{\\Sigma}$',
    '\U0001d72f': '$\\mathbit{\\Tau}$',
    '\U0001d730': '$\\mathbit{\\Upsilon}$',
    '\U0001d731': '$\\mathbit{\\Phi}$',
    '\U0001d732': '$\\mathbit{\\Chi}$',
    '\U0001d733': '$\\mathbit{\\Psi}$',
    '\U0001d734': '$\\mathbit{\\Omega}$',
    '\U0001d735': '$\\mathbit{\\nabla}$',
    '\U0001d736': '$\\mathbit{\\Alpha}$',
    '\U0001d737': '$\\mathbit{\\Beta}$',
    '\U0001d738': '$\\mathbit{\\Gamma}$',
    '\U0001d739': '$\\mathbit{\\Delta}$',
    '\U0001d73a': '$\\mathbit{\\Epsilon}$',
    '\U0001d73b': '$\\mathbit{\\Zeta}$',
    '\U0001d73c': '$\\mathbit{\\Eta}$',
    '\U0001d73d': '$\\mathbit{\\Theta}$',
    '\U0001d73e': '$\\mathbit{\\Iota}$',
    '\U0001d73f': '$\\mathbit{\\Kappa}$',
    '\U0001d740': '$\\mathbit{\\Lambda}$',
    '\U0001d741': '$M$',
    '\U0001d742': '$N$',
    '\U0001d743': '$\\mathbit{\\Xi}$',
    '\U0001d744': '$O$',
    '\U0001d745': '$\\mathbit{\\Pi}$',
    '\U0001d746': '$\\mathbit{\\Rho}$',
    '\U0001d747': '$\\mathbit{\\varsigma}$',
    '\U0001d748': '$\\mathbit{\\Sigma}$',
    '\U0001d749': '$\\mathbit{\\Tau}$',
    '\U0001d74a': '$\\mathbit{\\Upsilon}$',
    '\U0001d74b': '$\\mathbit{\\Phi}$',
    '\U0001d74c': '$\\mathbit{\\Chi}$',
    '\U0001d74d': '$\\mathbit{\\Psi}$',
    '\U0001d74e': '$\\mathbit{\\Omega}$',
    '\U0001d74f': '$\\partial$',
    '\U0001d750': '$\\in$',
    '\U0001d751': '{\\mathbit{\\vartheta}}',
    '\U0001d752': '{\\mathbit{\\varkappa}}',
    '\U0001d753': '{\\mathbit{\\phi}}',
    '\U0001d754': '{\\mathbit{\\varrho}}',
    '\U0001d755': '{\\mathbit{\\varpi}}',
    '\U0001d756': '$\\mathsfbf{\\Alpha}$',
    '\U0001d757': '$\\mathsfbf{\\Beta}$',
    '\U0001d758': '$\\mathsfbf{\\Gamma}$',
    '\U0001d759': '$\\mathsfbf{\\Delta}$',
    '\U0001d75a': '$\\mathsfbf{\\Epsilon}$',
    '\U0001d75b': '$\\mathsfbf{\\Zeta}$',
    '\U0001d75c': '$\\mathsfbf{\\Eta}$',
    '\U0001d75d': '$\\mathsfbf{\\Theta}$',
    '\U0001d75e': '$\\mathsfbf{\\Iota}$',
    '\U0001d75f': '$\\mathsfbf{\\Kappa}$',
    '\U0001d760': '$\\mathsfbf{\\Lambda}$',
    '\U0001d761': '$M$',
    '\U0001d762': '$N$',
    '\U0001d763': '$\\mathsfbf{\\Xi}$',
    '\U0001d764': '$O$',
    '\U0001d765': '$\\mathsfbf{\\Pi}$',
    '\U0001d766': '$\\mathsfbf{\\Rho}$',
    '\U0001d767': '{\\mathsfbf{\\vartheta}}',
    '\U0001d768': '$\\mathsfbf{\\Sigma}$',
    '\U0001d769': '$\\mathsfbf{\\Tau}$',
    '\U0001d76a': '$\\mathsfbf{\\Upsilon}$',
    '\U0001d76b': '$\\mathsfbf{\\Phi}$',
    '\U0001d76c': '$\\mathsfbf{\\Chi}$',
    '\U0001d76d': '$\\mathsfbf{\\Psi}$',
    '\U0001d76e': '$\\mathsfbf{\\Omega}$',
    '\U0001d76f': '$\\mathsfbf{\\nabla}$',
    '\U0001d770': '$\\mathsfbf{\\Alpha}$',
    '\U0001d771': '$\\mathsfbf{\\Beta}$',
    '\U0001d772': '$\\mathsfbf{\\Gamma}$',
    '\U0001d773': '$\\mathsfbf{\\Delta}$',
    '\U0001d774': '$\\mathsfbf{\\Epsilon}$',
    '\U0001d775': '$\\mathsfbf{\\Zeta}$',
    '\U0001d776': '$\\mathsfbf{\\Eta}$',
    '\U0001d777': '$\\mathsfbf{\\Theta}$',
    '\U0001d778': '$\\mathsfbf{\\Iota}$',
    '\U0001d779': '$\\mathsfbf{\\Kappa}$',
    '\U0001d77a': '$\\mathsfbf{\\Lambda}$',
    '\U0001d77b': '$M$',
    '\U0001d77c': '$N$',
    '\U0001d77d': '$\\mathsfbf{\\Xi}$',
    '\U0001d77e': '$O$',
    '\U0001d77f': '$\\mathsfbf{\\Pi}$',
    '\U0001d780': '$\\mathsfbf{\\Rho}$',
    '\U0001d781': '$\\mathsfbf{\\varsigma}$',
    '\U0001d782': '$\\mathsfbf{\\Sigma}$',
    '\U0001d783': '$\\mathsfbf{\\Tau}$',
    '\U0001d784': '$\\mathsfbf{\\Upsilon}$',
    '\U0001d785': '$\\mathsfbf{\\Phi}$',
    '\U0001d786': '$\\mathsfbf{\\Chi}$',
    '\U0001d787': '$\\mathsfbf{\\Psi}$',
    '\U0001d788': '$\\mathsfbf{\\Omega}$',
    '\U0001d789': '$\\partial$',
    '\U0001d78a': '$\\in$',
    '\U0001d78b': '{\\mathsfbf{\\vartheta}}',
    '\U0001d78c': '{\\mathsfbf{\\varkappa}}',
    '\U0001d78d': '{\\mathsfbf{\\phi}}',
    '\U0001d78e': '{\\mathsfbf{\\varrho}}',
    '\U0001d78f': '{\\mathsfbf{\\varpi}}',
    '\U0001d790': '$\\mathsfbfsl{\\Alpha}$',
    '\U0001d791': '$\\mathsfbfsl{\\Beta}$',
    '\U0001d792': '$\\mathsfbfsl{\\Gamma}$',
    '\U0001d793': '$\\mathsfbfsl{\\Delta}$',
    '\U0001d794': '$\\mathsfbfsl{\\Epsilon}$',
    '\U0001d795': '$\\mathsfbfsl{\\Zeta}$',
    '\U0001d796': '$\\mathsfbfsl{\\Eta}$',
    '\U0001d797': '$\\mathsfbfsl{\\vartheta}$',
    '\U0001d798': '$\\mathsfbfsl{\\Iota}$',
    '\U0001d799': '$\\mathsfbfsl{\\Kappa}$',
    '\U0001d79a': '$\\mathsfbfsl{\\Lambda}$',
    '\U0001d79b': '$M$',
    '\U0001d79c': '$N$',
    '\U0001d79d': '$\\mathsfbfsl{\\Xi}$',
    '\U0001d79e': '$O$',
    '\U0001d79f': '$\\mathsfbfsl{\\Pi}$',
    '\U0001d7a0': '$\\mathsfbfsl{\\Rho}$',
    '\U0001d7a1': '{\\mathsfbfsl{\\vartheta}}',
    '\U0001d7a2': '$\\mathsfbfsl{\\Sigma}$',
    '\U0001d7a3': '$\\mathsfbfsl{\\Tau}$',
    '\U0001d7a4': '$\\mathsfbfsl{\\Upsilon}$',
    '\U0001d7a5': '$\\mathsfbfsl{\\Phi}$',
    '\U0001d7a6': '$\\mathsfbfsl{\\Chi}$',
    '\U0001d7a7': '$\\mathsfbfsl{\\Psi}$',
    '\U0001d7a8': '$\\mathsfbfsl{\\Omega}$',
    '\U0001d7a9': '$\\mathsfbfsl{\\nabla}$',
    '\U0001d7aa': '$\\mathsfbfsl{\\Alpha}$',
    '\U0001d7ab': '$\\mathsfbfsl{\\Beta}$',
    '\U0001d7ac': '$\\mathsfbfsl{\\Gamma}$',
    '\U0001d7ad': '$\\mathsfbfsl{\\Delta}$',
    '\U0001d7ae': '$\\mathsfbfsl{\\Epsilon}$',
    '\U0001d7af': '$\\mathsfbfsl{\\Zeta}$',
    '\U0001d7b0': '$\\mathsfbfsl{\\Eta}$',
    '\U0001d7b1': '$\\mathsfbfsl{\\vartheta}$',
    '\U0001d7b2': '$\\mathsfbfsl{\\Iota}$',
    '\U0001d7b3': '$\\mathsfbfsl{\\Kappa}$',
    '\U0001d7b4': '$\\mathsfbfsl{\\Lambda}$',
    '\U0001d7b5': '$M$',
    '\U0001d7b6': '$N$',
    '\U0001d7b7': '$\\mathsfbfsl{\\Xi}$',
    '\U0001d7b8': '$O$',
    '\U0001d7b9': '$\\mathsfbfsl{\\Pi}$',
    '\U0001d7ba': '$\\mathsfbfsl{\\Rho}$',
    '\U0001d7bb': '$\\mathsfbfsl{\\varsigma}$',
    '\U0001d7bc': '$\\mathsfbfsl{\\Sigma}$',
    '\U0001d7bd': '$\\mathsfbfsl{\\Tau}$',
    '\U0001d7be': '$\\mathsfbfsl{\\Upsilon}$',
    '\U0001d7bf': '$\\mathsfbfsl{\\Phi}$',
    '\U0001d7c0': '$\\mathsfbfsl{\\Chi}$',
    '\U0001d7c1': '$\\mathsfbfsl{\\Psi}$',
    '\U0001d7c2': '$\\mathsfbfsl{\\Omega}$',
    '\U0001d7c3': '$\\partial$',
    '\U0001d7c4': '$\\in$',
    '\U0001d7c5': '{\\mathsfbfsl{\\vartheta}}',
    '\U0001d7c6': '{\\mathsfbfsl{\\varkappa}}',
    '\U0001d7c7': '{\\mathsfbfsl{\\phi}}',
    '\U0001d7c8': '{\\mathsfbfsl{\\varrho}}',
    '\U0001d7c9': '{\\mathsfbfsl{\\varpi}}',
    '\U0001d7ce': '$\\mathbf{0}$',
    '\U0001d7cf': '$\\mathbf{1}$',
    '\U0001d7d0': '$\\mathbf{2}$',
    '\U0001d7d1': '$\\mathbf{3}$',
    '\U0001d7d2': '$\\mathbf{4}$',
    '\U0001d7d3': '$\\mathbf{5}$',
    '\U0001d7d4': '$\\mathbf{6}$',
    '\U0001d7d5': '$\\mathbf{7}$',
    '\U0001d7d6': '$\\mathbf{8}$',
    '\U0001d7d7': '$\\mathbf{9}$',
    '\U0001d7d8': '$\\mathbb{0}$',
    '\U0001d7d9': '$\\mathbb{1}$',
    '\U0001d7da': '$\\mathbb{2}$',
    '\U0001d7db': '$\\mathbb{3}$',
    '\U0001d7dc': '$\\mathbb{4}$',
    '\U0001d7dd': '$\\mathbb{5}$',
    '\U0001d7de': '$\\mathbb{6}$',
    '\U0001d7df': '$\\mathbb{7}$',
    '\U0001d7e0': '$\\mathbb{8}$',
    '\U0001d7e1': '$\\mathbb{9}$',
    '\U0001d7e2': '$\\mathsf{0}$',
    '\U0001d7e3': '$\\mathsf{1}$',
    '\U0001d7e4': '$\\mathsf{2}$',
    '\U0001d7e5': '$\\mathsf{3}$',
    '\U0001d7e6': '$\\mathsf{4}$',
    '\U0001d7e7': '$\\mathsf{5}$',
    '\U0001d7e8': '$\\mathsf{6}$',
    '\U0001d7e9': '$\\mathsf{7}$',
    '\U0001d7ea': '$\\mathsf{8}$',
    '\U0001d7eb': '$\\mathsf{9}$',
    '\U0001d7ec': '$\\mathsfbf{0}$',
    '\U0001d7ed': '$\\mathsfbf{1}$',
    '\U0001d7ee': '$\\mathsfbf{2}$',
    '\U0001d7ef': '$\\mathsfbf{3}$',
    '\U0001d7f0': '$\\mathsfbf{4}$',
    '\U0001d7f1': '$\\mathsfbf{5}$',
    '\U0001d7f2': '$\\mathsfbf{6}$',
    '\U0001d7f3': '$\\mathsfbf{7}$',
    '\U0001d7f4': '$\\mathsfbf{8}$',
    '\U0001d7f5': '$\\mathsfbf{9}$',
    '\U0001d7f6': '$\\mathtt{0}$',
    '\U0001d7f7': '$\\mathtt{1}$',
    '\U0001d7f8': '$\\mathtt{2}$',
    '\U0001d7f9': '$\\mathtt{3}$',
    '\U0001d7fa': '$\\mathtt{4}$',
    '\U0001d7fb': '$\\mathtt{5}$',
    '\U0001d7fc': '$\\mathtt{6}$',
    '\U0001d7fd': '$\\mathtt{7}$',
    '\U0001d7fe': '$\\mathtt{8}$',
    '\U0001d7ff': '$\\mathtt{9}$',

    # Items from simple list
    '\u0106': "{\\a\\'C}",
    '\u0408': '{\\CYRJE}',
    '\u2191': '{\\textuparrow}',
    '\u0493': '{\\cyrghcrs}',
    '\u2116': '{\\textnumero}',
    '\u0418': '{\\CYRI}',
    '\u04a3': '{\\cyrndsc}',
    '\u2126': '{\\textohm}',
    '\u0428': '{\\CYRSH}',
    '\u04b3': '{\\cyrhdsc}',
    '\u0438': '{\\cyri}',
    '\u03bd': '{$\\nu$}',
    '\u04c3': '{\\CYRKHK}',
    '\u0448': '{\\cyrsh}',
    '\xcb': '{\\"E}',
    '\u0458': '{\\cyrje}',
    '\xdb': '{\\^U}',
    '\xeb': '{\\"e}',
    '\xfb': '{\\^u}',
    '\u0413': '{\\CYRG}',
    '\u0498': '{\\CYRZDSC}',
    '\xa0': '{~}',
    '\u0423': '{\\CYRU}',
    '\u04a8': '{\\CYRABHHA}',
    '\u0433': '{\\cyrg}',
    '\u04b8': '{\\CYRCHVCRS}',
    '\u203b': '{\\textreferencemark}',
    '\u211e': '{\\textrecipe}',
    '\xc0': '{\\`A}',
    '\u0443': '{\\cyru}',
    '\u04c8': '{\\cyrnhk}',
    '\u0151': '{\\H o}',
    '\u04d8': '{\\CYRSCHWA}',
    '\u0161': '{\\v s}',
    '\xe0': '{\\`a}',
    '\u0463': '{\\cyryat}',
    '\u04e8': '{\\CYROTLD}',
    '\u0171': '{\\H u}',
    '\u0473': '{\\cyrfita}',
    '\u20ab': '{\\textdong}',
    '\u2103': '{\\textcelsius}',
    '\u040e': '{\\CYRUSHRT}',
    '\u2212': '{\\textminus}',
    '\u2016': '{\\textbardbl}',
    '\u0499': '{\\cyrzdsc}',
    '\u041e': '{\\CYRO}',
    '\u2120': '{\\textservicemark}',
    '\u03a7': '{$\\chi$}',
    '\u2026': '{\\textellipsis}',
    '\u04a9': '{\\cyrabhha}',
    '\u042e': '{\\CYRYU}',
    '\xb1': '{\\textpm}',
    '\u0130': '{\\.I}',
    '\u04b9': '{\\cyrchvcrs}',
    '\u043e': '{\\cyro}',
    '\xc1': "{\\'A}",
    '\u044e': '{\\cyryu}',
    '\xd1': '{\\~N}',
    '\u0150': '{\\H O}',
    '\u04d9': '{\\cyrschwa}',
    '\u02dd': '{\\textacutedbl}',
    '\u045e': '{\\cyrushrt}',
    '\xe1': "{\\'a}",
    '\u0160': '{\\v S}',
    '\u04e9': '{\\cyrotld}',
    '\u266a': '{\\textmusicalnote}',
    '\xf1': '{\\~n}',
    '\u0170': '{\\H U}',
    '\u0409': '{\\CYRLJE}',
    '\u048e': '{\\CYRRTICK}',
    '\u2190': '{\\leftarrow}',
    '\u0419': '{\\CYRISHRT}',
    '\u011b': '{\\v e}',
    '\u049e': '{\\CYRKHCRS}',
    '\u0429': '{\\CYRSHCH}',
    '\u04ae': '{\\CYRY}',
    '\u0439': '{\\cyrishrt}',
    '\u04be': '{\\CYRABHCHDSC}',
    '\u0449': '{\\cyrshch}',
    '\u04ce': '{\\cyrmdsc}',
    '\xd6': '{\\"O}',
    '\u0459': '{\\cyrlje}',
    '\u015b': "{\\'s}",
    '\u20a6': '{\\textnaira}',
    '\xf6': '{\\"o}',
    '\u017b': '{\\.Z}',
    '\u0102': '{\\u A}',
    '\u0404': '{\\CYRIE}',
    '\u200c': '{\\textcompwordmark}',
    '\u048f': '{\\cyrrtick}',
    '\u0414': '{\\CYRD}',
    '\u049f': '{\\cyrkhcrs}',
    '\u0424': '{\\CYRF}',
    '\u04af': '{\\cyry}',
    '\u0434': '{\\cyrd}',
    '\xb7': '{\\textperiodcentered}',
    '\u04bf': '{\\cyrabhchdsc}',
    '\u0444': '{\\cyrf}',
    '\xc7': '{\\c C}',
    '\u0454': '{\\cyrie}',
    '\u0162': '{\\c T}',
    '\xe7': '{\\c c}',
    '\u0474': '{\\CYRIZH}',
    '\xf7': '{\\textdiv}',
    '\u010d': '{\\v c}',
    '\u040f': '{\\CYRDZHE}',
    '\u0192': '{\\textflorin}',
    '\u0494': '{\\CYRGHK}',
    '\u041f': '{\\CYRP}',
    '\u04a4': '{\\CYRNG}',
    '\xac': '{\\textlnot}',
    '\u042f': '{\\CYRYA}',
    '\u04b4': '{\\CYRTETSE}',
    '\u013d': '{\\v L}',
    '\u043f': '{\\cyrp}',
    '\u04c4': '{\\cyrkhk}',
    '\xcc': '{\\`I}',
    '\u044f': '{\\cyrya}',
    '\u2422': '{\\textblank}',
    '\u04d4': '{\\CYRAE}',
    '\xdc': '{\\"U}',
    '\u045f': '{\\cyrdzhe}',
    '\xec': '{\\`i}',
    '\u017d': '{\\v Z}',
    '\xfc': '{\\"u}',
    '\u040a': '{\\CYRNJE}',
    '\u010c': '{\\v C}',
    '\u0495': '{\\cyrghk}',
    '\u041a': '{\\CYRK}',
    '\u04a5': '{\\cyrng}',
    '\u042a': '{\\CYRHRDSN}',
    '\u2032': '{$\\prime$}',
    '\u04b5': '{\\cyrtetse}',
    '\u043a': '{\\cyrk}',
    '\u04c5': '{\\CYRLDSC}',
    '\u044a': '{\\cyrhrdsn}',
    '\xcd': "{\\'I}",
    '\u2052': '{\\textdiscount}',
    '\u04d5': '{\\cyrae}',
    '\u045a': '{\\cyrnje}',
    '\xdd': "{\\'Y}",
    '\u046a': '{\\CYRBYUS}',
    '\xed': "{\\'\\i}",
    '\u25ef': '{\\textbigcircle}',
    '\xfd': "{\\'y}",
    '\u017c': '{\\.z}',
    '\u0405': '{\\CYRDZE}',
    '\u0107': "{\\'c}",
    '\u0415': '{\\CYRE}',
    '\u2117': '{\\textcircledP}',
    '\u049a': '{\\CYRKDSC}',
    '\u0425': '{\\CYRH}',
    '\u2127': '{\\textmho}',
    '\u04aa': '{\\CYRSDSC}',
    '\xb2': '{\\texttwosuperior}',
    '\u0435': '{\\cyre}',
    '\u04ba': '{\\CYRSHHA}',
    '\u203d': '{\\textinterrobang}',
    '\xc2': '{\\^A}',
    '\u0445': '{\\cyrh}',
    '\u0147': '{\\v N}',
    '\u02c6': '{\\textasciicircum}',
    '\xd2': '{\\`O}',
    '\u0455': '{\\cyrdze}',
    '\u2261': '{$\\equiv$}',
    '\xe2': '{\\^a}',
    '\xf2': '{\\`o}',
    '\u0475': '{\\cyrizh}',
    '\u010e': '{\\v D}',
    '\u0410': '{\\CYRA}',
    '\u2018': '{\\textquoteleft}',
    '\u049b': '{\\cyrkdsc}',
    '\u011e': '{\\u G}',
    '\u0420': '{\\CYRR}',
    '\u04ab': '{\\cyrsdsc}',
    '\u232a': '{\\textrangle}',
    '\u212e': '{\\textestimated}',
    '\u0430': '{\\cyra}',
    '\xb3': '{\\textthreesuperior}',
    '\u04bb': '{\\cyrshha}',
    '\u013e': '{\\v l}',
    '\u0440': '{\\cyrr}',
    '\xc3': '{\\~A}',
    '\u04cb': '{\\CYRCHLDSC}',
    '\xd3': "{\\'O}",
    '\u015e': '{\\c S}',
    '\xe3': '{\\~a}',
    '\u016e': '{\\r U}',
    '\xf3': "{\\'o}",
    '\u017e': '{\\v z}',
    '\u040b': '{\\CYRTSHE}',
    '\u0490': '{\\CYRGUP}',
    '\u0119': '{\\k e}',
    '\u041b': '{\\CYRL}',
    '\u04a0': '{\\CYRKBEAK}',
    '\u042b': '{\\CYRERY}',
    '\u04b0': '{\\CYRYHCRS}',
    '\u0e37': '{\\textbaht}',
    '\u0139': "{\\'L}",
    '\xb8': '{\\c\\ }',
    '\u043b': '{\\cyrl}',
    '\u04c0': '{\\CYRpalochka}',
    '\xc8': '{\\`E}',
    '\u044b': '{\\cyrery}',
    '\u0159': '{\\v r}',
    '\u045b': '{\\cyrtshe}',
    '\u04e0': '{\\CYRABHDZE}',
    '\u25e6': '{\\textopenbullet}',
    '\xe8': '{\\`e}',
    '\u046b': '{\\cyrbyus}',
    '\u0179': "{\\'Z}",
    '\u0406': '{\\CYRII}',
    '\u0491': '{\\cyrgup}',
    '\u2193': '{\\textdownarrow}',
    '\u2192': '{\\textrightarrow}',
    '\u0416': '{\\CYRZH}',
    '\u0118': '{\\k E}',
    '\u201e': '{\\quotedblbase}',
    '\u04a1': '{\\cyrkbeak}',
    '\u0426': '{\\CYRC}',
    '\u04b1': '{\\cyryhcrs}',
    '\u0436': '{\\cyrzh}',
    '\xb9': '{\\textonesuperior}',
    '\u0446': '{\\cyrc}',
    '\xc9': "{\\'E}",
    '\u0148': '{\\v n}',
    '\u204e': '{\\textasteriskcentered}',
    '\u0456': '{\\cyrii}',
    '\xd9': '{\\`U}',
    '\u0158': '{\\v R}',
    '\u04e1': '{\\cyrabhdze}',
    '\xe9': "{\\'e}",
    '\xf9': '{\\`u}',
    '\u0178': '{\\"Y}',
    '\u0401': '{\\CYRYO}',
    '\u0103': '{\\u a}',
    '\u0411': '{\\CYRB}',
    '\u0496': '{\\CYRZHDSC}',
    '\u2019': '{\\textquoteright}',
    '\u0421': '{\\CYRS}',
    '\u04a6': '{\\CYRPHK}',
    '\u0431': '{\\cyrb}',
    '\u04b6': '{\\CYRCHRDSC}',
    '\u0441': '{\\cyrs}',
    '\u0143': "{\\'N}",
    '\u04c6': '{\\cyrldsc}',
    '\u02ca': '{\\textasciitilde}',
    '\xce': '{\\^I}',
    '\u0451': '{\\cyryo}',
    '\u0163': '{\\c t}',
    '\xee': '{\\^\\i}',
    '\u0497': '{\\cyrzhdsc}',
    '\u011a': '{\\v E}',
    '\u041c': '{\\CYRM}',
    '\u04a7': '{\\cyrphk}',
    '\u042c': '{\\CYRSFTSN}',
    '\u04b7': '{\\cyrchrdsc}',
    '\u013a': "{\\'l}",
    '\u043c': '{\\cyrm}',
    '\u2044': '{\\textfractionsolidus}',
    '\u04c7': '{\\CYRNHK}',
    '\u044c': '{\\cyrsftsn}',
    '\xcf': '{\\"I}',
    '\u015a': "{\\'S}",
    '\xef': '{\\"\\i}',
    '\u017a': "{\\'z}",
    '\xff': '{\\"y}',
    '\u0105': '{\\k a}',
    '\u0407': '{\\CYRYI}',
    '\u048c': '{\\CYRSEMISFTSN}',
    '\u0417': '{\\CYRZ}',
    '\u049c': '{\\CYRKVCRS}',
    '\u0427': '{\\CYRCH}',
    '\u2329': '{\\textlangle}',
    '\u04ac': '{\\CYRTDSC}',
    '\u0437': '{\\cyrz}',
    '\u04bc': '{\\CYRABHCH}',
    '\u20a1': '{\\textcolonmonetary}',
    '\xc4': '{\\"A}',
    '\u0447': '{\\cyrch}',
    '\u04cc': '{\\cyrchldsc}',
    '\u0155': "{\\'r}",
    '\xd4': '{\\^O}',
    '\u0457': '{\\cyryi}',
    '\u0165': '{\\v t}',
    '\xe4': '{\\"a}',
    '\u20a9': '{\\textwon}',
    '\xf4': '{\\^o}',
    '\u0402': '{\\CYRDJE}',
    '\u0104': '{\\k A}',
    '\u048d': '{\\cyrsemisftsn}',
    '\u0412': '{\\CYRV}',
    '\u201a': '{\\quotesinglbase}',
    '\u049d': '{\\cyrkvcrs}',
    '\u20b1': '{\\textpeso}',
    '\u0422': '{\\CYRT}',
    '\u04ad': '{\\cyrtdsc}',
    '\u0432': '{\\cyrv}',
    '\xb5': '{\\textmu}',
    '\u04bd': '{\\cyrabhch}',
    '\u0442': '{\\cyrt}',
    '\xc5': '{\\r A}',
    '\u0144': "{\\'n}",
    '\u04cd': '{\\CYRMDSC}',
    '\u0452': '{\\cyrdje}',
    '\xd5': '{\\~O}',
    '\u0154': "{\\'R}",
    '\u0462': '{\\CYRYAT}',
    '\xe5': '{\\r a}',
    '\u0164': '{\\v T}',
    '\u0472': '{\\CYRFITA}',
    '\xf5': '{\\~o}',
    '\u010f': '{\\v d}',
    '\u0492': '{\\CYRGHCRS}',
    '\u041d': '{\\CYRN}',
    '\u011f': '{\\u g}',
    '\u04a2': '{\\CYRNDSC}',
    '\u042d': '{\\CYREREV}',
    '\u04b2': '{\\CYRHDSC}',
    '\u043d': '{\\cyrn}',
    '\xca': '{\\^E}',
    '\u044d': '{\\cyrerev}',
    '\xda': "{\\'U}",
    '\u015f': '{\\c s}',
    '\u20a4': '{\\textlira}',
    '\xea': '{\\^e}',
    '\u016f': '{\\r u}',
    '\xfa': "{\\'u}"

    # Items to add at a latter date (check first)
    # '\u0000': r'{$\alpha$}',
    # '\u0000': r'{$\beta$}',
    # '\u0000': r'{$\gamma$}',
    # '\u0000': r'{$\delta$}',
    # '\u0000': r'{$\epsilon$}',
    # '\u0000': r'{$\varepsilon$}',
    # '\u0000': r'{$\zeta$}',
    # '\u0000': r'{$\eta$}',
    # '\u0000': r'{$\theta$}',
    # '\u0000': r'{$\vartheta$}',
    # '\u0000': r'{$\iota$}',
    # '\u0000': r'{$\kappa$}',
    # '\u0000': r'{$\lambda$}',
    # '\u0000': r'{$\mu$}',
    # '\u0000': r'{$\xi$}',
    # '\u0000': r'{$\pi$}',
    # '\u0000': r'{$\varpi$}',
    # '\u0000': r'{$\rho$}',
    # '\u0000': r'{$\varrho$}',
    # '\u0000': r'{$\sigma$}',
    # '\u0000': r'{$\varsigma$}',
    # '\u0000': r'{$\tau$}',
    # '\u0000': r'{$\upsilon$}',
    # '\u0000': r'{$\phi$}',
    # '\u0000': r'{$\varphi$}',
    # '\u0000': r'{$\psi$}',
    # '\u0000': r'{$\omega$}',
    # '\u0000': r'{$\Gamma$}',
    # '\u0000': r'{$\Delta$}',
    # '\u0000': r'{$\Theta$}',
    # '\u0000': r'{$\Lambda$}',
    # '\u0000': r'{$\Xi$}',
    # '\u0000': r'{$\Pi$}',
    # '\u0000': r'{$\Sigma$}',
    # '\u0000': r'{$\Upsilon$}',
    # '\u0000': r'{$\Phi$}',
    # '\u0000': r'{$\Psi$}',
    # '\u0000': r'{$\Omega$}',
    }
# }}}

entity_mapping = {
                '&mdash;':'{---}',
                '&ndash;':'{--}',
                '"':'{"}',
                }


class BibTeX:

    def __init__(self):
        self.rep_utf8 = MReplace(utf8enc2latex_mapping)
        self.rep_ent = MReplace(entity_mapping)
        # Set default conversion to ASCII BibTeX
        self.ascii_bibtex = True
        # This substitution is based on the description of cite key restrictions at
        # http://bibdesk.sourceforge.net/manual/BibDesk%20Help_2.html
        self.invalid_cit = re.compile('[ "@\',\\#}{~%&$^]')
        self.upper = re.compile('[' +
            string.ascii_uppercase + ']')
        self.escape = re.compile('[#&%_]')

    def ValidateCitationKey(self, text):
        """
        Removes characters not allowed in BibTeX keys
        """
        return self.invalid_cit.sub('', text)

    def braceUppercase(self, text):
        """
        Convert uppercase letters to bibtex encoded uppercase
        """
        return self.upper.sub(lambda m: '{%s}' % m.group(), text)

    def resolveEntities(self, text):
        return self.rep_ent.mreplace(text)

    def resolveUnicode(self, text):
        # UTF-8 text as entry
        text = self.rep_utf8.mreplace(text)
        return text.replace('$}{$', '')

    def escapeSpecialCharacters(self, text):
        """
        Latex escaping some (not all) special characters
        """
        text = text.replace('\\', '\\\\')
        text = text.replace('~', '{\\char`\\~}')  # TILDE
        return self.escape.sub(lambda m: '\\%s' % m.group(), text)

    # Calibre functions: Option to go to official ASCII Bibtex or unofficial UTF-8
    def utf8ToBibtex(self, text):
        """
        Go from an unicode entry to ASCII Bibtex format without encoding
        """
        if len(text) == 0:
            return ''
        text = self.resolveEntities(text)
        text = self.escapeSpecialCharacters(text)
        if self.ascii_bibtex :
            text = self.resolveUnicode(text)
        return text

    def bibtex_author_format(self, item):
        """
        Format authors for Bibtex compliance (get a list as input)
        """
        return self.utf8ToBibtex(' and '.join([author for author in item]))

    def stripUnmatchedSyntax(self, text, open_character, close_character):
        """
        Strips unmatched BibTeX syntax
        """
        stack = []
        assert len(open_character) == 1 and len(close_character) == 1
        remove = []
        for i, ch in enumerate(text):
            if ch == open_character:
                stack.append(i)
            elif ch == close_character:
                try:
                    stack.pop()
                except IndexError:
                    # Remove unmatched closing char
                    remove.append(i)
        # Remove unmatched opening chars
        remove.extend(stack)

        if remove:
            text = list(text)
            for i in sorted(remove, reverse=True):
                text.pop(i)
            text = ''.join(text)
        return text
