type token =
  | LBRA
  | RBRA
  | STRICT
  | GRAPH
  | DIGRAPH
  | Id of (string)
  | Id_html of (string)
  | Id_double_quoted of (string)
  | SEMICOLON
  | NODE
  | EDGE
  | LSBRA
  | RSBRA
  | COMMA
  | EQUALS
  | SUBGRAPH
  | COLON
  | PLUS
  | EDGEOP
  | EOF

open Parsing;;
# 2 "odot_parser.mly"
open Odot_types

let compass_pt_of_id id =
  let s =
    match id with
      Simple_id s -> s
     | Double_quoted_id s -> s
     | Html_id s -> "<"^s^">"
  in
  let s = String.lowercase s in
  match s with
    "n" -> N
   | "ne" -> NE
   | "e" -> E
   | "se" -> SE
   | "s" ->  S
   | "sw" ->  SW
   | "w" ->  W
   | "nw" ->  NW
   | _ -> failwith "Not a compass_pt"
# 46 "odot_parser.ml"
let yytransl_const = [|
  257 (* LBRA *);
  258 (* RBRA *);
  259 (* STRICT *);
  260 (* GRAPH *);
  261 (* DIGRAPH *);
  265 (* SEMICOLON *);
  266 (* NODE *);
  267 (* EDGE *);
  268 (* LSBRA *);
  269 (* RSBRA *);
  270 (* COMMA *);
  271 (* EQUALS *);
  272 (* SUBGRAPH *);
  273 (* COLON *);
  274 (* PLUS *);
  275 (* EDGEOP *);
    0 (* EOF *);
    0|]

let yytransl_block = [|
  262 (* Id *);
  263 (* Id_html *);
  264 (* Id_double_quoted *);
    0|]

let yylhs = "\255\255\
\002\000\002\000\002\000\002\000\002\000\004\000\004\000\005\000\
\005\000\005\000\006\000\006\000\008\000\008\000\009\000\010\000\
\010\000\010\000\011\000\011\000\011\000\011\000\011\000\012\000\
\012\000\012\000\012\000\007\000\001\000\013\000\013\000\003\000\
\003\000\003\000\016\000\016\000\015\000\015\000\014\000\014\000\
\000\000"

let yylen = "\002\000\
\000\000\002\000\003\000\004\000\005\000\000\000\004\000\001\000\
\003\000\005\000\001\000\001\000\002\000\003\000\003\000\002\000\
\002\000\002\000\002\000\003\000\001\000\001\000\001\000\001\000\
\002\000\003\000\002\000\005\000\006\000\000\000\001\000\001\000\
\001\000\001\000\001\000\003\000\001\000\001\000\000\000\001\000\
\002\000"

let yydefred = "\000\000\
\000\000\000\000\040\000\041\000\000\000\037\000\038\000\000\000\
\032\000\034\000\000\000\031\000\000\000\033\000\000\000\000\000\
\036\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\021\000\022\000\000\000\000\000\000\000\016\000\017\000\
\018\000\000\000\000\000\000\000\019\000\000\000\000\000\000\000\
\027\000\029\000\000\000\000\000\000\000\020\000\000\000\000\000\
\011\000\000\000\012\000\015\000\026\000\000\000\000\000\000\000\
\002\000\000\000\000\000\014\000\007\000\003\000\000\000\028\000\
\010\000\000\000\004\000\005\000"

let yydgoto = "\002\000\
\004\000\043\000\044\000\031\000\023\000\024\000\025\000\039\000\
\026\000\027\000\028\000\029\000\013\000\005\000\008\000\014\000"

let yysindex = "\003\000\
\004\255\000\000\000\000\000\000\039\255\000\000\000\000\009\255\
\000\000\000\000\250\254\000\000\023\255\000\000\018\255\161\255\
\000\000\033\255\033\255\033\255\009\255\014\255\033\255\028\255\
\000\000\000\000\000\000\150\255\051\255\009\255\000\000\000\000\
\000\000\068\255\009\255\009\255\000\000\003\255\033\255\161\255\
\000\000\000\000\066\255\027\255\161\255\000\000\076\255\077\255\
\000\000\028\255\000\000\000\000\000\000\033\255\009\255\009\255\
\000\000\079\255\009\255\000\000\000\000\000\000\032\255\000\000\
\000\000\009\255\000\000\000\000"

let yyrindex = "\000\000\
\073\255\000\000\000\000\000\000\000\000\000\000\000\000\084\255\
\000\000\000\000\048\255\000\000\000\000\000\000\000\000\000\000\
\000\000\139\255\139\255\139\255\084\255\064\255\096\255\000\000\
\112\255\000\000\000\000\093\255\000\000\088\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\139\255\095\255\
\000\000\000\000\000\000\088\255\000\000\000\000\080\255\064\255\
\000\000\128\255\000\000\000\000\000\000\139\255\088\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\088\255\000\000\
\000\000\088\255\000\000\000\000"

let yygindex = "\000\000\
\000\000\215\255\248\255\238\255\070\000\071\000\072\000\061\000\
\000\000\000\000\000\000\234\255\092\000\000\000\000\000\102\000"

let yytablesize = 177
let yytable = "\012\000\
\032\000\033\000\057\000\001\000\037\000\041\000\003\000\022\000\
\009\000\010\000\011\000\015\000\012\000\062\000\009\000\010\000\
\011\000\053\000\021\000\022\000\052\000\067\000\058\000\016\000\
\068\000\011\000\046\000\047\000\035\000\048\000\036\000\022\000\
\009\000\010\000\011\000\061\000\022\000\009\000\010\000\011\000\
\055\000\056\000\006\000\007\000\030\000\066\000\038\000\063\000\
\035\000\035\000\065\000\035\000\042\000\035\000\035\000\035\000\
\035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
\035\000\008\000\035\000\008\000\045\000\008\000\008\000\008\000\
\008\000\008\000\008\000\008\000\039\000\039\000\054\000\008\000\
\064\000\009\000\008\000\009\000\030\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\059\000\036\000\024\000\009\000\
\025\000\006\000\009\000\006\000\001\000\006\000\006\000\006\000\
\006\000\006\000\006\000\049\000\050\000\051\000\060\000\006\000\
\034\000\023\000\011\000\023\000\017\000\023\000\023\000\023\000\
\023\000\023\000\023\000\000\000\000\000\000\000\000\000\023\000\
\000\000\013\000\012\000\013\000\000\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\006\000\000\000\006\000\013\000\
\006\000\006\000\006\000\006\000\006\000\006\000\000\000\000\000\
\000\000\018\000\006\000\009\000\010\000\011\000\040\000\019\000\
\020\000\000\000\000\000\000\000\018\000\021\000\009\000\010\000\
\011\000\000\000\019\000\020\000\000\000\000\000\000\000\000\000\
\021\000"

let yycheck = "\008\000\
\019\000\020\000\044\000\001\000\023\000\028\000\003\001\016\000\
\006\001\007\001\008\001\018\001\021\000\055\000\006\001\007\001\
\008\001\040\000\016\001\028\000\039\000\063\000\045\000\001\001\
\066\000\008\001\035\000\036\000\015\001\038\000\017\001\040\000\
\006\001\007\001\008\001\054\000\045\000\006\001\007\001\008\001\
\014\001\015\001\004\001\005\001\012\001\014\001\019\001\056\000\
\001\001\002\001\059\000\004\001\002\001\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\013\001\014\001\015\001\016\001\
\017\001\002\001\019\001\004\001\001\001\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\004\001\005\001\013\001\016\001\
\002\001\002\001\019\001\004\001\001\001\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\017\001\017\001\002\001\016\001\
\002\001\002\001\019\001\004\001\013\001\006\001\007\001\008\001\
\009\001\010\001\011\001\038\000\038\000\038\000\050\000\016\001\
\021\000\002\001\019\001\004\001\015\000\006\001\007\001\008\001\
\009\001\010\001\011\001\255\255\255\255\255\255\255\255\016\001\
\255\255\002\001\019\001\004\001\255\255\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\002\001\255\255\004\001\016\001\
\006\001\007\001\008\001\009\001\010\001\011\001\255\255\255\255\
\255\255\004\001\016\001\006\001\007\001\008\001\009\001\010\001\
\011\001\255\255\255\255\255\255\004\001\016\001\006\001\007\001\
\008\001\255\255\010\001\011\001\255\255\255\255\255\255\255\255\
\016\001"

let yynames_const = "\
  LBRA\000\
  RBRA\000\
  STRICT\000\
  GRAPH\000\
  DIGRAPH\000\
  SEMICOLON\000\
  NODE\000\
  EDGE\000\
  LSBRA\000\
  RSBRA\000\
  COMMA\000\
  EQUALS\000\
  SUBGRAPH\000\
  COLON\000\
  PLUS\000\
  EDGEOP\000\
  EOF\000\
  "

let yynames_block = "\
  Id\000\
  Id_html\000\
  Id_double_quoted\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    Obj.repr(
# 45 "odot_parser.mly"
   (
  []
  )
# 215 "odot_parser.ml"
               : 'a_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'a_list) in
    Obj.repr(
# 48 "odot_parser.mly"
            (
  (_1, None) :: _2
  )
# 225 "odot_parser.ml"
               : 'a_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'a_list) in
    Obj.repr(
# 51 "odot_parser.mly"
                  (
  (_1, None) :: _3
  )
# 235 "odot_parser.ml"
               : 'a_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'id) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'a_list) in
    Obj.repr(
# 54 "odot_parser.mly"
                      (
  (_1, Some _3) :: _4
  )
# 246 "odot_parser.ml"
               : 'a_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'id) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'a_list) in
    Obj.repr(
# 57 "odot_parser.mly"
                            (
  (_1, Some _3) :: _5
  )
# 257 "odot_parser.ml"
               : 'a_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 63 "odot_parser.mly"
   (
  []
  )
# 265 "odot_parser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'a_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 66 "odot_parser.mly"
                               (
  _2 @ _4
  )
# 275 "odot_parser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id) in
    Obj.repr(
# 72 "odot_parser.mly"
     (
  (_1, None)
  )
# 284 "odot_parser.ml"
               : 'node_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id) in
    Obj.repr(
# 75 "odot_parser.mly"
              (
  (_1, Some (_3, None))
  )
# 294 "odot_parser.ml"
               : 'node_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'id) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'id) in
    Obj.repr(
# 78 "odot_parser.mly"
                       (
  try
  let compass_pt = compass_pt_of_id _5 in
  (_1, Some (_3, Some compass_pt))
with Failure _ ->
   failwith "Not a compass point."
  )
# 309 "odot_parser.ml"
               : 'node_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'node_id) in
    Obj.repr(
# 88 "odot_parser.mly"
          (
  Edge_node_id _1
  )
# 318 "odot_parser.ml"
               : 'edge_point))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'subgraph) in
    Obj.repr(
# 91 "odot_parser.mly"
           (
  Edge_subgraph _1
  )
# 327 "odot_parser.ml"
               : 'edge_point))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'edge_point) in
    Obj.repr(
# 97 "odot_parser.mly"
                    (
  [_2]
  )
# 336 "odot_parser.ml"
               : 'edgeRHS))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'edge_point) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'edgeRHS) in
    Obj.repr(
# 100 "odot_parser.mly"
                            (
  _2 :: _3
  )
# 346 "odot_parser.ml"
               : 'edgeRHS))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'edge_point) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'edgeRHS) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 106 "odot_parser.mly"
                               (
  (_1, _2, _3)
  )
# 357 "odot_parser.ml"
               : 'edge_stmt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 112 "odot_parser.mly"
                  (
  Attr_graph _2
  )
# 366 "odot_parser.ml"
               : 'attr_stmt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 115 "odot_parser.mly"
                 (
  Attr_node _2
  )
# 375 "odot_parser.ml"
               : 'attr_stmt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 118 "odot_parser.mly"
                 (
  Attr_edge _2
  )
# 384 "odot_parser.ml"
               : 'attr_stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'node_id) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list) in
    Obj.repr(
# 124 "odot_parser.mly"
                    (
  Stmt_node (_1, _2)
  )
# 394 "odot_parser.ml"
               : 'stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'id) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id) in
    Obj.repr(
# 127 "odot_parser.mly"
               (
  Stmt_equals (_1, _3)
  )
# 404 "odot_parser.ml"
               : 'stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'edge_stmt) in
    Obj.repr(
# 130 "odot_parser.mly"
            (
  Stmt_edge _1
  )
# 413 "odot_parser.ml"
               : 'stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr_stmt) in
    Obj.repr(
# 133 "odot_parser.mly"
            (
  Stmt_attr _1
  )
# 422 "odot_parser.ml"
               : 'stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'subgraph) in
    Obj.repr(
# 136 "odot_parser.mly"
           (
  Stmt_subgraph _1
  )
# 431 "odot_parser.ml"
               : 'stmt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stmt) in
    Obj.repr(
# 142 "odot_parser.mly"
       (
  [_1]
  )
# 440 "odot_parser.ml"
               : 'stmt_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stmt) in
    Obj.repr(
# 145 "odot_parser.mly"
                 (
  [_1]
  )
# 449 "odot_parser.ml"
               : 'stmt_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'stmt) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'stmt_list) in
    Obj.repr(
# 148 "odot_parser.mly"
                           (
  _1 :: _3
  )
# 459 "odot_parser.ml"
               : 'stmt_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stmt) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'stmt_list) in
    Obj.repr(
# 151 "odot_parser.mly"
                 (
  _1 :: _2
  )
# 469 "odot_parser.ml"
               : 'stmt_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'id_opt) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'stmt_list) in
    Obj.repr(
# 157 "odot_parser.mly"
                                      (
  { sub_id = _2 ;
   sub_stmt_list = _4;
}
  )
# 481 "odot_parser.ml"
               : 'subgraph))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'strict) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'graph_kind) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'id_opt) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'stmt_list) in
    Obj.repr(
# 165 "odot_parser.mly"
                                               (
  { strict = _1 ;
   kind = _2;
   id = _3;
   stmt_list = _5;
}
  )
# 497 "odot_parser.ml"
               : Odot_types.graph))
; (fun __caml_parser_env ->
    Obj.repr(
# 175 "odot_parser.mly"
   (
  None
  )
# 505 "odot_parser.ml"
               : 'id_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id) in
    Obj.repr(
# 178 "odot_parser.mly"
     (
  Some _1
  )
# 514 "odot_parser.ml"
               : 'id_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 184 "odot_parser.mly"
     (
  Simple_id _1
  )
# 523 "odot_parser.ml"
               : 'id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_dbl_q) in
    Obj.repr(
# 187 "odot_parser.mly"
           (
  Double_quoted_id _1
  )
# 532 "odot_parser.ml"
               : 'id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 190 "odot_parser.mly"
          (
  Html_id _1
  )
# 541 "odot_parser.ml"
               : 'id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 196 "odot_parser.mly"
                   (
  _1
  )
# 550 "odot_parser.ml"
               : 'id_dbl_q))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_dbl_q) in
    Obj.repr(
# 199 "odot_parser.mly"
                                 (
  _1 ^ _3
  )
# 560 "odot_parser.ml"
               : 'id_dbl_q))
; (fun __caml_parser_env ->
    Obj.repr(
# 205 "odot_parser.mly"
        (
  Graph
  )
# 568 "odot_parser.ml"
               : 'graph_kind))
; (fun __caml_parser_env ->
    Obj.repr(
# 208 "odot_parser.mly"
          (
  Digraph
  )
# 576 "odot_parser.ml"
               : 'graph_kind))
; (fun __caml_parser_env ->
    Obj.repr(
# 214 "odot_parser.mly"
   (
  false
  )
# 584 "odot_parser.ml"
               : 'strict))
; (fun __caml_parser_env ->
    Obj.repr(
# 217 "odot_parser.mly"
         (
  true
  )
# 592 "odot_parser.ml"
               : 'strict))
(* Entry graph *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let graph (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Odot_types.graph)
;;
