(* $Id: cam_args.ml,v 1.2 2005/05/09 15:20:51 zoggy Exp $ *)

let commands = ref []

let set_locale s = ignore(Glib.Main.setlocale `CTYPE (Some s))

let options =
  [
    "-e", Arg.String (fun s -> commands := s :: !commands),
    "<command>\texecute command after intialization" ;

    "--locale", Arg.String set_locale,
    "<locale>\n\t\tset locale, for example fr_FR" ;

  ]

let parse () =
  Arg.parse options
    (fun _ -> ())
    Cam_messages.usage;
  commands := List.rev !commands
