(* $Id: cam_com_history.ml,v 1.1 2005/05/19 14:50:07 zoggy Exp $ *)

module O = Config_file

let history : string option array = Array.create Cam_constant.com_history_size None

let pos = ref 0
let n = ref 0

let history_option = new O.list_cp O.string_wrappers
    ~group: Cam_rc.core_ini ["commands_history"]
    []
    ""

let get () =
  let rec iter acc nb_read i =
    if nb_read >= !n then
      acc
    else
      let pred_i =
	if i <= 0 then
	  Cam_constant.com_history_size - 1
	else
	  i - 1
      in
      match history.(pred_i) with
	None -> acc
      |	Some e ->
	  iter (e::acc) (nb_read+1) pred_i
  in
  List.rev (iter [] 0 !pos)

let add e =
  history.(!pos) <- Some e;
  n := min (!n+1) Cam_constant.com_history_size ;
  pos := (!pos + 1) mod Cam_constant.com_history_size;
  history_option#set (get ());
  Cam_rc.save_core ()

let init () =
  List.iter add (List.rev history_option#get)
