(* $Id: cam_commands.mli,v 1.3 2005/05/12 14:32:57 zoggy Exp $ *)

(** Commands management *)

type command = string array -> unit

type command_desc =
    {
      (** Name of the command *)
      com_name : string ;

      (** Description of arguments *)
      com_args : string array ;

      (** Description of arguments who are optional or can appear
	 a various number of times. *)
      com_more_args : string option ;

      (** Function executing the command *)
      com_f : command ;
    }

val register : command_desc -> unit
val string_to_argv : string -> string array
val launch_command : string -> string array -> unit
val ask_launch_command : ?width:int -> string -> string array -> unit
val eval_command : string -> unit

val available_command_names : unit -> string list
