<# [
open Dbf_sql.SQL_db
open Dbf_sql
] #>

<?block [
let table   = fst tmpl__env in

let pkey    =
  match table.SQL_db.ta_pkey with
    | [\] -> None
    | pkey -> Some { SQL_db.idx_name    = "";
                     SQL_db.idx_columns = pkey;
                     SQL_db.idx_unique  = true;
                     SQL_db.idx_db      = table.SQL_db.ta_db; }

and sql_pkey =
  if table.SQL_db.ta_pkey <> [\] then
    Some (Dbf_misc.join
            ~sep:", "
            ~to_string:(fun c -> c.col_name)
            table.SQL_db.ta_pkey)
  else
    None
in

let indexes =
  (match pkey with None -> [\] | Some i -> [i\]) @ (snd tmpl__env)
and columns = table.ta_columns
in

let table_name  = table.ta_name
and idx_name    = fun index -> index.idx_name

and col_name     = fun column -> column.col_name
and col_ocaml_ty = fun opt column ->
  if opt && column.col_nullable then
    Printf.sprintf "%s option" column.col_ocaml_ty
  else
    column.col_ocaml_ty
in

let args_of_columns = fun ~nullty ~opt columns ->
  let print =
    if   opt
    then (fun s1 s2 -> Printf.sprintf "?(%s : %s option)" s1 s2)
    else (fun s1 s2 -> Printf.sprintf "~(%s : %s)" s1 s2)
  in
    Dbf_misc.join
      ~sep:" "
      ~to_string:
        (fun c -> print c.col_name (col_ocaml_ty nullty c))
      columns

and sql_columns_spec_infos =
  let sql_column_spec_infos = fun column ->
    let db2 =
      Dbf_misc.StringMap.fold (fun k _ acc -> k :: acc)
        column.SQL_db.col_spec_ty [\]
    and db1 =
      Dbf_misc.StringMap.fold (fun k _ acc -> k :: acc)
        column.SQL_db.col_spec_options [\]
    in
    let dbs = Dbf_misc.uniq ~sorted:false (db1 @ db2) in
    let infos_for_db = fun db ->
      let spec_ty =
        try  Printf.sprintf "Some \"%s\""
          (String.escaped
             (Dbf_misc.StringMap.find db column.SQL_db.col_spec_ty))
        with Not_found ->
          "None"
      and spec_options =
        try
          Printf.sprintf "Some \"%s\""
            (String.escaped
               (Dbf_misc.join ~sep:" " ~to_string:(fun x -> x)
                  (Dbf_misc.StringMap.find db column.SQL_db.col_spec_options)))
        with
          | Not_found ->
              "None"
      in
        (Printf.sprintf "\"%s\"" (String.escaped db),
         Printf.sprintf "(%s, %s)" spec_ty spec_options)
    in
      List.map infos_for_db dbs
  in
    List.map
      (fun c -> (Printf.sprintf "\"%s\""
                   (String.escaped c.SQL_db.col_name),
                 Printf.sprintf "\"%s %s\""
                   (String.escaped (SQL_ty.fullstring_of_type c.col_type))
                   (if c.SQL_db.col_nullable then "NULL" else "NOT NULL"),
                 sql_column_spec_infos c))
      columns

and sql_columns =
  Dbf_misc.join
    ~sep:", "
    ~to_string:(fun c -> c.col_name)
    columns

and idx_sql_columns = fun index ->
  Dbf_misc.join ~sep:", " ~to_string:(fun c -> c.col_name) index.idx_columns
]?>

module T_<![table_name]!> = functor (Sql : Sql_driver.SqlDriver) ->
struct
  type <![table_name]!> = {
    <?iter:name=column [columns]?>
      <![col_name column]!> : <![col_ocaml_ty true column]!> ;
    <?/iter?>
  }

  let opt_values_of_args = fun <![args_of_columns true true columns]!> () ->
    [<?iter:name=c [columns]?>
       begin match <![col_name c]!> with
         | None   -> None
         | Some v -> begin
             <?if [c.col_nullable] ?>
               match v with
                 | None   ->
                     Some ("NULL",
                           "<![col_name c]!>")
                 | Some v ->
                     Some (Sql.escape_value ((<![c.col_ml2sql]!>) v),
                           "<![col_name c]!>")
             <?/if?><?if [not c.col_nullable]?>
               Some (Sql.escape_value ((<![c.col_ml2sql]!>) v),
                     "<![col_name c]!>")
             <?/if?>
           end
       end ;
    <?/iter?>]

  let columns_decls =
  [<?iter:name=c [sql_columns_spec_infos]?>
   <?block [let (name, ty, infos) = c]?>
    (<![name]!>, <![ty]!>,
     [<?iter:name=info [infos]?>(<![fst info]!>, <![snd info]!>);<?/iter?>]) ;
  <?/block?><?/iter?>]


  let sql_columns_decls =
    let sql_column_decl = fun (name, ty, opts) ->
      let (ty, options) =
        try
          match List.assoc Sql.db_id opts with
            | None,         None      -> (ty, "")
            | Some spec_ty, None      -> (spec_ty, "")
            | None,         Some opts -> (ty, opts)
            | Some spec_ty, Some opts -> (spec_ty, opts)
        with
          | Not_found -> (ty, "")
      in
        Printf.sprintf "%s %s %s" name ty options
    in
    let decls =
      Sql_misc.join
        ~sep:", "
        ~to_string:sql_column_decl
        columns_decls
    in
      <?if [sql_pkey <> None]?>
      let decls = Printf.sprintf "%s, PRIMARY KEY (%s)"
                    decls "<![String.escaped (Dbf_misc.unopt sql_pkey)]!>" in
      <?/if?>
        decls

  let row_as_record = fun ?(offset = 0) row ->
    {
      <?for:name=idx [(0, List.length columns - 1)]?>
      <?block [let column = List.nth columns idx]?>
        <![col_name column]!> =
           <?if [column.col_nullable]?>
             Sql_misc.apply_opt
               (<![column.col_sql2ml]!>) row.(<![string_of_int (idx)]!>) ;
           <?/if?><?if [not column.col_nullable]?>
             (<![column.col_sql2ml]!>)
               (Sql_misc.unopt row.(<![string_of_int (idx)]!>)) ;
           <?/if?>
      <?/block?>
      <?/for?>
    }

  let drop = fun db ->
    ignore (Sql.exec db "DROP TABLE <![table_name]!>")

  let create = fun db ->
    let create_table = fun () ->
      ignore (
        Sql.exec db
          (Printf.sprintf
            "CREATE TABLE <![table_name]!> ( %s )"
            sql_columns_decls)
      )
      <?iter:name=idx [indexes]?><?if [idx.SQL_db.idx_name <> ""]?>
    and create_index_<![idx_name idx]!> = fun () ->
      ignore (
        Sql.exec db
          ("CREATE <?if [idx.idx_unique]?>UNIQUE<?/if?> INDEX " ^
           "<![idx_name idx]!> ON <![table_name]!> " ^
           "( <![idx_sql_columns idx]!> )")
      )
    <?/if?><?/iter?>
    in begin
      create_table ();
      <?iter:name=index [indexes]?><?if [index.SQL_db.idx_name <> ""]?>
      create_index_<![idx_name index]!> ();
      <?/if?><?/iter?>
    end

  let select = fun db condition ->
    let query =
      Printf.sprintf
        "SELECT <![sql_columns]!> FROM <![table_name]!> WHERE %s"
        condition
    in
      Sql.exec db query

  let fetch = fun result ->
    match Sql.fetch_row result with
      | None                    -> None
      | Some (Sql.FR_Array row) -> Some (row_as_record row)
      | _                       -> Sql_misc.ie ()

  let fetch_all = fun result ->
    let to_array = function
      | Sql.FR_Array a -> a
      | _ -> Sql_misc.ie ()
    in
      Sql.map result ~f:(fun r -> row_as_record (to_array r))

  let insert = fun db <![args_of_columns true true columns]!> () ->
    let selected_columns =
      opt_values_of_args
        <?iter:name=c [columns]?><!["?" ^ (col_name c) ^ " "]!><?/iter?>
        ()
    in
    let query =
      Printf.sprintf "INSERT INTO <![table_name]!> (%s) VALUES (%s)"
        (Sql_misc.join_opt ~sep:", " ~to_string:snd selected_columns)
        (Sql_misc.join_opt ~sep:", " ~to_string:fst selected_columns)
    in
      ignore (Sql.exec db query)

  (*=======================================\
  | Insertion/update/deletion with indexes |
  \=======================================*)
  <?iter:name=idx [indexes]?><?if [idx.idx_unique]?>
  <?block [
    let (in_idx, out_idx) =
      List.partition (fun c -> List.memq c idx.idx_columns) columns
    and module_name =
      if idx.SQL_db.idx_name = "" then
        "PKey"
      else
        Printf.sprintf "I_%s" (idx_name idx)
  ]?>
  module <![module_name]!> =
  struct
    let condition_of_args = fun <![args_of_columns false false in_idx]!> ->
      let columns =
        [<?iter:name=c [in_idx]?>
           ((<![c.col_ml2sql]!>) <![col_name c]!>,
            "<![String.escaped (col_name c)]!>") ;
        <?/iter?>]
      in
        Sql_misc.join
          ~sep:" AND "
          ~to_string:
            (fun (value, name) ->
               Printf.sprintf "%s = %s" name (Sql.escape_value value))
          columns

    let delete = fun db <![args_of_columns false false in_idx]!> ->
      let query =
        Printf.sprintf
          "DELETE from <![table_name]!> WHERE %s"
          (condition_of_args <?iter:name=c [in_idx]?><![col_name c]!> <?/iter?>)
      in
        ignore (Sql.exec db query)

    let search = fun db <![args_of_columns false false in_idx]!> ->
      let condition =
        (condition_of_args <?iter:name=c [in_idx]?><![col_name c]!> <?/iter?>)
      in
        match select db condition with
          | Sql.R_Fetch r -> fetch r
          | _             -> None

    <?if [out_idx <> [\]] ?>
    let update = fun db <![args_of_columns false false in_idx]!>
                        <![args_of_columns true true out_idx]!>
                        () ->
      let in_columns =
        [<?iter:name=c [in_idx]?>
           (Sql.escape_value ((<![c.col_ml2sql]!>) <![col_name c]!>),
            "<![String.escaped (col_name c)]!>") ;
        <?/iter?>]
      and out_columns =
        opt_values_of_args
          <?iter:name=c [out_idx]?><!["?" ^ (col_name c)  ^ " "]!><?/iter?>
          ()
      in
      let query =
        Printf.sprintf "UPDATE <![table_name]!> SET %s WHERE %s"
          (Sql_misc.join_opt
             ~sep:" AND "
             ~to_string:
               (fun (value, name) ->
                  Printf.sprintf "%s = %s" name value)
             out_columns)
          (Sql_misc.join
             ~sep:" AND "
             ~to_string:
               (fun (value, name) ->
                 Printf.sprintf "%s = %s" name value)
             in_columns)
      in
        ignore (Sql.exec db query)
    <?/if?>

  end
  <?/block?><?/if?><?/iter?>

end
<?/block?>
