(* $Id: gstuff.ml,v 1.1 2005/04/08 14:25:17 zoggy Exp $ *)

let find_first_child store it =
  let p = store#get_path it in
  let res = ref None in
  store#foreach
    (fun _ it ->
      let parent = store#iter_parent it in
      match parent with
        None -> false
      | Some itp ->
          if store#get_path itp = p then (res := Some it; true) else false
    );
  !res

let find_iter_above store it =
  let p = store#get_path it in
  let res = ref None in
  store#foreach
    (fun path it ->
      let rr = store#get_row_reference path in
      store#iter_next it;
      if store#get_path it = p then (res := Some rr; true) else false
    );
  !res

let find_iter_below store it =
  if store#iter_next it then
    Some (store#get_row_reference (store#get_path it))
  else
    None
