/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef ACTIONSTATEMACHINE_H
#define ACTIONSTATEMACHINE_H


// -- Qt stuff
#include <QTextStream>
#include <QStateMachine>
#include <QState>
#include <QFinalState>
#include <QDir>

// -- Qt XML stuff
#include <QtXml/QDomDocument>
#include <QtXml/QDomNodeList>

// -- CamiTK Core stuff
#include <AbortException.h>
#include <Application.h>

// -- CamiTK Local stuff
#include "ActionState.h"
#include "SaveActionState.h"


using namespace camitk;

/**
  * \class ActionStateMachineMainWindow
  * \brief 
  * This Class describes ActionStateMachineMainWindow application.
  * It aims at showing the user how to simply execute image processing steps. 
  * This is a simple proof-of-concept application.
  * \author Nicolas Saubat
  */
class ActionStateMachine : public Application
{
	Q_OBJECT

public:
    /// construtor
    ActionStateMachine(int &argc, char ** argv) throw(AbortException);

    /// destructor
    virtual ~ActionStateMachine();

	/// where to save the files
	QString getSaveDirectory();
	
protected:

	void initMainWindow();

	void checkSCXMLFile(QString filename)	throw (AbortException);

	QString parseSCXMLTree()					throw (AbortException);

	///@{ Attributes 

	/// Application's name
	QString name;

	/// Actual state machine
	 QStateMachine machine;

	 ///  main window
	 MainWindow * mainWindow;

 	/// XML tree containing infos
	QDomDocument scxmlDoc;

	/// Map of action state to build transitions
	QMap<QString, ActionState *> * statesMap;

	/// Final State
	QFinalState * theEnd;

	/// Where to save all files
	QDir saveDirectory;

	/// To get track of the Action State Machine the duration
	QTime * startTime;

	/// Log stream to write report on logFile
	QTextStream * logStream;

	/// Log file
	QFile * logFile;


	 ///@}

private:
	///@{ Tool methods used in parseSCXMLTree()

	void createAllActionStates(QDomNodeList nodeList)	throw (AbortException);

	void createTransitions(QDomNodeList nodeList) throw(AbortException);

	void setCamiTKAction(ActionState * actionState, QDomElement actionElement) throw (AbortException);

	void setCamiTKSaveAction(SaveActionState * actionState, QDomElement actionElement) throw(AbortException);

	QVector<Action::ApplyStatus> stringToStatus(QString listOfStatus);
	///@}
};

#endif // ACTIONSTATEMACHINE_H
