/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file mml2Csv
 * @brief Create a csv with monitors at the end of a mml output
 * @author Johan Sarrazin
 * @date November 27 2012
 */


#include "mml2Csv.h"

#include <sys/types.h>
#include <dirent.h>
#include <math.h>
#include <list>
#include <qvarlengtharray.h>
#include <fstream>

#include "MonitorOut.hxx"

//------------------------ Constructor ------------------------------------------------------------
mml2Csv::mml2Csv(string saveFile, list<dataMonitoredList> values, list<string> filesMML)
{
    this->valuesMonitored = values;
    //Lists cannot be empty at this stage
    //For each mml file, Insert retrieved data in the map at the correct key (name of the monitor)
    list<string>::iterator itf;
    for (itf=filesMML.begin(); itf!=filesMML.end(); itf++) {
        //try to open and read the file
        ifstream fileMML((*itf).c_str() , ifstream::in);
        //Insert data in the correct monitor map from mapMonitors
        mmlOut = mml::monitoringOut(fileMML,xml_schema::flags::dont_validate);
        mml::MonitoringOut::time_sequence& ts(mmlOut->time());
        /**/
        mml::TimeStep::monitor_sequence monit;
        for (mml::MonitoringOut::time_iterator i(ts.begin());i != ts.end();++i)
            monit=(*i).monitor();
        /**/
        for (mml::TimeStep::monitor_iterator it(monit.begin());it != monit.end();++it) {
            vector<double> nl;
            nl.clear();
            // add data if exist
            if ((&(*it))->data().present()) {
                std::string s=(&(*it))->data().get();
                istringstream iss (s,istringstream::in);
                while (true) {
                    double d;
                    iss >> d;
                    if ( iss.eof() ) break;
                    nl.push_back(d);
                }
            }
            //check the type of monitors and add in the good list
            addDataToList((*it).type(),nl);
        }
        //close the file
        fileMML.close();
    }
    //write the CSV file
    writeCSV(saveFile, valuesMonitored);
}


// ----------------- Destructor ---------------
mml2Csv::~mml2Csv() {
}


//------------addDataToList---------------------------------------------
void mml2Csv::addDataToList(string typeMonitor, std::vector< double > data)
{
    bool found = false;
    list<dataMonitoredList>:: iterator it;
    it=valuesMonitored.begin();
    while (it!=valuesMonitored.end() && !found) {
        if (it->getMonitorName().compare(typeMonitor)==0) {
            found=true;
            it->addResults(data);
	}
            it++;
    }
}

// --------------------------------------------- writeCSV ----------------------------------
void mml2Csv::writeCSV(string filename,list<dataMonitoredList> values)
{
    ofstream myFile;
    if (!filename.find_last_of(".csv")) {
        filename+=".csv";
    }
    // open the file to write
    char separator=',';
    myFile.open (const_cast<char*>(filename.c_str()));

    //Write the CSV
    list<dataMonitoredList>::iterator it;
    vector<double>::iterator it2;

    //write results for each monitor in line
    vector<double> temp;
    for (it=values.begin(); it!= values.end();it++) {
        myFile << (*it).getMonitorName() << separator;
	temp = (*it).getResultData();
        for (it2=temp.begin(); it2!=temp.end();it2++) {
            myFile << (*it2) << separator;
        }
        myFile<<endl;
    }
    // close after
    myFile.close();
}

