/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Component includes
#include "DicomTreeDirectoryComponent.h"
#include "DicomTreeStudyComponent.h"

// GDCM includes
#include <gdcmImageReader.h>
#include "vtkGDCMImageReader.h"
#include <gdcmAttribute.h>
#include <gdcmIPPSorter.h>
#include <gdcmScanner.h>

// Qt includes
#include <QDir>

// VTK includes
#include <vtkStringArray.h>


using namespace camitk;
using namespace gdcm;

// --------------- Constructor -------------------
DicomTreeDirectoryComponent::DicomTreeDirectoryComponent(const QString & path) throw(AbortException) : Component(path, QDir(path).dirName(), NO_REPRESENTATION) {
    // Recursively get all files in the input directory
    gdcm::Directory dir;
    dir.Load(path.toStdString().c_str(), true);
    const std::vector< std::string > & fileNames = dir.GetFilenames();

    // filter files per image and STUDY
    gdcm::Tag studyUIDTag = gdcm::Tag(0x0020,0x000d);
    // Note : we can put an observer for load bar
    gdcm::Scanner studyScanner;
    studyScanner.AddTag(studyUIDTag);
    studyScanner.Scan(fileNames);

    // retrieve all the studies results
    const std::set< std::string > studyValues = studyScanner.GetValues();

    // for each value, build a new DicomStudyComponent given the associated study filenames
    foreach(std::string value, studyValues) {
        // std::cout << "FOUND STUDY " << value << std::endl;
        // get study associated filenames
        std::vector< std::string > studyFileNames = studyScanner.GetAllFilenamesFromTagToValue(studyUIDTag, value.c_str());
        // create a new DicomStudyComponent as sub component
        this->addChild(new DicomTreeStudyComponent(studyFileNames));

    }
}

// --------------- destructor -------------------
DicomTreeDirectoryComponent::~DicomTreeDirectoryComponent() {

}









