

#include "SimulationTabs.h"

#include <QString>
#include <QMessageBox>
#include <QTextStream>
#include <Application.h>
#include <QFrame>
#include <MonitoringDialog.h>
#include <MonitoringGuiManager.h>
#include <Log.h>


using namespace camitk;


// --------------- Constructor -------------------
SimulationTabs::SimulationTabs(ActionExtension * extension) : Action(extension) {
    // Setting name, description and input component
    setName("SimulationTabs");
    setDescription("Display tabs for simulation");
    setComponent("MMLComponent");

    // Setting classification family and tags
    setFamily("Modeling");
}
QWidget* SimulationTabs::getWidget() {

    MMLComponent * input = dynamic_cast<MMLComponent *> (getTargets().last());
    QWidget * widget;

    if( input ) {
        widget = input->getMonitoringGuiManager()->getDialog();
    } else {
        CAMITK_ERROR("SimulationTabs", "getWidget", "NULL widget");
        widget = NULL;
    }

    return widget;
}
// --------------- destructor -------------------
SimulationTabs::~SimulationTabs() {

}
// --------------- apply -------------------
Action::ApplyStatus SimulationTabs::apply() {

    return SUCCESS;
}


