/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Local
#include "DisplayFrame.h"

// CamiTK
#include <InteractiveViewer.h>
#include <Component.h>
#include <Property.h>

// vtk
#include <vtkAxesActor.h>

using namespace camitk;

// --------------- constructor -------------------
DisplayFrame::DisplayFrame(ActionExtension* extension) : Action(extension) {
    setName("Display Component Frame");
    setDescription(tr("This action allows to display/hide a component frame's axes."));
    setComponent("Component");

    // Setting classification family and tags
    setFamily("Frame");
    addTag(tr("Test"));
    addTag(tr("Display"));
    addTag(tr("Visualization"));

    Property * viewFrame = new Property("Display Component's Frame", false, tr("Display or not the local Component's Frame Axes in the 3D viewer"), "");
    addParameter(viewFrame);

    Property * frameSize = new Property("Scale Frame Axes", QVariant(1.0), tr("Axes size"), "viewer unit");
    addParameter(frameSize);

}


// --------------- destructor -------------------
DisplayFrame::~DisplayFrame() {
}

//--------------- apply ------------
Action::ApplyStatus DisplayFrame::apply() {
    bool view = property("Display Component's Frame").toBool();
    double size = property("Scale Frame Axes").toDouble();

    Component * inputComp = dynamic_cast<Component *> (getTargets().last());

    if (inputComp != NULL) {
        inputComp->setFrameVisibility(InteractiveViewer::get3DViewer(), view);
        inputComp->getFrameAxisActor()->SetTotalLength(size, size, size);

        // Refresh all the used viewers
        InteractiveViewer::get3DViewer()->refresh();

        return SUCCESS;
    }

    return ABORTED;
}
