/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MESH_DATA_MODEL_H
#define MESH_DATA_MODEL_H

#include <QAbstractTableModel>

namespace camitk {

class MeshComponent;

/**
 * Qt model for mesh data.
 * This class use the Qt model/view design
 */
class MeshDataModel : public QAbstractTableModel {

    Q_OBJECT

public :

    /**
     * @brief Constructor
     */
    MeshDataModel ( MeshComponent* meshComp );

    /**
     * @brief Number of data arrays
     */
    int rowCount ( const QModelIndex &parent = QModelIndex() ) const ;

    /**
     * @brief Number of data arrays columns
     */
    int columnCount ( const QModelIndex &parent = QModelIndex() ) const;

    /**
     * @brief Model data
     */
    QVariant data ( const QModelIndex &index, int role = Qt::DisplayRole ) const;

    /**
     * @brief Header data
     */
    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

    /**
     * @brief Refresh the model
     */
    void refresh();

private :

    MeshComponent* meshComponent; /// The component where the data are stored

};

}

#endif