/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef SIMULATOR_INTERACTIVESIMULATOR_H
#define SIMULATOR_INTERACTIVESIMULATOR_H
// Simulator includes
#include "Simulator.h"
/**
 *
 * @ingroup group_cepmodeling_libraries_mml
 *
 * @brief
 * An interactive simulator is a simulator that we can control step by step (ex: Sofa)
 */
class MML_API InteractiveSimulator: public Simulator {
public:
    /// constructor
    InteractiveSimulator(MonitoringManager* monitoringManager);
    /// constructor
    InteractiveSimulator(MonitoringManager* monitoringManager,const char* file);
    /// destructor
    virtual ~InteractiveSimulator();

    /// initialize the simulator
    virtual void init() = 0;
    /// end simultor
    virtual void end() = 0;
    /// get current position for one atom
    virtual void getPosition(int index, double position[3])=0;

    /**
     * ask the simulator do to one step of the simulation
     * @param dt integration step
     */
    virtual void doMove(double dt) = 0;

    /// Create a pml file from an imput file
    virtual void createPml(const char* inputFile,const char* pmlFile)=0;
};

#endif // SIMULATOR_INTERACTIVESIMULATOR_H
