/*------------------------ MIT License HEADER ------------------------------------
    Copyright ANSSI (2013-2015)
    Contributors : Ryad BENADJILA [ryad.benadjila@ssi.gouv.fr],
    Thomas CALDERON [thomas.calderon@ssi.gouv.fr]
    Marion DAUBIGNARD [marion.daubignard@ssi.gouv.fr]

    This software is a computer program whose purpose is to implement
    a PKCS#11 proxy as well as a PKCS#11 filter with security features
    in mind. The project source tree is subdivided in six parts.
    There are five main parts:
      1] OCaml/C PKCS#11 bindings (using OCaml IDL).
      2] XDR RPC generators (to be used with ocamlrpcgen and/or rpcgen).
      3] A PKCS#11 RPC server (daemon) in OCaml using a Netplex RPC basis.
      4] A PKCS#11 filtering module used as a backend to the RPC server.
      5] A PKCS#11 client module that comes as a dynamic library offering
         the PKCS#11 API to the software.
    There is one "optional" part:
      6] Tests in C and OCaml to be used with client module 5] or with the
         bindings 1]

    Here is a big picture of how the PKCS#11 proxy works:

 ----------------------   --------  socket (TCP or Unix)  --------------------
| 3] PKCS#11 RPC server|-|2] RPC  |<+++++++++++++++++++> | 5] Client library  |
 ----------------------  |  Layer | [SSL/TLS optional]   |  --------          |
           |              --------                       | |2] RPC  | PKCS#11 |
 ----------------------                                  | |  Layer |functions|
| 4] PKCS#11 filter    |                                 |  --------          |
 ----------------------                                   --------------------
           |                                                        |
 ----------------------                                             |
| 1] PKCS#11 OCaml     |                                  { PKCS#11 INTERFACE }
|       bindings       |                                            |
 ----------------------                                       APPLICATION
           |
           |
 { PKCS#11 INTERFACE }
           |
 REAL PKCS#11 MIDDLEWARE
    (shared library)

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

    Except as contained in this notice, the name(s) of the above copyright holders
    shall not be used in advertising or otherwise to promote the sale, use or other
    dealings in this Software without prior written authorization.

    The current source code is part of the bindings 1] source tree:
 ----------------------
| 1] PKCS#11 OCaml     |
|       bindings       |
 ----------------------
           |
           |
 { PKCS#11 INTERFACE }
           |
  REAL PKCS#11 MIDDLEWARE
     (shared library)

    Project: PKCS#11 Filtering Proxy
    File:    src/bindings-pkcs11/PRESENT_tables.h

-------------------------- MIT License HEADER ----------------------------------*/
unsigned long long T0_PRESENT[256] = {0x0003000300000000, 0x0002000300000001, 0x0002000300010000, 0x0003000200010001, 0x0003000200000001, 0x0002000200000000, 0x0003000200010000, 0x0003000300000001, 0x0002000200010001, 0x0003000300010000, 0x0003000300010001, 0x0003000200000000, 0x0002000300000000, 0x0002000300010001, 0x0002000200000001, 0x0002000200010000, 0x0001000300000002, 0x0000000300000003, 0x0000000300010002, 0x0001000200010003, 0x0001000200000003, 0x0000000200000002, 0x0001000200010002, 0x0001000300000003, 0x0000000200010003, 0x0001000300010002, 0x0001000300010003, 0x0001000200000002, 0x0000000300000002, 0x0000000300010003, 0x0000000200000003, 0x0000000200010002, 0x0001000300020000, 0x0000000300020001, 0x0000000300030000, 0x0001000200030001, 0x0001000200020001, 0x0000000200020000, 0x0001000200030000, 0x0001000300020001, 0x0000000200030001, 0x0001000300030000, 0x0001000300030001, 0x0001000200020000, 0x0000000300020000, 0x0000000300030001, 0x0000000200020001, 0x0000000200030000, 0x0003000100020002, 0x0002000100020003, 0x0002000100030002, 0x0003000000030003, 0x0003000000020003, 0x0002000000020002, 0x0003000000030002, 0x0003000100020003, 0x0002000000030003, 0x0003000100030002, 0x0003000100030003, 0x0003000000020002, 0x0002000100020002, 0x0002000100030003, 0x0002000000020003, 0x0002000000030002, 0x0003000100000002, 0x0002000100000003, 0x0002000100010002, 0x0003000000010003, 0x0003000000000003, 0x0002000000000002, 0x0003000000010002, 0x0003000100000003, 0x0002000000010003, 0x0003000100010002, 0x0003000100010003, 0x0003000000000002, 0x0002000100000002, 0x0002000100010003, 0x0002000000000003, 0x0002000000010002, 0x0001000100000000, 0x0000000100000001, 0x0000000100010000, 0x0001000000010001, 0x0001000000000001, 0x0000000000000000, 0x0001000000010000, 0x0001000100000001, 0x0000000000010001, 0x0001000100010000, 0x0001000100010001, 0x0001000000000000, 0x0000000100000000, 0x0000000100010001, 0x0000000000000001, 0x0000000000010000, 0x0003000100020000, 0x0002000100020001, 0x0002000100030000, 0x0003000000030001, 0x0003000000020001, 0x0002000000020000, 0x0003000000030000, 0x0003000100020001, 0x0002000000030001, 0x0003000100030000, 0x0003000100030001, 0x0003000000020000, 0x0002000100020000, 0x0002000100030001, 0x0002000000020001, 0x0002000000030000, 0x0003000300000002, 0x0002000300000003, 0x0002000300010002, 0x0003000200010003, 0x0003000200000003, 0x0002000200000002, 0x0003000200010002, 0x0003000300000003, 0x0002000200010003, 0x0003000300010002, 0x0003000300010003, 0x0003000200000002, 0x0002000300000002, 0x0002000300010003, 0x0002000200000003, 0x0002000200010002, 0x0001000100020002, 0x0000000100020003, 0x0000000100030002, 0x0001000000030003, 0x0001000000020003, 0x0000000000020002, 0x0001000000030002, 0x0001000100020003, 0x0000000000030003, 0x0001000100030002, 0x0001000100030003, 0x0001000000020002, 0x0000000100020002, 0x0000000100030003, 0x0000000000020003, 0x0000000000030002, 0x0003000300020000, 0x0002000300020001, 0x0002000300030000, 0x0003000200030001, 0x0003000200020001, 0x0002000200020000, 0x0003000200030000, 0x0003000300020001, 0x0002000200030001, 0x0003000300030000, 0x0003000300030001, 0x0003000200020000, 0x0002000300020000, 0x0002000300030001, 0x0002000200020001, 0x0002000200030000, 0x0003000300020002, 0x0002000300020003, 0x0002000300030002, 0x0003000200030003, 0x0003000200020003, 0x0002000200020002, 0x0003000200030002, 0x0003000300020003, 0x0002000200030003, 0x0003000300030002, 0x0003000300030003, 0x0003000200020002, 0x0002000300020002, 0x0002000300030003, 0x0002000200020003, 0x0002000200030002, 0x0003000100000000, 0x0002000100000001, 0x0002000100010000, 0x0003000000010001, 0x0003000000000001, 0x0002000000000000, 0x0003000000010000, 0x0003000100000001, 0x0002000000010001, 0x0003000100010000, 0x0003000100010001, 0x0003000000000000, 0x0002000100000000, 0x0002000100010001, 0x0002000000000001, 0x0002000000010000, 0x0001000300000000, 0x0000000300000001, 0x0000000300010000, 0x0001000200010001, 0x0001000200000001, 0x0000000200000000, 0x0001000200010000, 0x0001000300000001, 0x0000000200010001, 0x0001000300010000, 0x0001000300010001, 0x0001000200000000, 0x0000000300000000, 0x0000000300010001, 0x0000000200000001, 0x0000000200010000, 0x0001000300020002, 0x0000000300020003, 0x0000000300030002, 0x0001000200030003, 0x0001000200020003, 0x0000000200020002, 0x0001000200030002, 0x0001000300020003, 0x0000000200030003, 0x0001000300030002, 0x0001000300030003, 0x0001000200020002, 0x0000000300020002, 0x0000000300030003, 0x0000000200020003, 0x0000000200030002, 0x0001000100000002, 0x0000000100000003, 0x0000000100010002, 0x0001000000010003, 0x0001000000000003, 0x0000000000000002, 0x0001000000010002, 0x0001000100000003, 0x0000000000010003, 0x0001000100010002, 0x0001000100010003, 0x0001000000000002, 0x0000000100000002, 0x0000000100010003, 0x0000000000000003, 0x0000000000010002, 0x0001000100020000, 0x0000000100020001, 0x0000000100030000, 0x0001000000030001, 0x0001000000020001, 0x0000000000020000, 0x0001000000030000, 0x0001000100020001, 0x0000000000030001, 0x0001000100030000, 0x0001000100030001, 0x0001000000020000, 0x0000000100020000, 0x0000000100030001, 0x0000000000020001, 0x0000000000030000};

unsigned long long T1_PRESENT[256] = {0x000c000c00000000, 0x0008000c00000004, 0x0008000c00040000, 0x000c000800040004, 0x000c000800000004, 0x0008000800000000, 0x000c000800040000, 0x000c000c00000004, 0x0008000800040004, 0x000c000c00040000, 0x000c000c00040004, 0x000c000800000000, 0x0008000c00000000, 0x0008000c00040004, 0x0008000800000004, 0x0008000800040000, 0x0004000c00000008, 0x0000000c0000000c, 0x0000000c00040008, 0x000400080004000c, 0x000400080000000c, 0x0000000800000008, 0x0004000800040008, 0x0004000c0000000c, 0x000000080004000c, 0x0004000c00040008, 0x0004000c0004000c, 0x0004000800000008, 0x0000000c00000008, 0x0000000c0004000c, 0x000000080000000c, 0x0000000800040008, 0x0004000c00080000, 0x0000000c00080004, 0x0000000c000c0000, 0x00040008000c0004, 0x0004000800080004, 0x0000000800080000, 0x00040008000c0000, 0x0004000c00080004, 0x00000008000c0004, 0x0004000c000c0000, 0x0004000c000c0004, 0x0004000800080000, 0x0000000c00080000, 0x0000000c000c0004, 0x0000000800080004, 0x00000008000c0000, 0x000c000400080008, 0x000800040008000c, 0x00080004000c0008, 0x000c0000000c000c, 0x000c00000008000c, 0x0008000000080008, 0x000c0000000c0008, 0x000c00040008000c, 0x00080000000c000c, 0x000c0004000c0008, 0x000c0004000c000c, 0x000c000000080008, 0x0008000400080008, 0x00080004000c000c, 0x000800000008000c, 0x00080000000c0008, 0x000c000400000008, 0x000800040000000c, 0x0008000400040008, 0x000c00000004000c, 0x000c00000000000c, 0x0008000000000008, 0x000c000000040008, 0x000c00040000000c, 0x000800000004000c, 0x000c000400040008, 0x000c00040004000c, 0x000c000000000008, 0x0008000400000008, 0x000800040004000c, 0x000800000000000c, 0x0008000000040008, 0x0004000400000000, 0x0000000400000004, 0x0000000400040000, 0x0004000000040004, 0x0004000000000004, 0x0000000000000000, 0x0004000000040000, 0x0004000400000004, 0x0000000000040004, 0x0004000400040000, 0x0004000400040004, 0x0004000000000000, 0x0000000400000000, 0x0000000400040004, 0x0000000000000004, 0x0000000000040000, 0x000c000400080000, 0x0008000400080004, 0x00080004000c0000, 0x000c0000000c0004, 0x000c000000080004, 0x0008000000080000, 0x000c0000000c0000, 0x000c000400080004, 0x00080000000c0004, 0x000c0004000c0000, 0x000c0004000c0004, 0x000c000000080000, 0x0008000400080000, 0x00080004000c0004, 0x0008000000080004, 0x00080000000c0000, 0x000c000c00000008, 0x0008000c0000000c, 0x0008000c00040008, 0x000c00080004000c, 0x000c00080000000c, 0x0008000800000008, 0x000c000800040008, 0x000c000c0000000c, 0x000800080004000c, 0x000c000c00040008, 0x000c000c0004000c, 0x000c000800000008, 0x0008000c00000008, 0x0008000c0004000c, 0x000800080000000c, 0x0008000800040008, 0x0004000400080008, 0x000000040008000c, 0x00000004000c0008, 0x00040000000c000c, 0x000400000008000c, 0x0000000000080008, 0x00040000000c0008, 0x000400040008000c, 0x00000000000c000c, 0x00040004000c0008, 0x00040004000c000c, 0x0004000000080008, 0x0000000400080008, 0x00000004000c000c, 0x000000000008000c, 0x00000000000c0008, 0x000c000c00080000, 0x0008000c00080004, 0x0008000c000c0000, 0x000c0008000c0004, 0x000c000800080004, 0x0008000800080000, 0x000c0008000c0000, 0x000c000c00080004, 0x00080008000c0004, 0x000c000c000c0000, 0x000c000c000c0004, 0x000c000800080000, 0x0008000c00080000, 0x0008000c000c0004, 0x0008000800080004, 0x00080008000c0000, 0x000c000c00080008, 0x0008000c0008000c, 0x0008000c000c0008, 0x000c0008000c000c, 0x000c00080008000c, 0x0008000800080008, 0x000c0008000c0008, 0x000c000c0008000c, 0x00080008000c000c, 0x000c000c000c0008, 0x000c000c000c000c, 0x000c000800080008, 0x0008000c00080008, 0x0008000c000c000c, 0x000800080008000c, 0x00080008000c0008, 0x000c000400000000, 0x0008000400000004, 0x0008000400040000, 0x000c000000040004, 0x000c000000000004, 0x0008000000000000, 0x000c000000040000, 0x000c000400000004, 0x0008000000040004, 0x000c000400040000, 0x000c000400040004, 0x000c000000000000, 0x0008000400000000, 0x0008000400040004, 0x0008000000000004, 0x0008000000040000, 0x0004000c00000000, 0x0000000c00000004, 0x0000000c00040000, 0x0004000800040004, 0x0004000800000004, 0x0000000800000000, 0x0004000800040000, 0x0004000c00000004, 0x0000000800040004, 0x0004000c00040000, 0x0004000c00040004, 0x0004000800000000, 0x0000000c00000000, 0x0000000c00040004, 0x0000000800000004, 0x0000000800040000, 0x0004000c00080008, 0x0000000c0008000c, 0x0000000c000c0008, 0x00040008000c000c, 0x000400080008000c, 0x0000000800080008, 0x00040008000c0008, 0x0004000c0008000c, 0x00000008000c000c, 0x0004000c000c0008, 0x0004000c000c000c, 0x0004000800080008, 0x0000000c00080008, 0x0000000c000c000c, 0x000000080008000c, 0x00000008000c0008, 0x0004000400000008, 0x000000040000000c, 0x0000000400040008, 0x000400000004000c, 0x000400000000000c, 0x0000000000000008, 0x0004000000040008, 0x000400040000000c, 0x000000000004000c, 0x0004000400040008, 0x000400040004000c, 0x0004000000000008, 0x0000000400000008, 0x000000040004000c, 0x000000000000000c, 0x0000000000040008, 0x0004000400080000, 0x0000000400080004, 0x00000004000c0000, 0x00040000000c0004, 0x0004000000080004, 0x0000000000080000, 0x00040000000c0000, 0x0004000400080004, 0x00000000000c0004, 0x00040004000c0000, 0x00040004000c0004, 0x0004000000080000, 0x0000000400080000, 0x00000004000c0004, 0x0000000000080004, 0x00000000000c0000};

unsigned long long T2_PRESENT[256] = {0x0030003000000000, 0x0020003000000010, 0x0020003000100000, 0x0030002000100010, 0x0030002000000010, 0x0020002000000000, 0x0030002000100000, 0x0030003000000010, 0x0020002000100010, 0x0030003000100000, 0x0030003000100010, 0x0030002000000000, 0x0020003000000000, 0x0020003000100010, 0x0020002000000010, 0x0020002000100000, 0x0010003000000020, 0x0000003000000030, 0x0000003000100020, 0x0010002000100030, 0x0010002000000030, 0x0000002000000020, 0x0010002000100020, 0x0010003000000030, 0x0000002000100030, 0x0010003000100020, 0x0010003000100030, 0x0010002000000020, 0x0000003000000020, 0x0000003000100030, 0x0000002000000030, 0x0000002000100020, 0x0010003000200000, 0x0000003000200010, 0x0000003000300000, 0x0010002000300010, 0x0010002000200010, 0x0000002000200000, 0x0010002000300000, 0x0010003000200010, 0x0000002000300010, 0x0010003000300000, 0x0010003000300010, 0x0010002000200000, 0x0000003000200000, 0x0000003000300010, 0x0000002000200010, 0x0000002000300000, 0x0030001000200020, 0x0020001000200030, 0x0020001000300020, 0x0030000000300030, 0x0030000000200030, 0x0020000000200020, 0x0030000000300020, 0x0030001000200030, 0x0020000000300030, 0x0030001000300020, 0x0030001000300030, 0x0030000000200020, 0x0020001000200020, 0x0020001000300030, 0x0020000000200030, 0x0020000000300020, 0x0030001000000020, 0x0020001000000030, 0x0020001000100020, 0x0030000000100030, 0x0030000000000030, 0x0020000000000020, 0x0030000000100020, 0x0030001000000030, 0x0020000000100030, 0x0030001000100020, 0x0030001000100030, 0x0030000000000020, 0x0020001000000020, 0x0020001000100030, 0x0020000000000030, 0x0020000000100020, 0x0010001000000000, 0x0000001000000010, 0x0000001000100000, 0x0010000000100010, 0x0010000000000010, 0x0000000000000000, 0x0010000000100000, 0x0010001000000010, 0x0000000000100010, 0x0010001000100000, 0x0010001000100010, 0x0010000000000000, 0x0000001000000000, 0x0000001000100010, 0x0000000000000010, 0x0000000000100000, 0x0030001000200000, 0x0020001000200010, 0x0020001000300000, 0x0030000000300010, 0x0030000000200010, 0x0020000000200000, 0x0030000000300000, 0x0030001000200010, 0x0020000000300010, 0x0030001000300000, 0x0030001000300010, 0x0030000000200000, 0x0020001000200000, 0x0020001000300010, 0x0020000000200010, 0x0020000000300000, 0x0030003000000020, 0x0020003000000030, 0x0020003000100020, 0x0030002000100030, 0x0030002000000030, 0x0020002000000020, 0x0030002000100020, 0x0030003000000030, 0x0020002000100030, 0x0030003000100020, 0x0030003000100030, 0x0030002000000020, 0x0020003000000020, 0x0020003000100030, 0x0020002000000030, 0x0020002000100020, 0x0010001000200020, 0x0000001000200030, 0x0000001000300020, 0x0010000000300030, 0x0010000000200030, 0x0000000000200020, 0x0010000000300020, 0x0010001000200030, 0x0000000000300030, 0x0010001000300020, 0x0010001000300030, 0x0010000000200020, 0x0000001000200020, 0x0000001000300030, 0x0000000000200030, 0x0000000000300020, 0x0030003000200000, 0x0020003000200010, 0x0020003000300000, 0x0030002000300010, 0x0030002000200010, 0x0020002000200000, 0x0030002000300000, 0x0030003000200010, 0x0020002000300010, 0x0030003000300000, 0x0030003000300010, 0x0030002000200000, 0x0020003000200000, 0x0020003000300010, 0x0020002000200010, 0x0020002000300000, 0x0030003000200020, 0x0020003000200030, 0x0020003000300020, 0x0030002000300030, 0x0030002000200030, 0x0020002000200020, 0x0030002000300020, 0x0030003000200030, 0x0020002000300030, 0x0030003000300020, 0x0030003000300030, 0x0030002000200020, 0x0020003000200020, 0x0020003000300030, 0x0020002000200030, 0x0020002000300020, 0x0030001000000000, 0x0020001000000010, 0x0020001000100000, 0x0030000000100010, 0x0030000000000010, 0x0020000000000000, 0x0030000000100000, 0x0030001000000010, 0x0020000000100010, 0x0030001000100000, 0x0030001000100010, 0x0030000000000000, 0x0020001000000000, 0x0020001000100010, 0x0020000000000010, 0x0020000000100000, 0x0010003000000000, 0x0000003000000010, 0x0000003000100000, 0x0010002000100010, 0x0010002000000010, 0x0000002000000000, 0x0010002000100000, 0x0010003000000010, 0x0000002000100010, 0x0010003000100000, 0x0010003000100010, 0x0010002000000000, 0x0000003000000000, 0x0000003000100010, 0x0000002000000010, 0x0000002000100000, 0x0010003000200020, 0x0000003000200030, 0x0000003000300020, 0x0010002000300030, 0x0010002000200030, 0x0000002000200020, 0x0010002000300020, 0x0010003000200030, 0x0000002000300030, 0x0010003000300020, 0x0010003000300030, 0x0010002000200020, 0x0000003000200020, 0x0000003000300030, 0x0000002000200030, 0x0000002000300020, 0x0010001000000020, 0x0000001000000030, 0x0000001000100020, 0x0010000000100030, 0x0010000000000030, 0x0000000000000020, 0x0010000000100020, 0x0010001000000030, 0x0000000000100030, 0x0010001000100020, 0x0010001000100030, 0x0010000000000020, 0x0000001000000020, 0x0000001000100030, 0x0000000000000030, 0x0000000000100020, 0x0010001000200000, 0x0000001000200010, 0x0000001000300000, 0x0010000000300010, 0x0010000000200010, 0x0000000000200000, 0x0010000000300000, 0x0010001000200010, 0x0000000000300010, 0x0010001000300000, 0x0010001000300010, 0x0010000000200000, 0x0000001000200000, 0x0000001000300010, 0x0000000000200010, 0x0000000000300000};

unsigned long long T3_PRESENT[256] = {0x00c000c000000000, 0x008000c000000040, 0x008000c000400000, 0x00c0008000400040, 0x00c0008000000040, 0x0080008000000000, 0x00c0008000400000, 0x00c000c000000040, 0x0080008000400040, 0x00c000c000400000, 0x00c000c000400040, 0x00c0008000000000, 0x008000c000000000, 0x008000c000400040, 0x0080008000000040, 0x0080008000400000, 0x004000c000000080, 0x000000c0000000c0, 0x000000c000400080, 0x00400080004000c0, 0x00400080000000c0, 0x0000008000000080, 0x0040008000400080, 0x004000c0000000c0, 0x00000080004000c0, 0x004000c000400080, 0x004000c0004000c0, 0x0040008000000080, 0x000000c000000080, 0x000000c0004000c0, 0x00000080000000c0, 0x0000008000400080, 0x004000c000800000, 0x000000c000800040, 0x000000c000c00000, 0x0040008000c00040, 0x0040008000800040, 0x0000008000800000, 0x0040008000c00000, 0x004000c000800040, 0x0000008000c00040, 0x004000c000c00000, 0x004000c000c00040, 0x0040008000800000, 0x000000c000800000, 0x000000c000c00040, 0x0000008000800040, 0x0000008000c00000, 0x00c0004000800080, 0x00800040008000c0, 0x0080004000c00080, 0x00c0000000c000c0, 0x00c00000008000c0, 0x0080000000800080, 0x00c0000000c00080, 0x00c00040008000c0, 0x0080000000c000c0, 0x00c0004000c00080, 0x00c0004000c000c0, 0x00c0000000800080, 0x0080004000800080, 0x0080004000c000c0, 0x00800000008000c0, 0x0080000000c00080, 0x00c0004000000080, 0x00800040000000c0, 0x0080004000400080, 0x00c00000004000c0, 0x00c00000000000c0, 0x0080000000000080, 0x00c0000000400080, 0x00c00040000000c0, 0x00800000004000c0, 0x00c0004000400080, 0x00c00040004000c0, 0x00c0000000000080, 0x0080004000000080, 0x00800040004000c0, 0x00800000000000c0, 0x0080000000400080, 0x0040004000000000, 0x0000004000000040, 0x0000004000400000, 0x0040000000400040, 0x0040000000000040, 0x0000000000000000, 0x0040000000400000, 0x0040004000000040, 0x0000000000400040, 0x0040004000400000, 0x0040004000400040, 0x0040000000000000, 0x0000004000000000, 0x0000004000400040, 0x0000000000000040, 0x0000000000400000, 0x00c0004000800000, 0x0080004000800040, 0x0080004000c00000, 0x00c0000000c00040, 0x00c0000000800040, 0x0080000000800000, 0x00c0000000c00000, 0x00c0004000800040, 0x0080000000c00040, 0x00c0004000c00000, 0x00c0004000c00040, 0x00c0000000800000, 0x0080004000800000, 0x0080004000c00040, 0x0080000000800040, 0x0080000000c00000, 0x00c000c000000080, 0x008000c0000000c0, 0x008000c000400080, 0x00c00080004000c0, 0x00c00080000000c0, 0x0080008000000080, 0x00c0008000400080, 0x00c000c0000000c0, 0x00800080004000c0, 0x00c000c000400080, 0x00c000c0004000c0, 0x00c0008000000080, 0x008000c000000080, 0x008000c0004000c0, 0x00800080000000c0, 0x0080008000400080, 0x0040004000800080, 0x00000040008000c0, 0x0000004000c00080, 0x0040000000c000c0, 0x00400000008000c0, 0x0000000000800080, 0x0040000000c00080, 0x00400040008000c0, 0x0000000000c000c0, 0x0040004000c00080, 0x0040004000c000c0, 0x0040000000800080, 0x0000004000800080, 0x0000004000c000c0, 0x00000000008000c0, 0x0000000000c00080, 0x00c000c000800000, 0x008000c000800040, 0x008000c000c00000, 0x00c0008000c00040, 0x00c0008000800040, 0x0080008000800000, 0x00c0008000c00000, 0x00c000c000800040, 0x0080008000c00040, 0x00c000c000c00000, 0x00c000c000c00040, 0x00c0008000800000, 0x008000c000800000, 0x008000c000c00040, 0x0080008000800040, 0x0080008000c00000, 0x00c000c000800080, 0x008000c0008000c0, 0x008000c000c00080, 0x00c0008000c000c0, 0x00c00080008000c0, 0x0080008000800080, 0x00c0008000c00080, 0x00c000c0008000c0, 0x0080008000c000c0, 0x00c000c000c00080, 0x00c000c000c000c0, 0x00c0008000800080, 0x008000c000800080, 0x008000c000c000c0, 0x00800080008000c0, 0x0080008000c00080, 0x00c0004000000000, 0x0080004000000040, 0x0080004000400000, 0x00c0000000400040, 0x00c0000000000040, 0x0080000000000000, 0x00c0000000400000, 0x00c0004000000040, 0x0080000000400040, 0x00c0004000400000, 0x00c0004000400040, 0x00c0000000000000, 0x0080004000000000, 0x0080004000400040, 0x0080000000000040, 0x0080000000400000, 0x004000c000000000, 0x000000c000000040, 0x000000c000400000, 0x0040008000400040, 0x0040008000000040, 0x0000008000000000, 0x0040008000400000, 0x004000c000000040, 0x0000008000400040, 0x004000c000400000, 0x004000c000400040, 0x0040008000000000, 0x000000c000000000, 0x000000c000400040, 0x0000008000000040, 0x0000008000400000, 0x004000c000800080, 0x000000c0008000c0, 0x000000c000c00080, 0x0040008000c000c0, 0x00400080008000c0, 0x0000008000800080, 0x0040008000c00080, 0x004000c0008000c0, 0x0000008000c000c0, 0x004000c000c00080, 0x004000c000c000c0, 0x0040008000800080, 0x000000c000800080, 0x000000c000c000c0, 0x00000080008000c0, 0x0000008000c00080, 0x0040004000000080, 0x00000040000000c0, 0x0000004000400080, 0x00400000004000c0, 0x00400000000000c0, 0x0000000000000080, 0x0040000000400080, 0x00400040000000c0, 0x00000000004000c0, 0x0040004000400080, 0x00400040004000c0, 0x0040000000000080, 0x0000004000000080, 0x00000040004000c0, 0x00000000000000c0, 0x0000000000400080, 0x0040004000800000, 0x0000004000800040, 0x0000004000c00000, 0x0040000000c00040, 0x0040000000800040, 0x0000000000800000, 0x0040000000c00000, 0x0040004000800040, 0x0000000000c00040, 0x0040004000c00000, 0x0040004000c00040, 0x0040000000800000, 0x0000004000800000, 0x0000004000c00040, 0x0000000000800040, 0x0000000000c00000};

unsigned long long T4_PRESENT[256] = {0x0300030000000000, 0x0200030000000100, 0x0200030001000000, 0x0300020001000100, 0x0300020000000100, 0x0200020000000000, 0x0300020001000000, 0x0300030000000100, 0x0200020001000100, 0x0300030001000000, 0x0300030001000100, 0x0300020000000000, 0x0200030000000000, 0x0200030001000100, 0x0200020000000100, 0x0200020001000000, 0x0100030000000200, 0x0000030000000300, 0x0000030001000200, 0x0100020001000300, 0x0100020000000300, 0x0000020000000200, 0x0100020001000200, 0x0100030000000300, 0x0000020001000300, 0x0100030001000200, 0x0100030001000300, 0x0100020000000200, 0x0000030000000200, 0x0000030001000300, 0x0000020000000300, 0x0000020001000200, 0x0100030002000000, 0x0000030002000100, 0x0000030003000000, 0x0100020003000100, 0x0100020002000100, 0x0000020002000000, 0x0100020003000000, 0x0100030002000100, 0x0000020003000100, 0x0100030003000000, 0x0100030003000100, 0x0100020002000000, 0x0000030002000000, 0x0000030003000100, 0x0000020002000100, 0x0000020003000000, 0x0300010002000200, 0x0200010002000300, 0x0200010003000200, 0x0300000003000300, 0x0300000002000300, 0x0200000002000200, 0x0300000003000200, 0x0300010002000300, 0x0200000003000300, 0x0300010003000200, 0x0300010003000300, 0x0300000002000200, 0x0200010002000200, 0x0200010003000300, 0x0200000002000300, 0x0200000003000200, 0x0300010000000200, 0x0200010000000300, 0x0200010001000200, 0x0300000001000300, 0x0300000000000300, 0x0200000000000200, 0x0300000001000200, 0x0300010000000300, 0x0200000001000300, 0x0300010001000200, 0x0300010001000300, 0x0300000000000200, 0x0200010000000200, 0x0200010001000300, 0x0200000000000300, 0x0200000001000200, 0x0100010000000000, 0x0000010000000100, 0x0000010001000000, 0x0100000001000100, 0x0100000000000100, 0x0000000000000000, 0x0100000001000000, 0x0100010000000100, 0x0000000001000100, 0x0100010001000000, 0x0100010001000100, 0x0100000000000000, 0x0000010000000000, 0x0000010001000100, 0x0000000000000100, 0x0000000001000000, 0x0300010002000000, 0x0200010002000100, 0x0200010003000000, 0x0300000003000100, 0x0300000002000100, 0x0200000002000000, 0x0300000003000000, 0x0300010002000100, 0x0200000003000100, 0x0300010003000000, 0x0300010003000100, 0x0300000002000000, 0x0200010002000000, 0x0200010003000100, 0x0200000002000100, 0x0200000003000000, 0x0300030000000200, 0x0200030000000300, 0x0200030001000200, 0x0300020001000300, 0x0300020000000300, 0x0200020000000200, 0x0300020001000200, 0x0300030000000300, 0x0200020001000300, 0x0300030001000200, 0x0300030001000300, 0x0300020000000200, 0x0200030000000200, 0x0200030001000300, 0x0200020000000300, 0x0200020001000200, 0x0100010002000200, 0x0000010002000300, 0x0000010003000200, 0x0100000003000300, 0x0100000002000300, 0x0000000002000200, 0x0100000003000200, 0x0100010002000300, 0x0000000003000300, 0x0100010003000200, 0x0100010003000300, 0x0100000002000200, 0x0000010002000200, 0x0000010003000300, 0x0000000002000300, 0x0000000003000200, 0x0300030002000000, 0x0200030002000100, 0x0200030003000000, 0x0300020003000100, 0x0300020002000100, 0x0200020002000000, 0x0300020003000000, 0x0300030002000100, 0x0200020003000100, 0x0300030003000000, 0x0300030003000100, 0x0300020002000000, 0x0200030002000000, 0x0200030003000100, 0x0200020002000100, 0x0200020003000000, 0x0300030002000200, 0x0200030002000300, 0x0200030003000200, 0x0300020003000300, 0x0300020002000300, 0x0200020002000200, 0x0300020003000200, 0x0300030002000300, 0x0200020003000300, 0x0300030003000200, 0x0300030003000300, 0x0300020002000200, 0x0200030002000200, 0x0200030003000300, 0x0200020002000300, 0x0200020003000200, 0x0300010000000000, 0x0200010000000100, 0x0200010001000000, 0x0300000001000100, 0x0300000000000100, 0x0200000000000000, 0x0300000001000000, 0x0300010000000100, 0x0200000001000100, 0x0300010001000000, 0x0300010001000100, 0x0300000000000000, 0x0200010000000000, 0x0200010001000100, 0x0200000000000100, 0x0200000001000000, 0x0100030000000000, 0x0000030000000100, 0x0000030001000000, 0x0100020001000100, 0x0100020000000100, 0x0000020000000000, 0x0100020001000000, 0x0100030000000100, 0x0000020001000100, 0x0100030001000000, 0x0100030001000100, 0x0100020000000000, 0x0000030000000000, 0x0000030001000100, 0x0000020000000100, 0x0000020001000000, 0x0100030002000200, 0x0000030002000300, 0x0000030003000200, 0x0100020003000300, 0x0100020002000300, 0x0000020002000200, 0x0100020003000200, 0x0100030002000300, 0x0000020003000300, 0x0100030003000200, 0x0100030003000300, 0x0100020002000200, 0x0000030002000200, 0x0000030003000300, 0x0000020002000300, 0x0000020003000200, 0x0100010000000200, 0x0000010000000300, 0x0000010001000200, 0x0100000001000300, 0x0100000000000300, 0x0000000000000200, 0x0100000001000200, 0x0100010000000300, 0x0000000001000300, 0x0100010001000200, 0x0100010001000300, 0x0100000000000200, 0x0000010000000200, 0x0000010001000300, 0x0000000000000300, 0x0000000001000200, 0x0100010002000000, 0x0000010002000100, 0x0000010003000000, 0x0100000003000100, 0x0100000002000100, 0x0000000002000000, 0x0100000003000000, 0x0100010002000100, 0x0000000003000100, 0x0100010003000000, 0x0100010003000100, 0x0100000002000000, 0x0000010002000000, 0x0000010003000100, 0x0000000002000100, 0x0000000003000000};

unsigned long long T5_PRESENT[256] = {0x0c000c0000000000, 0x08000c0000000400, 0x08000c0004000000, 0x0c00080004000400, 0x0c00080000000400, 0x0800080000000000, 0x0c00080004000000, 0x0c000c0000000400, 0x0800080004000400, 0x0c000c0004000000, 0x0c000c0004000400, 0x0c00080000000000, 0x08000c0000000000, 0x08000c0004000400, 0x0800080000000400, 0x0800080004000000, 0x04000c0000000800, 0x00000c0000000c00, 0x00000c0004000800, 0x0400080004000c00, 0x0400080000000c00, 0x0000080000000800, 0x0400080004000800, 0x04000c0000000c00, 0x0000080004000c00, 0x04000c0004000800, 0x04000c0004000c00, 0x0400080000000800, 0x00000c0000000800, 0x00000c0004000c00, 0x0000080000000c00, 0x0000080004000800, 0x04000c0008000000, 0x00000c0008000400, 0x00000c000c000000, 0x040008000c000400, 0x0400080008000400, 0x0000080008000000, 0x040008000c000000, 0x04000c0008000400, 0x000008000c000400, 0x04000c000c000000, 0x04000c000c000400, 0x0400080008000000, 0x00000c0008000000, 0x00000c000c000400, 0x0000080008000400, 0x000008000c000000, 0x0c00040008000800, 0x0800040008000c00, 0x080004000c000800, 0x0c0000000c000c00, 0x0c00000008000c00, 0x0800000008000800, 0x0c0000000c000800, 0x0c00040008000c00, 0x080000000c000c00, 0x0c0004000c000800, 0x0c0004000c000c00, 0x0c00000008000800, 0x0800040008000800, 0x080004000c000c00, 0x0800000008000c00, 0x080000000c000800, 0x0c00040000000800, 0x0800040000000c00, 0x0800040004000800, 0x0c00000004000c00, 0x0c00000000000c00, 0x0800000000000800, 0x0c00000004000800, 0x0c00040000000c00, 0x0800000004000c00, 0x0c00040004000800, 0x0c00040004000c00, 0x0c00000000000800, 0x0800040000000800, 0x0800040004000c00, 0x0800000000000c00, 0x0800000004000800, 0x0400040000000000, 0x0000040000000400, 0x0000040004000000, 0x0400000004000400, 0x0400000000000400, 0x0000000000000000, 0x0400000004000000, 0x0400040000000400, 0x0000000004000400, 0x0400040004000000, 0x0400040004000400, 0x0400000000000000, 0x0000040000000000, 0x0000040004000400, 0x0000000000000400, 0x0000000004000000, 0x0c00040008000000, 0x0800040008000400, 0x080004000c000000, 0x0c0000000c000400, 0x0c00000008000400, 0x0800000008000000, 0x0c0000000c000000, 0x0c00040008000400, 0x080000000c000400, 0x0c0004000c000000, 0x0c0004000c000400, 0x0c00000008000000, 0x0800040008000000, 0x080004000c000400, 0x0800000008000400, 0x080000000c000000, 0x0c000c0000000800, 0x08000c0000000c00, 0x08000c0004000800, 0x0c00080004000c00, 0x0c00080000000c00, 0x0800080000000800, 0x0c00080004000800, 0x0c000c0000000c00, 0x0800080004000c00, 0x0c000c0004000800, 0x0c000c0004000c00, 0x0c00080000000800, 0x08000c0000000800, 0x08000c0004000c00, 0x0800080000000c00, 0x0800080004000800, 0x0400040008000800, 0x0000040008000c00, 0x000004000c000800, 0x040000000c000c00, 0x0400000008000c00, 0x0000000008000800, 0x040000000c000800, 0x0400040008000c00, 0x000000000c000c00, 0x040004000c000800, 0x040004000c000c00, 0x0400000008000800, 0x0000040008000800, 0x000004000c000c00, 0x0000000008000c00, 0x000000000c000800, 0x0c000c0008000000, 0x08000c0008000400, 0x08000c000c000000, 0x0c0008000c000400, 0x0c00080008000400, 0x0800080008000000, 0x0c0008000c000000, 0x0c000c0008000400, 0x080008000c000400, 0x0c000c000c000000, 0x0c000c000c000400, 0x0c00080008000000, 0x08000c0008000000, 0x08000c000c000400, 0x0800080008000400, 0x080008000c000000, 0x0c000c0008000800, 0x08000c0008000c00, 0x08000c000c000800, 0x0c0008000c000c00, 0x0c00080008000c00, 0x0800080008000800, 0x0c0008000c000800, 0x0c000c0008000c00, 0x080008000c000c00, 0x0c000c000c000800, 0x0c000c000c000c00, 0x0c00080008000800, 0x08000c0008000800, 0x08000c000c000c00, 0x0800080008000c00, 0x080008000c000800, 0x0c00040000000000, 0x0800040000000400, 0x0800040004000000, 0x0c00000004000400, 0x0c00000000000400, 0x0800000000000000, 0x0c00000004000000, 0x0c00040000000400, 0x0800000004000400, 0x0c00040004000000, 0x0c00040004000400, 0x0c00000000000000, 0x0800040000000000, 0x0800040004000400, 0x0800000000000400, 0x0800000004000000, 0x04000c0000000000, 0x00000c0000000400, 0x00000c0004000000, 0x0400080004000400, 0x0400080000000400, 0x0000080000000000, 0x0400080004000000, 0x04000c0000000400, 0x0000080004000400, 0x04000c0004000000, 0x04000c0004000400, 0x0400080000000000, 0x00000c0000000000, 0x00000c0004000400, 0x0000080000000400, 0x0000080004000000, 0x04000c0008000800, 0x00000c0008000c00, 0x00000c000c000800, 0x040008000c000c00, 0x0400080008000c00, 0x0000080008000800, 0x040008000c000800, 0x04000c0008000c00, 0x000008000c000c00, 0x04000c000c000800, 0x04000c000c000c00, 0x0400080008000800, 0x00000c0008000800, 0x00000c000c000c00, 0x0000080008000c00, 0x000008000c000800, 0x0400040000000800, 0x0000040000000c00, 0x0000040004000800, 0x0400000004000c00, 0x0400000000000c00, 0x0000000000000800, 0x0400000004000800, 0x0400040000000c00, 0x0000000004000c00, 0x0400040004000800, 0x0400040004000c00, 0x0400000000000800, 0x0000040000000800, 0x0000040004000c00, 0x0000000000000c00, 0x0000000004000800, 0x0400040008000000, 0x0000040008000400, 0x000004000c000000, 0x040000000c000400, 0x0400000008000400, 0x0000000008000000, 0x040000000c000000, 0x0400040008000400, 0x000000000c000400, 0x040004000c000000, 0x040004000c000400, 0x0400000008000000, 0x0000040008000000, 0x000004000c000400, 0x0000000008000400, 0x000000000c000000};

unsigned long long T6_PRESENT[256] = {0x3000300000000000, 0x2000300000001000, 0x2000300010000000, 0x3000200010001000, 0x3000200000001000, 0x2000200000000000, 0x3000200010000000, 0x3000300000001000, 0x2000200010001000, 0x3000300010000000, 0x3000300010001000, 0x3000200000000000, 0x2000300000000000, 0x2000300010001000, 0x2000200000001000, 0x2000200010000000, 0x1000300000002000, 0x0000300000003000, 0x0000300010002000, 0x1000200010003000, 0x1000200000003000, 0x0000200000002000, 0x1000200010002000, 0x1000300000003000, 0x0000200010003000, 0x1000300010002000, 0x1000300010003000, 0x1000200000002000, 0x0000300000002000, 0x0000300010003000, 0x0000200000003000, 0x0000200010002000, 0x1000300020000000, 0x0000300020001000, 0x0000300030000000, 0x1000200030001000, 0x1000200020001000, 0x0000200020000000, 0x1000200030000000, 0x1000300020001000, 0x0000200030001000, 0x1000300030000000, 0x1000300030001000, 0x1000200020000000, 0x0000300020000000, 0x0000300030001000, 0x0000200020001000, 0x0000200030000000, 0x3000100020002000, 0x2000100020003000, 0x2000100030002000, 0x3000000030003000, 0x3000000020003000, 0x2000000020002000, 0x3000000030002000, 0x3000100020003000, 0x2000000030003000, 0x3000100030002000, 0x3000100030003000, 0x3000000020002000, 0x2000100020002000, 0x2000100030003000, 0x2000000020003000, 0x2000000030002000, 0x3000100000002000, 0x2000100000003000, 0x2000100010002000, 0x3000000010003000, 0x3000000000003000, 0x2000000000002000, 0x3000000010002000, 0x3000100000003000, 0x2000000010003000, 0x3000100010002000, 0x3000100010003000, 0x3000000000002000, 0x2000100000002000, 0x2000100010003000, 0x2000000000003000, 0x2000000010002000, 0x1000100000000000, 0x0000100000001000, 0x0000100010000000, 0x1000000010001000, 0x1000000000001000, 0x0000000000000000, 0x1000000010000000, 0x1000100000001000, 0x0000000010001000, 0x1000100010000000, 0x1000100010001000, 0x1000000000000000, 0x0000100000000000, 0x0000100010001000, 0x0000000000001000, 0x0000000010000000, 0x3000100020000000, 0x2000100020001000, 0x2000100030000000, 0x3000000030001000, 0x3000000020001000, 0x2000000020000000, 0x3000000030000000, 0x3000100020001000, 0x2000000030001000, 0x3000100030000000, 0x3000100030001000, 0x3000000020000000, 0x2000100020000000, 0x2000100030001000, 0x2000000020001000, 0x2000000030000000, 0x3000300000002000, 0x2000300000003000, 0x2000300010002000, 0x3000200010003000, 0x3000200000003000, 0x2000200000002000, 0x3000200010002000, 0x3000300000003000, 0x2000200010003000, 0x3000300010002000, 0x3000300010003000, 0x3000200000002000, 0x2000300000002000, 0x2000300010003000, 0x2000200000003000, 0x2000200010002000, 0x1000100020002000, 0x0000100020003000, 0x0000100030002000, 0x1000000030003000, 0x1000000020003000, 0x0000000020002000, 0x1000000030002000, 0x1000100020003000, 0x0000000030003000, 0x1000100030002000, 0x1000100030003000, 0x1000000020002000, 0x0000100020002000, 0x0000100030003000, 0x0000000020003000, 0x0000000030002000, 0x3000300020000000, 0x2000300020001000, 0x2000300030000000, 0x3000200030001000, 0x3000200020001000, 0x2000200020000000, 0x3000200030000000, 0x3000300020001000, 0x2000200030001000, 0x3000300030000000, 0x3000300030001000, 0x3000200020000000, 0x2000300020000000, 0x2000300030001000, 0x2000200020001000, 0x2000200030000000, 0x3000300020002000, 0x2000300020003000, 0x2000300030002000, 0x3000200030003000, 0x3000200020003000, 0x2000200020002000, 0x3000200030002000, 0x3000300020003000, 0x2000200030003000, 0x3000300030002000, 0x3000300030003000, 0x3000200020002000, 0x2000300020002000, 0x2000300030003000, 0x2000200020003000, 0x2000200030002000, 0x3000100000000000, 0x2000100000001000, 0x2000100010000000, 0x3000000010001000, 0x3000000000001000, 0x2000000000000000, 0x3000000010000000, 0x3000100000001000, 0x2000000010001000, 0x3000100010000000, 0x3000100010001000, 0x3000000000000000, 0x2000100000000000, 0x2000100010001000, 0x2000000000001000, 0x2000000010000000, 0x1000300000000000, 0x0000300000001000, 0x0000300010000000, 0x1000200010001000, 0x1000200000001000, 0x0000200000000000, 0x1000200010000000, 0x1000300000001000, 0x0000200010001000, 0x1000300010000000, 0x1000300010001000, 0x1000200000000000, 0x0000300000000000, 0x0000300010001000, 0x0000200000001000, 0x0000200010000000, 0x1000300020002000, 0x0000300020003000, 0x0000300030002000, 0x1000200030003000, 0x1000200020003000, 0x0000200020002000, 0x1000200030002000, 0x1000300020003000, 0x0000200030003000, 0x1000300030002000, 0x1000300030003000, 0x1000200020002000, 0x0000300020002000, 0x0000300030003000, 0x0000200020003000, 0x0000200030002000, 0x1000100000002000, 0x0000100000003000, 0x0000100010002000, 0x1000000010003000, 0x1000000000003000, 0x0000000000002000, 0x1000000010002000, 0x1000100000003000, 0x0000000010003000, 0x1000100010002000, 0x1000100010003000, 0x1000000000002000, 0x0000100000002000, 0x0000100010003000, 0x0000000000003000, 0x0000000010002000, 0x1000100020000000, 0x0000100020001000, 0x0000100030000000, 0x1000000030001000, 0x1000000020001000, 0x0000000020000000, 0x1000000030000000, 0x1000100020001000, 0x0000000030001000, 0x1000100030000000, 0x1000100030001000, 0x1000000020000000, 0x0000100020000000, 0x0000100030001000, 0x0000000020001000, 0x0000000030000000};

unsigned long long T7_PRESENT[256] = {0xc000c00000000000, 0x8000c00000004000, 0x8000c00040000000, 0xc000800040004000, 0xc000800000004000, 0x8000800000000000, 0xc000800040000000, 0xc000c00000004000, 0x8000800040004000, 0xc000c00040000000, 0xc000c00040004000, 0xc000800000000000, 0x8000c00000000000, 0x8000c00040004000, 0x8000800000004000, 0x8000800040000000, 0x4000c00000008000, 0x0000c0000000c000, 0x0000c00040008000, 0x400080004000c000, 0x400080000000c000, 0x0000800000008000, 0x4000800040008000, 0x4000c0000000c000, 0x000080004000c000, 0x4000c00040008000, 0x4000c0004000c000, 0x4000800000008000, 0x0000c00000008000, 0x0000c0004000c000, 0x000080000000c000, 0x0000800040008000, 0x4000c00080000000, 0x0000c00080004000, 0x0000c000c0000000, 0x40008000c0004000, 0x4000800080004000, 0x0000800080000000, 0x40008000c0000000, 0x4000c00080004000, 0x00008000c0004000, 0x4000c000c0000000, 0x4000c000c0004000, 0x4000800080000000, 0x0000c00080000000, 0x0000c000c0004000, 0x0000800080004000, 0x00008000c0000000, 0xc000400080008000, 0x800040008000c000, 0x80004000c0008000, 0xc0000000c000c000, 0xc00000008000c000, 0x8000000080008000, 0xc0000000c0008000, 0xc00040008000c000, 0x80000000c000c000, 0xc0004000c0008000, 0xc0004000c000c000, 0xc000000080008000, 0x8000400080008000, 0x80004000c000c000, 0x800000008000c000, 0x80000000c0008000, 0xc000400000008000, 0x800040000000c000, 0x8000400040008000, 0xc00000004000c000, 0xc00000000000c000, 0x8000000000008000, 0xc000000040008000, 0xc00040000000c000, 0x800000004000c000, 0xc000400040008000, 0xc00040004000c000, 0xc000000000008000, 0x8000400000008000, 0x800040004000c000, 0x800000000000c000, 0x8000000040008000, 0x4000400000000000, 0x0000400000004000, 0x0000400040000000, 0x4000000040004000, 0x4000000000004000, 0x0000000000000000, 0x4000000040000000, 0x4000400000004000, 0x0000000040004000, 0x4000400040000000, 0x4000400040004000, 0x4000000000000000, 0x0000400000000000, 0x0000400040004000, 0x0000000000004000, 0x0000000040000000, 0xc000400080000000, 0x8000400080004000, 0x80004000c0000000, 0xc0000000c0004000, 0xc000000080004000, 0x8000000080000000, 0xc0000000c0000000, 0xc000400080004000, 0x80000000c0004000, 0xc0004000c0000000, 0xc0004000c0004000, 0xc000000080000000, 0x8000400080000000, 0x80004000c0004000, 0x8000000080004000, 0x80000000c0000000, 0xc000c00000008000, 0x8000c0000000c000, 0x8000c00040008000, 0xc00080004000c000, 0xc00080000000c000, 0x8000800000008000, 0xc000800040008000, 0xc000c0000000c000, 0x800080004000c000, 0xc000c00040008000, 0xc000c0004000c000, 0xc000800000008000, 0x8000c00000008000, 0x8000c0004000c000, 0x800080000000c000, 0x8000800040008000, 0x4000400080008000, 0x000040008000c000, 0x00004000c0008000, 0x40000000c000c000, 0x400000008000c000, 0x0000000080008000, 0x40000000c0008000, 0x400040008000c000, 0x00000000c000c000, 0x40004000c0008000, 0x40004000c000c000, 0x4000000080008000, 0x0000400080008000, 0x00004000c000c000, 0x000000008000c000, 0x00000000c0008000, 0xc000c00080000000, 0x8000c00080004000, 0x8000c000c0000000, 0xc0008000c0004000, 0xc000800080004000, 0x8000800080000000, 0xc0008000c0000000, 0xc000c00080004000, 0x80008000c0004000, 0xc000c000c0000000, 0xc000c000c0004000, 0xc000800080000000, 0x8000c00080000000, 0x8000c000c0004000, 0x8000800080004000, 0x80008000c0000000, 0xc000c00080008000, 0x8000c0008000c000, 0x8000c000c0008000, 0xc0008000c000c000, 0xc00080008000c000, 0x8000800080008000, 0xc0008000c0008000, 0xc000c0008000c000, 0x80008000c000c000, 0xc000c000c0008000, 0xc000c000c000c000, 0xc000800080008000, 0x8000c00080008000, 0x8000c000c000c000, 0x800080008000c000, 0x80008000c0008000, 0xc000400000000000, 0x8000400000004000, 0x8000400040000000, 0xc000000040004000, 0xc000000000004000, 0x8000000000000000, 0xc000000040000000, 0xc000400000004000, 0x8000000040004000, 0xc000400040000000, 0xc000400040004000, 0xc000000000000000, 0x8000400000000000, 0x8000400040004000, 0x8000000000004000, 0x8000000040000000, 0x4000c00000000000, 0x0000c00000004000, 0x0000c00040000000, 0x4000800040004000, 0x4000800000004000, 0x0000800000000000, 0x4000800040000000, 0x4000c00000004000, 0x0000800040004000, 0x4000c00040000000, 0x4000c00040004000, 0x4000800000000000, 0x0000c00000000000, 0x0000c00040004000, 0x0000800000004000, 0x0000800040000000, 0x4000c00080008000, 0x0000c0008000c000, 0x0000c000c0008000, 0x40008000c000c000, 0x400080008000c000, 0x0000800080008000, 0x40008000c0008000, 0x4000c0008000c000, 0x00008000c000c000, 0x4000c000c0008000, 0x4000c000c000c000, 0x4000800080008000, 0x0000c00080008000, 0x0000c000c000c000, 0x000080008000c000, 0x00008000c0008000, 0x4000400000008000, 0x000040000000c000, 0x0000400040008000, 0x400000004000c000, 0x400000000000c000, 0x0000000000008000, 0x4000000040008000, 0x400040000000c000, 0x000000004000c000, 0x4000400040008000, 0x400040004000c000, 0x4000000000008000, 0x0000400000008000, 0x000040004000c000, 0x000000000000c000, 0x0000000040008000, 0x4000400080000000, 0x0000400080004000, 0x00004000c0000000, 0x40000000c0004000, 0x4000000080004000, 0x0000000080000000, 0x40000000c0000000, 0x4000400080004000, 0x00000000c0004000, 0x40004000c0000000, 0x40004000c0004000, 0x4000000080000000, 0x0000400080000000, 0x00004000c0004000, 0x0000000080004000, 0x00000000c0000000};

unsigned long long TroundCounters80[31] = {0x0000000000040000, 0x0000000000080000, 0x00000000000c0000, 0x0000000000100000, 0x0000000000140000, 0x0000000000180000, 0x00000000001c0000, 0x0000000000200000, 0x0000000000240000, 0x0000000000280000, 0x00000000002c0000, 0x0000000000300000, 0x0000000000340000, 0x0000000000380000, 0x00000000003c0000, 0x0000000000400000, 0x0000000000440000, 0x0000000000480000, 0x00000000004c0000, 0x0000000000500000, 0x0000000000540000, 0x0000000000580000, 0x00000000005c0000, 0x0000000000600000, 0x0000000000640000, 0x0000000000680000, 0x00000000006c0000, 0x0000000000700000, 0x0000000000740000, 0x0000000000780000, 0x00000000007c0000};

unsigned long long TsboxKS80[16] = {0xc000000000000000, 0x5000000000000000, 0x6000000000000000, 0xb000000000000000, 0x9000000000000000, 0x0000000000000000, 0xa000000000000000, 0xd000000000000000, 0x3000000000000000, 0xe000000000000000, 0xf000000000000000, 0x8000000000000000, 0x4000000000000000, 0x7000000000000000, 0x1000000000000000, 0x2000000000000000};

unsigned long long TroundCounters128[31] = {0x0000000000000002, 0x0000000000000004, 0x0000000000000006, 0x0000000000000008, 0x000000000000000a, 0x000000000000000c, 0x000000000000000e, 0x0000000000000010, 0x0000000000000012, 0x0000000000000014, 0x0000000000000016, 0x0000000000000018, 0x000000000000001a, 0x000000000000001c, 0x000000000000001e, 0x0000000000000020, 0x0000000000000022, 0x0000000000000024, 0x0000000000000026, 0x0000000000000028, 0x000000000000002a, 0x000000000000002c, 0x000000000000002e, 0x0000000000000030, 0x0000000000000032, 0x0000000000000034, 0x0000000000000036, 0x0000000000000038, 0x000000000000003a, 0x000000000000003c, 0x000000000000003e};

unsigned long long TsboxKS128[256] = {0xcc00000000000000, 0xc500000000000000, 0xc600000000000000, 0xcb00000000000000, 0xc900000000000000, 0xc000000000000000, 0xca00000000000000, 0xcd00000000000000, 0xc300000000000000, 0xce00000000000000, 0xcf00000000000000, 0xc800000000000000, 0xc400000000000000, 0xc700000000000000, 0xc100000000000000, 0xc200000000000000, 0x5c00000000000000, 0x5500000000000000, 0x5600000000000000, 0x5b00000000000000, 0x5900000000000000, 0x5000000000000000, 0x5a00000000000000, 0x5d00000000000000, 0x5300000000000000, 0x5e00000000000000, 0x5f00000000000000, 0x5800000000000000, 0x5400000000000000, 0x5700000000000000, 0x5100000000000000, 0x5200000000000000, 0x6c00000000000000, 0x6500000000000000, 0x6600000000000000, 0x6b00000000000000, 0x6900000000000000, 0x6000000000000000, 0x6a00000000000000, 0x6d00000000000000, 0x6300000000000000, 0x6e00000000000000, 0x6f00000000000000, 0x6800000000000000, 0x6400000000000000, 0x6700000000000000, 0x6100000000000000, 0x6200000000000000, 0xbc00000000000000, 0xb500000000000000, 0xb600000000000000, 0xbb00000000000000, 0xb900000000000000, 0xb000000000000000, 0xba00000000000000, 0xbd00000000000000, 0xb300000000000000, 0xbe00000000000000, 0xbf00000000000000, 0xb800000000000000, 0xb400000000000000, 0xb700000000000000, 0xb100000000000000, 0xb200000000000000, 0x9c00000000000000, 0x9500000000000000, 0x9600000000000000, 0x9b00000000000000, 0x9900000000000000, 0x9000000000000000, 0x9a00000000000000, 0x9d00000000000000, 0x9300000000000000, 0x9e00000000000000, 0x9f00000000000000, 0x9800000000000000, 0x9400000000000000, 0x9700000000000000, 0x9100000000000000, 0x9200000000000000, 0x0c00000000000000, 0x0500000000000000, 0x0600000000000000, 0x0b00000000000000, 0x0900000000000000, 0x0000000000000000, 0x0a00000000000000, 0x0d00000000000000, 0x0300000000000000, 0x0e00000000000000, 0x0f00000000000000, 0x0800000000000000, 0x0400000000000000, 0x0700000000000000, 0x0100000000000000, 0x0200000000000000, 0xac00000000000000, 0xa500000000000000, 0xa600000000000000, 0xab00000000000000, 0xa900000000000000, 0xa000000000000000, 0xaa00000000000000, 0xad00000000000000, 0xa300000000000000, 0xae00000000000000, 0xaf00000000000000, 0xa800000000000000, 0xa400000000000000, 0xa700000000000000, 0xa100000000000000, 0xa200000000000000, 0xdc00000000000000, 0xd500000000000000, 0xd600000000000000, 0xdb00000000000000, 0xd900000000000000, 0xd000000000000000, 0xda00000000000000, 0xdd00000000000000, 0xd300000000000000, 0xde00000000000000, 0xdf00000000000000, 0xd800000000000000, 0xd400000000000000, 0xd700000000000000, 0xd100000000000000, 0xd200000000000000, 0x3c00000000000000, 0x3500000000000000, 0x3600000000000000, 0x3b00000000000000, 0x3900000000000000, 0x3000000000000000, 0x3a00000000000000, 0x3d00000000000000, 0x3300000000000000, 0x3e00000000000000, 0x3f00000000000000, 0x3800000000000000, 0x3400000000000000, 0x3700000000000000, 0x3100000000000000, 0x3200000000000000, 0xec00000000000000, 0xe500000000000000, 0xe600000000000000, 0xeb00000000000000, 0xe900000000000000, 0xe000000000000000, 0xea00000000000000, 0xed00000000000000, 0xe300000000000000, 0xee00000000000000, 0xef00000000000000, 0xe800000000000000, 0xe400000000000000, 0xe700000000000000, 0xe100000000000000, 0xe200000000000000, 0xfc00000000000000, 0xf500000000000000, 0xf600000000000000, 0xfb00000000000000, 0xf900000000000000, 0xf000000000000000, 0xfa00000000000000, 0xfd00000000000000, 0xf300000000000000, 0xfe00000000000000, 0xff00000000000000, 0xf800000000000000, 0xf400000000000000, 0xf700000000000000, 0xf100000000000000, 0xf200000000000000, 0x8c00000000000000, 0x8500000000000000, 0x8600000000000000, 0x8b00000000000000, 0x8900000000000000, 0x8000000000000000, 0x8a00000000000000, 0x8d00000000000000, 0x8300000000000000, 0x8e00000000000000, 0x8f00000000000000, 0x8800000000000000, 0x8400000000000000, 0x8700000000000000, 0x8100000000000000, 0x8200000000000000, 0x4c00000000000000, 0x4500000000000000, 0x4600000000000000, 0x4b00000000000000, 0x4900000000000000, 0x4000000000000000, 0x4a00000000000000, 0x4d00000000000000, 0x4300000000000000, 0x4e00000000000000, 0x4f00000000000000, 0x4800000000000000, 0x4400000000000000, 0x4700000000000000, 0x4100000000000000, 0x4200000000000000, 0x7c00000000000000, 0x7500000000000000, 0x7600000000000000, 0x7b00000000000000, 0x7900000000000000, 0x7000000000000000, 0x7a00000000000000, 0x7d00000000000000, 0x7300000000000000, 0x7e00000000000000, 0x7f00000000000000, 0x7800000000000000, 0x7400000000000000, 0x7700000000000000, 0x7100000000000000, 0x7200000000000000, 0x1c00000000000000, 0x1500000000000000, 0x1600000000000000, 0x1b00000000000000, 0x1900000000000000, 0x1000000000000000, 0x1a00000000000000, 0x1d00000000000000, 0x1300000000000000, 0x1e00000000000000, 0x1f00000000000000, 0x1800000000000000, 0x1400000000000000, 0x1700000000000000, 0x1100000000000000, 0x1200000000000000, 0x2c00000000000000, 0x2500000000000000, 0x2600000000000000, 0x2b00000000000000, 0x2900000000000000, 0x2000000000000000, 0x2a00000000000000, 0x2d00000000000000, 0x2300000000000000, 0x2e00000000000000, 0x2f00000000000000, 0x2800000000000000, 0x2400000000000000, 0x2700000000000000, 0x2100000000000000, 0x2200000000000000};

#include <stdint.h>

/* Types definitions */
typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t byte;
typedef uint8_t u8;

/* Parallelism definition */
#define TABLE_P         1

#define KEY128          8

#define PRESENT128_SUBKEYS_SIZE         (32 * sizeof(u64))

/* Force compilation */
#define TABLE
#define PRESENT128

#ifdef TABLE

#ifdef TABLE
#ifdef PRESENT128
void PRESENT128table_key_schedule(const u8* masterKey128, u8* roundKeys128);
void PRESENT128table_core(const u8* plaintext, const u8* roundKeys128, u8* ciphertext);
void PRESENT128table_cipher(const u64 plaintext_in[TABLE_P], const u16 keys_in[TABLE_P][KEY128], u64 ciphertext_out[TABLE_P]);
#endif
#endif

/****************************************************************************************************/
/* some macros                                                                                      */

/* Should translate to a 'bswap' instruction in assembly */
#define BSWAP64(in) (u64)((u64)(((u64)(in) & (u64)0x00000000000000ffULL) << 56) |\
		(u64)(((u64)(in) & (u64)0x000000000000ff00ULL) << 40) |\
		(u64)(((u64)(in) & (u64)0x0000000000ff0000ULL) << 24) |\
		(u64)(((u64)(in) & (u64)0x00000000ff000000ULL) <<  8) |\
	        (u64)(((u64)(in) & (u64)0x000000ff00000000ULL) >>  8) |\
		(u64)(((u64)(in) & (u64)0x0000ff0000000000ULL) >> 24) |\
		(u64)(((u64)(in) & (u64)0x00ff000000000000ULL) >> 40) |\
		(u64)(((u64)(in) & (u64)0xff00000000000000ULL) >> 56) )
/* Should translate to a 'rot' instruction in assembly */
#define ROTL64(in, l) ((in) << l) ^ ((in) >> (64-l))
#define ROTR64(in, l) ((in) >> l) ^ ((in) << (64-l))

#define MASK4  0x0f
#define MASK8  0xff
#define MASK16 0xffff

#define PRESENTKS128(keyLow, keyHigh, round) do {\
	u64 temp;\
	keyLow  ^= TroundCounters128[round];\
	temp     = keyHigh;\
	keyHigh  = (temp   & 0x0000000000000007) << 61;\
	keyHigh |= (keyLow & 0xfffffffffffffff8) >> 3;\
	keyLow   = (keyLow & 0x0000000000000007) << 61;\
	keyLow  |= (temp   & 0xfffffffffffffff8) >> 3;\
	temp      = keyHigh >> 56;\
	keyHigh  &= 0x00ffffffffffffff;\
	temp      = TsboxKS128[temp];\
	keyHigh  |= temp;\
} while(0);

#define PRESENTROUND(state) do {\
	u64 stateIn;\
	stateIn = state;\
	state  = T0_PRESENT[stateIn & MASK8];\
	state ^= T1_PRESENT[(stateIn >> 8) & MASK8];\
	state ^= T2_PRESENT[(stateIn >> 16) & MASK8];\
	state ^= T3_PRESENT[(stateIn >> 24) & MASK8];\
	state ^= T4_PRESENT[(stateIn >> 32) & MASK8];\
	state ^= T5_PRESENT[(stateIn >> 40) & MASK8];\
	state ^= T6_PRESENT[(stateIn >> 48) & MASK8];\
	state ^= T7_PRESENT[(stateIn >> 56) & MASK8];\
} while(0);


/****************************************************************************************************/
/* PRESENT128 key schedule                                                                          */
#ifdef PRESENT128
void PRESENT128table_key_schedule(const u8* masterKey128, u8* roundKeys128)
{
	u64 currentKeyLow, currentKeyHigh;

	/* get low and high parts of master key */
	currentKeyHigh = BSWAP64(((u64 *)masterKey128)[0]);
	currentKeyLow = BSWAP64(((u64 *)masterKey128)[1]);

	/* get round key 0 and compute round key 1 */
	((u64 *)roundKeys128)[0] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 0);

	/* get round key 1 and compute round key 2 */
	((u64 *)roundKeys128)[1] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 1);

	/* get round key 2 and compute round key 3 */
	((u64 *)roundKeys128)[2] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 2);

	/* get round key 3 and compute round key 4 */
	((u64 *)roundKeys128)[3] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 3);

	/* get round key 4 and compute round key 5 */
	((u64 *)roundKeys128)[4] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 4);

	/* get round key 5 and compute round key 6 */
	((u64 *)roundKeys128)[5] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 5);

	/* get round key 6 and compute round key 7 */
	((u64 *)roundKeys128)[6] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 6);

	/* get round key 7 and compute round key 8 */
	((u64 *)roundKeys128)[7] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 7);

	/* get round key 8 and compute round key 9 */
	((u64 *)roundKeys128)[8] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 8);

	/* get round key 9 and compute round key 10 */
	((u64 *)roundKeys128)[9] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 9);

	/* get round key 10 and compute round key 11 */
	((u64 *)roundKeys128)[10] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 10);

	/* get round key 11 and compute round key 12 */
	((u64 *)roundKeys128)[11] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 11);

	/* get round key 12 and compute round key 13 */
	((u64 *)roundKeys128)[12] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 12);

	/* get round key 13 and compute round key 14 */
	((u64 *)roundKeys128)[13] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 13);

	/* get round key 14 and compute round key 15 */
	((u64 *)roundKeys128)[14] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 14);

	/* get round key 15 and compute round key 16 */
	((u64 *)roundKeys128)[15] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 15);

	/* get round key 16 and compute round key 17 */
	((u64 *)roundKeys128)[16] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 16);

	/* get round key 17 and compute round key 18 */
	((u64 *)roundKeys128)[17] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 17);

	/* get round key 18 and compute round key 19 */
	((u64 *)roundKeys128)[18] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 18);

	/* get round key 19 and compute round key 20 */
	((u64 *)roundKeys128)[19] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 19);

	/* get round key 20 and compute round key 21 */
	((u64 *)roundKeys128)[20] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 20);

	/* get round key 21 and compute round key 22 */
	((u64 *)roundKeys128)[21] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 21);

	/* get round key 22 and compute round key 23 */
	((u64 *)roundKeys128)[22] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 22);

	/* get round key 23 and compute round key 24 */
	((u64 *)roundKeys128)[23] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 23);

	/* get round key 24 and compute round key 25 */
	((u64 *)roundKeys128)[24] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 24);

	/* get round key 25 and compute round key 26 */
	((u64 *)roundKeys128)[25] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 25);

	/* get round key 26 and compute round key 27 */
	((u64 *)roundKeys128)[26] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 26);

	/* get round key 27 and compute round key 28 */
	((u64 *)roundKeys128)[27] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 27);

	/* get round key 28 and compute round key 29 */
	((u64 *)roundKeys128)[28] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 28);

	/* get round key 29 and compute round key 30 */
	((u64 *)roundKeys128)[29] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 29);

	/* get round key 30 and compute round key 31 */
	((u64 *)roundKeys128)[30] = currentKeyHigh;
	PRESENTKS128(currentKeyLow, currentKeyHigh, 30);

	/* get round key 31 */
	((u64 *)roundKeys128)[31] = currentKeyHigh;

	return;
}
#endif

/****************************************************************************************************/
/* PRESENT128 encryption core                                                                       */
#ifdef PRESENT128
void PRESENT128table_core(const u8* plaintext, const u8* roundKeys128, u8* ciphertext)
{
	u64 * state, * roundKeys;

	/* cast variables */
	*((u64*)ciphertext) = BSWAP64(*((u64*)plaintext));
	state     = (u64 *)ciphertext;
	roundKeys = (u64 *)roundKeys128;

	/* round 1 */
	state[0] ^= roundKeys[0];
	PRESENTROUND(state[0]);

	/* round 2 */
	state[0] ^= roundKeys[1];
	PRESENTROUND(state[0]);

	/* round 3 */
	state[0] ^= roundKeys[2];
	PRESENTROUND(state[0]);

	/* round 4 */
	state[0] ^= roundKeys[3];
	PRESENTROUND(state[0]);

	/* round 5 */
	state[0] ^= roundKeys[4];
	PRESENTROUND(state[0]);

	/* round 6 */
	state[0] ^= roundKeys[5];
	PRESENTROUND(state[0]);

	/* round 7 */
	state[0] ^= roundKeys[6];
	PRESENTROUND(state[0]);

	/* round 8 */
	state[0] ^= roundKeys[7];
	PRESENTROUND(state[0]);

	/* round 9 */
	state[0] ^= roundKeys[8];
	PRESENTROUND(state[0]);

	/* round 10 */
	state[0] ^= roundKeys[9];
	PRESENTROUND(state[0]);

	/* round 11 */
	state[0] ^= roundKeys[10];
	PRESENTROUND(state[0]);

	/* round 12 */
	state[0] ^= roundKeys[11];
	PRESENTROUND(state[0]);

	/* round 13 */
	state[0] ^= roundKeys[12];
	PRESENTROUND(state[0]);

	/* round 14 */
	state[0] ^= roundKeys[13];
	PRESENTROUND(state[0]);

	/* round 15 */
	state[0] ^= roundKeys[14];
	PRESENTROUND(state[0]);

	/* round 16 */
	state[0] ^= roundKeys[15];
	PRESENTROUND(state[0]);

	/* round 17 */
	state[0] ^= roundKeys[16];
	PRESENTROUND(state[0]);

	/* round 18 */
	state[0] ^= roundKeys[17];
	PRESENTROUND(state[0]);

	/* round 19 */
	state[0] ^= roundKeys[18];
	PRESENTROUND(state[0]);

	/* round 20 */
	state[0] ^= roundKeys[19];
	PRESENTROUND(state[0]);

	/* round 21 */
	state[0] ^= roundKeys[20];
	PRESENTROUND(state[0]);

	/* round 22 */
	state[0] ^= roundKeys[21];
	PRESENTROUND(state[0]);

	/* round 23 */
	state[0] ^= roundKeys[22];
	PRESENTROUND(state[0]);

	/* round 24 */
	state[0] ^= roundKeys[23];
	PRESENTROUND(state[0]);

	/* round 25 */
	state[0] ^= roundKeys[24];
	PRESENTROUND(state[0]);

	/* round 26 */
	state[0] ^= roundKeys[25];
	PRESENTROUND(state[0]);

	/* round 27 */
	state[0] ^= roundKeys[26];
	PRESENTROUND(state[0]);

	/* round 28 */
	state[0] ^= roundKeys[27];
	PRESENTROUND(state[0]);

	/* round 29 */
	state[0] ^= roundKeys[28];
	PRESENTROUND(state[0]);

	/* round 30 */
	state[0] ^= roundKeys[29];
	PRESENTROUND(state[0]);

	/* round 31 */
	state[0] ^= roundKeys[30];
	PRESENTROUND(state[0]);

	/* last addRoundKey */
	state[0] ^= roundKeys[31];

	/* endianness handling */
	state[0] = BSWAP64(state[0]);

	return;
}
#endif

/****************************************************************************************************/
/* PRESENT128 key schedule + encryption                                                             */
#ifdef PRESENT128
void PRESENT128table_cipher(const u64 plaintext_in[TABLE_P], const u16 keys_in[TABLE_P][KEY128], u64 ciphertext_out[TABLE_P])
{
	/* Key schedule: subkeys are of size 2*264 bytes */
	u8 subkeys[TABLE_P * PRESENT128_SUBKEYS_SIZE];

	/* Compute the subkeys */
	PRESENT128table_key_schedule((const u8*)keys_in, subkeys);

	/* Call the core encryption */
	PRESENT128table_core((const u8*)plaintext_in, subkeys, (u8*)ciphertext_out);

	return;
}
#endif

#endif
