#ifndef CODEC_IMAGE_HPP
#define CODEC_IMAGE_HPP

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#if defined(WIN32)
typedef __int16 int16_t;
#endif

class CCodecImage
{
private:

protected:
   struct ImageData
   {
     unsigned int Count;
     int Width, Height;
     int Pixels;
     int16_t *pImage;

     ImageData()
     {
       Count = 1;
       Width = 0;
       Height = 0;
       Pixels = 0;
       pImage = 0;
     }

     ~ImageData()
     {
       free(pImage);
       pImage = 0;
     }

     void Malloc(int w, int h)
     {
       void *s;

       // Only reallocate when size is different
       if (w == Width && h == Height && pImage != 0)
         return;
       s = realloc(pImage, w * h * sizeof(int16_t));
       if (s == 0)
       {
         printf("CCodecImage::ImageData::Malloc: no memory!\n");
         free(pImage);
         s = 0;
         Width = 0;
         Height = 0;
         Pixels = 0;
       }
       else
       {
         Width = w;
         Height = h;
         Pixels = w * h;
         memset(s, 0, Pixels * sizeof(int16_t));
       }
       pImage = (int16_t *)s;
     }

     void ref()
     {
       Count++;
     }
     bool deref()
     {
       return !--Count;
     }
   } *m_pData;

   static bool SanityCheck(const CCodecImage &one, const CCodecImage &two);
   virtual void detach();
   CCodecImage copy() const;

 public:
   CCodecImage();
   CCodecImage(const CCodecImage &);
   CCodecImage(int width, int height);
   virtual ~CCodecImage();

   int Width() const;
   int Height() const;
   virtual void Resize(int w, int h);

   void Load(int width, int height, const unsigned char *src);
   void Store(int width, int height, unsigned char *dst);

   CCodecImage &operator =(const CCodecImage &src);
   CCodecImage &operator -=(const CCodecImage &sub);
   CCodecImage operator -(const CCodecImage &sub) const;
};

template <class Image> class YUVTriplet
{
private:

public:
   Image Y;
   Image U;
   Image V;

   YUVTriplet<Image>()
   {
      /* Do exactly nothing */
   }

   YUVTriplet<Image>(const YUVTriplet <Image> &copy)
   {
     Y = copy.Y;
     U = copy.U;
     V = copy.V;
   }

   YUVTriplet<Image> &operator =(const YUVTriplet<Image> &assign)
   {
      Y = assign.Y;
      U = assign.U;
      V = assign.V;
      return *this;
   }

   void Resize(int w, int h)
   {
     Y.Resize(w, h);
     w >>= 1;
     h >>= 1;
     U.Resize(w, h);
     V.Resize(w, h);
   }

   YUVTriplet<Image> operator -(const YUVTriplet<Image> &sub) const
   {
      YUVTriplet<Image> result;

      result.Y = Y - sub.Y;
      result.U = U - sub.U;
      result.V = V - sub.V;
      return result;
   }
};

#endif
