/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "support.h"

#include "file2tag.h"
#include "mp3info.h"
#include "gui_file2tag.h"
#include "lib_id3v1.h"
#include "lib_id3v2.3.h"
#include "lib_vorbis.h"
#include "gui_queue.h"
#include "shared.h"



/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

static void
put_info_to_tag(gchar *filename, id3Tag *tag, gchar *values[][2], gint numvalues, gint whichtag)
{
	gint u = 0;
	
	id3Tag *v2 = malloc(sizeof(id3Tag));
// get old tag. v2 tag has higher prio, so it will overwrite the v1	
	if(whichtag == 1)
	{
		get_id3v1_tag(tag, filename);
		if(get_id3v2_tag(v2, filename)==0)
			memcpy(tag, v2, sizeof(id3Tag));
	}
#ifdef HAVE_OGG_H
	else
	{
		get_vorbis_tag(tag, filename);
	}
#endif
	free(v2);
			
	for(u=0; u!=numvalues; u++)
	{
		if(strcmp(values[u][0],"artist")==0)
		{
			memset(tag->artist, '\0', 1024);
			strncpy(tag->artist, values[u][1], 1023);
		}
		if(strcmp(values[u][0],"album")==0)
		{
			memset(tag->album, '\0', 1024);
			strncpy(tag->album, values[u][1], 1023);
		}
		if(strcmp(values[u][0],"song")==0)
		{
			memset(tag->title, '\0', 1024);
			strncpy(tag->title, values[u][1], 1023);
		}
		if(strcmp(values[u][0],"year")==0)
		{
			memset(tag->year, '\0', 5);
			strncpy(tag->year, values[u][1], 4);
		}
		if(strcmp(values[u][0],"track")==0)
		{
			memset(tag->track, '\0', 3);
			strncpy(tag->track, values[u][1], 3);
		}
	}
	return;
}



// This will put infos to an array in style:
// col0: "Artist", col1: <artist>
// from a given format (e.g. "%a - %s") and a filename.
static gint
get_tag_from_string(gchar *format, gchar *string, gchar *values[][2])
{
	gchar *trenner[8];
	gchar *ptrenner[8];
	gchar *pformat = format;
	gchar *pstring = string;
	gchar foo[2048];
	gchar *pfoo = foo;
	gint i = 0, u = -1;
	
	if(!format || !string)
		return 0;
	
	trenner[0] = calloc(2048, sizeof(gchar));
	ptrenner[0] = trenner[0];
	values[0][0] = calloc(128, sizeof(gchar));
	values[0][1] = calloc(2048, sizeof(gchar));
	
// Save the parts between %-switches in "trenner" and the switches in "options"
	if(format != NULL)
	{
		for(pformat=format; (*pformat!='\0'); pformat++)
		{
			if(*pformat!='%')
			{
				*ptrenner[i]++ = *pformat;
			}
			else
			{
				if(*(++pformat)=='%')
				{
					*ptrenner[i]++ = *pformat;
				}
				else
				{
					if(*pformat=='a')
						sprintf(values[i][0], "artist");
					if(*pformat=='b')
						sprintf(values[i][0], "album");
					if(*pformat=='s')
						sprintf(values[i][0], "song");
					if(*pformat=='t')
						sprintf(values[i][0], "track");
					if(*pformat=='y')
						sprintf(values[i][0], "year");
					if(*pformat=='x')
						sprintf(values[i][0], "delete");
				}
				trenner[++i] = calloc(2048, sizeof(gchar));
				ptrenner[i] = trenner[i];
				values[i][0] = calloc(128, sizeof(gchar));
				values[i][1] = calloc(2048, sizeof(gchar));
				if(i>=7) break;
			}
		}
		pstring = string;
		while(++u<=i)
		{
			if(*values[u][0]=='\0') break;
			ptrenner[u] = trenner[u];
			for(; (*ptrenner[u]!='\0'); pstring++)
			{
				if(*pstring!=*ptrenner[u]++)
				{
					for(u=0; u<=i; u++)
					{
						free(trenner[u]);
						free(values[u][0]);
						free(values[u][1]);
					}
					return 0;
				}
			}
			
			memset(foo, 0, 2048);
 			pfoo = foo;
			for(; (*pstring!='\0'); pstring++)
			{
				if(*trenner[u+1]=='\0')
				{
					strncpy(foo, pstring, 2047);
					break;
				}
				if(strncmp(pstring, trenner[u+1], strlen(trenner[u+1]))==0)
					break;
				else
					*pfoo++ = *pstring;
			}
			strncpy(values[u][1], foo, 2047);
		}
	}
	
	for(u=0; u<=i; u++)
		free(trenner[u]);
	return i;
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/









/**********************************************************************
 * this will extract infos from filename and put them for preview to a form
 **********************************************************************/
void
file2tag_preview_selected(GtkCList *clist)
{
	extern GtkWidget *cantus;
	
	GList *selection = NULL;
	Mp3Info *mp3info = NULL;
	gchar filename_noext[2048];
	gchar directory[2048];
	
	gchar *values[8][2];
	gint row = 0, numvalues = 0;
	
// First of all clear the current form
	file2tag_form_clear();
	
	selection = clist->selection;
	if (!selection)
		return;
	
// Get the first selected row in the queue gui
	row = (gint)selection->data;
// And find this filename in queue list
	mp3info = gtk_clist_get_row_data(clist, row);

	
// ---- Filename
	strncpy(filename_noext, mp3info->filename, 2047);
	*strrchr(filename_noext, '.') = '\0';
// get desired format
	numvalues = get_tag_from_string(gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_file2tag_file"))),
		filename_noext,
		values);

// now, put the data to the form.
	if(numvalues>0)
	{
		file2tag_form_fill(values);

// cleanups.
		for(row=0; row<=numvalues; row++)
		{
			if(values[row][0])
				free(values[row][0]);
			if(values[row][1])
				free(values[row][1]);
		}
	}
	
// ---- Directory
	strncpy(directory, mp3info->directory, 2047);
	*strrchr(directory, '/') = '\0';
	strncpy(directory, strrchr(directory, '/')+1, 2047);

// get desired format
	numvalues = get_tag_from_string(gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_file2tag_directory"))),
		directory,
		values);

// now, put the data to the form.
	if(numvalues>0)
	{
		file2tag_form_fill(values);
	
// cleanups.
		for(row = 0; row<=numvalues; row++)
		{
			if(values[row][0])
				free(values[row][0]);
			if(values[row][1])
				free(values[row][1]);
		}
	}
}






/**********************************************************************
 * this will extract infos from filename and directory, and put them
 * to a tag. works on the whole queue.
 **********************************************************************/
void
file2tag_proceed(void)
{
	extern GtkWidget *cantus;
	extern GList *queue;
	
	GList *item = NULL;
	Mp3Info *mp3info = NULL;
	gchar filename_noext[2048];
	gchar extension[2048];
	gchar fullfilename[2048];
	gchar directory[2048];
	gchar status[2048];
	id3Tag *tag = calloc(1, sizeof(id3Tag));
	
	gchar *values[8][2];
	gint row = 0, numvalues = 0, numrows = 0, currentrow = 0;
	
	if (!queue)
		return;

// Count rows (needed for the statusbar)
	item = g_list_first(queue);
	while(item)
	{
		item = item->next;
		++numrows;
	}
	
// Get the first row in the queue
	item = g_list_first(queue);
	while(item)
	{
// And find this filename in queue list
		mp3info = (Mp3Info *)item->data;
	
// ---- Filename
		strncpy(filename_noext, mp3info->filename, 2047);
		*strrchr(filename_noext, '.') = '\0';
		strncpy(extension, strrchr(mp3info->filename, '.'), 2047);
		snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);

// Lowercase the extension
#ifdef HAVE_OGG_H
		if( strtoucmp(extension, ".ogg") == 0 )
			strncpy(extension, ".ogg", 5);
#endif
		if( strtoucmp(extension, ".mp3") == 0 )
			strncpy(extension, ".mp3", 5);
		if( strtoucmp(extension, ".flac") == 0 )
			strncpy(extension, ".flac", 6);

// Set status/progressbar.
		snprintf(status, 2047, "Filename2Tag: %s", fullfilename);
		gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), status);
		gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), (gfloat)100/numrows*currentrow++*0.01);
		while(g_main_iteration(FALSE));
		
// get desired format
		numvalues = get_tag_from_string(gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_file2tag_file"))),
			filename_noext,
			values);

// Put this info to a tag-struct it wont overwrite field which are not in values.
// thus it will need the filename - just to get the old fields.
		if(numvalues>0)
		{
// And put the changed tag to the file
			if(strcmp(extension, ".mp3")==0
        || strcmp(extension, ".flac")==0)
			{
				put_info_to_tag(fullfilename, tag, values, numvalues, 1);
				set_id3v1_tag(tag, fullfilename);
				set_id3v2_tag(tag, fullfilename);
			}
#ifdef HAVE_OGG_H
			else
			{
				put_info_to_tag(fullfilename, tag, values, numvalues, 2);
				set_vorbis_tag(tag, fullfilename);
			}
#endif

// Update queuerow.
			mp3file_get_info_1(mp3info->directory, mp3info->filename, mp3info);
			clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
			clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
			
// cleanups.
			for(row=0; row<=numvalues; row++)
			{
				if(values[row][0])
					free(values[row][0]);
				if(values[row][1])
					free(values[row][1]);
			}
		}
	
// ---- Directory
		strncpy(directory, mp3info->directory, 2047);
		*strrchr(directory, '/') = '\0';
		strncpy(directory, strrchr(directory, '/')+1, 2047);
	
// get desired format
		numvalues = get_tag_from_string(gtk_entry_get_text(GTK_ENTRY(lookup_widget(cantus, "entry_cantus_file2tag_directory"))),
			directory,
			values);

// Put this info to a tag-struct. It wont overwrite field which are not in values.
// thus it will need the filename - just to get the old fields.
		if(numvalues>0)
		{
			memset(tag, 0, sizeof(id3Tag));
		
// And put the changed tag to the file
			if(strcmp(extension, ".mp3")==0
        || strcmp(extension, ".flac")==0)
			{
				put_info_to_tag(fullfilename, tag, values, numvalues, 1);
				set_id3v1_tag(tag, fullfilename);
				set_id3v2_tag(tag, fullfilename);
			}
#ifdef HAVE_OGG_H
			else
			{
				put_info_to_tag(fullfilename, tag, values, numvalues, 2);
				set_vorbis_tag(tag, fullfilename);
			}
#endif

// Update queuerow.
			mp3file_get_info_1(mp3info->directory, mp3info->filename, mp3info);
			clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
			clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
			
// cleanups.
			for(row=0; row<=numvalues; row++)
			{
				if(values[row][0])
					free(values[row][0]);
				if(values[row][1])
					free(values[row][1]);
			}
		}
		item = item->next;
	}
	free(tag);
	
// Set status
	gnome_appbar_set_status(GNOME_APPBAR (lookup_widget (cantus, "appbar")), "Ready.");
	gnome_appbar_set_progress(GNOME_APPBAR (lookup_widget (cantus, "appbar")), 0);
}
