/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "gui_shared.h"

/**********************************************************************
 * Returns a list of all rows selected in a clist.
 * The returned lists data is a pointer to the data of the row in queue.
 **********************************************************************/
GList *
clist_get_selected(GtkCList *clist)
{
	GList *selection = NULL;
	GList *selected_items = NULL;
	gint row = 0;

// if nothing is selected, return the empty glist.
	if(!(selection = clist->selection))
		return selected_items;

// get selected filenames one by one and append to a list of fullfilenames
	while(selection)
	{
		row = (gint)selection->data;
		selected_items = g_list_append(selected_items, gtk_clist_get_row_data(clist, row));
		selection = selection->next;
	}
// return the newmade list
	return selected_items;
}







/**********************************************************************
 * this will move all selected rows down one row.
 * Arguments: A clist.
 **********************************************************************/
void clist_move_selected_down(GtkCList *clist)
{
	GList *selection = NULL;
	gchar *foo = NULL;
	gint row = -1;
	gboolean stopit = FALSE;

// count rows in clist
	while(gtk_clist_get_text (clist, ++row, 0, &foo));

// and toggle swap each selected item with its followed one (if one is present)
	while (row >= 0)
	{
		selection = clist->selection;
		while (selection)
		{
			if((gint)selection->data==row)
			{
				if(gtk_clist_get_text (clist, row+1, 0, &foo))
					gtk_clist_swap_rows (clist, row, row+1);
				else
					stopit=TRUE;
				break;
			}
			selection = selection->next;
		}
		if(stopit) break;
		--row;
	}
}





/**********************************************************************
 * this will move all selected rows up one row.
 * Arguments: A clist.
 **********************************************************************/
void clist_move_selected_up(GtkCList *clist)
{
	GList *selection = NULL;
	gchar *foo = NULL;
	gint row = 0;
	gint max = -1;
	gboolean stopit = FALSE;

// count rows	
	while(gtk_clist_get_text (clist, ++max, 0, &foo));

// swap each selected item with the previous one (if present)
	while (row < max)
	{
		selection = clist->selection;
		while (selection)
		{
			if((gint)selection->data==row)
			{
				if(gtk_clist_get_text (clist, row-1, 0, &foo))
					gtk_clist_swap_rows (clist, row, row-1);
				else
					stopit=TRUE;
				break;
			}
			selection = selection->next;
		}
		if(stopit) break;
		++row;
	}
}



// a simple message popup
void
popup_info (gchar *text)
{
	GtkWidget *messagebox = NULL;
	
	messagebox = gnome_message_box_new (text,
		GNOME_MESSAGE_BOX_INFO,
		GNOME_STOCK_BUTTON_OK, 
		NULL);
	
	gtk_window_set_position(GTK_WINDOW(messagebox), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW(messagebox), TRUE);
	gtk_widget_show (messagebox);

	return;
}

