/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "interface.h"			/* contains functions to create the gui */
#include "callbacks.h"			/* any callback funcs */
#include "support.h"			/* the glade support file, e.g. with "lookup_widget" */
#include "gui_dirtree.h"		/* Needed to init the directory tree */
#include "memory.h"				/* Defines easier/(more secure) stackhandling funcs */
#include "queue.h"				/* To init the queue */
#include "configfile.h"			/* To init the configfile */
#include "shared.h"				/* For "configfile_show_hidden" */
#include "gui_filelist.h"		/* To init the filelist */

/* Init global variables for the windows, popups and dialogs */
GtkWidget *splash = NULL;
GtkWidget *cantus = NULL;
GtkWidget *options = NULL;
GtkWidget *rules = NULL;
GtkWidget *popup_cantus_queue = NULL;
GtkWidget *popup_cantus_filelist = NULL;
GtkWidget *popup_cantus_dirtree = NULL;
GtkWidget *popup_cantus_log_log = NULL;
GtkWidget *popup_rename_file = NULL;
GtkWidget *popup_rename_directory = NULL;
GtkWidget *popup_create_directory = NULL;
GtkWidget *popup_really_do = NULL;
GtkWidget *custom_find = NULL;
GtkWidget *custom_view = NULL;
GtkWidget *about = NULL;
GtkWidget *album_choose = NULL;
GtkWidget *tracks_sort = NULL;
GtkWidget *wait = NULL;

/* The stacks, for a better memoryhandling */
GList *queue = NULL;
GList *rulelist = NULL;

/* Other globals */
Cfg cfg;									/* contains the configuration needed while program execution */
gchar *current_dir = NULL;					/* Always will contain the directory name which is active for the filelist */
gchar *active_tag = NULL;					/* Will contain the full filename of the tag currently shown in the tageditor */
gint lastclick_x, lastclick_y;				/* Last click, is needed to determine the clickposition for popupmenus */
GtkWidget *lastclicked = NULL;				/* Guess what? */


/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

static GtkWidget*
create_mysplash (void)
{
	GtkWidget *splash;
	GtkWidget *pixmap;
	GdkColormap *colormap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	gchar *pathname = NULL;

	splash = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_widget_set_name(splash, "splash");
	gtk_object_set_data(GTK_OBJECT(splash), "splash", splash);
	gtk_window_set_title(GTK_WINDOW(splash), "Cantus - Be welcome!");
	gtk_window_set_position(GTK_WINDOW(splash), GTK_WIN_POS_CENTER);
	gtk_window_set_policy(GTK_WINDOW(splash), FALSE, FALSE, TRUE);

	colormap = gtk_widget_get_colormap(splash);
	
	pathname = g_strconcat(PACKAGE_PIXMAPS_DIR, "/logo_about.xpm", '\0');
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask, NULL, pathname);
	free(pathname);
	
	pixmap = gtk_pixmap_new (gdkpixmap, mask);

	gtk_widget_ref(pixmap);
	gtk_object_set_data_full(GTK_OBJECT(splash), "pixmap7", pixmap, (GtkDestroyNotify)gtk_widget_unref);

	gtk_widget_show (pixmap);
	gtk_container_add(GTK_CONTAINER (splash), pixmap);
	gtk_widget_shape_combine_mask(splash, mask, 0, 0);
  
	return splash;
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/








/**********************************************************************
 * This is the root of all evil :)
 * Arguments: Don't matter to me here.
 * Returns: 0 if success, 1 if error.
 **********************************************************************/
int
main(int argc, char *argv[])
{
	gchar configfilename[2048] = "\0";
	gchar windowtitle[1000] = "\0";
	
#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	current_dir = malloc(2048);
	strncpy(current_dir, "/", 1);
	active_tag = malloc(2048);
	
// Read configfile.
	snprintf(configfilename, 2047, "%s%s", getenv("HOME"), "/.cantusrc");
// Check for version and stuff. This function will also create a new file in case there is none, yet.
	if( !configfile_check(configfilename, "3") )
		exit(1);

// get the configuration
	get_config_to_struct(&cfg);
	
// gtk init
	gnome_init ("Cantus", VERSION, argc, argv);

// Create widgets
	popup_cantus_queue = create_popup_cantus_queue();
	popup_cantus_filelist = create_popup_cantus_filelist();
	popup_cantus_dirtree = create_popup_cantus_dirtree();
	popup_cantus_log_log = create_popup_cantus_log_log();
	cantus = create_cantus ();
	wait = create_wait();
	
#ifndef HAVE_OGG_H
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(cantus, "radio_cantus_tagedit_both")), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(lookup_widget(cantus, "radio_cantus_tagedit_ogg")), FALSE);
#endif

// set window title
	sprintf(windowtitle, "Cantus %s", VERSION);
	gtk_window_set_title(GTK_WINDOW(cantus), windowtitle);
	
// Show splashscreen, if enabled
	if( cfg.hidesplash )
	{
		gtk_widget_show(cantus);
	}
	else
	{
		splash = create_mysplash();
		gtk_widget_show(splash);
		gtk_timeout_add(3000, on_splash_timeout, NULL);
	}

// This will set correct column titles to the queue lists.
	queue_update (TRUE);
	
// init dirtree
	ctree_init_dirtree(GTK_CTREE(lookup_widget(cantus, "ctree_cantus_directories")));

// open the default directory
	if( *cfg.defaultdir != '\0' )
	{
		ctree_dirtree_open_directory(
			GTK_CTREE(lookup_widget(cantus, "ctree_cantus_directories")),
			cfg.defaultdir);
		strncpy(current_dir, cfg.defaultdir, 2047);
		clist_filelist_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_filelist")),
			current_dir,
			cfg.showhidden );
	}

	gtk_main();

// cleanups
	free(current_dir);
	free(active_tag);
	
	destroy_config (&cfg);
	rulelist = mem_free (rulelist);
	queue = mem_free (queue);

	return 0;
}









