/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef id3Tag_def
#define id3Tag_def
typedef struct id3Tag_s
{
	gchar title[1024];
	gchar artist[1024];
	gchar album[1024];
	gchar year[5];
	gchar comment[1024];
	gchar track[3];
	gchar genre[512];
	guint size;
	gboolean has_footer;
} id3Tag;
#endif


#ifndef mp3Info_def
#define mp3Info_def
typedef struct Mp3Info_s
{
	gchar directory[2048];
	gchar destinationfilename[2048];
	gchar filename[2048];
	gulong filesize;
	gchar owner[512];
	gchar group[512];
	gchar mode[5];
	gchar v1_artist[1024];
	gchar v1_title[1024];
	gchar v1_album[1024];
	gchar v1_year[5];
	gchar v1_comment[1024];
	gchar v1_track[3];
	gchar v1_genre[512];
	gchar v2_artist[1024];
	gchar v2_title[1024];
	gchar v2_album[1024];
	gchar v2_year[5];
	gchar v2_comment[1024];
	gchar v2_track[3];
	gchar v2_genre[512];
	gchar ogg_artist[1024];
	gchar ogg_title[1024];
	gchar ogg_album[1024];
	gchar ogg_year[5];
	gchar ogg_comment[1024];
	gchar ogg_track[3];
	gchar ogg_genre[512];
	gchar status[256];
	guint seconds;
	guint bitrate;
	guint frequency;
	guint channelmode;
} Mp3Info;
#endif


void mp3file_get_info_1(gchar *dir, gchar *filename, Mp3Info *mp3info);
GList *mp3file_get_infos(GList *fullfilenames);
